/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types;

import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.BindingType;
import org.safris.xml.bind.runtime.lang.MarshalException;
import org.safris.xml.bind.runtime.lang.SimpleType;
import org.safris.xml.bind.runtime.lang.UnmarshalException;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.types.XSType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QNameType<T extends BindingType>
extends XSType<SimpleType> {
    private QName value = null;

    protected static QNameType parse(String value) {
        return new QNameType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    protected static QNameType parse(QName value) {
        return new QNameType(value){

            protected QName _getName() {
                return null;
            }
        };
    }

    public QNameType(QNameType binding) {
        super(binding);
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = binding.value;
    }

    public QNameType(QName value) {
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = value;
    }

    protected QNameType(String value) {
        super(value);
        if (value == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = QName.valueOf(value);
    }

    protected QNameType() {
    }

    protected void setTEXT(QName value) {
        this.value = value;
    }

    @Override
    protected QName getTEXT() {
        return this.value;
    }

    @Override
    protected void parse(Element element) throws UnmarshalException, ValidationException {
        String value = "";
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeValue() == null) continue;
            value = value + nodeList.item(i).getNodeValue().trim();
        }
        if (value.length() == 0) {
            return;
        }
        this.value = QNameType.stringToQName(value);
        this.value = new QName(element.getOwnerDocument().getDocumentElement().lookupNamespaceURI(this.value.getPrefix()), this.value.getLocalPart());
    }

    @Override
    protected Element marshal() throws MarshalException, ValidationException {
        Element root = QNameType.createElementNS(this._getName().getNamespaceURI(), this._getName().getLocalPart());
        return this.marshal(root, this._getName(), this._getTypeName());
    }

    @Override
    protected Element marshal(Element parent, QName name, QName typeName) throws MarshalException {
        Document document = parent.getOwnerDocument();
        Element element = super.marshal(parent, name, typeName);
        if (this.value.getNamespaceURI() != null) {
            element.appendChild(document.createTextNode(QNameType._getPrefix(parent, this.value.getNamespaceURI()) + ":" + this.value.getLocalPart()));
        } else {
            element.appendChild(document.createTextNode(this.value.getLocalPart()));
        }
        return element;
    }

    @Override
    protected Attr marshalAttr(String name, Element parent) {
        Attr attr = parent.getOwnerDocument().createAttribute(name);
        attr.setNodeValue(QNameType._getPrefix(parent, this.value.getNamespaceURI()) + ":" + this.value.getLocalPart());
        return attr;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QNameType)) {
            return false;
        }
        return this.value.equals(((QNameType)obj).value);
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public String toString() {
        if (this.value == null) {
            return "";
        }
        return this.value.toString();
    }
}

