/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.types.lang;

import java.util.Date;

public class Duration {
    private static final char P = 'P';
    private static final char Y = 'Y';
    private static final char M = 'M';
    private static final char D = 'D';
    private static final char T = 'T';
    private static final char H = 'H';
    private static final char S = 'S';
    private Date value = null;
    private boolean isNegative = false;

    public Duration(Duration binding) {
        if (binding == null) {
            throw new IllegalArgumentException("value cannot be null");
        }
        this.value = binding.value;
    }

    protected Duration() {
        this(false, 0, 0, 0, 0, 0, 0);
    }

    public Duration(boolean isNegative, int years) {
        this.isNegative = isNegative;
        this.value = new Date(years, 0, 0, 0, 0, 0);
    }

    public Duration(boolean isNegative, int years, int months) {
        this.isNegative = isNegative;
        this.value = new Date(years, months, 0, 0, 0, 0);
    }

    public Duration(boolean isNegative, int years, int months, int days) {
        this.isNegative = isNegative;
        this.value = new Date(years, months, days, 0, 0, 0);
    }

    public Duration(boolean isNegative, int years, int months, int days, int hours) {
        this.isNegative = isNegative;
        this.value = new Date(years, months, days, hours, 0, 0);
    }

    public Duration(boolean isNegative, int years, int months, int days, int hours, int minutes) {
        this.isNegative = isNegative;
        this.value = new Date(years, months, days, hours, minutes, 0);
    }

    public Duration(boolean isNegative, int years, int months, int days, int hours, int minutes, int seconds) {
        this.isNegative = isNegative;
        this.value = new Date(years, months, days, hours, minutes, seconds);
    }

    public String toString() {
        StringBuffer stringBuffer = null;
        stringBuffer = this.isNegative ? new StringBuffer("-") : new StringBuffer();
        stringBuffer.append(String.valueOf('P'));
        if (this.value.getYear() != -1) {
            if (this.value.getYear() != 0) {
                stringBuffer.append(this.value.getYear());
                stringBuffer.append('Y');
            }
            if (this.value.getMonth() != 0) {
                stringBuffer.append(this.value.getMonth());
                stringBuffer.append('M');
            }
            if (this.value.getDate() != 0) {
                stringBuffer.append(this.value.getDate());
                stringBuffer.append('D');
            }
        }
        if (this.value.getHours() != 0 || this.value.getMinutes() != 0 || this.value.getSeconds() != 0) {
            stringBuffer.append('T');
            if (this.value.getHours() != 0) {
                stringBuffer.append(this.value.getHours());
                stringBuffer.append('H');
            }
            if (this.value.getMinutes() != 0) {
                stringBuffer.append(this.value.getMinutes());
                stringBuffer.append('M');
            }
            if (this.value.getSeconds() != 0) {
                stringBuffer.append(this.value.getSeconds());
                stringBuffer.append('S');
            }
        }
        if (stringBuffer.length() == 1) {
            stringBuffer.append(0).append('D');
        }
        return stringBuffer.toString();
    }
}

