/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.util;

import java.io.StringReader;
import org.safris.xml.bind.runtime.lang.Bindings;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.safris.xml.bind.runtime.util.DefaultErrorHandler;
import org.safris.xml.bind.runtime.util.Validator;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class DefaultValidator
extends Validator {
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static XMLReader xmlReader = null;

    public void validate(String string) throws ValidationException {
        if (xmlReader == null) {
            return;
        }
        try {
            xmlReader.parse(new InputSource(new StringReader(string)));
        }
        catch (Exception e) {
            throw new ValidationException(e);
        }
    }

    public void validate(Element element) throws ValidationException {
        if (xmlReader == null) {
            return;
        }
        String output = Bindings.domToString(element);
        try {
            xmlReader.parse(new InputSource(new StringReader(output)));
        }
        catch (Exception e) {
            ValidationException validationException = new ValidationException("\n" + output + "\n" + e.getMessage());
            validationException.setStackTrace(e.getStackTrace());
            throw validationException;
        }
    }

    static {
        try {
            System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser");
            xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature(NAMESPACES_FEATURE_ID, true);
            xmlReader.setFeature(VALIDATION_FEATURE_ID, true);
            xmlReader.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, true);
            xmlReader.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
            xmlReader.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
            DefaultErrorHandler errorHandler = new DefaultErrorHandler();
            if (errorHandler != null) {
                xmlReader.setErrorHandler(errorHandler);
            }
        }
        catch (SAXException e) {
            System.err.println("Error initializing XMLReader: " + e);
            System.err.println("This must be fixed.");
            System.exit(1);
        }
    }
}

