/*
 * Decompiled with CFR 0.152.
 */
package org.safris.xml.bind.runtime.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.safris.xml.bind.runtime.lang.ValidationException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class Validator {
    private static final QName XSI = new QName("http://www.w3.org/2001/XMLSchema-instance", "xsi", "xmlns");
    private static final Map<String, URL> schemaLocations = new HashMap<String, URL>();
    private static Validator validator = null;
    private boolean validateOnMarshal = false;
    private boolean validateOnUnmarshal = false;

    public static Validator getSystemValidator() {
        return validator;
    }

    public static void setSystemValidator(Validator validator) {
        Validator.validator = validator;
    }

    public static void registerSchemaLocation(String namespaceURI, String schemaLocation) {
        URL url = null;
        File file = null;
        try {
            url = new URL(schemaLocation);
        }
        catch (MalformedURLException e) {
            file = new File(schemaLocation);
            try {
                url = new URL("file://" + file.getAbsolutePath());
            }
            catch (MalformedURLException ex) {
                System.err.println("Unknown URL format: " + schemaLocation);
                System.exit(1);
            }
        }
        schemaLocations.put(namespaceURI, url);
    }

    public void setValidateOnMarshal(boolean validateOnMarshal) {
        this.validateOnMarshal = validateOnMarshal;
    }

    public boolean isValidateOnMarshal() {
        return this.validateOnMarshal;
    }

    public void setValidateOnUnmarshal(boolean validateOnUnmarshal) {
        this.validateOnUnmarshal = validateOnUnmarshal;
    }

    public boolean isValidateOnUnmarshal() {
        return this.validateOnUnmarshal;
    }

    private void validateElement(Element element) throws ValidationException {
        if (element != element.getOwnerDocument().getDocumentElement()) {
            return;
        }
        NamedNodeMap attributes = element.getAttributes();
        Node node = null;
        ArrayList<String> namespaces = new ArrayList<String>(attributes.getLength());
        for (int i = 0; i < attributes.getLength(); ++i) {
            node = attributes.item(i);
            if (!node.getNodeName().startsWith("xmlns")) continue;
            namespaces.add(node.getNodeValue());
        }
        Set<String> registeredNamespaces = schemaLocations.keySet();
        for (String namespace : namespaces) {
            if (namespace == null || namespace.length() == 0 || XSI.getNamespaceURI().equals(namespace) || registeredNamespaces.contains(namespace)) continue;
            throw new ValidationException("I do not know how to find the schema for the \"" + namespace + "\" namespace. Please register its location using Validator.registerSchemaLocation().");
        }
        String namespaceLocations = "";
        for (Map.Entry<String, URL> entry : schemaLocations.entrySet()) {
            namespaceLocations = namespaceLocations + " " + entry.getKey() + " " + entry.getValue();
        }
        element.setAttributeNS("http://www.w3.org/2000/xmlns/", XSI.getPrefix() + ":" + XSI.getLocalPart(), "http://www.w3.org/2001/XMLSchema-instance");
        element.setAttributeNS(XSI.getNamespaceURI(), "xsi:schemaLocation", namespaceLocations.substring(1));
        this.validate(element);
    }

    public abstract void validate(Element var1) throws ValidationException;

    public void validateMarshal(Element element) throws ValidationException {
        if (this.validateOnMarshal) {
            this.validateElement(element);
        }
    }

    public void validateUnmarshal(Element element) throws ValidationException {
        if (this.validateOnUnmarshal) {
            this.validateElement(element);
        }
    }
}

