/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.api;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementMessageHeader;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.messaging.api.BullhornAlert;
import org.sakaiproject.messaging.api.BullhornData;
import org.sakaiproject.messaging.api.bullhornhandlers.AbstractBullhornHandler;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class AnnouncementsBullhornHandler
extends AbstractBullhornHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementsBullhornHandler.class);
    @Resource
    private AnnouncementService announcementService;
    @Resource
    private EntityManager entityManager;
    @Resource
    private ServerConfigurationService serverConfigurationService;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalSessionFactory")
    private SessionFactory sessionFactory;
    @Resource
    private SiteService siteService;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalTransactionManager")
    private PlatformTransactionManager transactionManager;

    public List<String> getHandledEvents() {
        return Arrays.asList("annc.new", "annc.revise.availability", "annc.delete.own", "annc.delete.any", "annc.available.announcement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<List<BullhornData>> handleEvent(Event event) {
        List bhEvents = Collections.emptyList();
        String eventName = event.getEvent();
        String eventResource = event.getResource();
        SecurityAdvisor sa = this.unlock(new String[]{"annc.read", "annc.read.drafts"});
        try {
            AnnouncementMessage message = (AnnouncementMessage)this.announcementService.getMessage(this.entityManager.newReference(eventResource));
            boolean isDraftMessage = false;
            boolean isFutureMessage = false;
            if (message != null) {
                isDraftMessage = message.getHeader().getDraft();
                isFutureMessage = Instant.now().isBefore(message.getHeader().getInstant());
            }
            if ("annc.delete.own".equals(eventName) || "annc.delete.any".equals(eventName) || "annc.revise.availability".equals(eventName) && (isDraftMessage || isFutureMessage)) {
                try {
                    new TransactionTemplate(this.transactionManager).executeWithoutResult(transactionStatus -> {
                        Session session = this.sessionFactory.getCurrentSession();
                        CriteriaBuilder queryBuilder = session.getCriteriaBuilder();
                        CriteriaQuery eventQuery = queryBuilder.createQuery(BullhornAlert.class);
                        Root eventQueryTable = eventQuery.from(BullhornAlert.class);
                        eventQuery.where(new javax.persistence.criteria.Predicate[]{queryBuilder.and(new javax.persistence.criteria.Predicate[]{queryBuilder.or(new javax.persistence.criteria.Predicate[]{queryBuilder.equal((Expression)eventQueryTable.get("event"), (Object)"annc.new"), queryBuilder.equal((Expression)eventQueryTable.get("event"), (Object)"annc.available.announcement"), queryBuilder.equal((Expression)eventQueryTable.get("event"), (Object)"annc.revise.availability")})}), queryBuilder.equal((Expression)eventQueryTable.get("ref"), (Object)eventResource)});
                        session.createQuery(eventQuery).list().forEach(arg_0 -> ((Session)session).detach(arg_0));
                        CriteriaDelete eventDeleteQuery = queryBuilder.createCriteriaDelete(BullhornAlert.class);
                        Root eventDeleteQueryTable = eventDeleteQuery.from(BullhornAlert.class);
                        eventDeleteQuery.where(new javax.persistence.criteria.Predicate[]{queryBuilder.and(new javax.persistence.criteria.Predicate[]{queryBuilder.or(new javax.persistence.criteria.Predicate[]{queryBuilder.equal((Expression)eventQueryTable.get("event"), (Object)"annc.new"), queryBuilder.equal((Expression)eventQueryTable.get("event"), (Object)"annc.available.announcement"), queryBuilder.equal((Expression)eventQueryTable.get("event"), (Object)"annc.revise.availability")})}), queryBuilder.equal((Expression)eventDeleteQueryTable.get("ref"), (Object)eventResource)});
                        session.createQuery(eventDeleteQuery).executeUpdate();
                    });
                }
                catch (TransactionException te) {
                    log.warn("Could not remove bullhorn alerts for announcement [{}], {}", (Object)eventResource, (Object)te.toString());
                }
            } else if (message != null) {
                Site site;
                ToolConfiguration toolConfig;
                String eventUserId = event.getUserId();
                String eventContext = event.getContext();
                if (!isDraftMessage && this.announcementService.isMessageViewable(message) && (toolConfig = (site = this.siteService.getSite(eventContext)).getToolForCommonId("sakai.announcements")) != null) {
                    String url = this.serverConfigurationService.getPortalUrl() + "/directtool/" + toolConfig.getId() + "?itemReference=" + eventResource + "&sakai_action=doShowmetadata";
                    String title = ((AnnouncementMessageHeader)message.getHeader()).getSubject();
                    Set usersToNotify = new HashSet();
                    Collection groups = message.getHeader().getGroups();
                    if (groups.isEmpty()) {
                        usersToNotify = site.getUsersIsAllowed("annc.read");
                    } else {
                        for (String group : groups) {
                            usersToNotify.addAll(site.getGroup(group).getUsersIsAllowed("annc.read"));
                        }
                    }
                    bhEvents = usersToNotify.stream().filter(Predicate.not(eventUserId::equals)).filter(Predicate.not(arg_0 -> ((SecurityService)this.securityService).isSuperUser(arg_0))).map(u -> new BullhornData(eventUserId, u, eventContext, title, url)).collect(Collectors.toList());
                }
            } else {
                log.debug("The event [{}] was not processed by this handler because message was null and should likely be investigated", (Object)event);
            }
        }
        catch (Exception e) {
            log.warn("Could not handle event [{}], {}", (Object)event, (Object)e.toString());
        }
        finally {
            this.lock(sa);
        }
        return Optional.of(bhEvents);
    }
}

