/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Resource;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementMessageHeader;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.messaging.api.AbstractUserNotificationHandler;
import org.sakaiproject.messaging.api.UserNotification;
import org.sakaiproject.messaging.api.UserNotificationData;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

@Component
public class AnnouncementsUserNotificationHandler
extends AbstractUserNotificationHandler {
    private static final Logger log = LoggerFactory.getLogger(AnnouncementsUserNotificationHandler.class);
    @Resource
    private AnnouncementService announcementService;
    @Resource
    private EntityManager entityManager;
    @Resource
    private ServerConfigurationService serverConfigurationService;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalSessionFactory")
    private SessionFactory sessionFactory;
    @Resource
    private SiteService siteService;
    @Resource(name="org.sakaiproject.springframework.orm.hibernate.GlobalTransactionManager")
    private PlatformTransactionManager transactionManager;

    public List<String> getHandledEvents() {
        return Arrays.asList("annc.new", "annc.revise.availability", "annc.delete.own", "annc.delete.any", "annc.available.announcement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<List<UserNotificationData>> handleEvent(Event e) {
        String from = e.getUserId();
        final String ref = e.getResource();
        String[] pathParts = ref.split("/");
        String siteId = pathParts[3];
        SecurityAdvisor sa = this.unlock(new String[]{"annc.read", "annc.read.drafts"});
        AnnouncementMessage message = null;
        try {
            message = (AnnouncementMessage)this.announcementService.getMessage(this.entityManager.newReference(ref));
        }
        catch (Exception ex) {
            log.debug("No announcement with id {}", (Object)ref);
        }
        try {
            Site site;
            ToolConfiguration tc;
            if ("annc.delete.own".equals(e.getEvent()) || "annc.delete.any".equals(e.getEvent()) || "annc.revise.availability".equals(e.getEvent()) && message.getHeader().getDraft()) {
                try {
                    TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
                    transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                        protected void doInTransactionWithoutResult(TransactionStatus status) {
                            List alerts = AnnouncementsUserNotificationHandler.this.sessionFactory.getCurrentSession().createCriteria(UserNotification.class).add((Criterion)Restrictions.eq((String)"event", (Object)"annc.new")).add((Criterion)Restrictions.eq((String)"ref", (Object)ref)).list();
                            AnnouncementsUserNotificationHandler.this.sessionFactory.getCurrentSession().createQuery("delete UserNotification where event = :event and ref = :ref").setString("event", "annc.new").setString("ref", ref).executeUpdate();
                        }
                    });
                }
                catch (Exception e1) {
                    log.error("Failed to delete user notification add announcement event", (Throwable)e1);
                }
                Optional<List<UserNotificationData>> e1 = Optional.empty();
                return e1;
            }
            if (!message.getHeader().getDraft() && this.announcementService.isMessageViewable(message) && (tc = (site = this.siteService.getSite(siteId)).getToolForCommonId("sakai.announcements")) != null) {
                String url = this.serverConfigurationService.getPortalUrl() + "/directtool/" + tc.getId() + "?itemReference=" + ref + "&sakai_action=doShowmetadata";
                String title = ((AnnouncementMessageHeader)message.getHeader()).getSubject();
                ArrayList<UserNotificationData> bhEvents = new ArrayList<UserNotificationData>();
                Set usersList = new HashSet();
                if (message.getHeader().getGroups().isEmpty()) {
                    usersList = site.getUsersIsAllowed("annc.read");
                } else {
                    for (String group : message.getHeader().getGroups()) {
                        usersList.addAll(site.getGroup(group).getUsersIsAllowed("annc.read"));
                    }
                }
                for (String to : usersList) {
                    if (from.equals(to) || this.securityService.isSuperUser(to)) continue;
                    bhEvents.add(new UserNotificationData(from, to, siteId, title, url));
                }
                Optional optional = Optional.of(bhEvents);
                return optional;
            }
        }
        catch (Exception ex) {
            log.error("No site with id '" + siteId + "'", (Throwable)ex);
        }
        finally {
            this.lock(sa);
        }
        return Optional.empty();
    }
}

