/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.api;

import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.time.api.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViewableFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ViewableFilter.class);
    private Filter filter = null;
    private Time t;
    private int numberOfAnnouncements;
    private AnnouncementService announcementService;
    private int accepted = 0;

    public ViewableFilter(Filter filter, Time t, int numberOfAnnouncements, AnnouncementService announcementService) {
        this.filter = filter;
        this.numberOfAnnouncements = numberOfAnnouncements;
        this.t = t;
        this.announcementService = announcementService;
    }

    public boolean accept(Object o) {
        if (this.accepted >= this.numberOfAnnouncements) {
            return false;
        }
        if (o instanceof AnnouncementMessage) {
            long limitDate;
            long release;
            ResourceProperties msgProperties;
            String releaseDate;
            AnnouncementMessage msg = (AnnouncementMessage)o;
            if (this.t != null && (releaseDate = (msgProperties = msg.getProperties()).getProperty("releaseDate")) != null && (release = Long.parseLong(releaseDate)) < (limitDate = Long.parseLong(this.t.toString()))) {
                return false;
            }
            if (msg.getHeader().getDraft() || !this.announcementService.isMessageViewable(msg)) {
                return false;
            }
        }
        if (this.filter != null) {
            return this.filter.accept(o);
        }
        ++this.accepted;
        return true;
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
    }
}

