/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.List;
import java.util.Stack;
import org.sakaiproject.announcement.impl.BaseAnnouncementService;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.db.api.SqlReader;
import org.sakaiproject.db.api.SqlService;
import org.sakaiproject.entity.api.Edit;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.message.api.Message;
import org.sakaiproject.message.api.MessageChannel;
import org.sakaiproject.message.api.MessageChannelEdit;
import org.sakaiproject.message.api.MessageEdit;
import org.sakaiproject.message.util.BaseMessage;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.util.BaseDbDoubleStorage;
import org.sakaiproject.util.DoubleStorageUser;
import org.sakaiproject.util.Xml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DbAnnouncementService
extends BaseAnnouncementService {
    private static Logger M_log = LoggerFactory.getLogger(DbAnnouncementService.class);
    protected String m_cTableName = "ANNOUNCEMENT_CHANNEL";
    protected String m_rTableName = "ANNOUNCEMENT_MESSAGE";
    protected boolean m_locksInDb = true;
    protected static final String[] FIELDS = new String[]{"MESSAGE_DATE", "OWNER", "DRAFT", "PUBVIEW", "MESSAGE_ORDER"};
    protected SqlService m_sqlService = null;
    protected boolean m_convertToDraft = false;
    protected boolean m_convertToPubView = false;
    protected boolean m_autoDdl = false;

    public void setSqlService(SqlService service) {
        this.m_sqlService = service;
    }

    public void setContainerTableName(String name) {
        this.m_cTableName = name;
    }

    public void setResourceTableName(String name) {
        this.m_rTableName = name;
    }

    public void setLocksInDb(String value) {
        this.m_locksInDb = Boolean.valueOf(value);
    }

    public void setConvertDraft(String value) {
        this.m_convertToDraft = Boolean.valueOf(value);
    }

    public void setConvertPubView(String value) {
        this.m_convertToPubView = Boolean.valueOf(value);
    }

    public void setAutoDdl(String value) {
        this.m_autoDdl = new Boolean(value);
    }

    @Override
    public void init() {
        try {
            if (this.m_autoDdl) {
                this.m_sqlService.ddl(((Object)((Object)this)).getClass().getClassLoader(), "sakai_announcement");
            }
            super.init();
            M_log.info("init(): tables: " + this.m_cTableName + " " + this.m_rTableName + " locks-in-db: " + this.m_locksInDb);
            if (this.m_convertToDraft) {
                this.m_convertToDraft = false;
                this.convertToDraft();
            }
            if (this.m_convertToPubView) {
                this.m_convertToPubView = false;
                this.convertToPubView();
            }
        }
        catch (Throwable t) {
            M_log.warn("init(): ", t);
        }
    }

    protected BaseMessage.Storage newStorage() {
        return new DbStorage((DoubleStorageUser)this);
    }

    protected void convertToDraft() {
        M_log.info("convertToDraft");
        try {
            final Connection connection = this.m_sqlService.borrowConnection();
            boolean wasCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            String sql = "select CHANNEL_ID, MESSAGE_ID, XML from " + this.m_rTableName;
            this.m_sqlService.dbRead(connection, sql, null, new SqlReader(){
                private int count = 0;

                public Object readSqlResultRecord(ResultSet result) {
                    try {
                        String channelId = result.getString(1);
                        String messageId = result.getString(2);
                        String xml = result.getString(3);
                        Document doc = Xml.readDocumentFromString((String)xml);
                        Element root = doc.getDocumentElement();
                        if (!root.getTagName().equals("message")) {
                            M_log.warn("convertToDraft(): XML root element not message: " + root.getTagName());
                            return null;
                        }
                        BaseMessage.BaseMessageEdit m = new BaseMessage.BaseMessageEdit((BaseMessage)DbAnnouncementService.this, null, root);
                        String owner = m.getHeader().getFrom().getId();
                        boolean draft = m.getHeader().getDraft();
                        String update = "update " + DbAnnouncementService.this.m_rTableName + " set OWNER = ?, DRAFT = ? where CHANNEL_ID = ? and MESSAGE_ID = ?";
                        Object[] fields = new Object[]{owner, draft ? "1" : "0", channelId, messageId};
                        boolean ok = DbAnnouncementService.this.m_sqlService.dbWrite(connection, update, fields);
                        if (!ok) {
                            M_log.info("convertToDraft: channel: " + channelId + " message: " + messageId + " owner: " + owner + " draft: " + draft + " ok: " + ok);
                        }
                        ++this.count;
                        if (this.count % 100 == 0) {
                            M_log.info("convertToDraft: " + this.count);
                        }
                        return null;
                    }
                    catch (Throwable ignore) {
                        return null;
                    }
                }
            });
            connection.commit();
            connection.setAutoCommit(wasCommit);
            this.m_sqlService.returnConnection(connection);
        }
        catch (Throwable t) {
            M_log.warn("convertToDraft: failed: " + t);
        }
        M_log.info("convertToDraft: done");
    }

    protected void convertToPubView() {
        M_log.info("convertToPubView");
        try {
            final Connection connection = this.m_sqlService.borrowConnection();
            boolean wasCommit = connection.getAutoCommit();
            connection.setAutoCommit(false);
            String sql = "select CHANNEL_ID, MESSAGE_ID, XML, PUBVIEW from " + this.m_rTableName;
            this.m_sqlService.dbRead(connection, sql, null, new SqlReader(){

                public Object readSqlResultRecord(ResultSet result) {
                    try {
                        Object[] fields;
                        String update;
                        String channelId = result.getString(1);
                        String messageId = result.getString(2);
                        String xml = result.getString(3);
                        String pubViewSetting = result.getString(4);
                        Document doc = Xml.readDocumentFromString((String)xml);
                        Element root = doc.getDocumentElement();
                        if (!root.getTagName().equals("message")) {
                            M_log.warn("convertToPubView(): XML root element not message: " + root.getTagName());
                            return null;
                        }
                        BaseMessage.BaseMessageEdit m = new BaseMessage.BaseMessageEdit((BaseMessage)DbAnnouncementService.this, null, root);
                        boolean pubview = false;
                        if (m.getProperties().getProperty("SAKAI:pubview") != null) {
                            if ("1".equals(pubViewSetting)) {
                                return null;
                            }
                            pubview = true;
                        } else {
                            Reference channel = DbAnnouncementService.this.m_entityManager.newReference(channelId);
                            String ref = DbAnnouncementService.this.messageReference(channel.getContext(), channel.getId(), m.getId());
                            pubview = DbAnnouncementService.this.getPubView(ref);
                            if (!pubview && "0".equals(pubViewSetting)) {
                                return null;
                            }
                        }
                        if (!pubview) {
                            update = "update " + DbAnnouncementService.this.m_rTableName + " set PUBVIEW = ? where CHANNEL_ID = ? and MESSAGE_ID = ?";
                            boolean ok = DbAnnouncementService.this.m_sqlService.dbWrite(connection, update, fields = new Object[]{"0", channelId, messageId});
                            if (!ok) {
                                M_log.info("convertToPubView: channel: " + channelId + " message: " + messageId + " pubview: " + pubview + " ok: " + ok);
                            }
                        } else {
                            m.getPropertiesEdit().addProperty("SAKAI:pubview", Boolean.TRUE.toString());
                            doc = Xml.createDocument();
                            m.toXml(doc, new Stack());
                            xml = Xml.writeDocumentToString((Document)doc);
                            update = "update " + DbAnnouncementService.this.m_rTableName + " set PUBVIEW = ?, XML = ? where CHANNEL_ID = ? and MESSAGE_ID = ?";
                            fields = new Object[]{"1", xml, channelId, messageId};
                            boolean ok = DbAnnouncementService.this.m_sqlService.dbWrite(connection, update, fields);
                            if (!ok) {
                                M_log.info("convertToPubView: channel: " + channelId + " message: " + messageId + " pubview: " + pubview + " ok: " + ok);
                            }
                        }
                        return null;
                    }
                    catch (Throwable ignore) {
                        return null;
                    }
                }
            });
            connection.commit();
            connection.setAutoCommit(wasCommit);
            this.m_sqlService.returnConnection(connection);
        }
        catch (Throwable t) {
            M_log.warn("convertToPubView: failed: " + t);
        }
        M_log.info("convertToPubView: done");
    }

    protected boolean getPubView(String ref) {
        try {
            AuthzGroup realm = this.m_authzGroupService.getAuthzGroup(ref);
            Role pubview = realm.getRole("pubview");
            if (pubview != null) {
                return true;
            }
            Role anon = realm.getRole(".anon");
            return anon != null && anon.getAllowedFunctions().contains("content.read");
        }
        catch (GroupNotDefinedException e) {
            return false;
        }
    }

    protected class DbStorage
    extends BaseDbDoubleStorage
    implements BaseMessage.Storage {
        public DbStorage(DoubleStorageUser user) {
            super(DbAnnouncementService.this.m_cTableName, "CHANNEL_ID", DbAnnouncementService.this.m_rTableName, "MESSAGE_ID", "CHANNEL_ID", "MESSAGE_DATE", "OWNER", "DRAFT", "PUBVIEW", FIELDS, DbAnnouncementService.this.m_locksInDb, "channel", "message", user, DbAnnouncementService.this.m_sqlService);
        }

        public boolean checkChannel(String ref) {
            return super.getContainer(ref) != null;
        }

        public MessageChannel getChannel(String ref) {
            return (MessageChannel)super.getContainer(ref);
        }

        public List getChannels() {
            return super.getAllContainers();
        }

        public MessageChannelEdit putChannel(String ref) {
            return (MessageChannelEdit)super.putContainer(ref);
        }

        public MessageChannelEdit editChannel(String ref) {
            return (MessageChannelEdit)super.editContainer(ref);
        }

        public void commitChannel(MessageChannelEdit edit) {
            super.commitContainer((Edit)edit);
        }

        public void cancelChannel(MessageChannelEdit edit) {
            super.cancelContainer((Edit)edit);
        }

        public void removeChannel(MessageChannelEdit edit) {
            super.removeContainer((Edit)edit);
        }

        public List getChannelIdsMatching(String root) {
            return super.getContainerIdsMatching(root);
        }

        public boolean checkMessage(MessageChannel channel, String id) {
            return super.checkResource((Entity)channel, id);
        }

        public Message getMessage(MessageChannel channel, String id) {
            return (Message)super.getResource((Entity)channel, id);
        }

        public List getMessages(MessageChannel channel) {
            return super.getAllResources((Entity)channel);
        }

        public MessageEdit putMessage(MessageChannel channel, String id) {
            return (MessageEdit)super.putResource((Entity)channel, id, null);
        }

        public MessageEdit editMessage(MessageChannel channel, String id) {
            return (MessageEdit)super.editResource((Entity)channel, id);
        }

        public void commitMessage(MessageChannel channel, MessageEdit edit) {
            super.commitResource((Entity)channel, (Edit)edit);
        }

        public void cancelMessage(MessageChannel channel, MessageEdit edit) {
            super.cancelResource((Entity)channel, (Edit)edit);
        }

        public void removeMessage(MessageChannel channel, MessageEdit edit) {
            super.removeResource((Entity)channel, (Edit)edit);
        }

        public int getCount(MessageChannel channel) {
            return super.getCount((Entity)channel);
        }

        public int getCount(MessageChannel channel, Filter filter) {
            return super.getCount((Entity)channel, filter);
        }

        public List getMessages(MessageChannel channel, Filter filter, boolean asc, PagingPosition pager) {
            return super.getAllResources((Entity)channel, filter, null, asc, pager);
        }

        public List getMessages(MessageChannel channel, Time afterDate, int limitedToLatest, String draftsForId, boolean pubViewOnly) {
            return super.getResources((Entity)channel, afterDate, limitedToLatest, draftsForId, pubViewOnly);
        }
    }
}

