/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.alias.api.Alias;
import org.sakaiproject.alias.api.AliasService;
import org.sakaiproject.announcement.api.AnnouncementChannel;
import org.sakaiproject.announcement.api.AnnouncementChannelEdit;
import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementMessageEdit;
import org.sakaiproject.announcement.api.AnnouncementMessageHeader;
import org.sakaiproject.announcement.api.AnnouncementMessageHeaderEdit;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.announcement.impl.SiteEmailNotificationAnnc;
import org.sakaiproject.authz.api.FunctionManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.entity.api.ContextObserver;
import org.sakaiproject.entity.api.Edit;
import org.sakaiproject.entity.api.Entity;
import org.sakaiproject.entity.api.EntityNotDefinedException;
import org.sakaiproject.entity.api.EntityPermissionException;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.EntityTransferrer;
import org.sakaiproject.entity.api.EntityTransferrerRefMigrator;
import org.sakaiproject.entity.api.HttpAccess;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.event.api.NotificationEdit;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.message.api.Message;
import org.sakaiproject.message.api.MessageChannel;
import org.sakaiproject.message.api.MessageEdit;
import org.sakaiproject.message.api.MessageHeader;
import org.sakaiproject.message.api.MessageHeaderEdit;
import org.sakaiproject.message.util.BaseMessage;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.util.MergedList;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.StringUtil;
import org.sakaiproject.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BaseAnnouncementService
extends BaseMessage
implements AnnouncementService,
ContextObserver,
EntityTransferrer,
EntityTransferrerRefMigrator {
    private static Logger M_log = LoggerFactory.getLogger(BaseAnnouncementService.class);
    private static final String SAKAI_ANNOUNCEMENT_TOOL_ID = "sakai.announcements";
    private static final String PORTLET_CONFIG_PARM_MERGED_CHANNELS = "mergedAnnouncementChannels";
    protected static ResourceLoader rb = new ResourceLoader("annc-access");
    private DocumentBuilder docBuilder = null;
    private Transformer docTransformer = null;
    private ContentHostingService contentHostingService;
    private SiteEmailNotificationAnnc siteEmailNotificationAnnc;
    private FunctionManager functionManager;
    private AliasService aliasService;
    private ToolManager toolManager;
    protected NotificationService m_notificationService = null;

    public void setContentHostingService(ContentHostingService service) {
        this.contentHostingService = service;
    }

    public void setSiteEmailNotificationAnnc(SiteEmailNotificationAnnc siteEmailNotificationAnnc) {
        this.siteEmailNotificationAnnc = siteEmailNotificationAnnc;
    }

    public void setFunctionManager(FunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    public void setNotificationService(NotificationService service) {
        this.m_notificationService = service;
    }

    public void init() {
        try {
            super.init();
            NotificationEdit edit = this.m_notificationService.addTransientNotification();
            edit.setFunction(this.eventId("new"));
            edit.addFunction(this.eventId("revise.own"));
            edit.addFunction(this.eventId("revise.any"));
            edit.setResourceFilter(this.getAccessPoint(true) + "/" + "msg");
            edit.setAction((NotificationAction)this.siteEmailNotificationAnnc);
            this.functionManager.registerFunction(this.eventId("read"));
            this.functionManager.registerFunction(this.eventId("new"));
            this.functionManager.registerFunction(this.eventId("delete.any"));
            this.functionManager.registerFunction(this.eventId("delete.own"));
            this.functionManager.registerFunction(this.eventId("revise.any"));
            this.functionManager.registerFunction(this.eventId("revise.own"));
            this.functionManager.registerFunction(this.eventId("all.groups"));
            this.functionManager.registerFunction(this.eventId("read.drafts"));
            this.m_entityManager.registerEntityProducer((EntityProducer)this, "/announcement");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setIgnoringComments(true);
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            this.docBuilder = factory.newDocumentBuilder();
            TransformerFactory tFactory = TransformerFactory.newInstance();
            this.docTransformer = tFactory.newTransformer();
            M_log.info("init()");
        }
        catch (Throwable t) {
            M_log.warn("init(): ", t);
        }
    }

    public Entity newContainer(String ref) {
        return new BaseAnnouncementChannelEdit(ref);
    }

    public Entity newContainer(Element element) {
        return new BaseAnnouncementChannelEdit(element);
    }

    public Entity newContainer(Entity other) {
        return new BaseAnnouncementChannelEdit((MessageChannel)other);
    }

    public Entity newResource(Entity container, String id, Object[] others) {
        return new BaseAnnouncementMessageEdit((MessageChannel)container, id);
    }

    public Entity newResource(Entity container, Element element) {
        return new BaseAnnouncementMessageEdit((MessageChannel)container, element);
    }

    public Entity newResource(Entity container, Entity other) {
        return new BaseAnnouncementMessageEdit((MessageChannel)container, (Message)other);
    }

    public Edit newContainerEdit(String ref) {
        BaseAnnouncementChannelEdit rv = new BaseAnnouncementChannelEdit(ref);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Element element) {
        BaseAnnouncementChannelEdit rv = new BaseAnnouncementChannelEdit(element);
        rv.activate();
        return rv;
    }

    public Edit newContainerEdit(Entity other) {
        BaseAnnouncementChannelEdit rv = new BaseAnnouncementChannelEdit((MessageChannel)other);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Entity container, String id, Object[] others) {
        BaseAnnouncementMessageEdit rv = new BaseAnnouncementMessageEdit((MessageChannel)container, id);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Entity container, Element element) {
        BaseAnnouncementMessageEdit rv = new BaseAnnouncementMessageEdit((MessageChannel)container, element);
        rv.activate();
        return rv;
    }

    public Edit newResourceEdit(Entity container, Entity other) {
        BaseAnnouncementMessageEdit rv = new BaseAnnouncementMessageEdit((MessageChannel)container, (Message)other);
        rv.activate();
        return rv;
    }

    public Object[] storageFields(Entity r) {
        Object[] rv = new Object[]{((Message)r).getHeader().getDate(), ((Message)r).getHeader().getFrom().getId(), ((AnnouncementMessage)r).getAnnouncementHeader().getDraft() ? "1" : "0", r.getProperties().getProperty("SAKAI:pubview") == null ? "0" : "1", ((Message)r).getHeader().getMessage_order()};
        return rv;
    }

    public boolean isDraft(Entity r) {
        return ((AnnouncementMessage)r).getAnnouncementHeader().getDraft();
    }

    public String getOwnerId(Entity r) {
        return ((Message)r).getHeader().getFrom().getId();
    }

    public Time getDate(Entity r) {
        return ((Message)r).getHeader().getDate();
    }

    public Integer getMessage_order(Entity r) {
        return ((Message)r).getHeader().getMessage_order();
    }

    protected String serviceName() {
        return AnnouncementService.class.getName();
    }

    protected MessageHeaderEdit newMessageHeader(Message msg, String id) {
        return new BaseAnnouncementMessageHeaderEdit(msg, id);
    }

    protected MessageHeaderEdit newMessageHeader(Message msg, Element el) {
        return new BaseAnnouncementMessageHeaderEdit(msg, el);
    }

    protected MessageHeaderEdit newMessageHeader(Message msg, MessageHeader other) {
        return new BaseAnnouncementMessageHeaderEdit(msg, other);
    }

    protected String eventId(String secure) {
        if (StringUtils.isBlank((String)secure)) {
            try {
                throw new IllegalArgumentException("anouncement eventId() input cannot be null or blank");
            }
            catch (Exception e) {
                secure = "INVALID_KEY";
                M_log.error("Bad call to BaseAnnouncementService.eventId(String) - input string is blank, generating '" + secure + "' event name and logging trace", (Throwable)e);
            }
        }
        return "annc." + secure;
    }

    protected String getReferenceRoot() {
        return "/announcement";
    }

    public boolean parseEntityReference(String reference, Reference ref) {
        if (reference.startsWith("/announcement")) {
            String[] parts = StringUtil.split((String)reference, (String)"/");
            String id = null;
            String subType = null;
            String context = null;
            String container = null;
            if (parts.length > 2) {
                subType = parts[2];
                if ("channel".equals(subType)) {
                    if (parts.length > 3) {
                        context = parts[3];
                        if (parts.length > 4) {
                            id = parts[4];
                        }
                    }
                } else if ("msg".equals(subType)) {
                    if (parts.length > 5) {
                        context = parts[3];
                        container = parts[4];
                        id = parts[5];
                    }
                } else if ("rss".equals(subType) || "announcement".equals(subType)) {
                    if (parts.length > 3) {
                        context = parts[3];
                    }
                } else {
                    M_log.warn("parse(): unknown message subtype: " + subType + " in ref: " + reference);
                }
            }
            if ("rss".equals(subType) && context != null && context.length() > 0) {
                if (!this.m_siteService.siteExists(context)) {
                    try {
                        String aliasTarget = this.aliasService.getTarget(context);
                        if (aliasTarget.startsWith("/announcement") && (parts = StringUtil.split((String)aliasTarget, (String)"/")).length > 3) {
                            context = parts[3];
                        }
                    }
                    catch (Exception e) {
                        M_log.debug((Object)((Object)this) + ".parseEntityReference(): " + e.toString());
                        return false;
                    }
                }
                if (!this.m_siteService.siteExists(context)) {
                    M_log.warn((Object)((Object)this) + ".parseEntityReference() no valid site or alias: " + context);
                    return false;
                }
            }
            ref.set("sakai:announcement", subType, id, container, context);
            return true;
        }
        return false;
    }

    public Reference getAnnouncementReference(String context) {
        StringBuilder refString = new StringBuilder();
        refString.append(this.getAccessPoint(true));
        refString.append("/");
        refString.append("announcement");
        refString.append("/");
        refString.append(context);
        return this.m_entityManager.newReference(refString.toString());
    }

    public String channelReference(String context, String id) {
        String channelRef = null;
        try {
            ToolConfiguration tool = this.m_siteService.getSite(context).getToolForCommonId(SAKAI_ANNOUNCEMENT_TOOL_ID);
            if (tool != null) {
                channelRef = tool.getConfig().getProperty("channel", null);
            }
        }
        catch (IdUnusedException e) {
            M_log.debug("Could not find channelRef in channel property, falling back to default method...");
        }
        if (channelRef == null || channelRef.trim().length() == 0) {
            channelRef = super.channelReference(context, id);
        }
        return channelRef;
    }

    public String getRssUrl(Reference ref) {
        String alias = null;
        List aliasList = this.aliasService.getAliases(ref.getReference());
        if (!aliasList.isEmpty()) {
            alias = ((Alias)aliasList.get(0)).getId();
        }
        StringBuilder rssUrlString = new StringBuilder();
        rssUrlString.append(this.m_serverConfigurationService.getAccessUrl());
        rssUrlString.append(this.getAccessPoint(true));
        rssUrlString.append("/");
        rssUrlString.append("rss");
        rssUrlString.append("/");
        if (alias != null) {
            rssUrlString.append(alias);
        } else {
            rssUrlString.append(ref.getContext());
        }
        return rssUrlString.toString();
    }

    public boolean isMessageViewable(AnnouncementMessage message) {
        ResourceProperties messageProps = message.getProperties();
        Time now = this.m_timeService.newTime();
        try {
            Time releaseDate = message.getProperties().getTimeProperty("releaseDate");
            if (now.before(releaseDate)) {
                return false;
            }
        }
        catch (Exception releaseDate) {
            // empty catch block
        }
        try {
            Time retractDate = message.getProperties().getTimeProperty("retractDate");
            if (now.after(retractDate)) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void contextCreated(String context, boolean toolPlacement) {
        if (toolPlacement) {
            this.enableMessageChannel(context);
        }
    }

    public void contextUpdated(String context, boolean toolPlacement) {
        if (toolPlacement) {
            this.enableMessageChannel(context);
        }
    }

    public void contextDeleted(String context, boolean toolPlacement) {
        this.disableMessageChannel(context);
    }

    public String[] myToolIds() {
        String[] toolIds = new String[]{SAKAI_ANNOUNCEMENT_TOOL_ID};
        return toolIds;
    }

    protected Element generateItemElement(Document doc, AnnouncementMessage msg, Reference msgRef) {
        Element item = doc.createElement("item");
        Element el = doc.createElement("title");
        el.appendChild(doc.createTextNode(msg.getAnnouncementHeader().getSubject()));
        item.appendChild(el);
        el = doc.createElement("author");
        el.appendChild(doc.createTextNode(msg.getHeader().getFrom().getEmail()));
        item.appendChild(el);
        el = doc.createElement("link");
        el.appendChild(doc.createTextNode(msgRef.getUrl()));
        item.appendChild(el);
        el = doc.createElement("description");
        el.appendChild(doc.createTextNode(msg.getBody()));
        item.appendChild(el);
        el = doc.createElement("pubDate");
        Date date = new Date(msg.getHeader().getDate().getTime());
        String pubDate = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.ENGLISH).format(date);
        el.appendChild(doc.createTextNode(pubDate));
        item.appendChild(el);
        el = doc.createElement("message_order");
        el.appendChild(doc.createTextNode(msg.getHeader().getMessage_order().toString()));
        item.appendChild(el);
        List attachments = msg.getAnnouncementHeader().getAttachments();
        if (attachments.size() > 0) {
            for (Reference attachment : attachments) {
                el = doc.createElement("enclosure");
                el.setAttribute("url", attachment.getUrl());
                el.setAttribute("type", attachment.getType());
                item.appendChild(el);
            }
        }
        return item;
    }

    protected void printAnnouncementRss(OutputStream out, Reference rssRef) {
        try {
            Site site = this.m_siteService.getSite(rssRef.getContext());
            Document doc = this.docBuilder.newDocument();
            Element root = doc.createElement("rss");
            root.setAttribute("version", "2.0");
            doc.appendChild(root);
            Element channel = doc.createElement("channel");
            root.appendChild(channel);
            Element el = doc.createElement("title");
            el.appendChild(doc.createTextNode("Announcements for " + site.getTitle()));
            channel.appendChild(el);
            el = doc.createElement("description");
            String desc = site.getDescription() != null ? site.getDescription() : site.getTitle();
            el.appendChild(doc.createTextNode(desc));
            channel.appendChild(el);
            el = doc.createElement("link");
            StringBuilder siteUrl = new StringBuilder(this.m_serverConfigurationService.getServerUrl());
            siteUrl.append(this.m_serverConfigurationService.getString("portalPath"));
            siteUrl.append(site.getReference());
            el.appendChild(doc.createTextNode(siteUrl.toString()));
            channel.appendChild(el);
            el = doc.createElement("lastBuildDate");
            String now = new SimpleDateFormat("EEE', 'dd' 'MMM' 'yyyy' 'HH:mm:ss' 'Z", Locale.ENGLISH).format(new Date());
            el.appendChild(doc.createTextNode(now));
            channel.appendChild(el);
            el = doc.createElement("generator");
            el.appendChild(doc.createTextNode("Sakai Announcements RSS Generator"));
            channel.appendChild(el);
            AnnouncementChannel anncChan = (AnnouncementChannel)this.getChannelPublic(this.channelReference(rssRef.getContext(), "main"));
            if (anncChan == null) {
                M_log.warn((Object)((Object)this) + ".printAnnouncementRss invalid request " + rssRef.getContext());
                return;
            }
            List anncList = anncChan.getMessagesPublic(null, false);
            for (AnnouncementMessage msg : anncList) {
                if (!this.isMessageViewable(msg)) continue;
                Reference msgRef = this.m_entityManager.newReference(msg.getReference());
                Element item = this.generateItemElement(doc, msg, msgRef);
                channel.appendChild(item);
            }
            this.docTransformer.transform(new DOMSource(doc), new StreamResult(out));
        }
        catch (Exception e) {
            M_log.warn((Object)((Object)this) + "printAnnouncementRss ", (Throwable)e);
        }
    }

    protected void printAnnouncementHtml(PrintWriter out, Reference ref) throws EntityPermissionException, EntityNotDefinedException {
        try {
            if (ref.getProperties().getProperty("SAKAI:pubview") == null || !ref.getProperties().getProperty("SAKAI:pubview").equals(Boolean.TRUE.toString())) {
                this.unlock("read", ref.getReference());
            }
            AnnouncementMessage msg = (AnnouncementMessage)ref.getEntity();
            AnnouncementMessageHeader hdr = msg.getAnnouncementHeader();
            out.println("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" lang=\"en\" xml:lang=\"en\">\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n<style type=\"text/css\">body{margin:0px;padding:1em;font-family:Verdana,Arial,Helvetica,sans-serif;font-size:80%;}</style>\n<title>" + rb.getString("announcement") + ": " + Validator.escapeHtml((String)hdr.getSubject()) + "</title></head>\n<body>");
            out.println("<h1>" + rb.getString("announcement") + "</h1>");
            out.println("<table><tr><td><b>" + rb.getString("from_colon") + "</b></td><td>" + Validator.escapeHtml((String)hdr.getFrom().getDisplayName()) + "</td></tr>");
            out.println("<tr><td><b>" + rb.getString("date_colon") + "</b></td><td>" + Validator.escapeHtml((String)hdr.getDate().toStringLocalFull()) + "</td></tr>");
            out.println("<tr><td><b>" + rb.getString("subject_colon") + "</b></td><td>" + Validator.escapeHtml((String)hdr.getSubject()) + "</td></tr></table>");
            out.println("<p>" + Validator.escapeHtmlFormattedText((String)msg.getBody()) + "</p>");
            List attachments = hdr.getAttachments();
            if (attachments.size() > 0) {
                out.println("<p><b>" + rb.getString("attachments_colon") + "</b></p><p>");
                for (Reference attachment : attachments) {
                    out.println("<a href=\"" + Validator.escapeHtml((String)attachment.getUrl()) + "\">" + Validator.escapeHtml((String)attachment.getUrl()) + "</a><br />");
                }
                out.println("</p>");
            }
            out.println("</body></html>");
        }
        catch (PermissionException e) {
            throw new EntityPermissionException(e.getUser(), e.getLock(), e.getResource());
        }
    }

    public HttpAccess getHttpAccess() {
        return new HttpAccess(){

            public void handleAccess(HttpServletRequest req, HttpServletResponse res, Reference ref, Collection copyrightAcceptedRefs) throws EntityPermissionException, EntityNotDefinedException {
                if (!"msg".equals(ref.getSubType()) && !"rss".equals(ref.getSubType())) {
                    throw new EntityNotDefinedException(ref.getReference());
                }
                try {
                    if ("msg".equals(ref.getSubType())) {
                        res.setContentType("text/html; charset=UTF-8");
                        BaseAnnouncementService.this.printAnnouncementHtml(res.getWriter(), ref);
                    } else {
                        res.setContentType("application/xml");
                        res.setCharacterEncoding("UTF-8");
                        BaseAnnouncementService.this.printAnnouncementRss((OutputStream)res.getOutputStream(), ref);
                    }
                }
                catch (IOException e) {
                    throw new EntityNotDefinedException(ref.getReference());
                }
            }
        };
    }

    public AnnouncementChannel getAnnouncementChannel(String ref) throws IdUnusedException, PermissionException {
        return (AnnouncementChannel)this.getChannel(ref);
    }

    public AnnouncementChannelEdit addAnnouncementChannel(String ref) throws IdUsedException, IdInvalidException, PermissionException {
        return (AnnouncementChannelEdit)this.addChannel(ref);
    }

    public List getMessages(String channelReference, Filter filter, boolean order, boolean merged) throws IdUnusedException, PermissionException, NullPointerException {
        Vector messageList = new Vector();
        filter = new PrivacyFilter(filter);
        Site site = null;
        String initMergeList = null;
        try {
            site = this.m_siteService.getSite(this.getAnnouncementChannel(channelReference).getContext());
            ToolConfiguration tc = site.getToolForCommonId(SAKAI_ANNOUNCEMENT_TOOL_ID);
            if (tc != null) {
                initMergeList = tc.getPlacementConfig().getProperty(PORTLET_CONFIG_PARM_MERGED_CHANNELS);
            }
            MergedList mergedAnnouncementList = new MergedList();
            String[] channelArrayFromConfigParameterValue = null;
            channelArrayFromConfigParameterValue = mergedAnnouncementList.getChannelReferenceArrayFromDelimitedString(channelReference, initMergeList);
            for (int i = 0; i < channelArrayFromConfigParameterValue.length; ++i) {
                AnnouncementChannel siteChannel = this.getAnnouncementChannel(channelArrayFromConfigParameterValue[i]);
                if (siteChannel == null || !this.allowGetChannel(siteChannel.getReference()) || !merged && !siteChannel.getContext().equals(site.getId())) continue;
                messageList.addAll(siteChannel.getMessages(filter, order));
            }
            Collections.sort(messageList);
            if (!order) {
                Collections.reverse(messageList);
            }
        }
        catch (IdUnusedException e) {
            M_log.warn(e.getMessage());
        }
        catch (PermissionException e) {
            M_log.warn(e.getMessage());
        }
        catch (NullPointerException e) {
            M_log.warn(e.getMessage());
        }
        return messageList;
    }

    public String getLabel() {
        return "announcement";
    }

    protected String getSummaryFromHeader(Message item, MessageHeader header) {
        String newText;
        if (header instanceof AnnouncementMessageHeader) {
            AnnouncementMessageHeader hdr = (AnnouncementMessageHeader)header;
            newText = hdr.getSubject();
        } else {
            newText = item.getBody();
            if (newText.length() > 50) {
                newText = newText.substring(1, 49);
            }
        }
        newText = newText + ", " + header.getFrom().getDisplayName() + ", " + header.getDate().toStringLocalFull();
        return newText;
    }

    public void transferCopyEntities(String fromContext, String toContext, List resourceIds) {
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, resourceIds);
    }

    public Map<String, String> transferCopyEntitiesRefMigrator(String fromContext, String toContext, List resourceIds) {
        String oChannelRef = this.channelReference(fromContext, "main");
        AnnouncementChannel oChannel = null;
        try {
            oChannel = (AnnouncementChannel)this.getChannel(oChannelRef);
            String nChannelRef = this.channelReference(toContext, "main");
            AnnouncementChannel nChannel = null;
            try {
                nChannel = (AnnouncementChannel)this.getChannel(nChannelRef);
            }
            catch (IdUnusedException e) {
                try {
                    this.commitChannel(this.addChannel(nChannelRef));
                    try {
                        nChannel = (AnnouncementChannel)this.getChannel(nChannelRef);
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (nChannel != null) {
                List oMessageList = oChannel.getMessages(null, true);
                AnnouncementMessage oMessage = null;
                AnnouncementMessageHeaderEdit oMessageHeader = null;
                AnnouncementMessageEdit nMessage = null;
                for (int i = 0; i < oMessageList.size(); ++i) {
                    oMessage = (AnnouncementMessage)oMessageList.get(i);
                    String oMessageId = oMessage.getId();
                    boolean toBeImported = true;
                    if (resourceIds != null && resourceIds.size() > 0) {
                        toBeImported = false;
                        for (int m = 0; m < resourceIds.size() && !toBeImported; ++m) {
                            if (!((String)resourceIds.get(m)).equals(oMessageId)) continue;
                            toBeImported = true;
                        }
                    }
                    String assignmentReference = StringUtil.trimToNull((String)oMessage.getProperties().getProperty("assignmentReference"));
                    if (toBeImported && assignmentReference != null) {
                        toBeImported = false;
                    }
                    if (!toBeImported) continue;
                    oMessageHeader = (AnnouncementMessageHeaderEdit)oMessage.getHeader();
                    ResourceProperties oProperties = oMessage.getProperties();
                    nMessage = (AnnouncementMessageEdit)nChannel.addMessage();
                    nMessage.setBody(oMessage.getBody());
                    AnnouncementMessageHeaderEdit nMessageHeader = (AnnouncementMessageHeaderEdit)nMessage.getHeaderEdit();
                    nMessageHeader.setDate(oMessageHeader.getDate());
                    nMessageHeader.setMessage_order(oMessageHeader.getMessage_order());
                    if ("false".equalsIgnoreCase(this.m_serverConfigurationService.getString("import.importAsDraft"))) {
                        nMessageHeader.setDraft(oMessageHeader.getDraft());
                    } else {
                        nMessageHeader.setDraft(true);
                    }
                    nMessageHeader.setFrom(oMessageHeader.getFrom());
                    nMessageHeader.setSubject(oMessageHeader.getSubject());
                    List oAttachments = oMessageHeader.getAttachments();
                    List nAttachments = this.m_entityManager.newReferenceList();
                    for (int n = 0; n < oAttachments.size(); ++n) {
                        Reference oAttachmentRef = (Reference)oAttachments.get(n);
                        String oAttachmentId = ((Reference)oAttachments.get(n)).getId();
                        if (oAttachmentId.indexOf(fromContext) != -1) {
                            String nAttachmentId = oAttachmentId.replaceAll(fromContext, toContext);
                            try {
                                ContentResource attachment = this.contentHostingService.getResource(nAttachmentId);
                                nAttachments.add(this.m_entityManager.newReference(attachment.getReference()));
                            }
                            catch (IdUnusedException e) {
                                try {
                                    ContentResource oAttachment = this.contentHostingService.getResource(oAttachmentId);
                                    try {
                                        ContentResource attachment;
                                        if (this.contentHostingService.isAttachmentResource(nAttachmentId)) {
                                            attachment = this.contentHostingService.addAttachmentResource(Validator.escapeResourceName((String)oAttachment.getProperties().getProperty("DAV:displayname")), toContext, this.toolManager.getTool(SAKAI_ANNOUNCEMENT_TOOL_ID).getTitle(), oAttachment.getContentType(), oAttachment.getContent(), oAttachment.getProperties());
                                            nAttachments.add(this.m_entityManager.newReference(attachment.getReference()));
                                            continue;
                                        }
                                        attachment = this.contentHostingService.addResource(Validator.escapeResourceName((String)oAttachment.getProperties().getProperty("DAV:displayname")), toContext, 1, oAttachment.getContentType(), oAttachment.getContent(), oAttachment.getProperties(), 0);
                                        nAttachments.add(this.m_entityManager.newReference(attachment.getReference()));
                                    }
                                    catch (Exception eeAny) {
                                        M_log.warn(" cannot add new attachment with id=" + nAttachmentId);
                                    }
                                }
                                catch (Exception eAny) {
                                    M_log.warn(" cannot find the original attachment with id=" + oAttachmentId);
                                }
                            }
                            catch (Exception any) {
                                M_log.info(any.getMessage());
                            }
                            continue;
                        }
                        nAttachments.add(oAttachmentRef);
                    }
                    nMessageHeader.replaceAttachments(nAttachments);
                    ResourcePropertiesEdit p = nMessage.getPropertiesEdit();
                    p.clear();
                    p.addAll(oProperties);
                    nChannel.commitMessage((MessageEdit)nMessage, -1);
                }
            }
            this.transferSynopticOptions(fromContext, toContext);
        }
        catch (IdUnusedException e) {
            M_log.warn(" MessageChannel " + fromContext + " cannot be found. ");
        }
        catch (Exception any) {
            M_log.warn(".importResources(): exception in handling " + this.serviceName() + " : ", (Throwable)any);
        }
        return null;
    }

    public void updateEntityReferences(String toContext, Map<String, String> transversalMap) {
        block7: {
            if (transversalMap != null && transversalMap.size() > 0) {
                try {
                    Set<Map.Entry<String, String>> entrySet = transversalMap.entrySet();
                    String channelId = this.m_serverConfigurationService.getString("channel", null);
                    String toSiteId = toContext;
                    if (channelId != null) break block7;
                    channelId = this.channelReference(toSiteId, "main");
                    try {
                        AnnouncementChannel aChannel = this.getAnnouncementChannel(channelId);
                        this.m_threadLocalManager.set(aChannel.getReference() + ".msgs", null);
                        List mList = aChannel.getMessages(null, true);
                        for (AnnouncementMessage msg : mList) {
                            String msgBody = msg.getBody();
                            boolean updated = false;
                            for (Map.Entry<String, String> entry : entrySet) {
                                String fromContextRef = entry.getKey();
                                if (!msgBody.contains(fromContextRef)) continue;
                                msgBody = msgBody.replace(fromContextRef, entry.getValue());
                                updated = true;
                            }
                            if (!updated) continue;
                            AnnouncementMessageEdit editMsg = aChannel.editAnnouncementMessage(msg.getId());
                            editMsg.setBody(msgBody);
                            aChannel.commitMessage((MessageEdit)editMsg, -1);
                        }
                    }
                    catch (Exception e) {
                        M_log.debug("Unable to remove Announcements " + e);
                    }
                }
                catch (Exception e) {
                    M_log.debug("transferCopyEntities: End removing Announcement data");
                }
            }
        }
    }

    public String[] summarizableToolIds() {
        return new String[]{SAKAI_ANNOUNCEMENT_TOOL_ID, "sakai.motd"};
    }

    public String getSummarizableReference(String siteId, String toolIdentifier) {
        if ("sakai.motd".equals(toolIdentifier)) {
            return "/announcement/channel/!site/motd";
        }
        return super.getSummarizableReference(siteId, toolIdentifier);
    }

    public void transferCopyEntities(String fromContext, String toContext, List ids, boolean cleanup) {
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, ids, cleanup);
    }

    public Map<String, String> transferCopyEntitiesRefMigrator(String fromContext, String toContext, List ids, boolean cleanup) {
        block5: {
            try {
                if (!cleanup) break block5;
                String channelId = this.m_serverConfigurationService.getString("channel", null);
                String toSiteId = toContext;
                if (channelId != null) break block5;
                channelId = this.channelReference(toSiteId, "main");
                try {
                    AnnouncementChannel aChannel = this.getAnnouncementChannel(channelId);
                    List mList = aChannel.getMessages(null, true);
                    for (AnnouncementMessage msg : mList) {
                        aChannel.removeMessage(msg.getId());
                    }
                }
                catch (Exception e) {
                    M_log.debug("Unable to remove Announcements " + e);
                }
            }
            catch (Exception e) {
                M_log.debug("transferCopyEntities: End removing Announcement data");
            }
        }
        this.transferCopyEntitiesRefMigrator(fromContext, toContext, ids);
        return null;
    }

    public void clearMessagesCache(String channelRef) {
        this.m_threadLocalManager.set(channelRef + ".msgs", null);
    }

    protected class PrivacyFilter
    implements Filter {
        protected Filter m_filter = null;

        public PrivacyFilter(Filter filter) {
            this.m_filter = filter;
        }

        public boolean accept(Object o) {
            AnnouncementMessage msg;
            if (o instanceof AnnouncementMessage && (msg = (AnnouncementMessage)o).getAnnouncementHeader().getDraft() && !BaseAnnouncementService.this.m_securityService.isSuperUser() && !msg.getHeader().getFrom().getId().equals(BaseAnnouncementService.this.m_sessionManager.getCurrentSessionUserId()) && !BaseAnnouncementService.this.unlockCheck("read.drafts", msg.getReference())) {
                return false;
            }
            if (this.m_filter != null) {
                return this.m_filter.accept(o);
            }
            return true;
        }
    }

    public class BaseAnnouncementMessageHeaderEdit
    extends BaseMessage.BaseMessageHeaderEdit
    implements AnnouncementMessageHeaderEdit {
        protected String m_subject;

        public BaseAnnouncementMessageHeaderEdit(Message msg, String id) {
            super((BaseMessage)BaseAnnouncementService.this, msg, id);
            this.m_subject = null;
        }

        public BaseAnnouncementMessageHeaderEdit(Message msg, Element el) {
            super((BaseMessage)BaseAnnouncementService.this, msg, el);
            this.m_subject = null;
            this.m_subject = el.getAttribute("subject");
        }

        public BaseAnnouncementMessageHeaderEdit(Message msg, MessageHeader other) {
            super((BaseMessage)BaseAnnouncementService.this, msg, other);
            this.m_subject = null;
            this.m_subject = ((AnnouncementMessageHeader)other).getSubject();
        }

        public String getSubject() {
            return this.m_subject == null ? "" : this.m_subject;
        }

        public void setSubject(String subject) {
            if (StringUtil.different((String)subject, (String)this.m_subject)) {
                this.m_subject = subject;
            }
        }

        public Element toXml(Document doc, Stack stack) {
            Element header = super.toXml(doc, stack);
            header.setAttribute("subject", this.getSubject());
            header.setAttribute("draft", new Boolean(this.getDraft()).toString());
            return header;
        }
    }

    public class BaseAnnouncementMessageEdit
    extends BaseMessage.BaseMessageEdit
    implements AnnouncementMessageEdit {
        public BaseAnnouncementMessageEdit(MessageChannel channel, String id) {
            super((BaseMessage)BaseAnnouncementService.this, channel, id);
        }

        public BaseAnnouncementMessageEdit(MessageChannel channel, Message other) {
            super((BaseMessage)BaseAnnouncementService.this, channel, other);
        }

        public BaseAnnouncementMessageEdit(MessageChannel channel, Element el) {
            super((BaseMessage)BaseAnnouncementService.this, channel, el);
        }

        public AnnouncementMessageHeader getAnnouncementHeader() {
            return (AnnouncementMessageHeader)this.getHeader();
        }

        public AnnouncementMessageHeaderEdit getAnnouncementHeaderEdit() {
            return (AnnouncementMessageHeaderEdit)this.getHeader();
        }
    }

    public class BaseAnnouncementChannelEdit
    extends BaseMessage.BaseMessageChannelEdit<AnnouncementMessageEdit>
    implements AnnouncementChannelEdit {
        public BaseAnnouncementChannelEdit(String ref) {
            super((BaseMessage)BaseAnnouncementService.this, ref);
        }

        public BaseAnnouncementChannelEdit(MessageChannel other) {
            super((BaseMessage)BaseAnnouncementService.this, other);
        }

        public BaseAnnouncementChannelEdit(Element el) {
            super((BaseMessage)BaseAnnouncementService.this, el);
        }

        public AnnouncementMessage getAnnouncementMessage(String messageId) throws IdUnusedException, PermissionException {
            AnnouncementMessage msg = (AnnouncementMessage)this.getMessage(messageId);
            if (msg.getAnnouncementHeader().getDraft() && !BaseAnnouncementService.this.m_securityService.isSuperUser() && !msg.getHeader().getFrom().getId().equals(BaseAnnouncementService.this.m_sessionManager.getCurrentSessionUserId()) && !BaseAnnouncementService.this.unlockCheck("read.drafts", msg.getReference())) {
                throw new PermissionException(BaseAnnouncementService.this.m_sessionManager.getCurrentSessionUserId(), "read", msg.getReference());
            }
            return msg;
        }

        public List getMessages(Filter filter, boolean ascending) throws PermissionException {
            filter = new PrivacyFilter(filter);
            return super.getMessages(filter, ascending);
        }

        public AnnouncementMessageEdit editAnnouncementMessage(String messageId) throws IdUnusedException, PermissionException, InUseException {
            return (AnnouncementMessageEdit)this.editMessage(messageId);
        }

        public void removeAnnouncementMessage(String messageId) throws PermissionException {
            this.removeMessage(messageId);
        }

        public AnnouncementMessageEdit addAnnouncementMessage() throws PermissionException {
            return (AnnouncementMessageEdit)this.addMessage();
        }

        public AnnouncementMessage addAnnouncementMessage(String subject, boolean draft, List attachments, String body) throws PermissionException {
            AnnouncementMessageEdit edit = (AnnouncementMessageEdit)this.addMessage();
            AnnouncementMessageHeaderEdit header = edit.getAnnouncementHeaderEdit();
            edit.setBody(body);
            header.replaceAttachments(attachments);
            header.setSubject(subject);
            header.setDraft(draft);
            this.commitMessage((MessageEdit)edit);
            return edit;
        }

        public void commitMessage(MessageEdit edit, int priority, String invokee) {
            int currentMax = this.setMessageOrderMax(edit);
            this.setMessageUnreleasedMax(currentMax);
            super.commitMessage(edit, priority, invokee);
        }

        private void setMessageUnreleasedMax(int currentMax) {
            boolean releaseDateFirst = BaseAnnouncementService.this.m_serverConfigurationService.getBoolean("sakai.announcement.release_date_first", true);
            if (!releaseDateFirst) {
                return;
            }
            try {
                List msglist = this.getMessages(null, false);
                for (MessageEdit me : msglist) {
                    Date releaseDate = null;
                    try {
                        releaseDate = me.getProperties().getDateProperty("releaseDate");
                    }
                    catch (EntityPropertyNotDefinedException e) {
                        if (!M_log.isDebugEnabled()) continue;
                        M_log.debug("Exception moving an unreleased item.", (Throwable)e);
                        continue;
                    }
                    catch (EntityPropertyTypeException e) {
                        if (!M_log.isDebugEnabled()) continue;
                        M_log.debug("Exception moving an unreleased item.", (Throwable)e);
                        continue;
                    }
                    if (releaseDate.compareTo(new Date()) <= 0) continue;
                    if (M_log.isDebugEnabled()) {
                        M_log.debug("Placing unreleased announcement to top of list " + me.getId());
                    }
                    try {
                        AnnouncementMessageEdit em = this.editAnnouncementMessage(me.getId());
                        em.getHeaderEdit().setMessage_order(Integer.valueOf(++currentMax));
                        super.commitMessage((MessageEdit)em, -1, "");
                    }
                    catch (InUseException e) {
                        if (!M_log.isDebugEnabled()) continue;
                        M_log.debug("Exception moving an unreleased item.", (Throwable)e);
                    }
                    catch (IdUnusedException e) {
                        if (!M_log.isDebugEnabled()) continue;
                        M_log.debug("Exception moving an unreleased item.", (Throwable)e);
                    }
                }
            }
            catch (PermissionException ex) {
                M_log.error(ex.getMessage());
            }
        }

        private int setMessageOrderMax(MessageEdit msg) {
            int currentMax = 0;
            try {
                List msglist = this.getMessages(null, false);
                for (MessageEdit me : msglist) {
                    if (me.getHeaderEdit().getMessage_order() <= currentMax) continue;
                    currentMax = me.getHeaderEdit().getMessage_order();
                }
                msg.getHeaderEdit().setMessage_order(Integer.valueOf(++currentMax));
            }
            catch (PermissionException ex) {
                M_log.error(ex.getMessage());
            }
            return currentMax;
        }
    }
}

