/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.impl;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementMessageEdit;
import org.sakaiproject.announcement.api.AnnouncementMessageHeader;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationCommand;
import org.sakaiproject.api.app.scheduler.ScheduledInvocationManager;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.Notification;
import org.sakaiproject.event.api.NotificationEdit;
import org.sakaiproject.event.api.NotificationService;
import org.sakaiproject.event.cover.EventTrackingService;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.message.api.MessageHeader;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.EmailNotification;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.SiteEmailNotification;

public class SiteEmailNotificationAnnc
extends SiteEmailNotification
implements ScheduledInvocationCommand {
    private static ResourceLoader rb = new ResourceLoader("siteemaanc");
    private static final String PORTLET_CONFIG_PARM_MERGED_CHANNELS = "mergedAnnouncementChannels";
    private static Log M_log = LogFactory.getLog(SiteEmailNotificationAnnc.class);
    private ScheduledInvocationManager scheduledInvocationManager;

    public SiteEmailNotificationAnnc() {
    }

    public SiteEmailNotificationAnnc(String siteId) {
        super(siteId);
    }

    public void setScheduledInvocationManager(ScheduledInvocationManager service) {
        this.scheduledInvocationManager = service;
    }

    protected String getResourceAbility() {
        return "annc.read";
    }

    public void notify(Notification notification, Event event) {
        Reference ref = EntityManager.newReference((String)event.getResource());
        AnnouncementMessageEdit msg = (AnnouncementMessageEdit)ref.getEntity();
        AnnouncementMessageHeader hdr = msg.getAnnouncementHeader();
        if (hdr.getDraft()) {
            return;
        }
        Time now = TimeService.newTime();
        if (now.after(hdr.getDate())) {
            super.notify(notification, event);
        }
    }

    protected String htmlContent(Event event) {
        String siteId;
        StringBuilder buf = new StringBuilder();
        String newline = "<br />\n";
        Reference ref = EntityManager.newReference((String)event.getResource());
        AnnouncementMessage msg = (AnnouncementMessage)ref.getEntity();
        AnnouncementMessageHeader hdr = msg.getAnnouncementHeader();
        String title = siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        String url = ServerConfigurationService.getPortalUrl() + "/site/" + siteId;
        try {
            Site site = SiteService.getSite((String)siteId);
            title = site.getTitle();
            url = site.getUrl();
        }
        catch (Exception ignore) {
            M_log.warn((Object)("Failed to load site: " + siteId + " for: " + event.getResource()));
        }
        if ("annc.new".equals(event.getEvent())) {
            buf.append(rb.getFormattedMessage("noti.header.add", new Object[]{title, ServerConfigurationService.getString((String)"ui.service", (String)"Sakai"), url}));
        } else {
            buf.append(rb.getFormattedMessage("noti.header.update", new Object[]{title, ServerConfigurationService.getString((String)"ui.service", (String)"Sakai"), url}));
        }
        buf.append(newline);
        buf.append(newline);
        buf.append(newline);
        buf.append(rb.getString("Subject"));
        buf.append(hdr.getSubject());
        buf.append(newline);
        buf.append(newline);
        buf.append(rb.getString("Group"));
        buf.append(SiteEmailNotificationAnnc.getAnnouncementGroup(msg));
        buf.append(newline);
        buf.append(newline);
        buf.append(rb.getString("Message"));
        buf.append(newline);
        buf.append(newline);
        buf.append(msg.getBody());
        buf.append(newline);
        buf.append(newline);
        List attachments = hdr.getAttachments();
        if (attachments.size() > 0) {
            buf.append(newline + rb.getString("Attachments") + newline);
            for (Reference attachment : attachments) {
                String attachmentTitle = attachment.getProperties().getPropertyFormatted("DAV:displayname");
                buf.append("<a href=\"" + attachment.getUrl() + "\">");
                buf.append(attachmentTitle);
                buf.append("</a>" + newline);
            }
        }
        return buf.toString();
    }

    private static String getAnnouncementGroup(AnnouncementMessage a) {
        if (a.getProperties().getProperty("SAKAI:pubview") != null && a.getProperties().getProperty("SAKAI:pubview").equals(Boolean.TRUE.toString())) {
            return rb.getString("Public");
        }
        if (a.getAnnouncementHeader().getAccess().equals(MessageHeader.MessageAccess.CHANNEL)) {
            return rb.getString("Allgroups");
        }
        int count = 0;
        String allGroupString = "";
        try {
            Site site = SiteService.getSite((String)EntityManager.newReference((String)a.getReference()).getContext());
            Iterator i = a.getAnnouncementHeader().getGroups().iterator();
            while (i.hasNext()) {
                Group aGroup = site.getGroup((String)i.next());
                if (aGroup == null) continue;
                if (++count > 1) {
                    allGroupString = allGroupString.concat(", ").concat(aGroup.getTitle());
                    continue;
                }
                allGroupString = aGroup.getTitle();
            }
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        return allGroupString;
    }

    protected List getHeaders(Event event) {
        List rv = super.getHeaders(event);
        rv.add("Subject: " + this.getSubject(event));
        rv.add(this.getFromAddress(event));
        rv.add(this.getTo(event));
        return rv;
    }

    protected String getTag(String title, boolean shouldUseHtml) {
        if (shouldUseHtml) {
            return rb.getFormattedMessage("noti.tag.html", new Object[]{ServerConfigurationService.getString((String)"ui.service", (String)"Sakai"), ServerConfigurationService.getPortalUrl(), title});
        }
        return rb.getFormattedMessage("noti.tag", new Object[]{ServerConfigurationService.getString((String)"ui.service", (String)"Sakai"), ServerConfigurationService.getPortalUrl(), title});
    }

    protected String getSubject(Event event) {
        String siteId;
        Reference ref = EntityManager.newReference((String)event.getResource());
        AnnouncementMessage msg = (AnnouncementMessage)ref.getEntity();
        AnnouncementMessageHeader hdr = msg.getAnnouncementHeader();
        String title = siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        try {
            Site site = SiteService.getSite((String)siteId);
            title = site.getTitle();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return rb.getFormattedMessage("noti.subj", new Object[]{title, hdr.getSubject()});
    }

    protected String getFromAddress(Event event) {
        Reference ref = EntityManager.newReference((String)event.getResource());
        String siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        String title = "";
        try {
            Site site = SiteService.getSite((String)siteId);
            title = site.getTitle();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String userEmail = "no-reply@" + ServerConfigurationService.getServerName();
        String userDisplay = ServerConfigurationService.getString((String)"ui.service", (String)"Sakai");
        String from = "From: Sakai";
        if (title != null && !title.equals("")) {
            from = "From: \"" + title + "\" <" + userEmail + ">";
        } else {
            String fromVal = this.getFrom(event);
            if (fromVal != null) {
                from = fromVal;
            }
        }
        AnnouncementMessage msg = (AnnouncementMessage)ref.getEntity();
        String userId = msg.getAnnouncementHeader().getFrom().getDisplayId();
        boolean notificationEmailFromReplyable = ServerConfigurationService.getBoolean((String)"notify.email.from.replyable", (boolean)false);
        if (notificationEmailFromReplyable && from.contains("no-reply@") && userId != null) {
            try {
                User u = UserDirectoryService.getUser((String)userId);
                userDisplay = u.getDisplayName();
                userEmail = u.getEmail();
                if (userEmail != null && userEmail.trim().length() == 0) {
                    userEmail = null;
                }
            }
            catch (UserNotDefinedException e) {
                // empty catch block
            }
            if (userEmail == null) {
                userEmail = "no-reply@" + ServerConfigurationService.getServerName();
            }
            if (userDisplay == null) {
                userDisplay = ServerConfigurationService.getString((String)"ui.service", (String)"Sakai");
            }
            from = "From: \"" + userDisplay + "\" <" + userEmail + ">";
        }
        return from;
    }

    protected void addSpecialRecipients(List users, Reference ref) {
    }

    public void execute(String opaqueContext) {
        Reference ref = EntityManager.newReference((String)opaqueContext);
        this.enableSecurityAdvisorToGetAnnouncement();
        AnnouncementMessage msg = (AnnouncementMessage)ref.getEntity();
        AnnouncementMessageHeader hdr = msg.getAnnouncementHeader();
        String notification = msg.getProperties().getProperty("notificationLevel");
        int noti = 2;
        if ("r".equals(notification)) {
            noti = 1;
        } else if ("n".equals(notification)) {
            noti = 0;
        }
        Event delayedNotificationEvent = EventTrackingService.newEvent((String)"annc.schInv.notify", (String)msg.getReference(), (boolean)true, (int)noti);
        NotificationService notificationService = (NotificationService)ComponentManager.get(NotificationService.class);
        NotificationEdit notify = notificationService.addTransientNotification();
        super.notify((Notification)notify, delayedNotificationEvent);
        this.disableSecurityAdvisor();
    }

    protected void enableSecurityAdvisorToGetAnnouncement() {
        SecurityService.pushAdvisor((SecurityAdvisor)new SecurityAdvisor(){

            public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                if (function.equals("annc.read") || function.equals("content.read")) {
                    return SecurityAdvisor.SecurityAdvice.ALLOWED;
                }
                return SecurityAdvisor.SecurityAdvice.PASS;
            }
        });
    }

    protected void disableSecurityAdvisor() {
        SecurityService.popAdvisor();
    }

    protected EmailNotification makeEmailNotification() {
        return new SiteEmailNotificationAnnc();
    }

    protected String plainTextContent(Event event) {
        String siteId;
        StringBuilder buf = new StringBuilder();
        String newline = "\n\r";
        Reference ref = EntityManager.newReference((String)event.getResource());
        AnnouncementMessage msg = (AnnouncementMessage)ref.getEntity();
        AnnouncementMessageHeader hdr = msg.getAnnouncementHeader();
        String title = siteId = this.getSite() != null ? this.getSite() : ref.getContext();
        try {
            Site site = SiteService.getSite((String)siteId);
            title = site.getTitle();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        if ("annc.new".equals(event.getEvent())) {
            buf.append(FormattedText.convertFormattedTextToPlaintext((String)rb.getFormattedMessage("noti.header.add", new Object[]{title, ServerConfigurationService.getString((String)"ui.service", (String)"Sakai"), ServerConfigurationService.getPortalUrl(), siteId})));
        } else {
            buf.append(FormattedText.convertFormattedTextToPlaintext((String)rb.getFormattedMessage("noti.header.update", new Object[]{title, ServerConfigurationService.getString((String)"ui.service", (String)"Sakai"), ServerConfigurationService.getPortalUrl(), siteId})));
        }
        buf.append(newline);
        buf.append(newline);
        buf.append(newline);
        buf.append(rb.getString("Subject"));
        buf.append(hdr.getSubject());
        buf.append(newline);
        buf.append(newline);
        buf.append(rb.getString("Group"));
        buf.append(SiteEmailNotificationAnnc.getAnnouncementGroup(msg));
        buf.append(newline);
        buf.append(newline);
        buf.append(rb.getString("Message"));
        buf.append(newline);
        buf.append(newline);
        buf.append(FormattedText.convertFormattedTextToPlaintext((String)msg.getBody()));
        buf.append(newline);
        buf.append(newline);
        List attachments = hdr.getAttachments();
        if (attachments.size() > 0) {
            buf.append(newline + rb.getString("Attachments") + newline);
            for (Reference attachment : attachments) {
                String attachmentTitle = attachment.getProperties().getPropertyFormatted("DAV:displayname");
                buf.append(attachmentTitle + ": " + attachment.getUrl() + newline);
            }
        }
        return buf.toString();
    }
}

