/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.entityprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.announcement.api.AnnouncementChannel;
import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementMessageHeader;
import org.sakaiproject.announcement.api.AnnouncementService;
import org.sakaiproject.announcement.entityprovider.AnnouncementEntityProviderImpl;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityPermissionException;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entitybroker.EntityBrokerManager;
import org.sakaiproject.entitybroker.EntityReference;
import org.sakaiproject.entitybroker.EntityView;
import org.sakaiproject.entitybroker.entityprovider.CoreEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.annotations.EntityCustomAction;
import org.sakaiproject.entitybroker.entityprovider.capabilities.ActionsExecutable;
import org.sakaiproject.entitybroker.entityprovider.capabilities.AutoRegisterEntityProvider;
import org.sakaiproject.entitybroker.entityprovider.capabilities.RESTful;
import org.sakaiproject.entitybroker.entityprovider.search.Search;
import org.sakaiproject.entitybroker.exception.EntityException;
import org.sakaiproject.entitybroker.exception.EntityNotFoundException;
import org.sakaiproject.entitybroker.util.AbstractEntityProvider;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.message.api.Message;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.tool.api.ToolManager;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.MergedList;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnouncementEntityProviderImpl
extends AbstractEntityProvider
implements CoreEntityProvider,
AutoRegisterEntityProvider,
ActionsExecutable,
RESTful {
    public static final String ENTITY_PREFIX = "announcement";
    private static final String PORTLET_CONFIG_PARAM_MERGED_CHANNELS = "mergedAnnouncementChannels";
    private static final String MOTD_SITEID = "!site";
    private static final String ADMIN_SITEID = "!admin";
    private static final String MOTD_CHANNEL_SUFFIX = "motd";
    public static int DEFAULT_NUM_ANNOUNCEMENTS = 3;
    public static int DEFAULT_DAYS_IN_PAST = 10;
    private static final Log log = LogFactory.getLog(AnnouncementEntityProviderImpl.class);
    private static ResourceLoader rb = new ResourceLoader("announcement");
    private EntityBrokerManager entityBrokerManager;
    private EntityManager entityManager;
    private SecurityService securityService;
    private SessionManager sessionManager;
    private SiteService siteService;
    private AnnouncementService announcementService;
    private UserDirectoryService userDirectoryService;
    private TimeService timeService;
    private ToolManager toolManager;

    public void setEntityBrokerManager(EntityBrokerManager entityBrokerManager) {
        this.entityBrokerManager = entityBrokerManager;
    }

    public String getEntityPrefix() {
        return ENTITY_PREFIX;
    }

    public List<?> getAnnouncements(String siteId, Map<String, Object> params, boolean onlyPublic) {
        boolean motdView = false;
        if (StringUtils.equals((String)siteId, (String)MOTD_SITEID)) {
            motdView = true;
        }
        int numberOfAnnouncements = NumberUtils.toInt((String)((String)params.get("n")), (int)0);
        int numberOfDaysInThePast = NumberUtils.toInt((String)((String)params.get("d")), (int)0);
        String currentUserId = this.sessionManager.getCurrentSessionUserId();
        log.debug((Object)("motdView: " + motdView));
        log.debug((Object)("siteId: " + siteId));
        log.debug((Object)("currentUserId: " + currentUserId));
        log.debug((Object)("onlyPublic: " + onlyPublic));
        if (!(onlyPublic || motdView || this.securityService.unlock(currentUserId, "annc.read", this.siteService.siteReference(siteId)))) {
            throw new SecurityException("You do not have access to site: " + siteId);
        }
        List channels = this.getChannels(siteId);
        if (channels.size() == 0) {
            throw new EntityNotFoundException("No announcement channels found for site: " + siteId, siteId);
        }
        log.debug((Object)("channels: " + channels.toString()));
        log.debug((Object)("num channels: " + channels.size()));
        Site site = null;
        String siteTitle = null;
        ToolConfiguration synopticTc = null;
        if (!motdView) {
            try {
                site = this.siteService.getSite(siteId);
            }
            catch (IdUnusedException e) {
                throw new IllegalArgumentException("No site found for the siteid:" + siteId + " : " + e.getMessage());
            }
            synopticTc = site.getToolForCommonId("sakai.synoptic.announcement");
        }
        if (synopticTc != null) {
            Properties props = synopticTc.getPlacementConfig();
            if (props.isEmpty()) {
                props = synopticTc.getConfig();
            }
            if (props != null) {
                if (numberOfAnnouncements == 0 && props.get("items") != null) {
                    numberOfAnnouncements = this.getIntegerParameter((Map)props, "items", DEFAULT_NUM_ANNOUNCEMENTS);
                }
                if (numberOfDaysInThePast == 0 && props.get("days") != null) {
                    numberOfDaysInThePast = this.getIntegerParameter((Map)props, "days", DEFAULT_DAYS_IN_PAST);
                }
            }
        }
        siteTitle = !motdView ? site.getTitle() : rb.getString("motd.title");
        if (numberOfAnnouncements == 0) {
            numberOfAnnouncements = DEFAULT_NUM_ANNOUNCEMENTS;
        }
        if (numberOfDaysInThePast == 0) {
            numberOfDaysInThePast = DEFAULT_DAYS_IN_PAST;
        }
        log.debug((Object)("numberOfAnnouncements: " + numberOfAnnouncements));
        log.debug((Object)("numberOfDaysInThePast: " + numberOfDaysInThePast));
        Time t = this.timeService.newTime(this.getTimeForDaysInPast(numberOfDaysInThePast).getTime());
        ArrayList announcements = new ArrayList();
        for (String channel : channels) {
            try {
                announcements.addAll(this.announcementService.getMessages(channel, t, numberOfAnnouncements, true, false, onlyPublic));
            }
            catch (PermissionException e) {
                log.warn((Object)("User: " + currentUserId + " does not have access to view the announcement channel: " + channel + ". Skipping..."));
            }
        }
        log.debug((Object)("announcements.size(): " + announcements.size()));
        List<DecoratedAnnouncement> decoratedAnnouncements = new ArrayList();
        for (Message m : announcements) {
            AnnouncementMessage a = (AnnouncementMessage)m;
            try {
                DecoratedAnnouncement da = this.createDecoratedAnnouncement(a, siteTitle);
                decoratedAnnouncements.add(da);
            }
            catch (Exception e) {
                log.info((Object)("Exception caught processing announcement: " + m.getId() + " for user: " + currentUserId + ". Skipping..."));
            }
        }
        Collections.sort(decoratedAnnouncements);
        Collections.reverse(decoratedAnnouncements);
        if (numberOfAnnouncements > announcements.size()) {
            numberOfAnnouncements = announcements.size();
        }
        decoratedAnnouncements = decoratedAnnouncements.subList(0, numberOfAnnouncements);
        return decoratedAnnouncements;
    }

    private DecoratedAnnouncement createDecoratedAnnouncement(AnnouncementMessage a, String siteTitle) {
        String reference = a.getReference();
        String announcementId = a.getId();
        Reference ref = this.entityManager.newReference(reference);
        String siteId = ref.getContext();
        String channel = ref.getContainer();
        DecoratedAnnouncement da = new DecoratedAnnouncement(this, siteId, channel, announcementId);
        da.setTitle(a.getAnnouncementHeader().getSubject());
        da.setBody(a.getBody());
        da.setCreatedByDisplayName(a.getHeader().getFrom().getDisplayName());
        da.setCreatedOn(new Date(a.getHeader().getDate().getTime()));
        da.setSiteId(siteId);
        da.setSiteTitle(siteTitle);
        ArrayList<DecoratedAttachment> attachments = new ArrayList<DecoratedAttachment>();
        for (Reference attachment : a.getHeader().getAttachments()) {
            String url = attachment.getUrl();
            String name = attachment.getProperties().getPropertyFormatted(attachment.getProperties().getNamePropDisplayName());
            DecoratedAttachment decoratedAttachment = new DecoratedAttachment(this, name, url);
            attachments.add(decoratedAttachment);
        }
        da.setAttachments(attachments);
        return da;
    }

    private List<DecoratedAttachment> decorateAttachments(List<Reference> attachments) {
        ArrayList<DecoratedAttachment> decoAttachments = new ArrayList<DecoratedAttachment>();
        for (Reference attachment : attachments) {
            DecoratedAttachment da = new DecoratedAttachment(this);
            da.setId(Validator.escapeHtml((String)attachment.getId()));
            da.setName(Validator.escapeHtml((String)attachment.getProperties().getPropertyFormatted(attachment.getProperties().getNamePropDisplayName())));
            da.setType(attachment.getProperties().getProperty(attachment.getProperties().getNamePropContentType()));
            da.setUrl(attachment.getUrl());
            da.setRef(attachment.getEntity().getReference());
            decoAttachments.add(da);
        }
        return decoAttachments;
    }

    public DecoratedAnnouncement findEntityById(String entityId, String siteId) {
        AnnouncementMessage tempMsg = null;
        DecoratedAnnouncement decoratedAnnouncement = new DecoratedAnnouncement(this);
        if (entityId != null) {
            try {
                AnnouncementChannel announcementChannel = this.announcementService.getAnnouncementChannel("/announcement/channel/" + siteId + "/main");
                tempMsg = (AnnouncementMessage)announcementChannel.getMessage(entityId);
            }
            catch (IdUnusedException e) {
                log.error((Object)"ID Unused Exception");
            }
            catch (PermissionException e) {
                log.error((Object)"ID PermissionException");
            }
        }
        decoratedAnnouncement.setSiteId(tempMsg.getId());
        decoratedAnnouncement.setBody(tempMsg.getBody());
        AnnouncementMessageHeader header = tempMsg.getAnnouncementHeader();
        decoratedAnnouncement.setTitle(header.getSubject());
        List attachments = header.getAttachments();
        List attachmentUrls = this.decorateAttachments(attachments);
        decoratedAnnouncement.setAttachments(attachmentUrls);
        decoratedAnnouncement.setCreatedOn(new Date(header.getDate().getTime()));
        decoratedAnnouncement.setCreatedByDisplayName(header.getFrom().getDisplayName());
        decoratedAnnouncement.setSiteId(siteId);
        return decoratedAnnouncement;
    }

    private int getIntegerParameter(Map<?, ?> params, String paramName, int defaultValue) {
        String intValString = (String)params.get(paramName);
        if (StringUtils.trimToNull((String)intValString) != null) {
            return Integer.parseInt(intValString);
        }
        return defaultValue;
    }

    private Date getTimeForDaysInPast(int n) {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -n);
        return cal.getTime();
    }

    private List<String> getChannels(String siteId) {
        ToolConfiguration toolConfig;
        List<Object> channels = new ArrayList();
        if (StringUtils.equals((String)siteId, (String)MOTD_SITEID)) {
            log.debug((Object)"is motd site, returning motd channel");
            channels = Collections.singletonList(this.announcementService.channelReference(siteId, MOTD_CHANNEL_SUFFIX));
            return channels;
        }
        if (this.siteService.isUserSite(siteId) && !this.securityService.isSuperUser()) {
            log.debug((Object)"is user site and not super user, returning all permitted channels");
            channels = Arrays.asList(new MergedList().getAllPermittedChannels((MergedList.ChannelReferenceMaker)new AnnouncementChannelReferenceMaker(this, null)));
            return channels;
        }
        Site site = null;
        try {
            site = this.siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            return channels;
        }
        if (site != null && (toolConfig = site.getToolForCommonId("sakai.announcements")) != null) {
            Properties props = toolConfig.getPlacementConfig();
            if (props.isEmpty()) {
                props = toolConfig.getConfig();
            }
            if (props != null) {
                String mergeProp = (String)props.get(PORTLET_CONFIG_PARAM_MERGED_CHANNELS);
                if (StringUtils.isNotBlank((String)mergeProp)) {
                    log.debug((Object)"is normal site or super user, returning all merged channels in this site");
                    log.debug((Object)("mergeProp: " + mergeProp));
                    channels = Arrays.asList(new MergedList().getChannelReferenceArrayFromDelimitedString(new AnnouncementChannelReferenceMaker(this, null).makeReference(siteId), mergeProp));
                } else {
                    log.debug((Object)"is normal site or super user but no merged channels, using original siteId channel");
                    channels = Collections.singletonList(this.announcementService.channelReference(siteId, "main"));
                }
            }
        }
        return channels;
    }

    @EntityCustomAction(action="site", viewKey="list")
    public List<?> getAnnouncementsForSite(EntityView view, Map<String, Object> params) {
        String siteId = view.getPathSegment(2);
        if (StringUtils.isBlank((String)siteId)) {
            throw new IllegalArgumentException("siteId must be set in order to get the announcements for a site, via the URL /announcement/site/siteId");
        }
        boolean onlyPublic = false;
        String currentUserId = this.sessionManager.getCurrentSessionUserId();
        if (StringUtils.isBlank((String)currentUserId)) {
            onlyPublic = true;
        }
        if (!this.siteService.siteExists(siteId)) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, siteId);
        }
        List l = this.getAnnouncements(siteId, params, onlyPublic);
        return l;
    }

    @EntityCustomAction(action="user", viewKey="list")
    public List<?> getAnnouncementsForUser(EntityView view, Map<String, Object> params) {
        String userId = this.sessionManager.getCurrentSessionUserId();
        if (StringUtils.isBlank((String)userId)) {
            return this.getMessagesOfTheDay(view, params);
        }
        String siteId = this.siteService.getUserSiteId(userId);
        if (StringUtils.isBlank((String)siteId)) {
            throw new IllegalArgumentException("No siteId was found for userId: " + userId);
        }
        if (StringUtils.equals((String)userId, (String)"admin")) {
            siteId = ADMIN_SITEID;
        }
        List l = this.getAnnouncements(siteId, params, false);
        return l;
    }

    @EntityCustomAction(action="motd", viewKey="list")
    public List<?> getMessagesOfTheDay(EntityView view, Map<String, Object> params) {
        List l = this.getAnnouncements(MOTD_SITEID, params, false);
        return l;
    }

    @EntityCustomAction(action="msg", viewKey="list")
    public DecoratedAnnouncement showAnnouncement(EntityView view, Map<String, Object> params) throws EntityPermissionException {
        String siteId = view.getPathSegment(2);
        String channelId = view.getPathSegment(3);
        String announcementId = view.getPathSegment(4);
        return this.getAnnouncement(siteId, channelId, announcementId);
    }

    @EntityCustomAction(action="message", viewKey="list")
    public Object getAnnouncementByID(EntityView view, Map<String, Object> params) {
        String siteId = view.getPathSegment(2);
        String msgId = view.getPathSegment(3);
        if (StringUtils.isBlank((String)siteId) || StringUtils.isBlank((String)msgId)) {
            throw new IllegalArgumentException("siteId must be set in order to get the announcements for a site, via the URL /announcement/site/siteId");
        }
        boolean onlyPublic = false;
        String currentUserId = this.sessionManager.getCurrentSessionUserId();
        if (StringUtils.isBlank((String)currentUserId)) {
            onlyPublic = true;
        }
        if (!this.siteService.siteExists(siteId)) {
            throw new EntityNotFoundException("Invalid siteId: " + siteId, siteId);
        }
        return this.findEntityById(msgId, siteId);
    }

    private DecoratedAnnouncement getAnnouncement(String siteId, String channelId, String announcementId) {
        if (announcementId == null || announcementId.length() == 0) {
            throw new IllegalArgumentException("You must supply an announcementId");
        }
        if (siteId == null || siteId.length() == 0) {
            throw new IllegalArgumentException("You must supply the siteId.");
        }
        if (channelId == null || channelId.length() == 0) {
            throw new IllegalArgumentException("You must supply an channelId");
        }
        String ref = this.announcementService.channelReference(siteId, channelId);
        try {
            AnnouncementChannel channel = this.announcementService.getAnnouncementChannel(ref);
            AnnouncementMessage message = channel.getAnnouncementMessage(announcementId);
            return this.createDecoratedAnnouncement(message, null);
        }
        catch (IdUnusedException e) {
            throw new EntityNotFoundException("Couldn't find: " + e.getId(), e.getId());
        }
        catch (PermissionException e) {
            throw new EntityException("You don't have permissions to access this channel.", e.getResource(), 403);
        }
    }

    public boolean entityExists(String id) {
        return true;
    }

    public Object getSampleEntity() {
        return new DecoratedAnnouncement(this);
    }

    public List<String> findEntityRefs(String[] arg0, String[] arg1, String[] arg2, boolean arg3) {
        return null;
    }

    public String createEntity(EntityReference ref, Object entity, Map<String, Object> params) {
        return null;
    }

    public void updateEntity(EntityReference ref, Object entity, Map<String, Object> params) {
    }

    public void deleteEntity(EntityReference ref, Map<String, Object> params) {
    }

    public String[] getHandledOutputFormats() {
        return new String[]{"xml", "json"};
    }

    public String[] getHandledInputFormats() {
        return null;
    }

    public List<?> getEntities(EntityReference ref, Search search) {
        return null;
    }

    public Object getEntity(EntityReference ref) {
        String[] parts;
        String id = ref.getId();
        if (id != null && (parts = id.split(":")).length == 3) {
            String siteId = parts[0];
            String channelId = parts[1];
            String announcementId = parts[2];
            return this.getAnnouncement(siteId, channelId, announcementId);
        }
        return null;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setSiteService(SiteService siteService) {
        this.siteService = siteService;
    }

    public void setAnnouncementService(AnnouncementService announcementService) {
        this.announcementService = announcementService;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        this.userDirectoryService = userDirectoryService;
    }

    public void setTimeService(TimeService timeService) {
        this.timeService = timeService;
    }

    public void setToolManager(ToolManager toolManager) {
        this.toolManager = toolManager;
    }

    static /* synthetic */ AnnouncementService access$100(AnnouncementEntityProviderImpl x0) {
        return x0.announcementService;
    }
}

