/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.announcement.tool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.alias.api.Alias;
import org.sakaiproject.alias.cover.AliasService;
import org.sakaiproject.announcement.api.AnnouncementChannel;
import org.sakaiproject.announcement.api.AnnouncementChannelEdit;
import org.sakaiproject.announcement.api.AnnouncementMessage;
import org.sakaiproject.announcement.api.AnnouncementMessageEdit;
import org.sakaiproject.announcement.api.AnnouncementMessageHeaderEdit;
import org.sakaiproject.announcement.cover.AnnouncementService;
import org.sakaiproject.announcement.tool.AnnouncementAction;
import org.sakaiproject.announcement.tool.AnnouncementActionState;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.cheftool.Context;
import org.sakaiproject.cheftool.ControllerState;
import org.sakaiproject.cheftool.JetspeedRunData;
import org.sakaiproject.cheftool.PagedResourceActionII;
import org.sakaiproject.cheftool.RunData;
import org.sakaiproject.cheftool.VelocityPortlet;
import org.sakaiproject.cheftool.api.Menu;
import org.sakaiproject.cheftool.api.MenuItem;
import org.sakaiproject.cheftool.menu.MenuDivider;
import org.sakaiproject.cheftool.menu.MenuEntry;
import org.sakaiproject.cheftool.menu.MenuImpl;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.cover.ContentTypeImageService;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.entitybroker.EntityBroker;
import org.sakaiproject.entitybroker.entityprovider.extension.ActionReturn;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.event.api.SessionState;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.javax.Filter;
import org.sakaiproject.javax.PagingPosition;
import org.sakaiproject.message.api.Message;
import org.sakaiproject.message.api.MessageChannelEdit;
import org.sakaiproject.message.api.MessageEdit;
import org.sakaiproject.message.api.MessageHeader;
import org.sakaiproject.site.api.Group;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.ToolConfiguration;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.api.Placement;
import org.sakaiproject.tool.api.Tool;
import org.sakaiproject.tool.api.ToolSession;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.tool.cover.ToolManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.MergedList;
import org.sakaiproject.util.MergedListEntryProviderFixedListWrapper;
import org.sakaiproject.util.ParameterParser;
import org.sakaiproject.util.ResourceLoader;
import org.sakaiproject.util.SortedIterator;
import org.sakaiproject.util.StringUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnnouncementAction
extends PagedResourceActionII {
    private static Log M_log = LogFactory.getLog(AnnouncementAction.class);
    private static ResourceLoader rb = new ResourceLoader("announcement");
    private static final String CONTEXT_ENABLED_MENU_ITEM_EXISTS = "EnabledMenuItemExists";
    private static final String CONTEXT_ENABLE_ITEM_CHECKBOXES = "EnableItemCheckBoxes";
    private static final String ENABLED_MENU_ITEM_EXISTS = "EnabledMenuItemExists";
    private static final String NOT_SELECTED_FOR_REVISE_STATUS = "noSelectedForRevise";
    private static final String FINISH_DELETING_STATUS = "FinishDeleting";
    private static final String DELETE_ANNOUNCEMENT_STATUS = "deleteAnnouncement";
    private static final String POST_STATUS = "post";
    private static final String CANCEL_STATUS = "cancel";
    private static final String MERGE_STATUS = "merge";
    private static final String REORDER_STATUS = "reorder";
    private static final String OPTIONS_STATUS = "options";
    private static final String SSTATE_NOTI_VALUE = "noti_value";
    private static final String SSTATE_PUBLICVIEW_VALUE = "public_view_value";
    private static final String SORT_DATE = "date";
    private static final String SORT_MESSAGE_ORDER = "message_order";
    private static final String SORT_RELEASEDATE = "releasedate";
    private static final String SORT_RETRACTDATE = "retractdate";
    private static final String SORT_PUBLIC = "public";
    private static final String SORT_FROM = "from";
    private static final String SORT_SUBJECT = "subject";
    private static final String SORT_CHANNEL = "channel";
    private static final String SORT_FOR = "for";
    private static final String SORT_GROUPTITLE = "grouptitle";
    private static final String SORT_GROUPDESCRIPTION = "groupdescription";
    private static String SORT_CURRENTORDER = "date";
    private static final String CONTEXT_VAR_DISPLAY_OPTIONS = "displayOptions";
    private static final String VELOCITY_DISPLAY_OPTIONS = "displayOptions";
    private static final String PERMISSIONS_BUTTON_HANDLER = "doPermissions";
    private static final String REORDER_BUTTON_HANDLER = "doReorder";
    private static final String REFRESH_BUTTON_HANDLER = "doCancel";
    private static final String MERGE_BUTTON_HANDLER = "doMerge";
    private static final String SSTATE_ATTRIBUTE_MERGED_CHANNELS = "mergedChannels";
    private static final String VELOCITY_MERGED_CHANNEL_LIST = "mergedAnnouncementsCollection";
    private static final String STATE_CHANNEL_REF = "channelId";
    private static final String STATE_CHANNEL_PUBVIEW = "channelPubView";
    private static final String PORTLET_CONFIG_PARM_NON_MERGED_CHANNELS = "nonMergedAnnouncementChannels";
    private static final String PORTLET_CONFIG_PARM_MERGED_CHANNELS = "mergedAnnouncementChannels";
    public static final String STATE_MESSAGE = "message";
    public static final String STATE_MESSAGES = "pagedMessages";
    protected static final String STATE_INITED = "annc.state.inited";
    private static final String STATE_CURRENT_SORTED_BY = "session.state.sorted.by";
    private static final String STATE_CURRENT_SORT_ASC = "session.state.sort.asc";
    private static final String STATE_SELECTED_VIEW = "state.selected.view";
    private static final String SC_TRUE = "true";
    private static final String SC_FALSE = "false";
    private static final String PUBLIC_DISPLAY_DISABLE_BOOLEAN = "publicDisplayBoolean";
    private static final String VIEW_MODE_ALL = "view.all";
    private static final String VIEW_MODE_PUBLIC = "view.public";
    private static final String VIEW_MODE_BYGROUP = "view.bygroup";
    private static final String VIEW_MODE_MYGROUPS = "view.mygroups";
    private static final long MILLISECONDS_IN_DAY = 86400000L;
    private static final long FUTURE_DAYS = 7L;
    private static final String HIDDEN = "hidden";
    private static final String SPECIFY_DATES = "specify";
    private static final String SYNOPTIC_ANNOUNCEMENT_TOOL = "sakai.synoptic.announcement";
    private static final String UPDATE_PERMISSIONS = "site.upd";
    private ContentHostingService contentHostingService = null;
    private EventTrackingService eventTrackingService = null;
    private EntityBroker entityBroker;

    public static String getCurrentOrder() {
        String enableReorder = ServerConfigurationService.getString((String)"sakai.announcement.reorder", (String)"false");
        if (enableReorder.equals("true")) {
            SORT_CURRENTORDER = "message_order";
        }
        return SORT_CURRENTORDER;
    }

    private static String getAnnouncementRange(AnnouncementMessage a) {
        if (a.getProperties().getProperty("SAKAI:pubview") != null && a.getProperties().getProperty("SAKAI:pubview").equals(Boolean.TRUE.toString())) {
            return rb.getString("gen.public");
        }
        if (a.getAnnouncementHeader().getAccess().equals(MessageHeader.MessageAccess.CHANNEL)) {
            return rb.getString("range.allgroups");
        }
        int count = 0;
        String allGroupString = "";
        try {
            Site site = SiteService.getSite((String)EntityManager.newReference((String)a.getReference()).getContext());
            Iterator i = a.getAnnouncementHeader().getGroups().iterator();
            while (i.hasNext()) {
                Group aGroup = site.getGroup((String)i.next());
                if (aGroup == null) continue;
                if (++count > 1) {
                    allGroupString = allGroupString.concat(", ").concat(aGroup.getTitle());
                    continue;
                }
                allGroupString = aGroup.getTitle();
            }
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        return allGroupString;
    }

    protected void enableObserver(SessionState sstate, boolean enable) {
        if (enable) {
            AnnouncementAction.enableObservers((SessionState)sstate);
        } else {
            AnnouncementAction.disableObservers((SessionState)sstate);
        }
    }

    private boolean isOnWorkspaceTab() {
        String siteId = ToolManager.getCurrentPlacement().getContext();
        if (SiteService.getUserSiteId((String)"admin").equals(siteId)) {
            return false;
        }
        return SiteService.isUserSite((String)siteId);
    }

    public String buildMergeContext(VelocityPortlet portlet, Context context, RunData runData, AnnouncementActionState state, SessionState sstate) {
        MergedList mergedAnnouncementList = new MergedList();
        mergedAnnouncementList.loadChannelsFromDelimitedString(this.isOnWorkspaceTab(), (MergedList.EntryProvider)new EntryProvider(this), StringUtil.trimToZero((String)SessionManager.getCurrentSessionUserId()), mergedAnnouncementList.getChannelReferenceArrayFromDelimitedString(state.getChannelId(), portlet.getPortletConfig().getInitParameter(this.getPortletConfigParameterNameForLoadOnly(portlet))), SecurityService.isSuperUser(), ToolManager.getCurrentPlacement().getContext());
        context.put("mergedAnnouncementsCollection", (Object)mergedAnnouncementList);
        context.put("tlang", (Object)rb);
        sstate.setAttribute("mergedChannels", (Object)mergedAnnouncementList);
        String template = (String)this.getContext(runData).get("template");
        return template + "-merge";
    }

    public String buildReorderContext(VelocityPortlet portlet, Context context, RunData runData, AnnouncementActionState state, SessionState sstate) {
        context.put("tlang", (Object)rb);
        String template = (String)this.getContext(runData).get("template");
        return template + "-reorder";
    }

    private String getPortletConfigParameterNameForLoadOnly(VelocityPortlet portlet) {
        String configParameter = StringUtils.trimToNull((String)portlet.getPortletConfig().getInitParameter("nonMergedAnnouncementChannels"));
        String configParameterName = configParameter != null ? "nonMergedAnnouncementChannels" : "mergedAnnouncementChannels";
        return configParameterName;
    }

    public String buildMainPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState sstate) {
        Collection groups;
        AnnouncementMessage message;
        boolean menu_revise;
        boolean menu_delete;
        boolean menu_new;
        AnnouncementChannel channel;
        String template;
        Placement placement;
        AnnouncementActionState state;
        block43: {
            state = (AnnouncementActionState)this.getState(portlet, rundata, AnnouncementActionState.class);
            placement = ToolManager.getCurrentPlacement();
            if (placement != null) {
                AnnouncementActionState.DisplayOptions disOptions;
                Properties props = placement.getPlacementConfig();
                if (props.isEmpty()) {
                    props = placement.getConfig();
                }
                if ((disOptions = state.getDisplayOptions()) != null) {
                    disOptions.loadProperties((Map)props);
                }
                context.put("displayOptions", (Object)disOptions);
            } else {
                context.put("displayOptions", (Object)state.getDisplayOptions());
            }
            template = (String)this.getContext(rundata).get("template");
            context.put("channelAccess", (Object)MessageHeader.MessageAccess.CHANNEL);
            context.put("groupAccess", (Object)MessageHeader.MessageAccess.GROUPED);
            Site site = null;
            try {
                site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                context.put("site", (Object)site);
            }
            catch (IdUnusedException e) {
                M_log.debug((Object)(this + ".buildMainPanelContext "), (Throwable)e);
            }
            catch (NullPointerException e) {
                M_log.warn((Object)(this + ".buildMainPanelContext "), (Throwable)e);
            }
            String channelId = state.getChannelId();
            if (channelId == null) {
                channelId = StringUtils.trimToNull((String)portlet.getPortletConfig().getInitParameter("channel"));
                if (channelId == null) {
                    channelId = AnnouncementService.channelReference((String)ToolManager.getCurrentPlacement().getContext(), (String)SiteService.MAIN_CONTAINER);
                }
                state.setChannelId(channelId);
                state.setIsListVM(true);
            }
            context.put("channel_id", (Object)(channelId == null ? rb.getString("java.nownull") : channelId));
            context.put("notification", (Object)this.notificationEnabled(state));
            channel = null;
            menu_new = true;
            menu_delete = true;
            menu_revise = true;
            boolean menu_reorder = true;
            try {
                if (AnnouncementService.allowGetChannel((String)channelId) && this.isOkayToDisplayMessageMenu(state)) {
                    channel = AnnouncementService.getAnnouncementChannel((String)channelId);
                    if (channel.allowGetMessages() && !state.getCurrentSortedBy().equals("grouptitle") && !state.getCurrentSortedBy().equals("groupdescription")) {
                        int i;
                        menu_new = channel.allowAddMessage();
                        List messages = null;
                        String view = (String)sstate.getAttribute("state.selected.view");
                        if (view != null) {
                            if (view.equals("view.all")) {
                                messages = this.getMessages(channel, null, true, state, portlet);
                            } else if (view.equals("view.bygroup")) {
                                messages = this.getMessagesByGroups(site, channel, null, true, state, portlet);
                            } else if (view.equals("view.public")) {
                                messages = this.getMessagesPublic(site, channel, null, true, state, portlet);
                            }
                        } else {
                            messages = this.getMessages(channel, null, true, state, portlet);
                        }
                        sstate.setAttribute("messages", (Object)messages);
                        messages = this.readResourcesPage(sstate, 1, messages.size() + 1);
                        messages = this.trimListToMaxNumberOfAnnouncements(messages, state.getDisplayOptions());
                        sstate.setAttribute("messages", (Object)messages);
                        messages = this.prepPage(sstate);
                        sstate.setAttribute("pagedMessages", (Object)messages);
                        menu_delete = false;
                        for (i = 0; i < messages.size(); ++i) {
                            message = (AnnouncementWrapper)messages.get(i);
                            if (!AnnouncementWrapper.access$100((AnnouncementWrapper)message) || !channel.allowRemoveMessage((Message)message)) continue;
                            menu_delete = true;
                            break;
                        }
                        menu_revise = false;
                        for (i = 0; i < messages.size(); ++i) {
                            if (!channel.allowEditMessage(((Message)messages.get(i)).getId())) continue;
                            menu_revise = true;
                            break block43;
                        }
                        break block43;
                    }
                    menu_new = channel.allowAddMessage();
                    menu_revise = false;
                    menu_delete = false;
                    break block43;
                }
                menu_new = false;
                menu_revise = false;
                menu_delete = false;
            }
            catch (PermissionException error) {
                M_log.warn((Object)(this + ".buildMainPanelContext "), (Throwable)error);
            }
            catch (IdUnusedException error) {
                if (AnnouncementService.allowAddChannel((String)channelId)) {
                    try {
                        AnnouncementChannelEdit edit = AnnouncementService.addAnnouncementChannel((String)channelId);
                        AnnouncementService.commitChannel((MessageChannelEdit)edit);
                        channel = edit;
                    }
                    catch (IdUsedException err) {
                        M_log.debug((Object)(this + ".buildMainPanelContext "), (Throwable)err);
                    }
                    catch (IdInvalidException err) {
                    }
                    catch (PermissionException err) {
                        // empty catch block
                    }
                    if (channel != null) {
                        menu_new = channel.allowAddMessage();
                    }
                    menu_revise = false;
                    menu_delete = false;
                }
                menu_new = false;
                menu_revise = false;
                menu_delete = false;
            }
        }
        String statusName = state.getStatus();
        AnnouncementActionState.DisplayOptions displayOptions = state.getDisplayOptions();
        if (statusName == "showMetadata" && channel != null) {
            String messageReference = state.getMessageReference();
            try {
                message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReference));
                menu_new = channel.allowAddMessage();
                menu_delete = channel.allowRemoveMessage((Message)message);
                menu_revise = channel.allowEditMessage(message.getId());
            }
            catch (IdUnusedException e) {
                M_log.error((Object)e);
            }
            catch (PermissionException e) {
                M_log.error((Object)e);
            }
        }
        if (placement != null && "MOTD".equals(placement.getTitle()) && placement.getId().contains("admin")) {
            this.buildMenu(portlet, context, rundata, state, menu_new, menu_delete, menu_revise, this.isOkToShowMergeButton(statusName), false, this.isOkToShowOptionsButton(statusName), displayOptions);
        } else {
            this.buildMenu(portlet, context, rundata, state, menu_new, menu_delete, menu_revise, this.isOkToShowMergeButton(statusName), this.isOkToShowPermissionsButton(statusName), this.isOkToShowOptionsButton(statusName), displayOptions);
        }
        context.put("allow_new", (Object)menu_new);
        context.put("allow_delete", (Object)menu_delete);
        context.put("allow_revise", (Object)menu_revise);
        if (statusName != null) {
            template = this.getTemplate(portlet, context, rundata, sstate, state, template);
        }
        if (channel != null && channel.allowGetMessages() && this.isOkayToDisplayMessageMenu(state)) {
            String currentSortedBy = state.getCurrentSortedBy();
            context.put("currentSortedBy", (Object)currentSortedBy);
            if (state.getCurrentSortAsc()) {
                context.put("currentSortAsc", (Object)"true");
            } else {
                context.put("currentSortAsc", (Object)"false");
            }
            if (currentSortedBy != null && !currentSortedBy.equals("grouptitle") && !currentSortedBy.equals("groupdescription")) {
                this.buildSortedContext(portlet, context, rundata, sstate);
            }
        }
        context.put("service", (Object)AnnouncementService.getInstance());
        context.put("entityManager", (Object)EntityManager.getInstance());
        context.put("timeservice", (Object)TimeService.getInstance());
        context.put("isOnWorkspaceTab", (Object)(this.isOnWorkspaceTab() ? "true" : "false"));
        context.put("channel", (Object)channel);
        Tool tool = ToolManager.getCurrentTool();
        String toolId = tool.getId();
        context.put("toolId", (Object)toolId);
        if (channel != null && (groups = channel.getGroupsAllowGetMessage()) != null && groups.size() > 0) {
            Vector sortedGroups = new Vector();
            SortedIterator i = new SortedIterator(groups.iterator(), (Comparator)new AnnouncementComparator(this, "grouptitle", true));
            while (i.hasNext()) {
                sortedGroups.add(i.next());
            }
            context.put("groups", sortedGroups);
        }
        if (sstate.getAttribute("state.selected.view") != null) {
            context.put("view", sstate.getAttribute("state.selected.view"));
        }
        AnnouncementAction.justDelivered((SessionState)sstate);
        return template;
    }

    public void buildSortedContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState sstate) {
        Vector<AnnouncementMessage> messageList = new Vector<AnnouncementMessage>();
        Vector<AnnouncementMessage> showMessagesList = new Vector<AnnouncementMessage>();
        List messages = this.prepPage(sstate);
        for (int i = 0; i < messages.size(); ++i) {
            AnnouncementMessage m = (AnnouncementMessage)messages.get(i);
            messageList.addElement(m);
        }
        AnnouncementActionState state = (AnnouncementActionState)this.getState(portlet, rundata, AnnouncementActionState.class);
        SortedIterator sortedMessageIterator = new SortedIterator(messageList.iterator(), (Comparator)new AnnouncementComparator(this, state.getCurrentSortedBy(), state.getCurrentSortAsc()));
        while (sortedMessageIterator.hasNext()) {
            showMessagesList.add((AnnouncementMessage)sortedMessageIterator.next());
        }
        context.put("showMessagesList", showMessagesList.iterator());
        context.put("messageListVector", showMessagesList);
        context.put("totalPageNumber", sstate.getAttribute("total_page_number"));
        context.put("formPageNumber", (Object)"page_number");
        context.put("prev_page_exists", sstate.getAttribute("msg-prev-page"));
        context.put("next_page_exists", sstate.getAttribute("msg-next-page"));
        context.put("current_page", sstate.getAttribute("current-page"));
        this.pagingInfoToContext(sstate, context);
        if (sstate.getAttribute("msg-top") != null && sstate.getAttribute("page-size") != null) {
            int btmMsgPos;
            int topMsgPos = (Integer)sstate.getAttribute("msg-top") + 1;
            int allMsgNumber = btmMsgPos = topMsgPos + (Integer)sstate.getAttribute("page-size") - 1;
            if (sstate.getAttribute("num-messages") != null && btmMsgPos > (allMsgNumber = ((Integer)sstate.getAttribute("num-messages")).intValue())) {
                btmMsgPos = allMsgNumber;
            }
            String[] viewValues = new String[]{new Integer(topMsgPos).toString(), new Integer(btmMsgPos).toString(), new Integer(allMsgNumber).toString()};
            context.put("announcementItemRangeArray", (Object)viewValues);
        }
    }

    public String getTemplate(VelocityPortlet portlet, Context context, RunData rundata, SessionState sstate, AnnouncementActionState state, String value) {
        String template = value;
        String statusName = state.getStatus();
        if (statusName.equals("deleteAnnouncement")) {
            template = this.buildDeleteAnnouncementContext(portlet, context, rundata, state);
        } else if (statusName.equals("showMetadata")) {
            template = this.buildShowMetadataContext(portlet, context, rundata, state, sstate);
        } else if (statusName.equals("goToReviseAnnouncement") || statusName.equals("backToReviseAnnouncement") || statusName.equals("new") || statusName.equals("stayAtRevise")) {
            template = this.buildReviseAnnouncementContext(portlet, context, rundata, state, sstate);
        } else if (statusName.equals("revisePreviw")) {
            template = this.buildPreviewContext(portlet, context, rundata, state);
        } else if (statusName.equals("cancel") || statusName.equals("post") || statusName.equals("FinishDeleting")) {
            template = this.buildCancelContext(portlet, context, rundata, state);
        } else if (statusName.equals("noSelectedForDeletion") || statusName.equals("noSelectedForRevise")) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youhave"));
        } else if (statusName.equals("moreThanOneSelectedForRevise")) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.pleasechoose"));
        } else if (statusName.equals("noPermissionToRevise")) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youdont"));
        } else if (statusName.equals("merge")) {
            template = this.buildMergeContext(portlet, context, rundata, state, sstate);
        } else if (statusName.equals("options")) {
            template = this.buildOptionsPanelContext(portlet, context, rundata, sstate);
        } else if (statusName.equals("reorder")) {
            template = this.buildReorderContext(portlet, context, rundata, state, sstate);
        }
        return template;
    }

    public String buildOptionsPanelContext(VelocityPortlet portlet, Context context, RunData runData, SessionState state) {
        AnnouncementActionState actionState = (AnnouncementActionState)this.getState(portlet, runData, AnnouncementActionState.class);
        context.put("displayOptions", (Object)actionState.getDisplayOptions());
        String channelId = actionState.getChannelId();
        Reference channelRef = EntityManager.newReference((String)channelId);
        context.put("description", (Object)(rb.getString("java.setting") + SiteService.getSiteDisplay((String)channelRef.getContext())));
        Reference anncRef = AnnouncementService.getAnnouncementReference((String)ToolManager.getCurrentPlacement().getContext());
        List aliasList = AliasService.getAliases((String)anncRef.getReference());
        if (!aliasList.isEmpty()) {
            String[] alias = ((Alias)aliasList.get(0)).getId().split("\\.");
            context.put("rssAlias", (Object)FormattedText.escapeHtmlFormattedTextSupressNewlines((String)alias[0]));
        }
        context.put("rssUrl", (Object)AnnouncementService.getRssUrl((Reference)anncRef));
        String template = (String)this.getContext(runData).get("template");
        return template + "-customize";
    }

    private boolean isOkayToDisplayMessageMenu(AnnouncementActionState state) {
        String selectedMessageReference = state.getMessageReference();
        if (state.getStatus() == null || state.getStatus().equals("cancel") || selectedMessageReference == null || selectedMessageReference.length() == 0) {
            return true;
        }
        if (state.getStatus().equals("merge")) {
            return false;
        }
        String channelID = this.getChannelIdFromReference(selectedMessageReference);
        boolean selectedMessageMatchesDefaultChannel = state.getChannelId().equals(channelID);
        return selectedMessageMatchesDefaultChannel;
    }

    private boolean isOkToShowOptionsButton(String statusName) {
        if (SiteService.allowUpdateSite((String)ToolManager.getCurrentPlacement().getContext()) && !this.isOnWorkspaceTab()) {
            return statusName == null || statusName.equals("cancel") || statusName.equals("post") || statusName.equals("deleteAnnouncement") || statusName.equals("FinishDeleting") || statusName.equals("noSelectedForDeletion") || statusName.equals("noSelectedForRevise");
        }
        return false;
    }

    private boolean isOkToShowMergeButton(String statusName) {
        String displayMerge = ServerConfigurationService.getString((String)"announcement.merge.display", (String)"1");
        if (displayMerge != null && !displayMerge.equals("1")) {
            return false;
        }
        if (SiteService.allowUpdateSite((String)ToolManager.getCurrentPlacement().getContext()) && !this.isOnWorkspaceTab()) {
            return statusName == null || statusName.equals("cancel") || statusName.equals("post") || statusName.equals("deleteAnnouncement") || statusName.equals("FinishDeleting") || statusName.equals("noSelectedForDeletion") || statusName.equals("noSelectedForRevise");
        }
        return false;
    }

    private boolean isOkToShowPermissionsButton(String statusName) {
        if (SiteService.allowUpdateSite((String)ToolManager.getCurrentPlacement().getContext())) {
            return statusName == null || statusName.equals("cancel") || statusName.equals("post") || statusName.equals("deleteAnnouncement") || statusName.equals("FinishDeleting") || statusName.equals("noSelectedForDeletion") || statusName.equals("noSelectedForRevise");
        }
        return false;
    }

    private List getMessages(AnnouncementChannel defaultChannel, Filter filter, boolean ascending, AnnouncementActionState state, VelocityPortlet portlet) throws PermissionException {
        String[] channelArrayFromConfigParameterValue;
        MergedList mergedAnnouncementList;
        List messageList;
        block11: {
            messageList = new ArrayList();
            mergedAnnouncementList = new MergedList();
            channelArrayFromConfigParameterValue = null;
            if ("sakai.synoptic.announcement".equals(ToolManager.getCurrentTool().getId())) {
                Site site = null;
                String initMergeList = null;
                try {
                    site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
                    ToolConfiguration tc = site.getToolForCommonId("sakai.announcements");
                    if (tc != null) {
                        initMergeList = tc.getPlacementConfig().getProperty("mergedAnnouncementChannels");
                    }
                    if (this.isOnWorkspaceTab() && !SecurityService.isSuperUser()) {
                        channelArrayFromConfigParameterValue = mergedAnnouncementList.getAllPermittedChannels((MergedList.ChannelReferenceMaker)new AnnouncementChannelReferenceMaker(this, null));
                        break block11;
                    }
                    channelArrayFromConfigParameterValue = mergedAnnouncementList.getChannelReferenceArrayFromDelimitedString(state.getChannelId(), initMergeList);
                }
                catch (IdUnusedException e1) {}
            } else {
                channelArrayFromConfigParameterValue = this.isOnWorkspaceTab() && !SecurityService.isSuperUser() ? mergedAnnouncementList.getAllPermittedChannels((MergedList.ChannelReferenceMaker)new AnnouncementChannelReferenceMaker(this, null)) : mergedAnnouncementList.getChannelReferenceArrayFromDelimitedString(state.getChannelId(), portlet.getPortletConfig().getInitParameter(this.getPortletConfigParameterNameForLoadOnly(portlet)));
            }
        }
        mergedAnnouncementList.loadChannelsFromDelimitedString(this.isOnWorkspaceTab(), (MergedList.EntryProvider)new MergedListEntryProviderFixedListWrapper((MergedList.EntryProvider)new EntryProvider(this), state.getChannelId(), channelArrayFromConfigParameterValue, (MergedListEntryProviderFixedListWrapper.ReferenceToChannelConverter)new AnnouncementReferenceToChannelConverter(this, null)), StringUtil.trimToZero((String)SessionManager.getCurrentSessionUserId()), channelArrayFromConfigParameterValue, SecurityService.isSuperUser(), ToolManager.getCurrentPlacement().getContext());
        for (MergedList.MergedEntry curEntry : mergedAnnouncementList) {
            if (!curEntry.isMerged()) continue;
            AnnouncementChannel curChannel = null;
            try {
                curChannel = (AnnouncementChannel)AnnouncementService.getChannel((String)curEntry.getReference());
            }
            catch (IdUnusedException e) {
                M_log.debug((Object)(this + ".getMessages()"), (Throwable)e);
            }
            catch (PermissionException e) {
                M_log.debug((Object)(this + ".getMessages()"), (Throwable)e);
            }
            if (curChannel == null || !AnnouncementService.allowGetChannel((String)curChannel.getReference())) continue;
            messageList.addAll(AnnouncementWrapper.access$400((List)curChannel.getMessages(filter, ascending), (AnnouncementChannel)curChannel, (AnnouncementChannel)defaultChannel, (AnnouncementActionState.DisplayOptions)state.getDisplayOptions()));
        }
        Collections.sort(messageList);
        if (!ascending) {
            Collections.reverse(messageList);
        }
        messageList = this.getViewableMessages(messageList, ToolManager.getCurrentPlacement().getContext());
        return messageList;
    }

    private List getMessagesByGroups(Site site, AnnouncementChannel defaultChannel, Filter filter, boolean ascending, AnnouncementActionState state, VelocityPortlet portlet) throws PermissionException {
        List messageList = this.getMessages(defaultChannel, filter, ascending, state, portlet);
        Vector<AnnouncementWrapper> rv = new Vector<AnnouncementWrapper>();
        for (int i = 0; i < messageList.size(); ++i) {
            AnnouncementWrapper aMessage = (AnnouncementWrapper)messageList.get(i);
            String pubview = aMessage.getProperties().getProperty("SAKAI:pubview");
            if (pubview != null && Boolean.valueOf(pubview).booleanValue()) {
                aMessage.setRange(rb.getString("range.public"));
                continue;
            }
            if (aMessage.getAnnouncementHeader().getAccess().equals(MessageHeader.MessageAccess.CHANNEL)) {
                aMessage.setRange(rb.getString("range.allgroups"));
                continue;
            }
            rv.add(aMessage);
        }
        return rv;
    }

    private List getMessagesPublic(Site site, AnnouncementChannel defaultChannel, Filter filter, boolean ascending, AnnouncementActionState state, VelocityPortlet portlet) throws PermissionException {
        List messageList = this.getMessages(defaultChannel, filter, ascending, state, portlet);
        Vector<AnnouncementMessage> rv = new Vector<AnnouncementMessage>();
        for (int i = 0; i < messageList.size(); ++i) {
            AnnouncementMessage aMessage = (AnnouncementMessage)messageList.get(i);
            String pubview = aMessage.getProperties().getProperty("SAKAI:pubview");
            if (pubview == null || !Boolean.valueOf(pubview).booleanValue()) continue;
            rv.add(aMessage);
        }
        return rv;
    }

    private List trimListToMaxNumberOfAnnouncements(List messageList, AnnouncementActionState.DisplayOptions options) {
        if (options != null && options.isEnforceNumberOfAnnouncementsLimit() && !this.isOnWorkspaceTab()) {
            int numberOfAnnouncements = options.getNumberOfAnnouncements();
            ArrayList<AnnouncementMessage> destList = new ArrayList<AnnouncementMessage>();
            int i = 0;
            for (int curAnnouncementCount = 0; i < messageList.size() && curAnnouncementCount < numberOfAnnouncements; ++curAnnouncementCount, ++i) {
                AnnouncementMessage message = (AnnouncementMessage)messageList.get(i);
                destList.add(message);
            }
            return destList;
        }
        return messageList;
    }

    private List getViewableMessages(List messageList, String siteId) {
        ArrayList<AnnouncementMessage> filteredMessages = new ArrayList<AnnouncementMessage>();
        for (AnnouncementMessage message : messageList) {
            if (this.isSynopticTool() || this.isOnWorkspaceTab()) {
                if (this.isHidden(message) || !AnnouncementService.isMessageViewable((AnnouncementMessage)message)) continue;
                filteredMessages.add(message);
                continue;
            }
            if (this.isHidden(message)) {
                if (!this.canViewHidden(message, siteId)) continue;
                filteredMessages.add(message);
                continue;
            }
            if (AnnouncementService.isMessageViewable((AnnouncementMessage)message)) {
                filteredMessages.add(message);
                continue;
            }
            if (!this.canViewHidden(message, siteId)) continue;
            filteredMessages.add(message);
        }
        return filteredMessages;
    }

    private boolean isSynopticTool() {
        String curToolId = ToolManager.getCurrentTool().getId();
        return "sakai.synoptic.announcement".equals(curToolId);
    }

    private boolean canViewHidden(AnnouncementMessage msg, String siteId) {
        boolean b = SecurityService.unlock((String)AnnouncementService.SECURE_ANNC_READ_DRAFT, (String)msg.getReference()) || SecurityService.unlock((String)"site.upd", (String)("/site/" + siteId)) || msg.getHeader().getFrom().getId().equals(SessionManager.getCurrentSessionUserId());
        return b;
    }

    private boolean isHidden(AnnouncementMessage message) {
        return message.getHeader().getDraft();
    }

    protected String buildPreviewContext(VelocityPortlet portlet, Context context, RunData rundata, AnnouncementActionState state) {
        context.put("conService", (Object)this.contentHostingService);
        context.put("contentTypeImageService", (Object)ContentTypeImageService.getInstance());
        String subject = state.getTempSubject();
        String body = state.getTempBody();
        Time tempReleaseDate = state.getTempReleaseDate();
        Time tempRetractDate = state.getTempRetractDate();
        String annTo = state.getTempAnnounceTo();
        context.put("subject", (Object)subject);
        context.put("body", (Object)body);
        context.put("user", (Object)UserDirectoryService.getCurrentUser());
        context.put("newAnn", (Object)(state.getIsNewAnnouncement() ? "true" : "else"));
        context.put("annTo", (Object)annTo);
        String channelId = state.getChannelId();
        Collection annToGroups = state.getTempAnnounceToGroups();
        String allGroupString = "";
        if (annToGroups != null) {
            Site site = null;
            int count = 0;
            try {
                site = SiteService.getSite((String)EntityManager.newReference((String)channelId).getContext());
                Iterator i = annToGroups.iterator();
                while (i.hasNext()) {
                    Group aGroup = site.getGroup((String)i.next());
                    if (aGroup == null) continue;
                    if (++count > 1) {
                        allGroupString = allGroupString.concat(", ").concat(aGroup.getTitle());
                        continue;
                    }
                    allGroupString = aGroup.getTitle();
                }
                context.put("annToGroups", (Object)allGroupString);
            }
            catch (IdUnusedException e1) {
                M_log.error((Object)e1);
            }
        }
        AnnouncementMessageEdit edit = state.getEdit();
        if (tempReleaseDate != null) {
            context.put("releaseDate", (Object)tempReleaseDate);
        } else {
            Time releaseDate = null;
            try {
                releaseDate = edit.getProperties().getTimeProperty("releaseDate");
                context.put("releaseDate", (Object)releaseDate);
            }
            catch (Exception e) {
                context.put("releaseDate", (Object)TimeService.newTime());
            }
        }
        if (tempRetractDate != null) {
            context.put("retractDate", (Object)tempRetractDate);
        } else {
            Time retractDate = null;
            try {
                retractDate = edit.getProperties().getTimeProperty("retractDate");
                context.put("retractDate", (Object)retractDate);
            }
            catch (Exception e) {
                context.put("retractDate", (Object)TimeService.newTime());
            }
        }
        Time modDate = null;
        try {
            modDate = edit.getProperties().getTimeProperty("modDate");
            context.put("modDate", (Object)modDate);
        }
        catch (Exception e) {
            context.put("modDate", (Object)TimeService.newTime());
        }
        List attachments = state.getAttachments();
        context.put("attachments", (Object)attachments);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        boolean pubview = Boolean.valueOf((String)sstate.getAttribute("public_view_value"));
        if (pubview) {
            context.put("IsPubView", (Object)rb.getString("java.yes"));
        } else {
            context.put("IsPubView", (Object)rb.getString("java.no"));
        }
        if (edit == null) {
            context.put("hidden", (Object)false);
        } else {
            boolean hidden = edit.getHeader().getDraft();
            context.put("hidden", (Object)hidden);
        }
        String notification = (String)sstate.getAttribute("noti_value");
        if ("r".equals(notification)) {
            context.put("noti", (Object)rb.getString("java.NOTI_REQUIRED"));
        } else if ("n".equals(notification)) {
            context.put("noti", (Object)rb.getString("java.NOTI_NONE"));
        } else {
            context.put("noti", (Object)rb.getString("java.NOTI_OPTIONAL"));
        }
        String template = (String)this.getContext(rundata).get("template");
        return template + "-preview";
    }

    protected String buildReviseAnnouncementContext(VelocityPortlet portlet, Context context, RunData rundata, AnnouncementActionState state, SessionState sstate) {
        List notiHistory;
        context.put("service", (Object)this.contentHostingService);
        context.put("contentTypeImageService", (Object)ContentTypeImageService.getInstance());
        context.put("dateFormat", (Object)this.getDateFormatString());
        String channelId = state.getChannelId();
        AnnouncementChannel channel = null;
        try {
            if (channelId != null && AnnouncementService.allowGetChannel((String)channelId)) {
                channel = AnnouncementService.getAnnouncementChannel((String)channelId);
                context.put("allowAddChannelMessage", (Object)new Boolean(channel.allowAddChannelMessage()));
                String announceTo = state.getTempAnnounceTo();
                if (announceTo != null && announceTo.length() != 0) {
                    context.put("announceTo", (Object)announceTo);
                } else if (state.getIsNewAnnouncement()) {
                    if (channel.allowAddChannelMessage()) {
                        context.put("announceTo", (Object)"site");
                    } else if (channel.getGroupsAllowAddMessage().size() > 0) {
                        context.put("announceTo", (Object)"groups");
                    }
                }
                AnnouncementMessageEdit edit = state.getEdit();
                boolean own = edit == null ? true : edit.getHeader().getFrom().getId().equals(SessionManager.getCurrentSessionUserId());
                Collection groups = channel.getGroupsAllowRemoveMessage(own);
                context.put("allowedRemoveGroups", (Object)groups);
                groups = channel.getGroupsAllowAddMessage();
                if (edit != null) {
                    Collection otherGroups = edit.getHeader().getGroupObjects();
                    for (Group g : otherGroups) {
                        if (groups.contains(g)) continue;
                        groups.add(g);
                    }
                }
                if (groups.size() > 0) {
                    Vector sortedGroups = new Vector();
                    SortedIterator i = new SortedIterator(groups.iterator(), (Comparator)new AnnouncementComparator(this, "grouptitle", true));
                    while (i.hasNext()) {
                        sortedGroups.add(i.next());
                    }
                    context.put("groups", sortedGroups);
                }
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        List attachments = state.getAttachments();
        if (state.getStatus().equals("new")) {
            context.put("new", (Object)"true");
            context.put("tempSubject", (Object)state.getTempSubject());
            context.put("tempBody", (Object)state.getTempBody());
            context.put("pubviewset", (Object)(sstate.getAttribute("channelPubView") == null ? Boolean.FALSE : Boolean.TRUE));
            Placement placement = ToolManager.getCurrentPlacement();
            context.put("motd", (Object)(placement != null && "MOTD".equals(placement.getTitle()) && placement.getId().contains("admin") ? Boolean.TRUE : Boolean.FALSE));
            boolean pubview = Boolean.valueOf((String)sstate.getAttribute("public_view_value"));
            if (pubview) {
                context.put("pubview", (Object)Boolean.TRUE);
            } else {
                context.put("pubview", (Object)Boolean.FALSE);
            }
            Time currentTime = TimeService.newTime();
            context.put("releaseDate", (Object)currentTime);
            long futureTimeLong = currentTime.getTime() + 604800000L;
            Time futureTime = TimeService.newTime((long)futureTimeLong);
            context.put("retractDate", (Object)futureTime);
            String notification = (String)sstate.getAttribute("noti_value");
            context.put("noti", (Object)notification);
        } else if (state.getStatus().equals("goToReviseAnnouncement")) {
            boolean specify = false;
            context.put("new", (Object)"false");
            AnnouncementMessageEdit edit = state.getEdit();
            context.put("message", (Object)edit);
            context.put("pubviewset", (Object)(sstate.getAttribute("channelPubView") == null ? Boolean.FALSE : Boolean.TRUE));
            context.put("pubview", (Object)(edit.getProperties().getProperty("SAKAI:pubview") != null ? 1 : 0));
            Time releaseDate = null;
            try {
                releaseDate = edit.getProperties().getTimeProperty("releaseDate");
                context.put("useReleaseDate", (Object)true);
                specify = true;
            }
            catch (Exception e) {
                releaseDate = edit.getHeader().getDate();
            }
            context.put("releaseDate", (Object)releaseDate);
            Time retractDate = null;
            try {
                retractDate = edit.getProperties().getTimeProperty("retractDate");
                context.put("useRetractDate", (Object)true);
                specify = true;
            }
            catch (Exception e) {
                long futureTimeLong = TimeService.newTime().getTime() + 604800000L;
                retractDate = TimeService.newTime((long)futureTimeLong);
            }
            context.put("retractDate", (Object)retractDate);
            context.put("specify", (Object)specify);
            context.put("hidden", (Object)edit.getHeader().getDraft());
            if (state.getEdit() != null && (notiHistory = state.getEdit().getProperties().getPropertyList("noti_history")) != null) {
                ArrayList<String[]> noti_history = new ArrayList<String[]>();
                Iterator it = notiHistory.iterator();
                while (it.hasNext()) {
                    noti_history.add(it.next().toString().split("_"));
                }
                context.put("notiHistory", noti_history);
            }
        } else {
            boolean pubview;
            context.put("new", (Object)"true");
            context.put("tempSubject", (Object)state.getTempSubject());
            context.put("tempBody", (Object)state.getTempBody());
            Time releaseDate = null;
            try {
                if (state.getTempReleaseDate() != null) {
                    releaseDate = state.getTempReleaseDate();
                    context.put("useReleaseDate", (Object)true);
                    context.put("specify", (Object)true);
                } else {
                    releaseDate = TimeService.newTime();
                    context.put("useReleaseDate", (Object)false);
                }
            }
            catch (Exception e) {
                releaseDate = TimeService.newTime();
            }
            context.put("releaseDate", (Object)releaseDate);
            Time retractDate = null;
            try {
                if (state.getTempRetractDate() != null) {
                    retractDate = state.getTempRetractDate();
                    context.put("useRetractDate", (Object)true);
                    context.put("specify", (Object)true);
                } else {
                    long futureTimeLong = TimeService.newTime().getTime() + 604800000L;
                    retractDate = TimeService.newTime((long)futureTimeLong);
                    context.put("useRetractDate", (Object)false);
                }
            }
            catch (Exception e) {
                long futureTimeLong = TimeService.newTime().getTime() + 604800000L;
                retractDate = TimeService.newTime((long)futureTimeLong);
            }
            context.put("retractDate", (Object)retractDate);
            if (state.getTempHidden() != null) {
                context.put("hidden", (Object)state.getTempHidden());
            }
            if (pubview = Boolean.valueOf((String)sstate.getAttribute("public_view_value")).booleanValue()) {
                context.put("pubview", (Object)Boolean.TRUE);
            } else {
                context.put("pubview", (Object)Boolean.FALSE);
            }
            String notification = (String)sstate.getAttribute("noti_value");
            context.put("noti", (Object)notification);
            if (state.getEdit() != null && (notiHistory = state.getEdit().getProperties().getPropertyList("noti_history")) != null) {
                ArrayList<String[]> noti_history = new ArrayList<String[]>();
                Iterator it = notiHistory.iterator();
                while (it.hasNext()) {
                    noti_history.add(it.next().toString().split("_"));
                }
                context.put("notiHistory", noti_history);
            }
        }
        context.put("attachments", (Object)attachments);
        context.put("newAnn", (Object)(state.getIsNewAnnouncement() ? "true" : "else"));
        context.put("announceToGroups", (Object)state.getTempAnnounceToGroups());
        context.put("publicDisable", sstate.getAttribute("publicDisplayBoolean"));
        String template = (String)this.getContext(rundata).get("template");
        return template + "-revise";
    }

    protected String buildShowMetadataContext(VelocityPortlet portlet, Context context, RunData rundata, AnnouncementActionState state, SessionState sstate) {
        context.put("conService", (Object)this.contentHostingService);
        context.put("contentTypeImageService", (Object)ContentTypeImageService.getInstance());
        String messageReference = state.getMessageReference();
        try {
            String assignmentReference;
            boolean assignmentCheck;
            AnnouncementMessage message;
            AnnouncementChannel channel;
            block22: {
                block21: {
                    channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReference));
                    message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReference));
                    try {
                        Time releaseDate = message.getProperties().getTimeProperty("releaseDate");
                        context.put("releaseDate", (Object)releaseDate);
                    }
                    catch (Exception e) {
                        if (!M_log.isDebugEnabled()) break block21;
                        M_log.debug((Object)("buildShowMetadataContext releaseDate is empty for message id " + message.getId()));
                    }
                }
                try {
                    Time retractDate = message.getProperties().getTimeProperty("retractDate");
                    context.put("retractDate", (Object)retractDate);
                }
                catch (Exception e) {
                    if (!M_log.isDebugEnabled()) break block22;
                    M_log.debug((Object)("buildShowMetadataContext retractDate is empty for message id " + message.getId()));
                }
            }
            try {
                Time modDate = message.getProperties().getTimeProperty("modDate");
                context.put("modDate", (Object)modDate);
            }
            catch (Exception e) {
                Time releaseDate = null;
                try {
                    releaseDate = message.getProperties().getTimeProperty("releaseDate");
                }
                catch (Exception ee) {
                    context.put("modDate", (Object)message.getHeader().getDate());
                }
            }
            context.put("message", (Object)message);
            context.put("pubviewset", (Object)(sstate.getAttribute("channelPubView") == null ? Boolean.FALSE : Boolean.TRUE));
            context.put("pubview", (Object)(message.getProperties().getProperty("SAKAI:pubview") != null ? 1 : 0));
            Collection groups = channel.getGroupsAllowGetMessage();
            if (groups != null) {
                context.put("range", (Object)AnnouncementAction.getAnnouncementRange((AnnouncementMessage)message));
            }
            boolean menu_new = channel.allowAddMessage();
            boolean menu_delete = channel.allowRemoveMessage((Message)message);
            boolean menu_revise = channel.allowEditMessage(message.getId());
            if (!this.isOkayToDisplayMessageMenu(state)) {
                menu_revise = false;
                menu_delete = false;
                menu_new = false;
            }
            boolean bl = assignmentCheck = (assignmentReference = message.getProperties().getProperty("assignmentReference")) != null && !"".equals(assignmentReference);
            if (assignmentCheck) {
                Map assignData = new HashMap();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("messageId", message.getId());
                ActionReturn ret = this.entityBroker.executeCustomAction(assignmentReference, "annc", params, null);
                if (ret != null && ret.getEntityData() != null) {
                    Object returnData = ret.getEntityData().getData();
                    assignData = (Map)returnData;
                }
                context.put("assignmenturl", assignData.get("assignmentUrl"));
                context.put("assignmenttitle", assignData.get("assignmentTitle"));
            }
            String statusName = state.getStatus();
            AnnouncementActionState.DisplayOptions displayOptions = state.getDisplayOptions();
            this.buildMenu(portlet, context, rundata, state, menu_new, menu_delete, menu_revise, this.isOkToShowMergeButton(statusName), this.isOkToShowPermissionsButton(statusName), this.isOkToShowOptionsButton(statusName), displayOptions);
            context.put("allow_new", (Object)menu_new);
            context.put("allow_delete", (Object)menu_delete);
            context.put("allow_revise", (Object)menu_revise);
            List msgs = (List)sstate.getAttribute("pagedMessages");
            if (msgs != null) {
                for (int i = 0; i < msgs.size(); ++i) {
                    if (!((AnnouncementWrapper)msgs.get(i)).getId().equals(message.getId())) continue;
                    boolean goPT = false;
                    boolean goNT = false;
                    if (i - 1 >= 0) {
                        goPT = true;
                        context.put("prevMsg", msgs.get(i - 1));
                    }
                    if (i + 1 < msgs.size()) {
                        goNT = true;
                        context.put("nextMsg", msgs.get(i + 1));
                    }
                    context.put("goPTButton", (Object)new Boolean(goPT));
                    context.put("goNTButton", (Object)new Boolean(goNT));
                }
            }
        }
        catch (IdUnusedException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + ".buildShowMetadataContext()" + (Object)((Object)e)));
            }
        }
        catch (PermissionException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + ".buildShowMetadataContext()" + (Object)((Object)e)));
            }
            AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.youmess") + e.toString()));
        }
        String template = (String)this.getContext(rundata).get("template");
        return template + "-metadata";
    }

    private void indexMessage(RunData rundata, Context context, int direction) {
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(((JetspeedRunData)rundata).getJs_peid());
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String messageReference = state.getMessageReference();
        try {
            AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReference));
            AnnouncementMessage message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReference));
            List msgs = (List)sstate.getAttribute("pagedMessages");
            for (int i = 0; i < msgs.size(); ++i) {
                if (!((AnnouncementWrapper)msgs.get(i)).getId().equals(message.getId())) continue;
                int index = i;
                if (direction == 1) {
                    if (index == -1 || index + 1 >= msgs.size()) continue;
                    AnnouncementWrapper next = (AnnouncementWrapper)msgs.get(index + 1);
                    state.setMessageReference(next.getReference());
                    continue;
                }
                if (direction != -1 || index == -1 || index - 1 < 0) continue;
                AnnouncementWrapper prev = (AnnouncementWrapper)msgs.get(index - 1);
                state.setMessageReference(prev.getReference());
            }
        }
        catch (IdUnusedException e) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.cannotfindann"));
        }
        catch (PermissionException e) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youacc"));
        }
    }

    public void doNext_message(RunData rundata, Context context) {
        this.indexMessage(rundata, context, 1);
    }

    public void doPrev_message(RunData rundata, Context context) {
        this.indexMessage(rundata, context, -1);
    }

    private String getMessageIDFromReference(String messageReference) {
        Reference ref = EntityManager.newReference((String)messageReference);
        return ref.getId();
    }

    private String getChannelIdFromReference(String messageReference) {
        Reference ref = EntityManager.newReference((String)messageReference);
        String channelId = AnnouncementService.channelReference((String)ref.getContext(), (String)ref.getContainer());
        return channelId;
    }

    public void doShowmetadata(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        String itemReference = rundata.getParameters().getString("itemReference");
        state.setMessageReference(itemReference);
        state.setIsListVM(false);
        state.setIsNewAnnouncement(false);
        state.setStatus("showMetadata");
        AnnouncementAction.disableObservers((SessionState)sstate);
    }

    protected String buildCancelContext(VelocityPortlet portlet, Context context, RunData rundata, AnnouncementActionState state) {
        String template = (String)this.getContext(rundata).get("template");
        return template;
    }

    protected String buildDeleteAnnouncementContext(VelocityPortlet portlet, Context context, RunData rundata, AnnouncementActionState state) {
        Vector v = state.getDelete_messages();
        if (v == null) {
            v = new Vector();
        }
        context.put("delete_messages", v.iterator());
        try {
            Site site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
            context.put("site", (Object)site);
        }
        catch (IdUnusedException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        context.put("channelAccess", (Object)MessageHeader.MessageAccess.CHANNEL);
        String template = (String)this.getContext(rundata).get("template");
        return template + "-delete";
    }

    public void doNewannouncement(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        state.setIsListVM(false);
        state.setAttachments(null);
        state.setSelectedAttachments(null);
        state.setDeleteMessages(null);
        state.setIsNewAnnouncement(true);
        state.setTempBody("");
        state.setTempSubject("");
        state.setStatus("new");
        sstate.setAttribute("public_view_value", null);
        sstate.setAttribute("noti_value", null);
        AnnouncementAction.disableObservers((SessionState)sstate);
    }

    public void doAnnouncement_form(RunData data, Context context) {
        ParameterParser params = data.getParameters();
        String option = params.getString("option");
        if (option != null) {
            if (option.equals("post")) {
                this.readAnnouncementForm(data, context, true);
                this.doPost(data, context);
            } else if (option.equals("preview")) {
                this.readAnnouncementForm(data, context, true);
                this.doRevisepreview(data, context);
            } else if (option.equals("save")) {
                this.readAnnouncementForm(data, context, true);
                this.doSavedraft(data, context);
            } else if (option.equals("cancel")) {
                this.doCancel(data, context);
            } else if (option.equals("attach")) {
                this.readAnnouncementForm(data, context, false);
                this.doAttachments(data, context);
            } else if (option.equals("sortbygrouptitle")) {
                this.readAnnouncementForm(data, context, false);
                this.doSortbygrouptitle(data, context);
            } else if (option.equals("sortbygroupdescription")) {
                this.readAnnouncementForm(data, context, false);
                this.doSortbygroupdescription(data, context);
            }
        }
    }

    protected void readAnnouncementForm(RunData rundata, Context context, boolean checkForm) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        ParameterParser params = rundata.getParameters();
        String subject = params.getString("subject");
        String body = params.getString("body");
        body = this.processFormattedTextFromBrowser(sstate, body);
        state.setTempSubject(subject);
        state.setTempBody(body);
        if (checkForm) {
            if (subject.length() == 0) {
                AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youneed"));
            } else if (body == null || body.replaceAll("<br>", "").replaceAll("<br/>", "").replaceAll("&nbsp;", "").replaceAll("&lt;br type=&quot;_moz&quot; /&gt;", "").trim().equals("") || body.length() == 0 || FormattedText.escapeHtml((String)body, (boolean)false).equals("&lt;br type=&quot;_moz&quot; /&gt;")) {
                body = "";
                AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youfill"));
            }
        }
        String specify = params.getString("hidden");
        boolean use_start_date = params.getBoolean("use_start_date");
        boolean use_end_date = params.getBoolean("use_end_date");
        if (checkForm && specify.equals("specify") && !use_start_date && !use_end_date) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.nodates"));
        }
        Time releaseDate = null;
        Time retractDate = null;
        if (use_start_date && "specify".equals(specify)) {
            int begin_year = params.getInt("release_year");
            int begin_month = params.getInt("release_month");
            int begin_day = params.getInt("release_day");
            int begin_hour = this.hourAmPmConvert(params, "release_hour", "release_ampm");
            int begin_min = params.getInt("release_minute");
            releaseDate = TimeService.newTimeLocal((int)begin_year, (int)begin_month, (int)begin_day, (int)begin_hour, (int)begin_min, (int)0, (int)0);
            state.setTempReleaseDate(releaseDate);
        } else {
            state.setTempReleaseDate(null);
        }
        if (use_end_date && "specify".equals(specify)) {
            int end_year = params.getInt("retract_year");
            int end_month = params.getInt("retract_month");
            int end_day = params.getInt("retract_day");
            int end_hour = this.hourAmPmConvert(params, "retract_hour", "retract_ampm");
            int end_min = params.getInt("retract_minute");
            retractDate = TimeService.newTimeLocal((int)end_year, (int)end_month, (int)end_day, (int)end_hour, (int)end_min, (int)0, (int)0);
            state.setTempRetractDate(retractDate);
        } else {
            state.setTempRetractDate(null);
        }
        if (checkForm && use_start_date && use_end_date && retractDate != null && retractDate.before(releaseDate)) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.baddates"));
        }
        state.setTempHidden(Boolean.valueOf(params.getBoolean("hidden")));
        String announceTo = params.getString("announceTo");
        state.setTempAnnounceTo(announceTo);
        if (announceTo != null && announceTo.equals("groups")) {
            String[] groupChoice = params.getStrings("selectedGroups");
            if (groupChoice != null) {
                state.setTempAnnounceToGroups(new ArrayList<String>(Arrays.asList(groupChoice)));
            }
            if (groupChoice == null || groupChoice.length == 0) {
                state.setTempAnnounceToGroups(null);
                if (checkForm) {
                    AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youchoosegroup"));
                }
            }
        } else {
            state.setTempAnnounceToGroups(null);
        }
        String publicView = params.getString("pubview");
        if (publicView == null) {
            publicView = "false";
        }
        sstate.setAttribute("public_view_value", (Object)publicView);
        String notification = rundata.getParameters().getString("notify");
        sstate.setAttribute("noti_value", (Object)notification);
    }

    private int hourAmPmConvert(ParameterParser params, String param_hour_name, String param_ampm_name) {
        int hour = params.getInt(param_hour_name);
        hour %= 12;
        if ("pm".equals(params.getString(param_ampm_name))) {
            hour += 12;
        }
        return hour;
    }

    public void doPost(RunData rundata, Context context) {
        this.postOrSaveDraft(rundata, context, true);
    }

    protected void postOrSaveDraft(RunData rundata, Context context, boolean post) {
        boolean titleChanged = false;
        boolean accessChanged = false;
        boolean availabilityChanged = false;
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        String channelId = state.getChannelId();
        String subject = state.getTempSubject();
        String body = state.getTempBody();
        Time tempReleaseDate = state.getTempReleaseDate();
        Time tempRetractDate = state.getTempRetractDate();
        Boolean tempHidden = state.getTempHidden();
        String announceTo = state.getTempAnnounceTo();
        if (sstate.getAttribute("message") != null) {
            state.setIsListVM(false);
            state.setStatus("stayAtRevise");
            AnnouncementAction.disableObservers((SessionState)sstate);
        } else {
            String notification = (String)sstate.getAttribute("noti_value");
            int noti = 2;
            if ("r".equals(notification)) {
                noti = 1;
            } else if ("n".equals(notification)) {
                noti = 0;
            }
            try {
                boolean oDraft;
                AnnouncementChannel channel = null;
                AnnouncementMessageEdit msg = null;
                if (state.getIsNewAnnouncement()) {
                    channel = AnnouncementService.getAnnouncementChannel((String)channelId);
                    msg = channel.addAnnouncementMessage();
                } else {
                    msg = state.getEdit();
                    channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(msg.getReference()));
                }
                msg.setBody(body);
                AnnouncementMessageHeaderEdit header = msg.getAnnouncementHeaderEdit();
                String oSubject = header.getSubject();
                header.setSubject(subject);
                if (StringUtils.trimToNull((String)oSubject) != null && StringUtils.trimToNull((String)subject) != null && !oSubject.equals(subject)) {
                    titleChanged = true;
                }
                int oldMessageOrder = header.getMessage_order();
                List channelMessages = channel.getMessages(null, true);
                AnnouncementService.clearMessagesCache((String)channel.getReference());
                SortedIterator messSorted = new SortedIterator(channelMessages.iterator(), (Comparator)new AnnouncementComparator(this, AnnouncementAction.getCurrentOrder(), true));
                int runningCount = 1;
                while (messSorted.hasNext()) {
                    AnnouncementMessageEdit ame = (AnnouncementMessageEdit)messSorted.next();
                    AnnouncementMessageHeaderEdit amhe = ame.getAnnouncementHeaderEdit();
                    int currentOrder = amhe.getMessage_order();
                    if (ame.getId().equals(msg.getId())) continue;
                    if (currentOrder != runningCount) {
                        amhe.setMessage_order(Integer.valueOf(runningCount));
                        channel.commitMessage_order((MessageEdit)ame);
                        if (M_log.isDebugEnabled()) {
                            M_log.debug((Object)("postOrSaveDraft modifying order: " + ame.getId() + ":" + currentOrder + ":" + runningCount + ":" + oldMessageOrder));
                        }
                    }
                    ++runningCount;
                }
                header.setMessage_order(Integer.valueOf(runningCount));
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)("postOrSaveDraft set message order for " + msg.getId() + " to running count " + runningCount));
                }
                if ((oDraft = header.getDraft()) != tempHidden) {
                    availabilityChanged = true;
                }
                header.setDraft(tempHidden.booleanValue());
                header.replaceAttachments(state.getAttachments());
                header.setFrom(UserDirectoryService.getCurrentUser());
                ParameterParser params = rundata.getParameters();
                String specify = params.getString("hidden");
                boolean use_start_date = params.getBoolean("use_start_date");
                boolean use_end_date = params.getBoolean("use_end_date");
                Time releaseDate = null;
                Time retractDate = null;
                String oReleaseDate = msg.getPropertiesEdit().getProperty("releaseDate");
                String oRetractDate = msg.getPropertiesEdit().getProperty("retractDate");
                if (use_start_date && "specify".equals("specify")) {
                    int begin_year = params.getInt("release_year");
                    int begin_month = params.getInt("release_month");
                    int begin_day = params.getInt("release_day");
                    int begin_hour = this.hourAmPmConvert(params, "release_hour", "release_ampm");
                    int begin_min = params.getInt("release_minute");
                    releaseDate = TimeService.newTimeLocal((int)begin_year, (int)begin_month, (int)begin_day, (int)begin_hour, (int)begin_min, (int)0, (int)0);
                    msg.getPropertiesEdit().addProperty("releaseDate", releaseDate.toString());
                    header.setDate(releaseDate);
                } else if (tempReleaseDate != null) {
                    msg.getPropertiesEdit().addProperty("releaseDate", tempReleaseDate.toString());
                    header.setDate(tempReleaseDate);
                } else {
                    if (msg.getProperties().getProperty("releaseDate") != null) {
                        msg.getPropertiesEdit().removeProperty("releaseDate");
                    }
                    header.setDate(TimeService.newTime());
                }
                if (use_end_date && "specify".equals(specify)) {
                    int end_year = params.getInt("retract_year");
                    int end_month = params.getInt("retract_month");
                    int end_day = params.getInt("retract_day");
                    int end_hour = this.hourAmPmConvert(params, "retract_hour", "retract_ampm");
                    int end_min = params.getInt("retract_minute");
                    retractDate = TimeService.newTimeLocal((int)end_year, (int)end_month, (int)end_day, (int)end_hour, (int)end_min, (int)0, (int)0);
                    msg.getPropertiesEdit().addProperty("retractDate", retractDate.toString());
                } else if (tempRetractDate != null) {
                    msg.getPropertiesEdit().addProperty("retractDate", tempRetractDate.toString());
                } else if (msg.getProperties().getProperty("retractDate") != null) {
                    msg.getPropertiesEdit().removeProperty("retractDate");
                }
                availabilityChanged = this.stringChanged(availabilityChanged, oReleaseDate, msg.getPropertiesEdit().getProperty("releaseDate"));
                availabilityChanged = this.stringChanged(availabilityChanged, oRetractDate, msg.getPropertiesEdit().getProperty("retractDate"));
                msg.getPropertiesEdit().addProperty("modDate", TimeService.newTime().toString());
                Placement placement = ToolManager.getCurrentPlacement();
                if (placement != null && "MOTD".equals(placement.getTitle()) && placement.getId().contains("admin")) {
                    msg.getPropertiesEdit().addProperty("SAKAI:pubview", Boolean.TRUE.toString());
                    header.clearGroupAccess();
                }
                String oPubView = msg.getPropertiesEdit().getProperty("SAKAI:pubview");
                String oAccess = header.getAccess().toString();
                Collection oGroups = header.getGroupObjects();
                try {
                    Site site = SiteService.getSite((String)channel.getContext());
                    if (announceTo != null && announceTo.equals("pubview") || Boolean.valueOf((String)sstate.getAttribute("public_view_value")).booleanValue()) {
                        msg.getPropertiesEdit().addProperty("SAKAI:pubview", Boolean.TRUE.toString());
                        header.clearGroupAccess();
                    } else {
                        msg.getPropertiesEdit().removeProperty("SAKAI:pubview");
                    }
                    accessChanged = this.stringChanged(accessChanged, oPubView, msg.getPropertiesEdit().getProperty("SAKAI:pubview"));
                    if (announceTo != null && announceTo.equals("site")) {
                        header.clearGroupAccess();
                    } else if (announceTo != null && announceTo.equals("groups")) {
                        Collection groupChoice = state.getTempAnnounceToGroups();
                        Vector<Group> groups = new Vector<Group>();
                        for (String groupId : groupChoice) {
                            groups.add(site.getGroup(groupId));
                        }
                        header.setGroupAccess(groups);
                    }
                    accessChanged = this.stringChanged(accessChanged, oAccess, header.getAccess().toString());
                    if (!accessChanged) {
                        Collection groups = header.getGroupObjects();
                        if (!(oGroups == null || groups == null || oGroups.containsAll(groups) && groups.containsAll(oGroups))) {
                            accessChanged = true;
                        }
                    }
                }
                catch (PermissionException e) {
                    AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.alert.youpermi") + subject));
                    state.setIsListVM(false);
                    state.setStatus("stayAtRevise");
                    AnnouncementAction.disableObservers((SessionState)sstate);
                    return;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                Time now = TimeService.newTime();
                int notiLevel = noti;
                if (msg.getAnnouncementHeaderEdit().getDraft()) {
                    notiLevel = 3;
                }
                if (releaseDate != null && now.before(releaseDate)) {
                    msg.getPropertiesEdit().addProperty("notificationLevel", notification);
                    msg.getPropertiesEdit().addPropertyToList("noti_history", now.toStringLocalFull() + "_" + notiLevel + "_" + releaseDate.toStringLocalFull());
                } else {
                    msg.getPropertiesEdit().addPropertyToList("noti_history", now.toStringLocalFull() + "_" + notiLevel);
                }
                channel.commitMessage((MessageEdit)msg, noti, "org.sakaiproject.announcement.impl.SiteEmailNotificationAnnc");
                if (!state.getIsNewAnnouncement()) {
                    state.setEdit(null);
                }
                if (titleChanged) {
                    this.eventTrackingService.post(this.eventTrackingService.newEvent("annc.revise.title", msg.getReference(), true));
                }
                if (accessChanged) {
                    this.eventTrackingService.post(this.eventTrackingService.newEvent("annc.revise.access", msg.getReference(), true));
                }
                if (availabilityChanged) {
                    this.eventTrackingService.post(this.eventTrackingService.newEvent("annc.revise.availability", msg.getReference(), true));
                }
            }
            catch (IdUnusedException e) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)(this + "doPost()"), (Throwable)e);
                }
            }
            catch (PermissionException e) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)(this + "doPost()"), (Throwable)e);
                }
                AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.alert.youpermi") + subject));
            }
            state.setIsListVM(true);
            state.setAttachments(null);
            state.setSelectedAttachments(null);
            state.setDeleteMessages(null);
            state.setStatus("post");
            state.setMessageReference("");
            state.setTempAnnounceTo(null);
            state.setTempAnnounceToGroups(null);
            state.setCurrentSortedBy(AnnouncementAction.getCurrentOrder());
            sstate.setAttribute("session.state.sorted.by", (Object)AnnouncementAction.getCurrentOrder());
            sstate.setAttribute("session.state.sort.asc", (Object)state.getCurrentSortAsc());
            AnnouncementAction.enableObservers((SessionState)sstate);
        }
    }

    private boolean stringChanged(boolean startValue, String s1, String s2) {
        boolean rv = startValue;
        if (!startValue) {
            if (s1 == null && s2 != null) {
                rv = true;
            } else if (s1 != null && s2 == null) {
                rv = true;
            } else if (s1 != null && s2 != null && !s1.equals(s2)) {
                rv = true;
            }
        }
        return rv;
    }

    public void doPreviewrevise(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        state.setStatus("backToReviseAnnouncement");
        AnnouncementAction.disableObservers((SessionState)sstate);
    }

    public void doDelete(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        Vector v = state.getDelete_messages();
        Iterator delete_messages = v.iterator();
        while (delete_messages.hasNext()) {
            try {
                AnnouncementMessage message = (AnnouncementMessage)delete_messages.next();
                AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(message.getReference()));
                if (channel.allowRemoveMessage((Message)message)) {
                    channel.removeAnnouncementMessage(message.getId());
                    AnnouncementAction.enableObservers((SessionState)sstate);
                    continue;
                }
                AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youdel"));
            }
            catch (IdUnusedException e) {
                if (!M_log.isDebugEnabled()) continue;
                M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
            }
            catch (PermissionException e) {
                if (!M_log.isDebugEnabled()) continue;
                M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
            }
            catch (NoSuchElementException e) {
                if (!M_log.isDebugEnabled()) continue;
                M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
            }
        }
        state.setIsListVM(true);
        state.setStatus("FinishDeleting");
    }

    public void doDeleteannouncement(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        String messageReference = state.getMessageReference();
        if (state.getIsListVM()) {
            String[] messageReferences = rundata.getParameters().getStrings("selectedMembers");
            if (messageReferences != null) {
                Vector<AnnouncementMessage> v = new Vector<AnnouncementMessage>();
                for (int i = 0; i < messageReferences.length; ++i) {
                    try {
                        AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReferences[i]));
                        AnnouncementMessage message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReferences[i]));
                        v.addElement(message);
                        continue;
                    }
                    catch (IdUnusedException e) {
                        if (!M_log.isDebugEnabled()) continue;
                        M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
                        continue;
                    }
                    catch (PermissionException e) {
                        if (M_log.isDebugEnabled()) {
                            M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
                        }
                        AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.alert.youdelann") + messageReferences[i]));
                    }
                }
                state.setDeleteMessages(v);
                state.setIsListVM(false);
                state.setStatus("deleteAnnouncement");
                AnnouncementAction.disableObservers((SessionState)sstate);
            } else {
                state.setIsListVM(true);
                state.setStatus("noSelectedForDeletion");
                AnnouncementAction.enableObservers((SessionState)sstate);
            }
        } else {
            state.setIsNewAnnouncement(false);
            Vector<AnnouncementMessage> v = new Vector<AnnouncementMessage>();
            try {
                AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReference));
                AnnouncementMessage message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReference));
                v.addElement(message);
            }
            catch (IdUnusedException e) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)(this + "doDeleteannouncement()"), (Throwable)e);
                }
            }
            catch (PermissionException e) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)(this + "doDeleteannouncement()"), (Throwable)e);
                }
                AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youdelann2"));
            }
            state.setDeleteMessages(v);
            state.setIsListVM(false);
            if (sstate.getAttribute("message") == null) {
                state.setStatus("deleteAnnouncement");
            }
        }
        AnnouncementAction.disableObservers((SessionState)sstate);
    }

    public void doDelete_announcement_link(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        String messageReference = rundata.getParameters().getString("itemReference");
        state.setMessageReference(messageReference);
        state.setIsNewAnnouncement(false);
        Vector<AnnouncementMessage> v = new Vector<AnnouncementMessage>();
        try {
            AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReference));
            AnnouncementMessage message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReference));
            v.addElement(message);
        }
        catch (IdUnusedException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + "doDeleteannouncement()"), (Throwable)e);
            }
        }
        catch (PermissionException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + "doDeleteannouncement()"), (Throwable)e);
            }
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.youdelann2"));
        }
        state.setDeleteMessages(v);
        if (sstate.getAttribute("message") == null) {
            state.setStatus("deleteAnnouncement");
        }
    }

    public void doReviseannouncement(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        state.setStatus("goToReviseAnnouncement");
        String messageReference = rundata.getParameters().getString("itemReference");
        state.setMessageReference(messageReference);
        try {
            AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReference));
            AnnouncementMessageEdit edit = channel.editAnnouncementMessage(this.getMessageIDFromReference(messageReference));
            state.setEdit(edit);
            state.setTempAnnounceToGroups(edit.getAnnouncementHeader().getGroups());
            List attachmentList = edit.getHeader().getAttachments();
            state.setAttachments(attachmentList);
            AnnouncementAction.disableObservers((SessionState)sstate);
        }
        catch (IdUnusedException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + "announcementRevise"), (Throwable)e);
            }
        }
        catch (PermissionException e) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + "announcementRevise"), (Throwable)e);
            }
            state.setStatus("showMetadata");
        }
        catch (InUseException err) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)(this + ".doReviseannouncementfrommenu"), (Throwable)err);
            }
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.thisitem"));
            state.setStatus("showMetadata");
        }
        state.setIsNewAnnouncement(false);
    }

    public void doReviseannouncementfrommenu(RunData rundata, Context context) {
        AnnouncementActionState state;
        block24: {
            state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
            String peid = ((JetspeedRunData)rundata).getJs_peid();
            SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
            String messageReference = state.getMessageReference();
            if (state.getIsListVM()) {
                String[] messageReferences = rundata.getParameters().getStrings("selectedMembers");
                if (messageReferences != null) {
                    if (messageReferences.length > 1) {
                        state.setIsListVM(true);
                        state.setStatus("moreThanOneSelectedForRevise");
                        AnnouncementAction.enableObservers((SessionState)sstate);
                    } else if (messageReferences.length == 1) {
                        state.setIsListVM(false);
                        state.setMessageReference(messageReferences[0]);
                        state.setStatus("goToReviseAnnouncement");
                        try {
                            AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReferences[0]));
                            AnnouncementMessage message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReferences[0]));
                            if (channel.allowEditMessage(message.getId())) {
                                state.setAttachments(message.getHeader().getAttachments());
                                AnnouncementMessageEdit edit = channel.editAnnouncementMessage(this.getMessageIDFromReference(messageReferences[0]));
                                state.setEdit(edit);
                                state.setTempAnnounceToGroups(edit.getAnnouncementHeader().getGroups());
                                break block24;
                            }
                            state.setIsListVM(true);
                            state.setStatus("noPermissionToRevise");
                        }
                        catch (IdUnusedException e) {
                            if (M_log.isDebugEnabled()) {
                                M_log.debug((Object)(this + "announcementReviseFromMenu"), (Throwable)e);
                            }
                        }
                        catch (PermissionException e) {
                            if (M_log.isDebugEnabled()) {
                                M_log.debug((Object)(this + "announcementReviseFromMenu"), (Throwable)e);
                            }
                            AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.alert.youacc") + e.toString()));
                        }
                        catch (InUseException err) {
                            if (M_log.isDebugEnabled()) {
                                M_log.debug((Object)(this + ".doReviseannouncementfrommenu"), (Throwable)err);
                            }
                            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.thisis"));
                            state.setIsListVM(false);
                            state.setStatus("showMetadata");
                            AnnouncementAction.disableObservers((SessionState)sstate);
                        }
                    }
                } else {
                    state.setIsListVM(true);
                    state.setStatus("noSelectedForRevise");
                    AnnouncementAction.enableObservers((SessionState)sstate);
                }
            } else {
                state.setIsListVM(false);
                state.setStatus("goToReviseAnnouncement");
                try {
                    AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReference));
                    AnnouncementMessage message = channel.getAnnouncementMessage(this.getMessageIDFromReference(messageReference));
                    if (channel.allowEditMessage(message.getId())) {
                        AnnouncementMessageEdit edit = channel.editAnnouncementMessage(this.getMessageIDFromReference(messageReference));
                        state.setEdit(edit);
                        state.setAttachments(message.getHeader().getAttachments());
                        state.setTempAnnounceToGroups(edit.getAnnouncementHeader().getGroups());
                    } else {
                        state.setIsListVM(true);
                        state.setStatus("noPermissionToRevise");
                    }
                }
                catch (IdUnusedException e) {
                    if (M_log.isDebugEnabled()) {
                        M_log.debug((Object)(this + "announcementReviseFromMenu"), (Throwable)e);
                    }
                }
                catch (PermissionException e) {
                    if (M_log.isDebugEnabled()) {
                        M_log.debug((Object)(this + "announcementReviseFromMenu"), (Throwable)e);
                    }
                    AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.alert.youacc") + e.toString()));
                }
                catch (InUseException err) {
                    if (M_log.isDebugEnabled()) {
                        M_log.debug((Object)(this + ".doReviseannouncementfrommenu"), (Throwable)err);
                    }
                    AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.thisis"));
                    state.setIsListVM(false);
                    state.setStatus("showMetadata");
                    AnnouncementAction.disableObservers((SessionState)sstate);
                }
            }
        }
        state.setIsNewAnnouncement(false);
    }

    public void doRevisepreview(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        if (sstate.getAttribute("message") != null) {
            state.setIsListVM(false);
            state.setStatus("stayAtRevise");
        } else {
            state.setStatus("revisePreviw");
        }
        AnnouncementAction.disableObservers((SessionState)sstate);
    }

    public void doAttachments(RunData data, Context context) {
        AnnouncementActionState actionState = (AnnouncementActionState)this.getState(context, data, AnnouncementActionState.class);
        if (actionState.getChannelId().contains("motd")) {
            ToolSession session = SessionManager.getCurrentToolSession();
            session.setAttribute("sakaiproject.filepicker.attachLinks", (Object)new Boolean(true).toString());
        }
        this.startHelper(data.getRequest(), "sakai.filepicker");
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        AnnouncementActionState myState = (AnnouncementActionState)this.getState(context, data, AnnouncementActionState.class);
        state.setAttribute("sakaiproject.filepicker.attachments", (Object)myState.getAttachments());
        myState.setStatus("backToReviseAnnouncement");
    }

    public void doCancel(RunData rundata, Context context) {
        SessionState sstate;
        block6: {
            AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
            if (state.getStatus().equals("options") || state.getStatus().equals("merge")) {
                this.cancelOptions();
            }
            String peid = ((JetspeedRunData)rundata).getJs_peid();
            sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
            state.setIsListVM(true);
            state.setAttachments(null);
            state.setSelectedAttachments(null);
            state.setDeleteMessages(null);
            state.setStatus("cancel");
            state.setTempAnnounceTo(null);
            state.setTempAnnounceToGroups(null);
            state.setCurrentSortedBy(AnnouncementAction.getCurrentOrder());
            sstate.setAttribute("session.state.sorted.by", (Object)AnnouncementAction.getCurrentOrder());
            sstate.setAttribute("session.state.sort.asc", (Object)state.getCurrentSortAsc());
            sstate.removeAttribute("mode");
            AnnouncementAction.enableObservers((SessionState)sstate);
            try {
                if (state.getEdit() != null) {
                    AnnouncementChannel channel = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(state.getEdit().getReference()));
                    channel.cancelMessage((MessageEdit)state.getEdit());
                    state.setEdit(null);
                }
            }
            catch (IdUnusedException e) {
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)(this + "doCancel()"), (Throwable)e);
                }
            }
            catch (PermissionException e) {
                if (!M_log.isDebugEnabled()) break block6;
                M_log.debug((Object)(this + "doCancel()"), (Throwable)e);
            }
        }
        AnnouncementAction.enableObservers((SessionState)sstate);
    }

    public void doLinkcancel(RunData rundata, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        state.setIsListVM(true);
        state.setAttachments(null);
        state.setSelectedAttachments(null);
        state.setDeleteMessages(null);
        state.setStatus("cancel");
        AnnouncementAction.enableObservers((SessionState)sstate);
    }

    public void doSavedraft(RunData rundata, Context context) {
        this.postOrSaveDraft(rundata, context, false);
    }

    private void setupSort(RunData rundata, Context context, String field) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(((JetspeedRunData)rundata).getJs_peid());
        sstate.setAttribute("session.state.sorted.by", (Object)field);
        if (state.getCurrentSortedBy().equals(field)) {
            boolean asc = state.getCurrentSortAsc();
            asc = !asc;
            state.setCurrentSortAsc(asc);
            sstate.setAttribute("session.state.sort.asc", (Object)new Boolean(asc));
        } else {
            state.setCurrentSortedBy(field);
            state.setCurrentSortAsc(true);
            sstate.setAttribute("session.state.sort.asc", (Object)Boolean.FALSE);
        }
    }

    public void doSortbysubject(RunData rundata, Context context) {
        this.setupSort(rundata, context, "subject");
    }

    public void doSortbyfrom(RunData rundata, Context context) {
        this.setupSort(rundata, context, "from");
    }

    public void doSortbypublic(RunData rundata, Context context) {
        this.setupSort(rundata, context, "public");
    }

    public void doSortbydate(RunData rundata, Context context) {
        this.setupSort(rundata, context, "date");
    }

    public void doSortbymessage_order(RunData rundata, Context context) {
        this.setupSort(rundata, context, "message_order");
    }

    public void doSortbyreleasedate(RunData rundata, Context context) {
        this.setupSort(rundata, context, "releasedate");
    }

    public void doSortbyretractdate(RunData rundata, Context context) {
        this.setupSort(rundata, context, "retractdate");
    }

    public void doSortbychannel(RunData rundata, Context context) {
        this.setupSort(rundata, context, "channel");
    }

    public void doSortbyfor(RunData rundata, Context context) {
        this.setupSort(rundata, context, "for");
    }

    public void doSortbygrouptitle(RunData rundata, Context context) {
        this.setupSort(rundata, context, "grouptitle");
    }

    public void doSortbygroupdescription(RunData rundata, Context context) {
        this.setupSort(rundata, context, "groupdescription");
    }

    private int seperatorMatrix(boolean a, boolean b, boolean c) {
        int i = 0;
        if (a) {
            i += 100;
        }
        if (b) {
            i += 10;
        }
        if (c) {
            ++i;
        }
        if (i == 111) {
            return 11;
        }
        if (i == 110 || i == 101) {
            return 10;
        }
        if (i == 11) {
            return 1;
        }
        if (i == 100 || i == 10 || i == 1 || i == 0) {
            return 0;
        }
        return 11;
    }

    private void buildMenu(VelocityPortlet portlet, Context context, RunData rundata, AnnouncementActionState state, boolean menu_new, boolean menu_delete, boolean menu_revise, boolean menu_merge, boolean menu_permissions, boolean menu_options, AnnouncementActionState.DisplayOptions displayOptions) {
        MenuImpl bar = new MenuImpl(portlet, rundata, "AnnouncementAction");
        boolean buttonRequiringCheckboxesPresent = false;
        Properties placementProperties = ToolManager.getCurrentPlacement().getPlacementConfig();
        String sakaiReorderProperty = ServerConfigurationService.getString((String)"sakai.announcement.reorder", (String)"false");
        if (displayOptions != null && !displayOptions.isShowOnlyOptionsButton()) {
            String statusName = state.getStatus();
            if (statusName != null) {
                if (statusName.equals("showMetadata")) {
                    boolean s1 = true;
                    boolean s2 = true;
                    int m = this.seperatorMatrix(menu_new, menu_revise, menu_delete);
                    if (m == 10) {
                        s2 = false;
                    }
                    if (m == 1) {
                        s1 = false;
                    }
                    if (m == 0) {
                        s2 = false;
                        s1 = false;
                    }
                    bar.add((MenuItem)new MenuEntry(rb.getString("gen.new"), null, menu_new, 0, "doNewannouncement"));
                    if (s1) {
                        bar.add((MenuItem)new MenuDivider());
                    }
                    bar.add((MenuItem)new MenuEntry(rb.getString("gen.revise"), null, menu_revise, 0, "doReviseannouncementfrommenu"));
                    if (s2) {
                        bar.add((MenuItem)new MenuDivider());
                    }
                    bar.add((MenuItem)new MenuEntry(rb.getString("gen.delete2"), null, menu_delete, 0, "doDeleteannouncement"));
                    buttonRequiringCheckboxesPresent = true;
                } else if (statusName.equals("reorder")) {
                    bar.add((MenuItem)new MenuEntry(rb.getString("java.refresh"), "doCancel"));
                } else {
                    bar.add((MenuItem)new MenuEntry(rb.getString("gen.new"), null, menu_new, 0, "doNewannouncement"));
                    buttonRequiringCheckboxesPresent = true;
                }
            } else {
                bar.add((MenuItem)new MenuEntry(rb.getString("gen.new"), null, menu_new, 0, "doNewannouncement"));
                buttonRequiringCheckboxesPresent = true;
            }
            if (menu_merge) {
                bar.add((MenuItem)new MenuEntry(rb.getString("java.merge"), "doMerge"));
            }
        }
        if (placementProperties.containsKey("enableReorder") && placementProperties.getProperty("enableReorder").equalsIgnoreCase("true") && menu_new && state.getStatus() != "reorder" && state.getStatus() != "showMetadata") {
            bar.add((MenuItem)new MenuEntry(rb.getString("java.reorder"), "doReorder"));
        } else if ((!placementProperties.containsKey("enableReorder") || !placementProperties.getProperty("enableReorder").equalsIgnoreCase("false")) && menu_new && state.getStatus() != "reorder" && state.getStatus() != "showMetadata" && sakaiReorderProperty.equalsIgnoreCase("true")) {
            bar.add((MenuItem)new MenuEntry(rb.getString("java.reorder"), "doReorder"));
        }
        if (menu_options) {
            this.addOptionsMenu((Menu)bar, (JetspeedRunData)rundata);
        }
        if (displayOptions != null && !displayOptions.isShowOnlyOptionsButton() && menu_permissions) {
            bar.add((MenuItem)new MenuEntry(rb.getString("java.permissions"), "doPermissions"));
        }
        SessionState stateForMenus = ((JetspeedRunData)rundata).getPortletSessionState(portlet.getID());
        stateForMenus.setAttribute("menu", (Object)bar);
        Iterator it = bar.getItems().iterator();
        boolean enabledItemExists = false;
        while (it.hasNext()) {
            MenuItem menuItem = (MenuItem)it.next();
            if (!menuItem.getIsEnabled()) continue;
            enabledItemExists = true;
            break;
        }
        context.put("EnabledMenuItemExists", (Object)enabledItemExists);
        context.put("EnableItemCheckBoxes", (Object)(enabledItemExists && buttonRequiringCheckboxesPresent ? 1 : 0));
        context.put("EnabledMenuItemExists", (Object)enabledItemExists);
        context.put("menu", (Object)bar);
        context.put("action", (Object)"AnnouncementAction");
        context.put("tlang", (Object)rb);
    }

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        AnnouncementActionState annState;
        String channelId;
        super.initState(state, portlet, rundata);
        if (this.contentHostingService == null) {
            this.contentHostingService = (ContentHostingService)ComponentManager.get((String)"org.sakaiproject.content.api.ContentHostingService");
        }
        if (this.entityBroker == null) {
            this.entityBroker = (EntityBroker)ComponentManager.get((String)"org.sakaiproject.entitybroker.EntityBroker");
        }
        if (this.eventTrackingService == null) {
            this.eventTrackingService = (EventTrackingService)ComponentManager.get((String)"org.sakaiproject.event.api.EventTrackingService");
        }
        if ((channelId = (annState = (AnnouncementActionState)this.getState(portlet, (RunData)rundata, AnnouncementActionState.class)).getChannelId()) == null) {
            channelId = StringUtils.trimToNull((String)portlet.getPortletConfig().getInitParameter("channel"));
            if (channelId == null) {
                channelId = AnnouncementService.channelReference((String)ToolManager.getCurrentPlacement().getContext(), (String)SiteService.MAIN_CONTAINER);
            }
            annState.setChannelId(channelId);
            annState.setIsListVM(true);
        }
        state.setAttribute("channelId", (Object)channelId);
        if (state.getAttribute("state.selected.view") == null) {
            state.setAttribute("state.selected.view", (Object)"view.all");
        }
        if (state.getAttribute("annc.state.inited") == null) {
            state.setAttribute("annc.state.inited", (Object)"annc.state.inited");
            if (SecurityService.unlock((User)UserDirectoryService.getAnonymousUser(), (String)AnnouncementService.SECURE_ANNC_READ, (String)channelId)) {
                state.setAttribute("channelPubView", (Object)"channelPubView");
            }
            MergedList mergedAnnouncementList = new MergedList();
            String[] channelArrayFromConfigParameterValue = null;
            channelArrayFromConfigParameterValue = this.isOnWorkspaceTab() && !SecurityService.isSuperUser() ? mergedAnnouncementList.getAllPermittedChannels((MergedList.ChannelReferenceMaker)new AnnouncementChannelReferenceMaker(this, null)) : mergedAnnouncementList.getChannelReferenceArrayFromDelimitedString(annState.getChannelId(), portlet.getPortletConfig().getInitParameter(this.getPortletConfigParameterNameForLoadOnly(portlet)));
            mergedAnnouncementList.loadChannelsFromDelimitedString(this.isOnWorkspaceTab(), (MergedList.EntryProvider)new MergedListEntryProviderFixedListWrapper((MergedList.EntryProvider)new EntryProvider(this), annState.getChannelId(), channelArrayFromConfigParameterValue, (MergedListEntryProviderFixedListWrapper.ReferenceToChannelConverter)new AnnouncementReferenceToChannelConverter(this, null)), StringUtil.trimToZero((String)SessionManager.getCurrentSessionUserId()), channelArrayFromConfigParameterValue, SecurityService.isSuperUser(), ToolManager.getCurrentPlacement().getContext());
        }
        if (annState.getDisplayOptions() == null) {
            this.loadDisplayOptionsFromPortletConfig(portlet, annState);
        }
        state.setAttribute("publicDisplayBoolean", (Object)Boolean.FALSE);
        Site site = null;
        try {
            site = SiteService.getSite((String)ToolManager.getCurrentPlacement().getContext());
            String[] disableStrgs = ServerConfigurationService.getStrings((String)"prevent.public.announcements");
            if (disableStrgs != null) {
                for (int i = 0; i < disableStrgs.length; ++i) {
                    if (!StringUtil.trimToZero((String)disableStrgs[i]).equals(site.getType())) continue;
                    state.setAttribute("publicDisplayBoolean", (Object)Boolean.TRUE);
                }
            }
        }
        catch (IdUnusedException e) {
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    private void loadDisplayOptionsFromPortletConfig(VelocityPortlet portlet, AnnouncementActionState annState) {
        AnnouncementActionState.DisplayOptions displayOptions = new AnnouncementActionState.DisplayOptions();
        annState.setDisplayOptions(displayOptions);
        Properties registeredProperties = ToolManager.getCurrentTool().getRegisteredConfig();
        displayOptions.loadProperties((Map)registeredProperties);
    }

    private void updateObservationOfChannel(MergedList mergedAnnouncementList, RunData runData, SessionState state, AnnouncementActionState annState) {
    }

    public void doPermissions(RunData data, Context context) {
        this.startHelper(data.getRequest(), "sakai.permissions.helper");
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        AnnouncementActionState stateObj = (AnnouncementActionState)this.getState(context, data, AnnouncementActionState.class);
        String channelRefStr = stateObj.getChannelId();
        Reference channelRef = EntityManager.newReference((String)channelRefStr);
        if (SiteService.siteExists((String)channelRef.getContext())) {
            String siteRef = SiteService.siteReference((String)channelRef.getContext());
            state.setAttribute("sakaiproject.permissions.targetRef", (Object)siteRef);
            state.setAttribute("sakaiproject.permissions.description", (Object)(rb.getString("java.set") + SiteService.getSiteDisplay((String)channelRef.getContext())));
        } else {
            state.setAttribute("sakaiproject.permissions.targetRef", (Object)channelRefStr);
            state.setAttribute("sakaiproject.permissions.description", (Object)(rb.getString("java.set") + channelRefStr));
        }
        state.setAttribute("sakaiproject.permissions.prefix", (Object)"annc.");
        ResourceLoader pRb = new ResourceLoader("permissions");
        HashMap pRbValues = new HashMap();
        for (Map.Entry entry : pRb.entrySet()) {
            pRbValues.put(entry.getKey(), entry.getValue());
        }
        state.setAttribute("permissionDescriptions", pRbValues);
        String groupAware = ToolManager.getCurrentTool().getRegisteredConfig().getProperty("groupAware");
        state.setAttribute("groupAware", (Object)(groupAware != null ? Boolean.valueOf(groupAware) : Boolean.FALSE));
        state.removeAttribute("menu");
    }

    public void doMerge(RunData runData, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, runData, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState sstate = ((JetspeedRunData)runData).getPortletSessionState(peid);
        this.doOptions(runData, context);
        if (!"options".equals(sstate.getAttribute("mode"))) {
            return;
        }
        this.enableObserver(sstate, false);
        state.setStatus("merge");
    }

    public void doReorder(RunData runData, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, runData, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState sstate = ((JetspeedRunData)runData).getPortletSessionState(peid);
        state.setStatus("reorder");
    }

    public void doUpdate(RunData runData, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, runData, AnnouncementActionState.class);
        if (!SiteService.allowUpdateSite((String)ToolManager.getCurrentPlacement().getContext())) {
            M_log.debug((Object)(this + ".doUpdate - Do not have permission to update"));
            state.setStatus("cancel");
            return;
        }
        if (state.getStatus().equals("merge")) {
            this.doMergeUpdate(runData, context);
        } else if (state.getStatus().equals("options")) {
            this.doOptionsUpdate(runData, context);
        } else if (state.getStatus().equals("reorder")) {
            this.doReorderUpdate(runData, context);
        } else {
            M_log.debug((Object)(this + ".doUpdate - Unexpected status"));
        }
    }

    private void doMergeUpdate(RunData runData, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, runData, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState sstate = ((JetspeedRunData)runData).getPortletSessionState(peid);
        MergedList mergedChannelList = (MergedList)sstate.getAttribute("mergedChannels");
        if (mergedChannelList != null) {
            mergedChannelList.loadFromRunData(runData.getParameters());
        } else if (M_log.isDebugEnabled()) {
            M_log.debug((Object)(this + ".doUpdate mergedChannelList == null"));
        }
        Placement placement = ToolManager.getCurrentPlacement();
        placement.getPlacementConfig().remove("nonMergedAnnouncementChannels");
        if (mergedChannelList != null) {
            placement.getPlacementConfig().setProperty("mergedAnnouncementChannels", mergedChannelList.getDelimitedChannelReferenceString());
        } else {
            placement.getPlacementConfig().remove("mergedAnnouncementChannels");
        }
        this.saveOptions();
        this.updateObservationOfChannel(mergedChannelList, runData, sstate, state);
        this.enableObserver(sstate, true);
        state.setStatus(null);
        sstate.removeAttribute("mode");
        state.setStatus("cancel");
    }

    public void doReorderUpdate(RunData rundata, Context context) {
        String[] messageReferences2;
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, rundata, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)rundata).getJs_peid();
        SessionState sstate = ((JetspeedRunData)rundata).getPortletSessionState(peid);
        String messageReference = state.getMessageReference();
        if (state.getIsListVM() && (messageReferences2 = rundata.getParameters().getStrings("selectedMembers2")) != null) {
            try {
                List allMessages = AnnouncementService.getChannel((String)state.getChannelId()).getMessages(null, true);
                int msgCount = allMessages.size();
                ArrayList<String> updatedMessageIds = new ArrayList<String>();
                Vector v2 = new Vector();
                int j = allMessages.size();
                if (sstate.getAttribute("msg-top") != null && sstate.getAttribute("page-size") != null) {
                    j = (Integer)sstate.getAttribute("msg-top");
                }
                int i = 0;
                while (i < messageReferences2.length) {
                    try {
                        AnnouncementChannel channel2 = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(messageReferences2[i]));
                        AnnouncementMessage message2 = channel2.getAnnouncementMessage(this.getMessageIDFromReference(messageReferences2[i]));
                        AnnouncementMessageEdit msg = (AnnouncementMessageEdit)message2;
                        AnnouncementMessageHeaderEdit header2 = msg.getAnnouncementHeaderEdit();
                        header2.setMessage_order(Integer.valueOf(msgCount - j));
                        channel2.commitMessage_order((MessageEdit)msg);
                        updatedMessageIds.add(msg.getId());
                    }
                    catch (IdUnusedException e) {
                        if (M_log.isDebugEnabled()) {
                            M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
                        }
                    }
                    catch (PermissionException e) {
                        if (M_log.isDebugEnabled()) {
                            M_log.debug((Object)(this + ".doDeleteannouncement()"), (Throwable)e);
                        }
                        AnnouncementAction.addAlert((SessionState)sstate, (String)(rb.getString("java.alert.youdelann") + messageReferences2[i]));
                    }
                    ++i;
                    ++j;
                }
                if (allMessages.size() > messageReferences2.length) {
                    SortedIterator messagesSorted = new SortedIterator(allMessages.iterator(), (Comparator)new AnnouncementComparator(this, "message_order", true));
                    int messageOrder = 1;
                    while (messagesSorted.hasNext()) {
                        Message message = (Message)messagesSorted.next();
                        if (!updatedMessageIds.contains(message.getId())) {
                            AnnouncementChannel channel2 = AnnouncementService.getAnnouncementChannel((String)this.getChannelIdFromReference(message.getReference()));
                            AnnouncementMessage message2 = channel2.getAnnouncementMessage(this.getMessageIDFromReference(message.getReference()));
                            AnnouncementMessageEdit msg = (AnnouncementMessageEdit)message2;
                            AnnouncementMessageHeaderEdit header2 = msg.getAnnouncementHeaderEdit();
                            header2.setMessage_order(Integer.valueOf(messageOrder));
                            channel2.commitMessage_order((MessageEdit)msg);
                        }
                        ++messageOrder;
                    }
                }
            }
            catch (PermissionException e1) {
                M_log.error((Object)e1);
            }
            catch (IdUnusedException e1) {
                M_log.error((Object)e1);
            }
        }
        state.setStatus(null);
        sstate.removeAttribute("mode");
        state.setStatus("cancel");
    }

    public void doOptionsUpdate(RunData runData, Context context) {
        AnnouncementActionState state = (AnnouncementActionState)this.getState(context, runData, AnnouncementActionState.class);
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState sstate = ((JetspeedRunData)runData).getPortletSessionState(peid);
        this.doUpdateDisplayOptions(runData, state, sstate);
        try {
            String alias = StringUtils.trimToNull((String)runData.getParameters().getString("rssAlias"));
            if (alias != null && alias.length() > 99) {
                AnnouncementAction.addAlert((SessionState)sstate, (String)"The length of alias cannot be greater than 99 characters");
                state.setStatus("options");
                return;
            }
            StringBuilder alertMsg = new StringBuilder();
            alias = FormattedText.processFormattedText((String)alias, (StringBuilder)alertMsg);
            if (alertMsg.length() > 0) {
                AnnouncementAction.addAlert((SessionState)sstate, (String)alertMsg.toString());
                state.setStatus("options");
                return;
            }
            Reference anncRef = AnnouncementService.getAnnouncementReference((String)ToolManager.getCurrentPlacement().getContext());
            List aliasList = AliasService.getAliases((String)anncRef.getReference());
            String oldAlias = null;
            if (!aliasList.isEmpty()) {
                String[] aliasSplit = ((Alias)aliasList.get(0)).getId().split("\\.");
                oldAlias = aliasSplit[0];
            }
            if (!(alias == null || oldAlias != null && oldAlias.equals(alias))) {
                AliasService.removeTargetAliases((String)anncRef.getReference());
                alias = alias + ".rss";
                AliasService.setAlias((String)alias, (String)anncRef.getReference());
            }
        }
        catch (IdUsedException ue) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.dupalias"));
        }
        catch (Exception e) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getString("java.alert.unknown"));
            M_log.warn((Object)(this + ".doOptionsUpdate"), (Throwable)e);
        }
        this.saveOptions();
        this.enableObserver(sstate, true);
        sstate.removeAttribute("mode");
        if (this.isSynopticTool() && state.getDisplayOptions().getNumberOfAnnouncements() > 20) {
            AnnouncementAction.addAlert((SessionState)sstate, (String)rb.getFormattedMessage("java.alert.customsize", new Object[]{20}));
            state.setStatus("options");
        } else {
            state.setStatus("cancel");
        }
    }

    public void doOptions(RunData runData, Context context) {
        super.doOptions(runData, context);
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState sstate = ((JetspeedRunData)runData).getPortletSessionState(peid);
        String msg = (String)sstate.getAttribute("message");
        if (msg == null || msg.equals("")) {
            AnnouncementActionState state = (AnnouncementActionState)this.getState(context, runData, AnnouncementActionState.class);
            state.setStatus("options");
        }
    }

    private void doUpdateDisplayOptions(RunData runData, AnnouncementActionState state, SessionState sstate) {
        AnnouncementActionState.DisplayOptions displayOptions = state.getDisplayOptions();
        ParameterParser parameters = runData.getParameters();
        displayOptions.loadProperties(parameters);
        Placement placement = ToolManager.getCurrentPlacement();
        displayOptions.saveProperties(placement.getPlacementConfig());
    }

    protected boolean notificationEnabled(AnnouncementActionState state) {
        return !state.getChannelId().contains("motd");
    }

    private String processFormattedTextFromBrowser(SessionState state, String strFromBrowser) {
        StringBuilder alertMsg = new StringBuilder();
        try {
            String text = FormattedText.processFormattedText((String)strFromBrowser, (StringBuilder)alertMsg);
            if (alertMsg.length() > 0) {
                AnnouncementAction.addAlert((SessionState)state, (String)alertMsg.toString());
            }
            return text;
        }
        catch (Exception e) {
            M_log.warn((Object)(this + ".processFormattedTextFromBrowser "), (Throwable)e);
            return strFromBrowser;
        }
    }

    protected List readResourcesPage(SessionState state, int first, int last) {
        List rv = (List)state.getAttribute("messages");
        if (rv == null) {
            return new Vector();
        }
        String sortedBy = "";
        if (state.getAttribute("session.state.sorted.by") != null) {
            sortedBy = state.getAttribute("session.state.sorted.by").toString();
        }
        boolean asc = false;
        if (state.getAttribute("session.state.sort.asc") != null) {
            asc = (Boolean)state.getAttribute("session.state.sort.asc");
        }
        if (sortedBy == null || sortedBy.equals("")) {
            sortedBy = AnnouncementAction.getCurrentOrder();
            asc = false;
        }
        SortedIterator rvSorted = new SortedIterator(rv.iterator(), (Comparator)new AnnouncementComparator(this, sortedBy, asc));
        PagingPosition page = new PagingPosition(first, last);
        page.validate(rv.size());
        Vector<Object> subrv = new Vector<Object>();
        for (int index = 0; index < rv.size(); ++index) {
            if (index >= page.getFirst() - 1 && index < page.getLast()) {
                subrv.add(rvSorted.next());
                continue;
            }
            rvSorted.next();
        }
        return subrv;
    }

    protected int sizeResources(SessionState state) {
        List rv = (List)state.getAttribute("messages");
        if (rv == null) {
            return 0;
        }
        return rv.size();
    }

    public void doView(RunData data, Context context) {
        SessionState state = ((JetspeedRunData)data).getPortletSessionState(((JetspeedRunData)data).getJs_peid());
        String viewMode = data.getParameters().getString("view");
        state.setAttribute("state.selected.view", (Object)viewMode);
        if (!viewMode.equals("view.all") && !viewMode.equals("view.public")) {
            if (viewMode.equals("view.bygroup")) {
                state.setAttribute("session.state.sorted.by", (Object)"for");
                state.setAttribute("session.state.sort.asc", (Object)Boolean.TRUE);
            } else if (viewMode.equals("view.mygroups")) {
                // empty if block
            }
        }
        this.resetPaging(state);
        this.doSearch_clear(data, context);
    }

    protected ControllerState getState(Context context, RunData rundata, Class stateClass) {
        return this.getState(((JetspeedRunData)rundata).getJs_peid(), rundata, stateClass);
    }

    protected ControllerState getState(VelocityPortlet portlet, RunData rundata, Class stateClass) {
        if (portlet == null) {
            M_log.warn((Object)(this + ".getState(): portlet null"));
            return null;
        }
        return this.getState(portlet.getID(), rundata, stateClass);
    }

    protected ControllerState getState(String peid, RunData rundata, Class stateClass) {
        if (peid == null) {
            M_log.warn((Object)(this + ".getState(): peid null"));
            return null;
        }
        try {
            SessionState ss = ((JetspeedRunData)rundata).getPortletSessionState(peid);
            ControllerState state = (ControllerState)ss.getAttribute("state");
            if (state != null) {
                return state;
            }
            state = (ControllerState)stateClass.newInstance();
            state.setId(peid);
            ss.setAttribute("state", (Object)state);
            return state;
        }
        catch (Exception e) {
            M_log.warn((Object)(this + ".getState"), (Throwable)e);
            return null;
        }
    }

    protected void releaseState(Context context, RunData rundata) {
        this.releaseState(((JetspeedRunData)rundata).getJs_peid(), rundata);
    }

    protected void releaseState(VelocityPortlet portlet, RunData rundata) {
        this.releaseState(portlet.getID(), rundata);
    }

    protected void releaseState(String peid, RunData rundata) {
        try {
            SessionState ss = ((JetspeedRunData)rundata).getPortletSessionState(peid);
            ControllerState state = (ControllerState)ss.getAttribute("state");
            state.recycle();
            ss.removeAttribute("state");
            ss.clear();
        }
        catch (Exception e) {
            M_log.warn((Object)"", (Throwable)e);
        }
    }

    static /* synthetic */ String access$000(AnnouncementMessage x0) {
        return AnnouncementAction.getAnnouncementRange((AnnouncementMessage)x0);
    }
}

