/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class ResetOnCloseInputStream
extends InputStream {
    private InputStream decorated_is;
    private File decorated_file = null;

    public ResetOnCloseInputStream(File file) throws FileNotFoundException {
        this.decorated_is = new FileInputStream(file);
        this.decorated_file = file;
    }

    public ResetOnCloseInputStream(InputStream anInputStream) {
        if (!anInputStream.markSupported()) {
            throw new IllegalArgumentException("marking not supported");
        }
        anInputStream.mark(Integer.MAX_VALUE);
        this.decorated_is = anInputStream;
    }

    @Override
    public void close() throws IOException {
        if (this.decorated_file != null) {
            this.decorated_is.close();
            this.decorated_is = new FileInputStream(this.decorated_file);
        } else {
            this.decorated_is.reset();
        }
    }

    public void finalize() throws IOException {
        if (this.decorated_is != null) {
            this.decorated_is.close();
        }
    }

    @Override
    public int read() throws IOException {
        return this.decorated_is.read();
    }
}

