/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.util.FormattedText;

@Deprecated
public class Validator {
    private static Log M_log = LogFactory.getLog(Validator.class);
    public static final String INVALID_CHARS_IN_RESOURCE_ID = "^/\\{}[]()%*?#&=\n\r\t\b\f";
    protected static final String INVALID_CHARS_IN_USER_ID = "^/\\%*?\n\r\t\b\f";
    protected static final String INVALID_CHARS_IN_SITE_TYPE = " $&':<>[]{}#%@/;=?\\^|~\"";
    protected static final String INVALID_CHARS_IN_SITE_SKIN = " $&':<>[]{}#%@/;=?\\^|~\"";
    protected static final String MAP_TO_A = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_B = "\ufffd\ufffd";
    protected static final String MAP_TO_C = "\ufffd\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_E = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_I = "\ufffd\ufffd\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_L = "\ufffd\ufffd";
    protected static final String MAP_TO_N = "\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_O = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_U = "\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd";
    protected static final String MAP_TO_Y = "\u0634??";
    protected static final String MAP_TO_X = "???\ufffd\ufffd\ufffd\ufffd\ufffd?\ufffd\ufffd\ufffd\ufffd?";
    protected static final String ESCAPE_CHARS_IN_RESOURCE_ID = ";'\"";
    protected static final String INVALID_CHARS_IN_ZIP_ENTRY = "/\\%:*?'\"";
    protected static final String ESCAPE_URL = "$&+,:;=?@ '\"<>#%{}|\\^~[]`";
    protected static final String ESCAPE_URL_SPECIAL = "^?;";
    protected static final String VALID_EMAIL = "abcdefghijklmnopqrstuvwxyz1234567890ABCDEFGHIJKLMNOPQRSTUVWXYZ!#$&'*+-=?^_`{|}~.";

    public static String escapeHtml(String value) {
        return FormattedText.escapeHtml(value, true);
    }

    public static String escapeHtmlSupressNewlines(String value) {
        return FormattedText.escapeHtml(value, false);
    }

    public static String escapeHtmlTextarea(String value) {
        return FormattedText.escapeHtml(value, false);
    }

    public static String escapeHtmlFormattedText(String value) {
        return FormattedText.escapeHtmlFormattedText(value);
    }

    public static String escapeHtmlFormattedTextSupressNewlines(String value) {
        return FormattedText.escapeHtmlFormattedTextSupressNewlines(value);
    }

    public static String escapeHtmlFormattedTextarea(String value) {
        return FormattedText.escapeHtmlFormattedTextarea(value);
    }

    public static String escapeHtmlFixCopyright(String value) {
        if (value.startsWith("&#169;")) {
            value = "copyright (c)" + value.substring(6);
        }
        return FormattedText.escapeHtml(value, true);
    }

    public static String escapeSql(String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\'') {
                    buf.append("''");
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"Validator.escapeSql: ", (Throwable)e);
            return "";
        }
    }

    public static String escapeJavascript(String value) {
        if (value == null || "".equals(value)) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            if (!Character.isLetter(value.charAt(0))) {
                buf.append("i");
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (!Character.isLetterOrDigit(c)) {
                    buf.append("x");
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"Validator.escapeJavascript: ", (Throwable)e);
            return "";
        }
    }

    public static String escapeUrl(String id) {
        if (id == null) {
            return "";
        }
        id = id.trim();
        try {
            byte[] bytes = id.getBytes("UTF-8");
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < bytes.length; ++i) {
                byte b = bytes[i];
                if (ESCAPE_URL_SPECIAL.indexOf((char)b) != -1) {
                    buf.append("^^x");
                    buf.append(Validator.toHex(b));
                    buf.append('^');
                    continue;
                }
                if (ESCAPE_URL.indexOf((char)b) != -1 || b <= 31 || b == 127 || b >= 128) {
                    buf.append("%");
                    buf.append(Validator.toHex(b));
                    continue;
                }
                buf.append((char)b);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (UnsupportedEncodingException e) {
            M_log.warn((Object)"Validator.escapeUrl: ", (Throwable)e);
            return "";
        }
    }

    public static boolean checkEmailLocal(String id) {
        for (int i = 0; i < id.length(); ++i) {
            if (VALID_EMAIL.indexOf(id.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public static String limitFormattedText(String value, int length) {
        StringBuilder ret = new StringBuilder();
        boolean didTrim = FormattedText.trimFormattedText(value = FormattedText.escapeHtmlFormattedTextSupressNewlines(value), length, ret);
        if (didTrim) {
            ret.append("...");
        }
        return ret.toString();
    }

    public static String escapeResourceName(String id) {
        if (id == null) {
            return "";
        }
        id = id.trim();
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if ("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd".indexOf(c) >= 0) {
                    buf.append('a');
                    continue;
                }
                if ("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd".indexOf(c) >= 0) {
                    buf.append('e');
                    continue;
                }
                if (MAP_TO_I.indexOf(c) >= 0) {
                    buf.append('i');
                    continue;
                }
                if ("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd".indexOf(c) >= 0) {
                    buf.append('o');
                    continue;
                }
                if ("\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd".indexOf(c) >= 0) {
                    buf.append('u');
                    continue;
                }
                if (MAP_TO_Y.indexOf(c) >= 0) {
                    buf.append('y');
                    continue;
                }
                if (MAP_TO_N.indexOf(c) >= 0) {
                    buf.append('n');
                    continue;
                }
                if ("\ufffd\ufffd".indexOf(c) >= 0) {
                    buf.append('b');
                    continue;
                }
                if (MAP_TO_C.indexOf(c) >= 0) {
                    buf.append('c');
                    continue;
                }
                if ("\ufffd\ufffd".indexOf(c) >= 0) {
                    buf.append('l');
                    continue;
                }
                if (MAP_TO_X.indexOf(c) >= 0) {
                    buf.append('x');
                    continue;
                }
                if (c < ' ') {
                    buf.append('_');
                    continue;
                }
                if (INVALID_CHARS_IN_RESOURCE_ID.indexOf(c) >= 0 || ESCAPE_CHARS_IN_RESOURCE_ID.indexOf(c) >= 0) {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"Validator.escapeResourceName: ", (Throwable)e);
            return "";
        }
    }

    public static String escapeQuestionMark(String id) {
        if (id == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (c == '?') {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"Validator.escapeQuestionMark: ", (Throwable)e);
            return "";
        }
    }

    public static String escapeZipEntry(String id) {
        if (id == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < id.length(); ++i) {
                char c = id.charAt(i);
                if (INVALID_CHARS_IN_ZIP_ENTRY.indexOf(c) != -1) {
                    buf.append('_');
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"Validator.escapeZipEntry: ", (Throwable)e);
            return "";
        }
    }

    public static String escapeJsQuoted(String value) {
        if (value == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c == '\'') {
                    buf.append("\\'");
                    continue;
                }
                if (c == '\\') {
                    buf.append("\\\\");
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"Validator.escapeJsQuoted: ", (Throwable)e);
            return "";
        }
    }

    public static boolean checkUserId(String id) {
        if (id == null) {
            return false;
        }
        if (id.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (INVALID_CHARS_IN_USER_ID.indexOf(id.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkResourceId(String id) {
        if (id == null) {
            return false;
        }
        if (id.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (INVALID_CHARS_IN_RESOURCE_ID.indexOf(id.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkSiteType(String id) {
        if (id == null) {
            return true;
        }
        if (id.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (" $&':<>[]{}#%@/;=?\\^|~\"".indexOf(id.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    public static boolean checkSiteSkin(String id) {
        if (id == null) {
            return true;
        }
        if (id.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < id.length(); ++i) {
            if (" $&':<>[]{}#%@/;=?\\^|~\"".indexOf(id.charAt(i)) == -1) continue;
            return false;
        }
        return true;
    }

    public static String getFileName(String fullName) {
        char c;
        StringBuilder buf = new StringBuilder();
        int index = fullName.length() - 1;
        while (index >= 0 && (c = fullName.charAt(index--)) != '\\' && c != '/' && c != ':') {
            buf.insert(0, c);
        }
        return buf.toString();
    }

    public static String getFileSizeWithDividor(String size) {
        StringBuilder newSize = new StringBuilder(size);
        int index = size.length();
        while (index > 3) {
            newSize.insert(index -= 3, ",");
        }
        return newSize.toString();
    }

    public static String getFileExtension(String fullName) {
        int index = fullName.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return fullName.substring(index + 1);
    }

    public static String getResourceTarget(String contentType) {
        String rv = "_blank";
        if (contentType != null && !Validator.letBrowserInline(contentType)) {
            rv = "_self";
        }
        return rv;
    }

    public static boolean letBrowserInline(String type) {
        if (type == null) {
            return false;
        }
        String lType = type.toLowerCase();
        if (lType.startsWith("text/")) {
            return true;
        }
        if (lType.equals("application/xhtml+xml")) {
            return true;
        }
        if (lType.startsWith("image/")) {
            return true;
        }
        if (lType.equals("application/pdf")) {
            return true;
        }
        if (lType.equals("application/x-pdf")) {
            return true;
        }
        if (lType.equals("application/x-osp")) {
            return true;
        }
        if (lType.equals("application/x-shockwave-flash")) {
            return true;
        }
        if (lType.equals("application/futuresplash")) {
            return true;
        }
        if (lType.indexOf("vrml") != -1 || lType.indexOf("cc3d") != -1) {
            return true;
        }
        String[] moreInlineTypes = ServerConfigurationService.getStrings((String)"content.mime.inline");
        if (moreInlineTypes != null) {
            for (int i = 0; i < moreInlineTypes.length; ++i) {
                if (!lType.equals(moreInlineTypes[i])) continue;
                return true;
            }
        }
        return false;
    }

    public static String limit(String value, Integer length) {
        return Validator.limit(value, (int)length);
    }

    public static String limit(String value, int length) {
        StringBuilder buf = new StringBuilder(value);
        if (buf.length() > length) {
            buf.setLength(length);
            buf.append("...");
        }
        return buf.toString();
    }

    public static String cleanInput(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 0) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder();
        block3: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            int next = 0;
            if (i + 1 < len) {
                next = value.charAt(i + 1);
            }
            switch (c) {
                case '\r': {
                    if (next == 10) {
                        buf.append('\n');
                        ++i;
                        continue block3;
                    }
                    buf.append(c);
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (buf.charAt(buf.length() - 1) == '\n') {
            buf.setLength(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String stripAllNewlines(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return value;
        }
        int len = value.length();
        StringBuilder buf = new StringBuilder();
        block3: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    buf.append(' ');
                    continue block3;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        return buf.toString();
    }

    private static final String toHex(byte b) {
        char[] ret = new char[]{Validator.hexDigit(b >>> 4 & 0xF), Validator.hexDigit(b >>> 0 & 0xF)};
        return new String(ret);
    }

    private static final char hexDigit(int i) {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        throw new IllegalArgumentException("Invalid digit:" + i);
    }

    public static boolean checkDate(int day, int month, int year) {
        return !(month == 2 ? (year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? day > 29 : day > 28) : (month == 4 || month == 6 || month == 9 || month == 11) && day > 30);
    }

    public static String generateQueryString(HttpServletRequest req) {
        StringBuilder sb = new StringBuilder();
        try {
            Enumeration e = req.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                for (String value : req.getParameterValues(name)) {
                    sb.append(URLEncoder.encode(name, "UTF-8")).append("=").append(URLEncoder.encode(value, "UTF-8")).append("&");
                }
            }
        }
        catch (UnsupportedEncodingException ex) {
            M_log.error((Object)"No UTF-8 Encoding on this JVM, !!!!");
        }
        if (sb.length() < 1) {
            return null;
        }
        return sb.substring(0, sb.length() - 1);
    }
}

