/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.email.api.EmailService;
import org.sakaiproject.email.cover.DigestService;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.cover.EntityManager;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.Notification;
import org.sakaiproject.event.api.NotificationAction;
import org.sakaiproject.event.cover.NotificationService;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.Preferences;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.cover.PreferencesService;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.Web;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailNotification
implements NotificationAction {
    private final String MULTIPART_BOUNDARY = "======sakai-multi-part-boundary======";
    private final String BOUNDARY_LINE = "\n\n--======sakai-multi-part-boundary======\n";
    private final String TERMINATION_LINE = "\n\n--======sakai-multi-part-boundary======--\n\n";
    private final String MIME_ADVISORY = "This message is for MIME-compliant mail readers.";
    protected String m_siteId = null;

    public EmailNotification() {
    }

    public EmailNotification(String siteId) {
        this.m_siteId = siteId;
    }

    public void set(Element el) {
        this.m_siteId = StringUtils.trimToNull((String)el.getAttribute("site"));
    }

    public void set(NotificationAction other) {
        EmailNotification eOther = (EmailNotification)other;
        this.m_siteId = eOther.m_siteId;
    }

    public NotificationAction getClone() {
        EmailNotification clone = this.makeEmailNotification();
        clone.set(this);
        return clone;
    }

    protected EmailNotification makeEmailNotification() {
        return null;
    }

    public void toXml(Element el) {
        if (this.m_siteId != null) {
            el.setAttribute("site", this.m_siteId);
        }
    }

    public void notify(Notification notification, Event event) {
        this.reNotify(notification.getId(), notification.getResourceFilter(), event.getPriority(), event);
    }

    public void reNotify(String notificationId, String resourceFilter, int eventPriority, Event event) {
        String message;
        if (eventPriority == NotificationService.NOTI_NONE) {
            return;
        }
        List recipients = this.getRecipients(event);
        List immediate = this.immediateRecipients(recipients, notificationId, resourceFilter, eventPriority, event);
        List digest = this.digestRecipients(recipients, notificationId, resourceFilter, eventPriority, event);
        if (immediate.size() == 0 && digest.size() == 0) {
            return;
        }
        List<String> headers = this.getHeaders(event);
        if ("true".equals(ServerConfigurationService.getString((String)"email.precedence.bulk", (String)"false"))) {
            String bulkFlag = "Precedence: bulk";
            headers.add(bulkFlag);
        }
        if (immediate.size() > 0) {
            message = this.getMessage(event);
            new Thread(new RunSendToUsers(immediate, headers, message)).start();
        }
        if (digest.size() > 0) {
            message = this.plainTextContent(event);
            StringBuilder messageForDigest = new StringBuilder();
            String item = this.findHeader("From", headers);
            if (item != null) {
                messageForDigest.append(item + "\n");
            }
            if ((item = this.findHeader("Date", headers)) != null) {
                messageForDigest.append(item + "\n");
            } else {
                messageForDigest.append("Date: " + TimeService.newTime().toStringLocalFullZ() + "\n");
            }
            item = this.findHeader("To", headers);
            if (item != null) {
                messageForDigest.append(item + "\n");
            }
            if ((item = this.findHeader("Cc", headers)) != null) {
                messageForDigest.append(item + "\n");
            }
            if ((item = this.findHeader("Subject", headers)) != null) {
                messageForDigest.append(item + "\n");
            }
            messageForDigest.append("\n");
            messageForDigest.append(message);
            for (User user : digest) {
                DigestService.digest((String)user.getId(), (String)this.findHeaderValue("Subject", headers), (String)messageForDigest.toString());
            }
        }
    }

    protected String getMessage(Event event) {
        Reference ref = EntityManager.newReference((String)event.getResource());
        String title = this.getSite() != null ? this.getSite() : ref.getContext();
        try {
            Site site = SiteService.getSite((String)title);
            title = site.getTitle();
        }
        catch (Exception ignore) {
            // empty catch block
        }
        StringBuilder message = new StringBuilder();
        message.append("This message is for MIME-compliant mail readers.");
        message.append("\n\n--======sakai-multi-part-boundary======\n");
        message.append(this.plainTextHeaders());
        message.append(this.plainTextContent(event));
        message.append(this.getTag(title, false));
        message.append("\n\n--======sakai-multi-part-boundary======\n");
        message.append(this.htmlHeaders());
        message.append(this.htmlPreamble(event));
        message.append(this.htmlContent(event));
        message.append(this.getTag(title, true));
        message.append(this.htmlEnd());
        message.append("\n\n--======sakai-multi-part-boundary======--\n\n");
        return message.toString();
    }

    protected String plainTextHeaders() {
        return "Content-Type: text/plain\n\n";
    }

    protected String plainTextContent(Event event) {
        return null;
    }

    protected String htmlHeaders() {
        return "Content-Type: text/html\n\n";
    }

    protected String htmlPreamble(Event event) {
        StringBuilder buf = new StringBuilder();
        buf.append("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"\n");
        buf.append("    \"http://www.w3.org/TR/html4/loose.dtd\">\n");
        buf.append("<html>");
        buf.append("  <head><title>");
        buf.append(this.getSubject(event));
        buf.append("</title></head>");
        buf.append("  <body>");
        return buf.toString();
    }

    protected String htmlContent(Event event) {
        return Web.encodeUrlsAsHtml(Web.escapeHtml(this.plainTextContent(event), true));
    }

    protected String htmlEnd() {
        return "  </body></html>";
    }

    protected String getTag(String title, boolean shouldUseHtml) {
        return "";
    }

    protected List<String> getHeaders(Event event) {
        Vector<String> rv = new Vector<String>();
        rv.add("MIME-Version: 1.0");
        rv.add("Content-Type: multipart/alternative; boundary=\"======sakai-multi-part-boundary======\"");
        return rv;
    }

    protected List getRecipients(Event event) {
        return new Vector();
    }

    protected String getSite() {
        return this.m_siteId;
    }

    protected List immediateRecipients(List recipients, Notification notification, Event event) {
        return this.immediateRecipients(recipients, notification.getId(), notification.getResourceFilter(), event.getPriority(), event);
    }

    protected List immediateRecipients(List<String> recipients, String notificationId, String resourceFilter, int eventPriority, Event event) {
        int priority = event.getPriority();
        if (priority == NotificationService.NOTI_REQUIRED) {
            return recipients;
        }
        Vector<User> rv = new Vector<User>();
        for (User user : recipients) {
            int option = this.getOption(user, notificationId, resourceFilter, eventPriority, event);
            if (!this.isImmediateDeliveryOption(option, resourceFilter)) continue;
            rv.add(user);
        }
        return rv;
    }

    protected boolean isImmediateDeliveryOption(int option, Notification notification) {
        return this.isImmediateDeliveryOption(option, notification.getResourceFilter());
    }

    protected boolean isImmediateDeliveryOption(int option, String resourceFilter) {
        String type;
        if (option == NotificationService.PREF_IMMEDIATE) {
            return true;
        }
        return option == NotificationService.PREF_NONE && (type = EntityManager.newReference((String)resourceFilter).getType()) != null && "org.sakaiproject.mailarchive.api.MailArchiveService".equals(type);
    }

    protected List digestRecipients(List recipients, Notification notification, Event event) {
        return this.digestRecipients(recipients, notification.getId(), notification.getResourceFilter(), event.getPriority(), event);
    }

    protected List digestRecipients(List recipients, String notificationId, String resourceFilter, int eventPriority, Event event) {
        Vector<User> rv = new Vector<User>();
        int priority = event.getPriority();
        if (priority == NotificationService.NOTI_REQUIRED) {
            return rv;
        }
        for (User user : recipients) {
            int option = this.getOption(user, notificationId, resourceFilter, eventPriority, event);
            if (option != NotificationService.PREF_DIGEST) continue;
            rv.add(user);
        }
        return rv;
    }

    protected int getOption(User user, Notification notification, Event event) {
        return this.getOption(user, notification.getId(), notification.getResourceFilter(), event.getPriority(), event);
    }

    protected int getOption(User user, String notificationId, String resourceFilter, int eventPriority, Event event) {
        int option;
        String priStr = Integer.toString(event.getPriority());
        Preferences prefs = PreferencesService.getPreferences((String)user.getId());
        ResourceProperties props = prefs.getProperties(NotificationService.PREFS_NOTI + notificationId);
        try {
            int option2 = (int)props.getLongProperty(priStr);
            if (option2 != NotificationService.PREF_NONE) {
                return option2;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String siteId = EntityManager.newReference((String)resourceFilter).getContext();
        if (siteId != null) {
            props = prefs.getProperties(NotificationService.PREFS_SITE + siteId);
            try {
                option = (int)props.getLongProperty(priStr);
                if (option != NotificationService.PREF_NONE) {
                    return option;
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        props = prefs.getProperties(NotificationService.PREFS_DEFAULT);
        try {
            option = (int)props.getLongProperty(priStr);
            if (option != NotificationService.PREF_NONE) {
                return option;
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        String type = EntityManager.newReference((String)resourceFilter).getType();
        if (type != null) {
            props = prefs.getProperties(NotificationService.PREFS_TYPE + type);
            try {
                int option3 = (int)props.getLongProperty(Integer.toString(NotificationService.NOTI_OPTIONAL));
                if (option3 != NotificationService.PREF_NONE) {
                    return option3;
                }
            }
            catch (EntityPropertyNotDefinedException e) {
                return NotificationService.PREF_IMMEDIATE;
            }
            catch (Exception ignore) {
                // empty catch block
            }
        }
        return NotificationService.PREF_NONE;
    }

    protected String findHeader(String header, List headers) {
        for (String h : headers) {
            if (!h.startsWith(header)) continue;
            return h;
        }
        return null;
    }

    protected String findHeaderValue(String header, List headers) {
        String line = this.findHeader(header, headers);
        if (line == null) {
            return null;
        }
        String value = line.substring(header.length() + 2);
        return value;
    }

    protected String getFrom(Event event) {
        if (NotificationService.isNotificationFromReplyable()) {
            return "From: " + this.getFromEventUser(event);
        }
        return "From: " + this.getFromService();
    }

    protected String getFromService() {
        return "\"" + ServerConfigurationService.getString((String)"ui.service", (String)"Sakai") + "\"<no-reply@" + ServerConfigurationService.getServerName() + ">";
    }

    protected String getFromEventUser(Event event) {
        String userDisplay = null;
        String userEmail = null;
        String userId = event.getUserId();
        if (userId == null) {
            userId = SessionManager.getCurrentSessionUserId();
        }
        if (userId != null) {
            try {
                User u = UserDirectoryService.getUser((String)userId);
                userDisplay = u.getDisplayName();
                userEmail = u.getEmail();
                if (userEmail != null && userEmail.trim().length() == 0) {
                    userEmail = null;
                }
            }
            catch (UserNotDefinedException e) {
                // empty catch block
            }
        }
        if (userEmail == null) {
            userEmail = "no-reply@" + ServerConfigurationService.getServerName();
        }
        if (userDisplay == null) {
            userDisplay = ServerConfigurationService.getString((String)"ui.service", (String)"Sakai");
        }
        return "\"" + userDisplay + "\" <" + userEmail + ">";
    }

    protected String getSubject(Event event) {
        return this.findHeaderValue("Subject", this.getHeaders(event));
    }

    public class RunSendToUsers
    implements Runnable {
        List immediate;
        List headers;
        String message;

        public RunSendToUsers(List immediate, List headers, String message) {
            this.immediate = immediate;
            this.headers = headers;
            this.message = message;
        }

        public void run() {
            EmailService emailService = (EmailService)ComponentManager.get(EmailService.class);
            if (emailService == null) {
                throw new RuntimeException("Unable to get EmailService to send emails");
            }
            emailService.sendToUsers((Collection)this.immediate, (Collection)this.headers, this.message);
        }
    }
}

