/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.messagebundle.api.MessageBundleService;
import org.sakaiproject.thread_local.api.ThreadLocalManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbResourceBundle
extends ResourceBundle {
    protected Locale locale;
    protected Map entries = new HashMap();
    protected String baseName;
    protected static Log log = LogFactory.getLog(DbResourceBundle.class);
    private static Object LOCK = new Object();
    private static ThreadLocalManager threadLocalManager;

    private DbResourceBundle(String baseName, Locale locale) {
        this.baseName = baseName;
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ThreadLocalManager getThreadLocalManager() {
        if (threadLocalManager == null) {
            Object object = LOCK;
            synchronized (object) {
                ThreadLocalManager component = (ThreadLocalManager)ComponentManager.get(ThreadLocalManager.class);
                if (component == null) {
                    throw new IllegalStateException("Unable to find the ThreadLocalManager using the ComponentManager");
                }
                threadLocalManager = component;
            }
        }
        return threadLocalManager;
    }

    public static ResourceBundle addResourceBundle(String baseName, Locale locale, ClassLoader classLoader) {
        DbResourceBundle newBundle = new DbResourceBundle(baseName, locale);
        String context = (String)DbResourceBundle.getThreadLocalManager().get("org.sakaiproject.util.RequestFilter.context");
        try {
            if (context != null) {
                Map bundleValues = DbResourceBundle.getMessageBundleService().getBundle(baseName, context, locale);
                for (Map.Entry entry : bundleValues.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    newBundle.addProperty(key, value);
                }
            }
            ResourceBundle loadedBundle = null;
            try {
                loadedBundle = classLoader == null ? ResourceBundle.getBundle(baseName, locale) : ResourceBundle.getBundle(baseName, locale, classLoader);
            }
            catch (NullPointerException e) {
                // empty catch block
            }
            Enumeration<String> keys = loadedBundle.getKeys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                if (newBundle.handleGetObject(key) != null) continue;
                newBundle.addProperty(key, loadedBundle.getString(key));
            }
        }
        catch (Exception e) {
            log.error((Object)("problem loading bundle: " + baseName + " locale: " + locale.toString() + " " + e.getMessage()));
        }
        return newBundle;
    }

    protected void addProperty(String name, String value) {
        this.entries.put(name, value);
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    protected Object handleGetObject(String key) {
        return this.entries.get(key);
    }

    @Override
    public Enumeration<String> getKeys() {
        return Collections.enumeration(this.entries.keySet());
    }

    public static void indexResourceBundle(String baseName, ResourceBundle newBundle, Locale loc, ClassLoader classLoader) {
        String context = (String)DbResourceBundle.getThreadLocalManager().get("org.sakaiproject.util.RequestFilter.context");
        if (context == null) {
            return;
        }
        MessageBundleService messageBundleService = DbResourceBundle.getMessageBundleService();
        messageBundleService.saveOrUpdate(baseName, context, newBundle, loc);
    }

    private static MessageBundleService getMessageBundleService() {
        return (MessageBundleService)ComponentManager.get((String)MessageBundleService.class.getName());
    }
}

