/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.MimeUtility;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.util.FormattedText;
import org.sakaiproject.util.Validator;

@Deprecated
public class Web {
    private static Log M_log = LogFactory.getLog(Web.class);
    private static final String START_JAVASCRIPT = "<script";
    private static final String END_JAVASCRIPT = "</script>";
    private static SessionManager sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);

    public static String escapeHtml(String value) {
        return FormattedText.escapeHtml(value, true);
    }

    public static String escapeHtmlFormattedText(String value) {
        return FormattedText.escapeHtmlFormattedText(value);
    }

    public static String escapeHtml(String value, boolean escapeNewlines) {
        return FormattedText.escapeHtml(value, escapeNewlines);
    }

    public static String escapeJsQuoted(String value) {
        return Validator.escapeJsQuoted(value);
    }

    public static String escapeUrl(String id) {
        return Validator.escapeUrl(id);
    }

    public static String unEscapeHtml(String value) {
        if (value == null) {
            return "";
        }
        if (value.equals("")) {
            return "";
        }
        value = value.replaceAll("&lt;", "<");
        value = value.replaceAll("&gt;", ">");
        value = value.replaceAll("&amp;", "&");
        value = value.replaceAll("&quot;", "\"");
        return value;
    }

    public static String encodeUrlsAsHtml(String text) {
        Pattern p = Pattern.compile("(?<!href=['\"]{1})(((https?|s?ftp|ftps|file|smb|afp|nfs|(x-)?man|gopher|txmt)://|mailto:)[-:;@a-zA-Z0-9_.,~%+/?=&#]+(?<![.,?:]))");
        Matcher m = p.matcher(text);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            String matchedUrl = m.group();
            m.appendReplacement(buf, "<a href=\"" + Web.unEscapeHtml(matchedUrl) + "\">$1</a>");
        }
        m.appendTail(buf);
        return buf.toString();
    }

    public static String escapeJavascript(String value) {
        if (value == null || "".equals(value)) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            if (!Character.isLetter(value.charAt(0))) {
                buf.append("i");
            }
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (!Character.isLetterOrDigit(c)) {
                    buf.append("x");
                    continue;
                }
                buf.append(c);
            }
            String rv = buf.toString();
            return rv;
        }
        catch (Exception e) {
            M_log.warn((Object)"escapeJavascript: ", (Throwable)e);
            return value;
        }
    }

    protected static final char hexDigit(int i) {
        switch (i) {
            case 0: {
                return '0';
            }
            case 1: {
                return '1';
            }
            case 2: {
                return '2';
            }
            case 3: {
                return '3';
            }
            case 4: {
                return '4';
            }
            case 5: {
                return '5';
            }
            case 6: {
                return '6';
            }
            case 7: {
                return '7';
            }
            case 8: {
                return '8';
            }
            case 9: {
                return '9';
            }
            case 10: {
                return 'A';
            }
            case 11: {
                return 'B';
            }
            case 12: {
                return 'C';
            }
            case 13: {
                return 'D';
            }
            case 14: {
                return 'E';
            }
            case 15: {
                return 'F';
            }
        }
        throw new IllegalArgumentException("Invalid digit:" + i);
    }

    public static String makePath(String[] parts, int start, int end) {
        StringBuilder buf = new StringBuilder();
        for (int i = start; i < end; ++i) {
            buf.append('/');
            buf.append(parts[i]);
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    protected static void print(PrintWriter out, String name, int value) {
        out.print(" " + name + ": ");
        if (value == -1) {
            out.println("none");
        } else {
            out.println(value);
        }
    }

    protected static void print(PrintWriter out, String name, String value) {
        out.print(" " + name + ": ");
        out.println(value == null ? "none" : value);
    }

    public static String returnUrl(HttpServletRequest req, String path) {
        StringBuilder url = new StringBuilder();
        url.append(Web.serverUrl(req));
        url.append(req.getContextPath());
        url.append(req.getServletPath());
        if (path != null) {
            url.append(path);
        }
        return url.toString();
    }

    public static void sendAutoUpdate(PrintWriter out, HttpServletRequest req, String placementId, int updateTime) {
        String userId = sessionManager.getCurrentSessionUserId();
        StringBuilder url = new StringBuilder(Web.serverUrl(req));
        url.append("/courier/");
        url.append(placementId);
        url.append("?userId=");
        url.append(userId);
        out.println("<script type=\"text/javascript\" language=\"JavaScript\">");
        out.println("updateTime = " + updateTime + "000;");
        out.println("updateUrl = \"" + url.toString() + "\";");
        out.println("scheduleUpdate();");
        out.println(END_JAVASCRIPT);
    }

    public static String serverUrl(HttpServletRequest req) {
        String transport = null;
        int port = 0;
        boolean secure = false;
        String forceSecure = System.getProperty("sakai.force.url.secure");
        if (forceSecure != null) {
            transport = "https";
            port = Integer.parseInt(forceSecure);
            secure = true;
        } else {
            transport = req.getScheme();
            port = req.getServerPort();
            secure = req.isSecure();
        }
        StringBuilder url = new StringBuilder();
        url.append(transport);
        url.append("://");
        url.append(req.getServerName());
        if (port != 80 && !secure || port != 443 && secure) {
            url.append(":");
            url.append(port);
        }
        return url.toString();
    }

    public static String snoop(PrintWriter out, boolean html, ServletConfig config, HttpServletRequest req) {
        String name;
        ByteArrayOutputStream ostream = null;
        if (out == null) {
            ostream = new ByteArrayOutputStream();
            out = new PrintWriter(ostream);
            html = false;
        }
        String h1 = "";
        String h1x = "";
        String pre = "";
        String prex = "";
        String b = "";
        String bx = "";
        String p = "";
        if (html) {
            h1 = "<h1>";
            h1x = "</h1>";
            pre = "<pre>";
            prex = "</pre>";
            b = "<b>";
            bx = "</b>";
            p = "<p>";
        }
        Enumeration e = null;
        out.println(h1 + "Snoop for request" + h1x);
        out.println(req.toString());
        if (config != null && (e = config.getInitParameterNames()) != null) {
            boolean first = true;
            while (e.hasMoreElements()) {
                if (first) {
                    out.println(h1 + "Init Parameters" + h1x);
                    out.println(pre);
                    first = false;
                }
                String param = (String)e.nextElement();
                out.println(" " + param + ": " + config.getInitParameter(param));
            }
            out.println(prex);
        }
        out.println(h1 + "Request information:" + h1x);
        out.println(pre);
        Web.print(out, "Request method", req.getMethod());
        String requestUri = req.getRequestURI();
        Web.print(out, "Request URI", requestUri);
        Web.displayStringChars(out, requestUri);
        Web.print(out, "Request protocol", req.getProtocol());
        String servletPath = req.getServletPath();
        Web.print(out, "Servlet path", servletPath);
        Web.displayStringChars(out, servletPath);
        String contextPath = req.getContextPath();
        Web.print(out, "Context path", contextPath);
        Web.displayStringChars(out, contextPath);
        String pathInfo = req.getPathInfo();
        Web.print(out, "Path info", pathInfo);
        Web.displayStringChars(out, pathInfo);
        Web.print(out, "Path translated", req.getPathTranslated());
        Web.print(out, "Query string", req.getQueryString());
        Web.print(out, "Content length", req.getContentLength());
        Web.print(out, "Content type", req.getContentType());
        Web.print(out, "Server name", req.getServerName());
        Web.print(out, "Server port", req.getServerPort());
        Web.print(out, "Remote user", req.getRemoteUser());
        Web.print(out, "Remote address", req.getRemoteAddr());
        Web.print(out, "Authorization scheme", req.getAuthType());
        out.println(prex);
        e = req.getHeaderNames();
        if (e.hasMoreElements()) {
            out.println(h1 + "Request headers:" + h1x);
            out.println(pre);
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                out.println(" " + name + ": " + req.getHeader(name));
            }
            out.println(prex);
        }
        if ((e = req.getParameterNames()).hasMoreElements()) {
            out.println(h1 + "Servlet parameters (Single Value style):" + h1x);
            out.println(pre);
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                out.println(" " + name + " = " + req.getParameter(name));
            }
            out.println(prex);
        }
        if ((e = req.getParameterNames()).hasMoreElements()) {
            out.println(h1 + "Servlet parameters (Multiple Value style):" + h1x);
            out.println(pre);
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                String[] vals = req.getParameterValues(name);
                if (vals != null) {
                    out.print(b + " " + name + " = " + bx);
                    out.println(vals[0]);
                    for (int i = 1; i < vals.length; ++i) {
                        out.println("           " + vals[i]);
                    }
                }
                out.println(p);
            }
            out.println(prex);
        }
        if ((e = req.getAttributeNames()).hasMoreElements()) {
            out.println(h1 + "Request attributes:" + h1x);
            out.println(pre);
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                out.println(" " + name + ": " + req.getAttribute(name));
            }
            out.println(prex);
        }
        if (ostream != null) {
            out.flush();
            return ostream.toString();
        }
        return "";
    }

    protected static final String toHex(byte b) {
        char[] ret = new char[]{Web.hexDigit(b >>> 4 & 0xF), Web.hexDigit(b >>> 0 & 0xF)};
        return new String(ret);
    }

    public static String encodeFileName(HttpServletRequest req, String fileName) {
        String agent = req.getHeader("USER-AGENT");
        try {
            fileName = agent != null && agent.indexOf("MSIE") >= 0 ? URLEncoder.encode(fileName, "UTF8") : (agent != null && agent.indexOf("Mozilla") >= 0 && agent.indexOf("Safari") == -1 ? MimeUtility.encodeText((String)fileName, (String)"UTF8", (String)"B") : URLEncoder.encode(fileName, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            M_log.error((Object)e);
        }
        return fileName;
    }

    private static String internalEscapeHtml(String value, boolean escapeNewlines) {
        if (value == null) {
            return "";
        }
        try {
            StringBuilder buf = new StringBuilder();
            int len = value.length();
            block9: for (int i = 0; i < len; ++i) {
                char c = value.charAt(i);
                switch (c) {
                    case '<': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&lt;");
                        continue block9;
                    }
                    case '>': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&gt;");
                        continue block9;
                    }
                    case '&': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&amp;");
                        continue block9;
                    }
                    case '\"': {
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&quot;");
                        continue block9;
                    }
                    case '\n': {
                        if (escapeNewlines) {
                            if (buf == null) {
                                buf = new StringBuilder(value.substring(0, i));
                            }
                            buf.append("<br />\n");
                            continue block9;
                        }
                        if (buf == null) continue block9;
                        buf.append(c);
                        continue block9;
                    }
                    default: {
                        if (c < '\u0080') {
                            if (buf == null) continue block9;
                            buf.append(c);
                            continue block9;
                        }
                        if (buf == null) {
                            buf = new StringBuilder(value.substring(0, i));
                        }
                        buf.append("&#");
                        buf.append(Integer.toString(c));
                        buf.append(";");
                    }
                }
            }
            return buf == null ? value : buf.toString();
        }
        catch (Exception e) {
            return value;
        }
    }

    public static String cleanHtml(String htmlStr) {
        if (htmlStr == null) {
            return null;
        }
        htmlStr = htmlStr.replaceAll("<img ", "<img alt='' ");
        while (htmlStr.indexOf(START_JAVASCRIPT) != -1) {
            int badStart = htmlStr.indexOf(START_JAVASCRIPT);
            int badEnd = htmlStr.indexOf(END_JAVASCRIPT);
            String badHtml = badStart > -1 && badEnd == -1 ? htmlStr.substring(badStart) : htmlStr.substring(badStart, badEnd + END_JAVASCRIPT.length());
            htmlStr = htmlStr.replace(new StringBuilder(badHtml), new StringBuilder());
        }
        return htmlStr;
    }

    protected static void displayStringChars(PrintWriter out, String str) {
        if (str == null) {
            out.print("null");
        } else {
            for (int i = 0; i < str.length(); ++i) {
                char c = str.charAt(i);
                out.print(Integer.toHexString(c) + " ");
            }
        }
        out.println();
    }
}

