/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.content.cover.ContentTypeImageService;
import org.sakaiproject.entity.api.EntityPropertyNotDefinedException;
import org.sakaiproject.entity.api.EntityPropertyTypeException;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.serialize.SerializableEntity;
import org.sakaiproject.entity.api.serialize.SerializablePropertiesAccess;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.EmptyIterator;
import org.sakaiproject.util.EnumerationIterator;
import org.sakaiproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseResourceProperties
implements ResourceProperties,
SerializablePropertiesAccess,
SerializableEntity {
    private static Log M_log = LogFactory.getLog(BaseResourceProperties.class);
    private static final long serialVersionUID = 1L;
    protected Hashtable m_props = new Hashtable();
    protected transient boolean m_lazy = false;

    public BaseResourceProperties() {
    }

    public BaseResourceProperties(Element el) {
        this();
        NodeList children = el.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element element;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(element = (Element)child).getTagName().equals("property")) continue;
            String name = element.getAttribute("name");
            String enc = StringUtils.trimToNull((String)element.getAttribute("enc"));
            String value = null;
            value = "BASE64".equalsIgnoreCase(enc) ? Xml.decodeAttribute(element, "value") : element.getAttribute("value");
            if ("list".equals(element.getAttribute("list"))) {
                Object current = this.m_props.get(name);
                if (current == null) {
                    Vector<String> values = new Vector<String>();
                    this.m_props.put(name, values);
                    values.add(value);
                    continue;
                }
                if (current instanceof List) {
                    ((List)current).add(value);
                    continue;
                }
                M_log.warn((Object)("construct(el): value set not a list: " + name));
                continue;
            }
            this.m_props.put(name, value);
        }
    }

    public Element toXml(Document doc, Stack stack) {
        Element properties = doc.createElement("properties");
        ((Element)stack.peek()).appendChild(properties);
        Enumeration props = this.m_props.keys();
        while (props.hasMoreElements()) {
            String name = (String)props.nextElement();
            Object value = this.m_props.get(name);
            if (value instanceof String) {
                Element propElement = doc.createElement("property");
                properties.appendChild(propElement);
                propElement.setAttribute("name", name);
                Xml.encodeAttribute(propElement, "value", (String)value);
                propElement.setAttribute("enc", "BASE64");
                continue;
            }
            if (value instanceof List) {
                for (Object val : (List)value) {
                    if (val instanceof String) {
                        Element propElement = doc.createElement("property");
                        properties.appendChild(propElement);
                        propElement.setAttribute("name", name);
                        Xml.encodeAttribute(propElement, "value", (String)val);
                        propElement.setAttribute("enc", "BASE64");
                        propElement.setAttribute("list", "list");
                        continue;
                    }
                    M_log.warn((Object)(".toXml: in list not string: " + name));
                }
                continue;
            }
            M_log.warn((Object)(".toXml: not a string, not a value: " + name));
        }
        return properties;
    }

    public boolean isLazy() {
        return this.m_lazy;
    }

    public Iterator getPropertyNames() {
        if (this.m_props.size() == 0) {
            return new EmptyIterator();
        }
        return new EnumerationIterator(this.m_props.keys());
    }

    public String getProperty(String name) {
        Object value = this.m_props.get(name);
        if (value instanceof String) {
            return (String)value;
        }
        return null;
    }

    public Object get(String name) {
        return this.m_props.get(name);
    }

    public List getPropertyList(String name) {
        Object value = this.m_props.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            Vector rv = new Vector();
            rv.add(value);
            return rv;
        }
        if (value instanceof List) {
            Vector rv = new Vector();
            rv.addAll((List)value);
            return rv;
        }
        return null;
    }

    public boolean isLiveProperty(String name) {
        return name.equals("CHEF:creator") || name.equals("CHEF:modifiedby") || name.equals("DAV:creationdate") || name.equals("DAV:getcontentlength") || name.equals("DAV:getcontenttype") || name.equals("DAV:getlastmodified") || name.equals("CHEF:is-collection");
    }

    public String getPropertyFormatted(String name) {
        Object value = this.m_props.get(name);
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            try {
                if (name.equals("CHEF:creator") || name.equals("CHEF:modifiedby") || name.equals("CHEF:to")) {
                    return this.getUserProperty(name).getDisplayName();
                }
                if (name.equals("DAV:creationdate") || name.equals("DAV:getlastmodified")) {
                    return this.getTimeProperty(name).toStringLocalFull();
                }
                if (name.equals("DAV:getcontentlength")) {
                    long len = this.getLongProperty(name);
                    String[] byteString = new String[]{"KB", "KB", "MB", "GB"};
                    int count = 0;
                    long newLen = 0L;
                    long lenBytesExtra = len;
                    while (len > 1024L) {
                        newLen = len / 1024L;
                        lenBytesExtra = len - newLen * 1024L;
                        len = newLen;
                        ++count;
                    }
                    if (lenBytesExtra >= 512L || lenBytesExtra > 0L && newLen == 0L) {
                        ++newLen;
                    }
                    return Long.toString(newLen) + " " + byteString[count];
                }
                if (name.equals("DAV:getcontenttype")) {
                    return ContentTypeImageService.getContentTypeDisplayName((String)((String)value));
                }
            }
            catch (EntityPropertyNotDefinedException e) {
                return "";
            }
            catch (EntityPropertyTypeException e) {
                // empty catch block
            }
            return (String)value;
        }
        if (value instanceof List) {
            StringBuilder buf = new StringBuilder();
            Iterator i = ((List)value).iterator();
            while (i.hasNext()) {
                String val = (String)i.next();
                buf.append(val);
                if (!i.hasNext()) continue;
                buf.append(", ");
            }
            return buf.toString();
        }
        M_log.warn((Object)("getPropertyFormatted: value not string, not list: " + name));
        return "";
    }

    public boolean getBooleanProperty(String name) throws EntityPropertyNotDefinedException, EntityPropertyTypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EntityPropertyNotDefinedException();
        }
        try {
            return Boolean.valueOf(p);
        }
        catch (Exception any) {
            throw new EntityPropertyTypeException(name);
        }
    }

    public long getLongProperty(String name) throws EntityPropertyNotDefinedException, EntityPropertyTypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EntityPropertyNotDefinedException();
        }
        try {
            return Long.parseLong(p);
        }
        catch (Exception any) {
            throw new EntityPropertyTypeException(name);
        }
    }

    public Time getTimeProperty(String name) throws EntityPropertyNotDefinedException, EntityPropertyTypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EntityPropertyNotDefinedException();
        }
        try {
            return TimeService.newTimeGmt((String)p);
        }
        catch (Exception any) {
            throw new EntityPropertyTypeException(name);
        }
    }

    public User getUserProperty(String name) throws EntityPropertyNotDefinedException, EntityPropertyTypeException {
        String p = this.getProperty(name);
        if (p == null) {
            throw new EntityPropertyNotDefinedException();
        }
        try {
            return UserDirectoryService.getUser((String)p);
        }
        catch (Exception any) {
            throw new EntityPropertyTypeException(name);
        }
    }

    public String getNamePropCreator() {
        return "CHEF:creator";
    }

    public String getNamePropModifiedBy() {
        return "CHEF:modifiedby";
    }

    public String getNamePropCreationDate() {
        return "DAV:creationdate";
    }

    public String getNamePropDisplayName() {
        return "DAV:displayname";
    }

    public String getNamePropCopyrightChoice() {
        return "CHEF:copyrightchoice";
    }

    public String getNamePropCopyrightAlert() {
        return "CHEF:copyrightalert";
    }

    public String getNamePropCopyright() {
        return "CHEF:copyright";
    }

    public String getNamePropContentLength() {
        return "DAV:getcontentlength";
    }

    public String getNamePropContentType() {
        return "DAV:getcontenttype";
    }

    public String getNamePropModifiedDate() {
        return "DAV:getlastmodified";
    }

    public String getNamePropIsCollection() {
        return "CHEF:is-collection";
    }

    public String getNamePropCollectionBodyQuota() {
        return "CHEF:collection-body-quota";
    }

    public String getNamePropChatRoom() {
        return "CHEF:chat-room";
    }

    public String getNamePropTo() {
        return "CHEF:to";
    }

    public String getNamePropDescription() {
        return "CHEF:description";
    }

    public String getNamePropCalendarType() {
        return "CHEF:calendar-type";
    }

    public String getNamePropCalendarLocation() {
        return "CHEF:calendar-location";
    }

    public String getNamePropReplyStyle() {
        return "CHEF:discussion-reply-style";
    }

    public String getNamePropNewAssignmentCheckAddDueDate() {
        return "new_assignment_check_add_due_date";
    }

    public String getNamePropNewAssignmentCheckAutoAnnounce() {
        return "new_assignment_check_auto_announce";
    }

    public String getNamePropSubmissionPreviousGrades() {
        return "CHEF:submission_previous_grades";
    }

    public String getNamePropSubmissionScaledPreviousGrades() {
        return "CHEF:submission_scaled_previous_grades";
    }

    public String getNamePropSubmissionPreviousFeedbackText() {
        return "CHEF:submission_previous_feedback_text";
    }

    public String getNamePropSubmissionPreviousFeedbackComment() {
        return "CHEF:submission_previous_feedback_comment";
    }

    public String getNamePropAssignmentDeleted() {
        return "CHEF:assignment_deleted";
    }

    public String getTypeUrl() {
        return "text/url";
    }

    public String getNamePropStructObjType() {
        return "SAKAI:structobj_type";
    }

    public void setLazy(boolean lazy) {
        this.m_lazy = lazy;
    }

    public void addProperty(String name, String value) {
        if (value == null) {
            value = "";
        }
        this.m_props.put(name, value);
    }

    public void addPropertyToList(String name, String value) {
        Object current;
        if (value == null) {
            value = "";
        }
        if ((current = this.m_props.get(name)) == null) {
            Vector<String> values = new Vector<String>();
            this.m_props.put(name, values);
            values.add(value);
        } else if (current instanceof List) {
            ((List)current).add(value);
        } else {
            M_log.warn((Object)("addPropertyToList() value set not a list: " + name));
        }
    }

    public void addAll(ResourceProperties other) {
        Iterator iNames = other.getPropertyNames();
        while (iNames.hasNext()) {
            String name = (String)iNames.next();
            Object value = other.get(name);
            if (value == null) continue;
            if (value instanceof String) {
                this.m_props.put(name, value);
                continue;
            }
            if (!(value instanceof List)) continue;
            Vector list = new Vector();
            list.addAll((List)value);
            this.m_props.put(name, list);
        }
    }

    public void addAll(Properties props) {
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object value = props.get(name);
            if (value instanceof List) {
                Vector list = new Vector();
                list.addAll((List)value);
                this.m_props.put(name, list);
                continue;
            }
            this.m_props.put(name, value);
        }
    }

    public void clear() {
        this.m_props.clear();
    }

    public void removeProperty(String name) {
        this.m_props.remove(name);
    }

    public void set(ResourceProperties props) {
        this.clear();
        this.addAll(props);
    }

    public ContentHandler getContentHander() {
        return new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                if ("property".equals(qName)) {
                    String name = attributes.getValue("name");
                    String enc = StringUtils.trimToNull((String)attributes.getValue("enc"));
                    String value = null;
                    if ("BASE64".equalsIgnoreCase(enc)) {
                        String charset = StringUtils.trimToNull((String)attributes.getValue("charset"));
                        if (charset == null) {
                            charset = "UTF-8";
                        }
                        value = Xml.decode(charset, attributes.getValue("value"));
                    } else {
                        value = attributes.getValue("value");
                    }
                    if ("list".equals(attributes.getValue("list"))) {
                        Object current = BaseResourceProperties.this.m_props.get(name);
                        if (current == null) {
                            Vector<String> values = new Vector<String>();
                            BaseResourceProperties.this.m_props.put(name, values);
                            values.add(value);
                        } else if (current instanceof List) {
                            ((List)current).add(value);
                        } else {
                            M_log.warn((Object)("construct(el): value set not a list: " + name));
                        }
                    } else {
                        BaseResourceProperties.this.m_props.put(name, value);
                    }
                }
            }
        };
    }

    public Map<String, Object> getSerializableProperties() {
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.putAll(this.m_props);
        return m;
    }

    public void setSerializableProperties(Map<String, Object> properties) {
        this.m_props.clear();
        this.m_props.putAll(properties);
    }
}

