/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.i18n.InternationalizedMessages;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.user.api.PreferencesService;
import org.sakaiproject.util.DbResourceBundle;
import org.sakaiproject.util.DummyMap;

public class ResourceLoader
extends DummyMap
implements InternationalizedMessages {
    protected static final Log M_log = LogFactory.getLog(ResourceLoader.class);
    protected String baseName = null;
    protected ClassLoader classLoader = null;
    protected Hashtable<Locale, ResourceBundle> bundles = new Hashtable();
    protected Hashtable<Locale, Date> bundlesTimestamp = new Hashtable();
    protected String userId = null;
    protected String LOCALE_SESSION_KEY = "sakai.locale.";
    protected String DEBUG_LOCALE = "en_US_DEBUG";
    private String DBG_PREFIX = "** ";
    private String DBG_SUFFIX = " **";
    private static Object LOCK = new Object();
    private static SessionManager sessionManager;
    private static PreferencesService preferencesService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static SessionManager getSessionManager() {
        if (sessionManager == null) {
            Object object = LOCK;
            synchronized (object) {
                sessionManager = (SessionManager)ComponentManager.get(SessionManager.class);
            }
        }
        return sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PreferencesService getPreferencesService() {
        if (preferencesService == null) {
            Object object = LOCK;
            synchronized (object) {
                preferencesService = (PreferencesService)ComponentManager.get(PreferencesService.class);
            }
        }
        return preferencesService;
    }

    public ResourceLoader() {
    }

    public ResourceLoader(String name) {
        this.baseName = name;
    }

    public ResourceLoader(String name, ClassLoader classLoader) {
        this.baseName = name;
        this.classLoader = classLoader;
    }

    public ResourceLoader(String userId, String name) {
        this.userId = userId;
        this.baseName = name;
    }

    @Override
    public Set entrySet() {
        return this.getBundleAsMap().entrySet();
    }

    @Override
    public Object get(Object key) {
        return this.getString(key.toString());
    }

    public String getFormattedMessage(String key, Object[] args) {
        if (this.getLocale().toString().equals(this.DEBUG_LOCALE)) {
            return this.formatDebugPropertiesString(key);
        }
        String pattern = (String)this.get(key);
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("getFormattedMessage(key,args) bundle name=" + this.baseName + ", locale=" + this.getLocale().toString() + ", key=" + key + ", pattern=" + pattern));
        }
        return new MessageFormat(pattern, this.getLocale()).format(args, new StringBuffer(), (FieldPosition)null).toString();
    }

    public int getInt(String key, int dflt) {
        String value = this.getString(key);
        if (value.length() == 0) {
            return dflt;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return dflt;
        }
    }

    public Locale getLocale() {
        Locale loc = null;
        try {
            if (this.userId != null) {
                loc = this.getLocale(this.userId);
            } else {
                loc = (Locale)ResourceLoader.getSessionManager().getCurrentSession().getAttribute(this.LOCALE_SESSION_KEY + ResourceLoader.getSessionManager().getCurrentSessionUserId());
                if (loc == null) {
                    loc = this.setContextLocale(null);
                }
            }
        }
        catch (NullPointerException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)"getLocale() swallowing NPE");
                e.printStackTrace();
            }
            loc = this.setContextLocale(null);
        }
        if (loc == null) {
            M_log.info((Object)"getLocale() Locale not found in preferences or session, returning default");
            loc = Locale.getDefault();
        }
        return loc;
    }

    protected String formatDebugPropertiesString(String key) {
        StringBuilder dbgPropertiesString = new StringBuilder(this.DBG_PREFIX);
        dbgPropertiesString.append(this.baseName);
        dbgPropertiesString.append(" ");
        dbgPropertiesString.append(key);
        dbgPropertiesString.append(this.DBG_SUFFIX);
        return dbgPropertiesString.toString();
    }

    public Locale getLocale(String userId) {
        return ResourceLoader.getPreferencesService().getLocale(userId);
    }

    public Locale setContextLocale(Locale loc) {
        block16: {
            block15: {
                block14: {
                    if (loc == null) {
                        try {
                            loc = this.getLocale(ResourceLoader.getSessionManager().getCurrentSessionUserId());
                        }
                        catch (Exception e) {
                            if (!M_log.isWarnEnabled()) break block14;
                            M_log.warn((Object)"setContextLocale(Locale) swallowing Exception");
                            e.printStackTrace();
                        }
                    }
                }
                if (loc == null) {
                    try {
                        loc = (Locale)ResourceLoader.getSessionManager().getCurrentSession().getAttribute("locale");
                    }
                    catch (NullPointerException e) {
                        if (!M_log.isWarnEnabled()) break block15;
                        M_log.warn((Object)"setContextLocale(Locale) swallowing NPE");
                        e.printStackTrace();
                    }
                }
            }
            if (loc == null) {
                loc = Locale.getDefault();
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)"setContextLocale(Locale), default locale");
                }
            } else if (!Locale.getDefault().getLanguage().equals("en") && loc.getLanguage().equals("en") && !loc.toString().equals(this.DEBUG_LOCALE)) {
                loc = new Locale("");
                if (M_log.isDebugEnabled()) {
                    M_log.debug((Object)"setContextLocale(Locale), Tweak for English");
                }
            }
            try {
                String sessionUser = ResourceLoader.getSessionManager().getCurrentSessionUserId();
                if (sessionUser != null) {
                    ResourceLoader.getSessionManager().getCurrentSession().setAttribute(this.LOCALE_SESSION_KEY + sessionUser, (Object)loc);
                }
            }
            catch (Exception e) {
                if (!M_log.isWarnEnabled()) break block16;
                M_log.warn((Object)"setContextLocale(Locale) swallowing Exception");
                e.printStackTrace();
            }
        }
        return loc;
    }

    public boolean getIsValid(String key) {
        try {
            String value = this.getBundle().getString(key);
            return value != null;
        }
        catch (MissingResourceException e) {
            return false;
        }
    }

    public String getString(String key) {
        if (this.getLocale().toString().equals(this.DEBUG_LOCALE)) {
            return this.formatDebugPropertiesString(key);
        }
        try {
            String value = this.getBundle().getString(key);
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("getString(key) bundle name=" + this.baseName + ", locale=" + this.getLocale().toString() + ", key=" + key + ", value=" + value));
            }
            return value;
        }
        catch (MissingResourceException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("bundle '" + this.baseName + "'  missing key: '" + key + "'  from: " + e.getStackTrace()[3]));
            }
            return "[missing key (mre): " + this.baseName + " " + key + "]";
        }
        catch (NullPointerException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("bundle '" + this.baseName + "'  null pointer exception: '" + key + "'  from: " + e.getStackTrace()[3]));
            }
            return "[missing key (npe): " + this.baseName + " " + key + "]";
        }
        catch (ClassCastException e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("bundle '" + this.baseName + "'  class cast exception: '" + key + "'  from: " + e.getStackTrace()[3]));
            }
            return "[missing key (clc): " + this.baseName + " " + key + "]";
        }
    }

    public String getString(String key, String dflt) {
        if (this.getLocale().toString().equals(this.DEBUG_LOCALE)) {
            return this.formatDebugPropertiesString(key);
        }
        try {
            return this.getBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return dflt;
        }
        catch (NullPointerException e) {
            return dflt;
        }
        catch (ClassCastException e) {
            return dflt;
        }
    }

    public String[] getStrings(String key) {
        if (this.getLocale().toString().equals(this.DEBUG_LOCALE)) {
            return new String[]{this.formatDebugPropertiesString(key)};
        }
        int count = this.getInt(key + ".count", 0);
        if (count > 0) {
            String[] rv = new String[count];
            for (int i = 1; i <= count; ++i) {
                String value;
                block5: {
                    value = "";
                    try {
                        value = this.getBundle().getString(key + "." + i);
                    }
                    catch (MissingResourceException e) {
                        if (!M_log.isWarnEnabled()) break block5;
                        M_log.warn((Object)("getStrings(" + key + ") swallowing MissingResourceException for String " + i));
                        e.printStackTrace();
                    }
                }
                rv[i - 1] = value;
            }
            return rv;
        }
        return null;
    }

    @Override
    public Set keySet() {
        return this.getBundleAsMap().keySet();
    }

    public void purgeCache() {
        this.bundles = new Hashtable();
        M_log.debug((Object)"purge bundle cache");
    }

    public void setBaseName(String name) {
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("set baseName=" + name));
        }
        this.baseName = name;
    }

    @Override
    public Collection values() {
        return this.getBundleAsMap().values();
    }

    protected ResourceBundle getBundle() {
        if (ServerConfigurationService.getBoolean((String)"load.bundles.from.db", (boolean)false)) {
            return this.getBundleFromDb();
        }
        Locale loc = this.getLocale();
        ResourceBundle bundle = this.bundles.get(loc);
        if (bundle == null) {
            if (M_log.isDebugEnabled()) {
                M_log.debug((Object)("Load bundle name=" + this.baseName + ", locale=" + this.getLocale().toString()));
            }
            bundle = this.loadBundle(loc);
        }
        return bundle;
    }

    protected ResourceBundle getBundleFromDb() {
        Locale loc = this.getLocale();
        ResourceBundle bundle = this.bundles.get(loc);
        Date timeStamp = this.bundlesTimestamp.get(loc);
        if (timeStamp == null || timeStamp.getTime() + (long)ServerConfigurationService.getInt((String)"load.bundles.from.db.timeout", (int)30000) < new Date().getTime()) {
            M_log.debug((Object)("Load bundle name=" + this.baseName + ", locale=" + this.getLocale().toString()));
            bundle = this.loadBundle(loc);
        }
        return bundle;
    }

    protected Map<Object, Object> getBundleAsMap() {
        Hashtable<Object, Object> bundle = new Hashtable<Object, Object>();
        Enumeration<String> e = this.getBundle().getKeys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            bundle.put(key, this.getBundle().getObject(key));
        }
        return bundle;
    }

    protected ResourceBundle loadBundle(Locale loc) {
        if (ServerConfigurationService.getBoolean((String)"load.bundles.from.db", (boolean)false)) {
            return this.loadBundleFromDb(loc);
        }
        ResourceBundle newBundle = null;
        try {
            newBundle = this.classLoader == null ? ResourceBundle.getBundle(this.baseName, loc) : ResourceBundle.getBundle(this.baseName, loc, this.classLoader);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.setBundle(loc, newBundle);
        return newBundle;
    }

    protected ResourceBundle loadBundleFromDb(Locale loc) {
        ResourceBundle newBundle = null;
        try {
            newBundle = DbResourceBundle.addResourceBundle(this.baseName, loc, this.classLoader);
        }
        catch (Exception e) {
            if (M_log.isWarnEnabled()) {
                M_log.warn((Object)("loadBundle " + this.baseName + " " + loc.toString()), (Throwable)e);
            }
            throw new MissingResourceException("ResourceLoader.loadBundle failed", "", "");
        }
        DbResourceBundle.indexResourceBundle(this.baseName, newBundle, loc, this.classLoader);
        this.setBundle(loc, newBundle);
        return newBundle;
    }

    protected void setBundle(Locale loc, ResourceBundle bundle) {
        if (loc == null || bundle == null) {
            return;
        }
        this.bundles.put(loc, bundle);
        this.bundlesTimestamp.put(loc, new Date());
    }
}

