/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.user.api.UserNotificationPreferencesRegistration;
import org.sakaiproject.user.api.UserNotificationPreferencesRegistrationService;
import org.sakaiproject.util.ResourceLoader;

public abstract class UserNotificationPreferencesRegistrationImpl
implements UserNotificationPreferencesRegistration {
    private UserNotificationPreferencesRegistrationService userNotificationPreferencesRegistrationService;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String sectionTitle = "";
    private String sectionDescription = "";
    private String sectionTitleBundleKey = "";
    private String sectionDescriptionBundleKey = "";
    private String overrideSectionTitleBundleKey = "";
    private String sectionTitleOverride = "";
    private String defaultValue = "0";
    private String prefix = "";
    private String type = "";
    private String toolId = "";
    private Map<String, String> rawOptions = new HashMap<String, String>();
    private Map<String, String> options = new HashMap<String, String>();
    private boolean overrideBySite = false;
    private boolean expandByDefault = true;
    private String bundleLocation = "";
    private ResourceLoader rl = null;

    public UserNotificationPreferencesRegistrationImpl() {
    }

    public UserNotificationPreferencesRegistrationImpl(String sectionTitle, String sectionDescription, String sectionTitleOverride, String defaultValue, String prefix, String type, String toolId, Map<String, String> options, boolean overrideBySite, boolean expandByDefault) {
        this.sectionTitle = sectionTitle;
        this.sectionDescription = sectionDescription;
        this.sectionTitleOverride = sectionTitleOverride;
        this.defaultValue = defaultValue;
        this.prefix = prefix;
        this.type = type;
        this.options = options;
        this.overrideBySite = overrideBySite;
        this.expandByDefault = expandByDefault;
        this.toolId = toolId;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public Map<String, String> getRawOptions() {
        return this.rawOptions;
    }

    public void setRawOptions(Map<String, String> rawOptions) {
        this.rawOptions = rawOptions;
    }

    public void setSectionTitle(String sectionTitle) {
        this.sectionTitle = sectionTitle;
    }

    public String getSectionTitle() {
        return this.sectionTitle;
    }

    public void setSectionDescription(String sectionDescription) {
        this.sectionDescription = sectionDescription;
    }

    public String getSectionDescription() {
        return this.sectionDescription;
    }

    public String getSectionTitleOverride() {
        return this.sectionTitleOverride;
    }

    public void setSectionTitleOverride(String sectionTitleOverride) {
        this.sectionTitleOverride = sectionTitleOverride;
    }

    public boolean isOverrideBySite() {
        return this.overrideBySite;
    }

    public void setOverrideBySite(boolean overrideBySite) {
        this.overrideBySite = overrideBySite;
    }

    public boolean isExpandByDefault() {
        return this.expandByDefault;
    }

    public void setExpandByDefault(boolean expandByDefault) {
        this.expandByDefault = expandByDefault;
    }

    public void setSectionTitleBundleKey(String sectionTitleBundleKey) {
        this.sectionTitleBundleKey = sectionTitleBundleKey;
    }

    public String getSectionTitleBundleKey() {
        return this.sectionTitleBundleKey;
    }

    public void setSectionDescriptionBundleKey(String sectionDescriptionBundleKey) {
        this.sectionDescriptionBundleKey = sectionDescriptionBundleKey;
    }

    public String getSectionDescriptionBundleKey() {
        return this.sectionDescriptionBundleKey;
    }

    public void setOverrideSectionTitleBundleKey(String overrideSectionTitleBundleKey) {
        this.overrideSectionTitleBundleKey = overrideSectionTitleBundleKey;
    }

    public String getOverrideSectionTitleBundleKey() {
        return this.overrideSectionTitleBundleKey;
    }

    public void setBundleLocation(String bundleLocation) {
        this.bundleLocation = bundleLocation;
    }

    public String getBundleLocation() {
        return this.bundleLocation;
    }

    public void setToolId(String toolId) {
        this.toolId = toolId;
    }

    public String getToolId() {
        return this.toolId;
    }

    private ResourceLoader getLocalResourceLoader() {
        if (this.rl == null) {
            this.rl = (ResourceLoader)this.getResourceLoader(this.getBundleLocation());
        }
        return this.rl;
    }

    private Map<String, String> processOptionsMap(Map<String, String> optionsMap) {
        HashMap<String, String> processedOptions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : optionsMap.entrySet()) {
            ResourceLoader loader = this.getLocalResourceLoader();
            if (loader == null) continue;
            String value = loader.getString(entry.getValue());
            processedOptions.put(entry.getKey(), value);
        }
        return processedOptions;
    }

    public void init() {
        this.logger.info((Object)"UserPreferencesRegistrationImpl.init()");
        Map<String, String> processedOptions = this.processOptionsMap(this.getRawOptions());
        ResourceLoader loader = this.getLocalResourceLoader();
        if (loader != null) {
            this.sectionTitle = loader.getString(this.getSectionTitleBundleKey());
            this.sectionDescription = loader.getString(this.getSectionDescriptionBundleKey());
            this.sectionTitleOverride = loader.getString(this.getOverrideSectionTitleBundleKey());
        }
        this.options = processedOptions;
        this.getUserNotificationPreferencesRegistrationService().register((UserNotificationPreferencesRegistration)this);
    }

    public void setUserNotificationPreferencesRegistrationService(UserNotificationPreferencesRegistrationService userNotificationPreferencesRegistrationService) {
        this.userNotificationPreferencesRegistrationService = userNotificationPreferencesRegistrationService;
    }

    public UserNotificationPreferencesRegistrationService getUserNotificationPreferencesRegistrationService() {
        return this.userNotificationPreferencesRegistrationService;
    }
}

