/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.archive.api.ArchiveService;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzPermissionException;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.cover.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.cover.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserAlreadyDefinedException;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserIdInvalidException;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.sakaiproject.user.api.UserPermissionException;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.sakaiproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasicArchiveService
implements ArchiveService {
    private static Log M_log = LogFactory.getLog(BasicArchiveService.class);
    protected String m_storagePath = "/";
    protected static final HashMap userIdTrans = new HashMap();
    protected HashSet usersListAllowImport = new HashSet();
    public String[] SAKAI_roles = new String[]{"Affiliate", "Assistant", "Instructor", "Maintain", "Organizer", "Owner"};
    public String[] CT_roles = new String[]{"Affiliate", "Assistant", "Instructor", "Maintain", "Organizer", "Owner"};
    public String[] WT_roles = new String[0];
    private String old_toolId_prefix = "chef.";
    private String new_toolId_prefix = "sakai.";
    private String[] old_toolIds = new String[]{"sakai.noti.prefs", "sakai.presence", "sakai.siteinfogeneric", "sakai.sitesetupgeneric", "sakai.threadeddiscussion"};
    private String[] new_toolIds = new String[]{"sakai.preferences", "sakai.online", "sakai.siteinfo", "sakai.sitesetup", "sakai.discussion"};
    public String[] sakaiServicesToImport = new String[]{"AnnouncementService", "AssignmentService", "ContentHostingService", "CalendarService", "DiscussionService", "MailArchiveService", "SyllabusService", "RWikiObjectService", "DiscussionForumService", "WebService"};
    public String[] CT_tools_toImport = new String[0];
    public String[] WT_tools_toImport = new String[0];
    public HashMap tool_draft_flag = new HashMap();
    protected ServerConfigurationService m_serverConfigurationService = null;
    protected EntityManager m_entityManager = null;
    private ContentHostingService contentHostingService;

    public void setServerConfigurationService(ServerConfigurationService service) {
        this.m_serverConfigurationService = service;
    }

    public void setStoragePath(String path) {
        this.m_storagePath = path;
    }

    public void setEntityManager(EntityManager service) {
        this.m_entityManager = service;
    }

    public void init() {
        this.contentHostingService = (ContentHostingService)ComponentManager.get((String)ContentHostingService.class.getName());
        if (this.m_storagePath != null && !this.m_storagePath.endsWith("/")) {
            this.m_storagePath = this.m_storagePath + "/";
        }
        M_log.info((Object)("init(): storage path: " + this.m_storagePath));
    }

    public void destroy() {
        M_log.info((Object)"destroy()");
    }

    public String archive(String siteId) {
        String msg;
        Element root;
        Stack<Element> stack;
        Document doc;
        StringBuilder results = new StringBuilder();
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("archive(): site: " + siteId));
        }
        Site theSite = null;
        try {
            theSite = SiteService.getSite((String)siteId);
        }
        catch (IdUnusedException e) {
            results.append("Site: " + siteId + " not found.\n");
            M_log.warn((Object)("archive(): site not found: " + siteId));
            return results.toString();
        }
        List attachments = this.m_entityManager.newReferenceList();
        Time now = TimeService.newTime();
        String storagePath = this.m_storagePath + siteId + "-archive/";
        File dir = new File(this.m_storagePath + siteId + "-archive/");
        dir.mkdirs();
        List services = this.m_entityManager.getEntityProducers();
        for (EntityProducer service : services) {
            if (service == null || !service.willArchiveMerge()) continue;
            Document doc2 = Xml.createDocument();
            Stack<Element> stack2 = new Stack<Element>();
            Element root2 = doc2.createElement("archive");
            doc2.appendChild(root2);
            root2.setAttribute("source", siteId);
            root2.setAttribute("server", this.m_serverConfigurationService.getServerId());
            root2.setAttribute("date", now.toString());
            root2.setAttribute("system", "Sakai 2.8");
            stack2.push(root2);
            try {
                String msg2 = service.archive(siteId, doc2, stack2, storagePath, attachments);
                results.append(msg2);
            }
            catch (Throwable t) {
                results.append(t.toString() + "\n");
            }
            stack2.pop();
            String fileName = storagePath + service.getLabel() + ".xml";
            Xml.writeDocument((Document)doc2, (String)fileName);
        }
        if (attachments.size() > 0) {
            doc = Xml.createDocument();
            stack = new Stack<Element>();
            root = doc.createElement("archive");
            doc.appendChild(root);
            root.setAttribute("source", siteId);
            root.setAttribute("server", this.m_serverConfigurationService.getServerId());
            root.setAttribute("date", now.toString());
            root.setAttribute("system", "Sakai 2.8");
            stack.push(root);
            msg = this.contentHostingService.archiveResources(attachments, doc, stack, storagePath);
            results.append(msg);
            stack.pop();
            String fileName = storagePath + "attachment.xml";
            Xml.writeDocument((Document)doc, (String)fileName);
        }
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", siteId);
        root.setAttribute("date", now.toString());
        root.setAttribute("system", "Sakai 2.8");
        stack.push(root);
        msg = BasicArchiveService.archiveSite(theSite, doc, stack);
        results.append(msg);
        stack.pop();
        Xml.writeDocument((Document)doc, (String)(this.m_storagePath + siteId + "-archive/site.xml"));
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", siteId);
        root.setAttribute("date", now.toString());
        root.setAttribute("system", "Sakai 2.8");
        stack.push(root);
        msg = BasicArchiveService.archiveUsers(theSite, doc, stack);
        results.append(msg);
        stack.pop();
        Xml.writeDocument((Document)doc, (String)(this.m_storagePath + siteId + "-archive/user.xml"));
        return results.toString();
    }

    protected static String archiveSite(Site site, Document doc, Stack stack) {
        Element element = doc.createElement(SiteService.APPLICATION_ID);
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        Element siteNode = site.toXml(doc, stack);
        stack.push(siteNode);
        Vector roles = new Vector();
        String realmId = "/site/" + site.getId();
        try {
            Role role = null;
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)realmId);
            Element realmNode = doc.createElement("roles");
            ((Element)stack.peek()).appendChild(realmNode);
            stack.push(realmNode);
            roles.addAll(realm.getRoles());
            for (int i = 0; i < roles.size(); ++i) {
                role = (Role)roles.get(i);
                String roleId = role.getId();
                Element node = doc.createElement(roleId);
                realmNode.appendChild(node);
                Vector users = new Vector();
                users.addAll(realm.getUsersHasRole(role.getId()));
                for (int j = 0; j < users.size(); ++j) {
                    Element abilityNode = doc.createElement("ability");
                    abilityNode.setAttribute("roleId", roleId);
                    abilityNode.setAttribute("userId", (String)users.get(j));
                    node.appendChild(abilityNode);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stack.pop();
        return "archiving Site: " + site.getId() + "\n";
    }

    protected static String archiveUsers(Site site, Document doc, Stack stack) {
        Element element = doc.createElement(UserDirectoryService.APPLICATION_ID);
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        try {
            Vector users = new Vector();
            String realmId = "/site/" + site.getId();
            try {
                AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)realmId);
                users.addAll(UserDirectoryService.getUsers((Collection)realm.getUsers()));
                Collections.sort(users);
                for (int i = 0; i < users.size(); ++i) {
                    User user = (User)users.get(i);
                    user.toXml(doc, stack);
                }
            }
            catch (GroupNotDefinedException groupNotDefinedException) {
            }
            catch (Exception exception) {
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        stack.pop();
        return "archiving the users for Site: " + site.getId() + "\n";
    }

    public String merge(String fileName, String siteId, String creatorId) {
        int i;
        StringBuilder results = new StringBuilder();
        File[] files = null;
        File file = new File(this.m_storagePath + fileName);
        if (file == null || !file.exists()) {
            results.append("file: " + file.getPath() + " not found.\n");
            M_log.warn((Object)("merge(): file not found: " + file.getPath()));
            return results.toString();
        }
        files = file.isDirectory() ? file.listFiles() : new File[]{file};
        HashMap attachmentNames = new HashMap();
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].getPath().indexOf("user.xml") == -1) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, null);
            files[i] = null;
            break;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].getPath().indexOf("site.xml") == -1) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, creatorId);
            files[i] = null;
            break;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].getPath().indexOf("attachment.xml") == -1) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, null);
            files[i] = null;
            break;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || !files[i].getPath().endsWith(".xml")) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, null);
        }
        return results.toString();
    }

    public boolean checkSakaiRole(String siteId, String userId) {
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)siteId);
            Role role = realm.getRole(userId);
            for (int i = 0; i < this.SAKAI_roles.length; ++i) {
                if (!this.SAKAI_roles[i].equalsIgnoreCase(role.getId())) continue;
                return true;
            }
        }
        catch (GroupNotDefinedException groupNotDefinedException) {
            // empty catch block
        }
        return false;
    }

    protected boolean checkSystemRole(String system, String roleId) {
        block3: {
            block2: {
                if (!system.equalsIgnoreCase("CT")) break block2;
                for (int i = 0; i < this.CT_roles.length; ++i) {
                    if (!this.CT_roles[i].equalsIgnoreCase(roleId)) continue;
                    return true;
                }
                break block3;
            }
            if (!system.equalsIgnoreCase("Sakai 1.0") && !system.equalsIgnoreCase("Sakai 2.8")) break block3;
            for (int i = 0; i < this.SAKAI_roles.length; ++i) {
                if (!this.SAKAI_roles[i].equalsIgnoreCase(roleId)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkSakaiService(String serviceName) {
        for (int i = 0; i < this.sakaiServicesToImport.length; ++i) {
            if (!serviceName.endsWith(this.sakaiServicesToImport[i])) continue;
            return true;
        }
        return false;
    }

    protected void processMerge(String fileName, String siteId, StringBuilder results, Map attachmentNames, String creatorId) {
        fileName = fileName.replace('\\', '/');
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("merge(): processing file: " + fileName));
        }
        Site theSite = null;
        try {
            theSite = SiteService.getSite((String)siteId);
        }
        catch (IdUnusedException idUnusedException) {
            // empty catch block
        }
        Document doc = Xml.readDocument((String)fileName);
        if (doc == null) {
            results.append("Error reading xml from: " + fileName + "\n");
            return;
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("archive")) {
            results.append("File: " + fileName + " does not contain archive xml.  Found this root tag: " + root.getTagName() + "\n");
            return;
        }
        String fromSite = root.getAttribute("source");
        String system = root.getAttribute("system");
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            if (element.getTagName().equals(SiteService.APPLICATION_ID)) {
                if (system.equalsIgnoreCase("WT")) {
                    this.mergeSite(siteId, fromSite, element, userIdTrans, creatorId);
                    continue;
                }
                this.mergeSite(siteId, fromSite, element, new HashMap(), creatorId);
                continue;
            }
            if (element.getTagName().equals(UserDirectoryService.APPLICATION_ID)) {
                try {
                    if (!system.equalsIgnoreCase("WT")) continue;
                    String msg = this.mergeUsers(element, userIdTrans);
                    results.append(msg);
                }
                catch (Exception msg) {}
                continue;
            }
            if (theSite == null) {
                results.append("Site: " + siteId + " not found.\n");
                return;
            }
            String serviceName = this.translateServiceName(element.getTagName());
            try {
                EntityProducer service = (EntityProducer)ComponentManager.get((String)serviceName);
                try {
                    String msg = "";
                    if (system.equalsIgnoreCase("WT")) {
                        msg = service.merge(siteId, element, fileName, fromSite, attachmentNames, (Map)userIdTrans, new HashSet());
                    } else if ((system.equalsIgnoreCase("Sakai 1.0") || system.equalsIgnoreCase("Sakai 2.8")) && this.checkSakaiService(serviceName)) {
                        msg = service.merge(siteId, element, fileName, fromSite, attachmentNames, new HashMap(), (Set)this.usersListAllowImport);
                    } else if (system.equalsIgnoreCase("CT")) {
                        msg = service.merge(siteId, element, fileName, fromSite, attachmentNames, new HashMap(), (Set)this.usersListAllowImport);
                    }
                    results.append(msg);
                }
                catch (Throwable t) {
                    results.append("Error merging: " + serviceName + " in file: " + fileName + " : " + t.toString() + "\n");
                }
                continue;
            }
            catch (Throwable t) {
                results.append("Did not recognize the resource service: " + serviceName + " in file: " + fileName + "\n");
            }
        }
    }

    protected void unlock(String lock, String reference) throws PermissionException {
        if (!SecurityService.unlock((String)lock, (String)reference)) {
            // empty if block
        }
    }

    protected void mergeSiteInfo(Element el, String siteId) throws IdInvalidException, IdUsedException, PermissionException, IdUnusedException, InUseException {
        this.unlock(SiteService.SECURE_UPDATE_SITE, SiteService.siteReference((String)siteId));
        Site edit = SiteService.getSite((String)siteId);
        String desc = el.getAttribute("description-enc");
        try {
            byte[] decoded;
            byte[] filteredDecoded = decoded = Base64.decodeBase64((byte[])desc.getBytes("UTF-8"));
            for (int i = 0; i < decoded.length; ++i) {
                byte b = decoded[i];
                if (b == -109 || b == -108) {
                    filteredDecoded[i] = 34;
                    continue;
                }
                if (b == -111 || b == -110) {
                    filteredDecoded[i] = 39;
                    continue;
                }
                if (b != -106) continue;
                filteredDecoded[i] = 45;
            }
            desc = new String(decoded, "UTF-8");
        }
        catch (Exception any) {
            M_log.warn((Object)"mergeSiteInfo(): exception caught");
        }
        edit.setDescription(desc);
        SiteService.save((Site)edit);
    }

    protected void mergeSiteRoles(Element el, String siteId, HashMap useIdTrans) throws PermissionException {
        this.unlock(SiteService.SECURE_UPDATE_SITE, SiteService.siteReference((String)siteId));
        String source = "";
        Node parent0 = el.getParentNode();
        Node parent1 = parent0.getParentNode();
        Node parent = parent1.getParentNode();
        if (parent.getNodeType() == 1) {
            Element parentEl = (Element)parent;
            source = parentEl.getAttribute("system");
        }
        Vector roles = new Vector();
        String realmId = "/site/" + siteId;
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)realmId);
            roles.addAll(realm.getRoles());
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                String userId;
                Element element3;
                Node child2;
                int i2;
                int length2;
                NodeList children2;
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                Element element2 = (Element)child;
                if (source.equalsIgnoreCase("WT")) {
                    children2 = element2.getChildNodes();
                    length2 = children2.getLength();
                    for (i2 = 0; i2 < length2; ++i2) {
                        String newId;
                        child2 = children2.item(i2);
                        if (child2.getNodeType() != 1 || !(element3 = (Element)child2).getTagName().equals("ability")) continue;
                        userId = element3.getAttribute("userId");
                        if (!userIdTrans.isEmpty() && (newId = (String)useIdTrans.get(userId)) != null) {
                            userId = newId;
                        }
                        try {
                            User user = UserDirectoryService.getUser((String)userId);
                            String roleId = element3.getAttribute("roleId");
                            Role role = realm.getRole(roleId);
                            if (role == null) continue;
                            AuthzGroup realmEdit = AuthzGroupService.getAuthzGroup((String)realmId);
                            realmEdit.addMember(user.getId(), role.getId(), true, false);
                            AuthzGroupService.save((AuthzGroup)realmEdit);
                            continue;
                        }
                        catch (UserNotDefinedException e) {
                            M_log.warn((Object)("UserNotDefined in mergeSiteRoles: " + userId));
                            continue;
                        }
                        catch (AuthzPermissionException e) {
                            M_log.warn((Object)"AuthzPermissionException in mergeSiteRoles", (Throwable)e);
                        }
                    }
                    continue;
                }
                if (!this.checkSystemRole(source, element2.getTagName())) continue;
                children2 = element2.getChildNodes();
                length2 = children2.getLength();
                for (i2 = 0; i2 < length2; ++i2) {
                    child2 = children2.item(i2);
                    if (child2.getNodeType() != 1 || !(element3 = (Element)child2).getTagName().equals("ability")) continue;
                    userId = element3.getAttribute("userId");
                    this.usersListAllowImport.add(userId);
                }
            }
        }
        catch (GroupNotDefinedException err) {
            M_log.warn((Object)("()mergeSiteRoles realm edit exception caught GroupNotDefinedException " + realmId));
        }
    }

    protected String mergeUsers(Element element, HashMap useIdTrans) throws IdInvalidException, IdUsedException, PermissionException {
        String msg = "";
        int count = 0;
        boolean fromWT = false;
        boolean fromCTclassic = false;
        boolean fromCTools = false;
        String source = "";
        Node parent = element.getParentNode();
        if (parent.getNodeType() == 1) {
            Element parentEl = (Element)parent;
            source = parentEl.getAttribute("system");
        }
        if (source != null) {
            if (source.equalsIgnoreCase("CT")) {
                fromCTclassic = true;
            } else if (source.equalsIgnoreCase("WT")) {
                fromWT = true;
            } else {
                fromCTools = true;
            }
        } else {
            fromCTools = true;
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Object userId;
            Element element2;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(element2 = (Element)child).getTagName().equals("user") || !fromWT) continue;
            String wtId = element2.getAttribute("id");
            if (wtId.endsWith("umich.edu")) {
                userId = wtId.substring(0, wtId.indexOf("@"));
                element2.setAttribute("id", (String)userId);
                useIdTrans.put(wtId, userId);
                try {
                    User user = UserDirectoryService.getUser((String)userId);
                }
                catch (UserNotDefinedException e) {
                    try {
                        UserEdit userEdit = UserDirectoryService.mergeUser((Element)element2);
                        UserDirectoryService.commitEdit((UserEdit)userEdit);
                        ++count;
                        msg = msg.concat("The user id " + (String)userId + "(" + wtId + ") doesn't exist, and was just created. \n");
                    }
                    catch (UserIdInvalidException error) {
                        msg = msg.concat("This user with id -" + wtId + ", can't be merged because of the invalid email address.\n");
                    }
                    catch (UserAlreadyDefinedException userAlreadyDefinedException) {
                    }
                    catch (UserPermissionException userPermissionException) {}
                }
                continue;
            }
            try {
                userId = UserDirectoryService.getUser((String)wtId);
                continue;
            }
            catch (UserNotDefinedException e) {
                try {
                    UserEdit userEdit = UserDirectoryService.mergeUser((Element)element2);
                    UserDirectoryService.commitEdit((UserEdit)userEdit);
                    ++count;
                    continue;
                }
                catch (UserIdInvalidException error) {
                    msg = msg.concat("This user with id -" + wtId + ", can't be merged because of the invalid email address.\n");
                    continue;
                }
                catch (UserAlreadyDefinedException userAlreadyDefinedException) {
                    continue;
                }
                catch (UserPermissionException userPermissionException) {
                    // empty catch block
                }
            }
        }
        msg = msg + "merging user" + "(" + count + ") users\n";
        return msg;
    }

    protected void mergeSite(String siteId, String fromSiteId, Element element, HashMap useIdTrans, String creatorId) {
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element element2;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(element2 = (Element)child).getTagName().equals("site")) continue;
            NodeList toolChildren = element2.getElementsByTagName("tool");
            int tLength = toolChildren.getLength();
            for (int i2 = 0; i2 < tLength; ++i2) {
                Element element3 = (Element)toolChildren.item(i2);
                String toolId = element3.getAttribute("toolId");
                if (toolId != null) {
                    toolId = toolId.replaceAll(this.old_toolId_prefix, this.new_toolId_prefix);
                    for (int j = 0; j < this.old_toolIds.length; ++j) {
                        toolId = toolId.replaceAll(this.old_toolIds[i], this.new_toolIds[i]);
                    }
                }
                element3.setAttribute("toolId", toolId);
            }
            try {
                SiteService.merge((String)siteId, (Element)element2, (String)creatorId);
                this.mergeSiteInfo(element2, siteId);
            }
            catch (Exception i2) {
                // empty catch block
            }
            Site site = null;
            try {
                site = SiteService.getSite((String)siteId);
            }
            catch (IdUnusedException e) {
                M_log.warn((Object)(this + "The site with id " + siteId + " doesn't exit"));
                return;
            }
            if (site == null) continue;
            NodeList children2 = element2.getChildNodes();
            int length2 = children2.getLength();
            for (int i2 = 0; i2 < length2; ++i2) {
                Element element3;
                Node child2 = children2.item(i2);
                if (child2.getNodeType() != 1 || !(element3 = (Element)child2).getTagName().equals("roles")) continue;
                try {
                    this.mergeSiteRoles(element3, siteId, useIdTrans);
                    continue;
                }
                catch (PermissionException permissionException) {
                    // empty catch block
                }
            }
        }
    }

    protected String translateServiceName(String name) {
        if ("org.chefproject.service.GenericContentHostingService".equals(name)) {
            return ContentHostingService.class.getName();
        }
        return name;
    }
}

