/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.archive.api.ArchiveService;
import org.sakaiproject.archive.impl.SiteArchiver;
import org.sakaiproject.archive.impl.SiteMerger;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.EntityManager;

public class ArchiveService2Impl
implements ArchiveService {
    private static Log M_log = LogFactory.getLog(ArchiveService2Impl.class);
    protected ServerConfigurationService m_serverConfigurationService = null;
    protected EntityManager m_entityManager = null;
    protected SiteArchiver m_siteArchiver = null;
    protected SiteMerger m_siteMerger = null;
    protected String m_storagePath = "/";
    protected boolean m_filterSakaiServices = false;
    protected boolean m_filterSakaiRoles = false;
    protected String[] m_filteredSakaiServices = null;
    protected String[] m_filteredSakaiRoles = null;

    public void setServerConfigurationService(ServerConfigurationService service) {
        this.m_serverConfigurationService = service;
    }

    public void setEntityManager(EntityManager service) {
        this.m_entityManager = service;
    }

    public void setSiteArchiver(SiteArchiver siteArchiver) {
        this.m_siteArchiver = siteArchiver;
    }

    public void setSiteMerger(SiteMerger siteMerger) {
        this.m_siteMerger = siteMerger;
    }

    public void setStoragePath(String path) {
        this.m_storagePath = path;
    }

    public void setMergeFilterSakaiServices(boolean filter) {
        this.m_filterSakaiServices = filter;
    }

    public void setMergeFilterSakaiRoles(boolean filter) {
        this.m_filterSakaiRoles = filter;
    }

    public void setMergeFilteredSakaiServices(String[] filtered) {
        this.m_filteredSakaiServices = filtered;
    }

    public void setMergeFilteredSakaiRoles(String[] filtered) {
        this.m_filteredSakaiRoles = filtered;
    }

    public void init() {
        if (this.m_storagePath != null && !this.m_storagePath.endsWith("/")) {
            this.m_storagePath = this.m_storagePath + "/";
        }
        M_log.info((Object)("init(): storage path: " + this.m_storagePath));
    }

    public void destroy() {
        M_log.info((Object)"destroy()");
    }

    public String archive(String siteId) {
        return this.m_siteArchiver.archive(siteId, this.m_storagePath, "Sakai 2.8");
    }

    public String merge(String fileName, String siteId, String creatorId) {
        return this.m_siteMerger.merge(fileName, siteId, creatorId, this.m_storagePath, this.m_filterSakaiServices, this.m_filteredSakaiServices, this.m_filterSakaiRoles, this.m_filteredSakaiRoles);
    }
}

