/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.cover.ComponentManager;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SiteMerger {
    private static Log M_log = LogFactory.getLog(SiteMerger.class);
    protected static HashMap userIdTrans = new HashMap();
    protected AuthzGroupService m_authzGroupService = null;
    protected UserDirectoryService m_userDirectoryService = null;
    protected SiteService m_siteService = null;
    protected SecurityService m_securityService = null;
    protected EntityManager m_entityManager = null;
    private String old_toolId_prefix = "chef.";
    private String new_toolId_prefix = "sakai.";
    private String[] old_toolIds = new String[]{"sakai.noti.prefs", "sakai.presence", "sakai.siteinfogeneric", "sakai.sitesetupgeneric", "sakai.threadeddiscussion"};
    private String[] new_toolIds = new String[]{"sakai.preferences", "sakai.online", "sakai.siteinfo", "sakai.sitesetup", "sakai.discussion"};
    protected HashSet<String> usersListAllowImport = new HashSet();

    public void setAuthzGroupService(AuthzGroupService service) {
        this.m_authzGroupService = service;
    }

    public void setUserDirectoryService(UserDirectoryService service) {
        this.m_userDirectoryService = service;
    }

    public void setSiteService(SiteService service) {
        this.m_siteService = service;
    }

    public void setSecurityService(SecurityService service) {
        this.m_securityService = service;
    }

    public void setEntityManager(EntityManager m_entityManager) {
        this.m_entityManager = m_entityManager;
    }

    public String merge(String fileName, String siteId, String creatorId, String m_storagePath, boolean filterSakaiServices, String[] filteredSakaiServices, boolean filterSakaiRoles, String[] filteredSakaiRoles) {
        int i;
        StringBuilder results = new StringBuilder();
        File[] files = null;
        File file = new File(m_storagePath + fileName);
        if (file == null || !file.exists()) {
            results.append("file: " + file.getPath() + " not found.\n");
            M_log.warn((Object)("merge(): file not found: " + file.getPath()));
            return results.toString();
        }
        files = file.isDirectory() ? file.listFiles() : new File[]{file};
        HashMap attachmentNames = new HashMap();
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].getPath().indexOf("user.xml") == -1) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, null, filterSakaiServices, filteredSakaiServices, filterSakaiRoles, filteredSakaiRoles);
            files[i] = null;
            break;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].getPath().indexOf("site.xml") == -1) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, creatorId, filterSakaiServices, filteredSakaiServices, filterSakaiRoles, filteredSakaiRoles);
            files[i] = null;
            break;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || files[i].getPath().indexOf("attachment.xml") == -1) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, null, filterSakaiServices, filteredSakaiServices, filterSakaiRoles, filteredSakaiRoles);
            files[i] = null;
            break;
        }
        for (i = 0; i < files.length; ++i) {
            if (files[i] == null || !files[i].getPath().endsWith(".xml")) continue;
            this.processMerge(files[i].getPath(), siteId, results, attachmentNames, null, filterSakaiServices, filteredSakaiServices, filterSakaiRoles, filteredSakaiRoles);
        }
        return results.toString();
    }

    protected void processMerge(String fileName, String siteId, StringBuilder results, Map attachmentNames, String creatorId, boolean filterSakaiService, String[] filteredSakaiService, boolean filterSakaiRoles, String[] filteredSakaiRoles) {
        fileName = fileName.replace('\\', '/');
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("merge(): processing file: " + fileName));
        }
        Site theSite = null;
        try {
            theSite = this.m_siteService.getSite(siteId);
        }
        catch (IdUnusedException ignore) {
            M_log.warn((Object)ignore, (Throwable)ignore);
        }
        Document doc = Xml.readDocument((String)fileName);
        if (doc == null) {
            results.append("Error reading xml from: " + fileName + "\n");
            return;
        }
        Element root = doc.getDocumentElement();
        if (!root.getTagName().equals("archive")) {
            results.append("File: " + fileName + " does not contain archive xml.  Found this root tag: " + root.getTagName() + "\n");
            return;
        }
        String fromSite = root.getAttribute("source");
        String system = root.getAttribute("system");
        NodeList children = root.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            if (element.getTagName().equals("sakai:site")) {
                this.mergeSite(siteId, fromSite, element, new HashMap(), creatorId, filterSakaiRoles, filteredSakaiRoles);
                continue;
            }
            if (element.getTagName().equals("sakai:user")) continue;
            if (theSite == null) {
                results.append("Site: " + siteId + " not found.\n");
                return;
            }
            String serviceName = this.translateServiceName(element.getTagName());
            try {
                EntityProducer service = (EntityProducer)ComponentManager.get((String)serviceName);
                if (service == null) {
                    List entityProducers = this.m_entityManager.getEntityProducers();
                    for (EntityProducer entityProducer : entityProducers) {
                        if (!serviceName.equals(entityProducer.getClass().getName()) && !serviceName.equals(entityProducer.getLabel())) continue;
                        service = entityProducer;
                        break;
                    }
                }
                try {
                    String msg = "";
                    if (service != null) {
                        if (system.equalsIgnoreCase("Sakai 1.0") || system.equalsIgnoreCase("Sakai 2.8")) {
                            if (this.checkSakaiService(filterSakaiService, filteredSakaiService, serviceName)) {
                                if (M_log.isDebugEnabled()) {
                                    M_log.debug((Object)("Merging archive data for " + serviceName + " (" + fileName + ") to site " + siteId));
                                }
                                msg = service.merge(siteId, element, fileName, fromSite, attachmentNames, new HashMap(), this.usersListAllowImport);
                            } else {
                                M_log.warn((Object)("Skipping merge archive data for " + serviceName + " (" + fileName + ") to site " + siteId + ", checked filter failed (filtersOn=" + filterSakaiService + ", filters=" + Arrays.toString(filteredSakaiService) + ")"));
                            }
                        } else {
                            M_log.warn((Object)("Skipping archive data for for " + serviceName + " (" + fileName + ") to site " + siteId + ", this does not appear to be a sakai archive"));
                        }
                    } else {
                        M_log.warn((Object)("Skipping archive data for for " + serviceName + " (" + fileName + ") to site " + siteId + ", no service (EntityProducer) could be found to deal with this data"));
                    }
                    results.append(msg);
                }
                catch (Throwable t) {
                    results.append("Error merging: " + serviceName + " in file: " + fileName + " : " + t.toString() + "\n");
                    M_log.warn((Object)("Error merging: " + serviceName + " in file: " + fileName + " : " + t.toString()), t);
                }
                continue;
            }
            catch (Throwable t) {
                results.append("Did not recognize the resource service: " + serviceName + " in file: " + fileName + "\n");
                M_log.warn((Object)("Did not recognize the resource service: " + serviceName + " in file: " + fileName), t);
            }
        }
    }

    protected void mergeSite(String siteId, String fromSiteId, Element element, HashMap useIdTrans, String creatorId, boolean filterSakaiRoles, String[] filteredSakaiRoles) {
        String source = "";
        Node parent = element.getParentNode();
        if (parent.getNodeType() == 1) {
            Element parentEl = (Element)parent;
            source = parentEl.getAttribute("system");
        }
        NodeList children = element.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Element element2;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(element2 = (Element)child).getTagName().equals("site")) continue;
            NodeList toolChildren = element2.getElementsByTagName("tool");
            int tLength = toolChildren.getLength();
            for (int i2 = 0; i2 < tLength; ++i2) {
                Element element3 = (Element)toolChildren.item(i2);
                String toolId = element3.getAttribute("toolId");
                if (toolId != null) {
                    toolId = toolId.replaceAll(this.old_toolId_prefix, this.new_toolId_prefix);
                    for (int j = 0; j < this.old_toolIds.length; ++j) {
                        toolId = toolId.replaceAll(this.old_toolIds[i], this.new_toolIds[i]);
                    }
                }
                element3.setAttribute("toolId", toolId);
            }
            try {
                this.m_siteService.merge(siteId, element2, creatorId);
                this.mergeSiteInfo(element2, siteId);
            }
            catch (Exception any) {
                M_log.warn((Object)any, (Throwable)any);
            }
            Site site = null;
            try {
                site = this.m_siteService.getSite(siteId);
            }
            catch (IdUnusedException e) {
                M_log.warn((Object)(this + "The site with id " + siteId + " doesn't exit"), (Throwable)e);
                return;
            }
            if (site == null) continue;
            NodeList children2 = element2.getChildNodes();
            int length2 = children2.getLength();
            for (int i2 = 0; i2 < length2; ++i2) {
                Element element3;
                Node child2 = children2.item(i2);
                if (child2.getNodeType() != 1 || !(element3 = (Element)child2).getTagName().equals("roles")) continue;
                try {
                    this.mergeSiteRoles(element3, siteId, useIdTrans, filterSakaiRoles, filteredSakaiRoles);
                    continue;
                }
                catch (PermissionException e1) {
                    M_log.warn((Object)e1, (Throwable)e1);
                }
            }
        }
    }

    protected void mergeSiteInfo(Element el, String siteId) throws IdInvalidException, IdUsedException, PermissionException, IdUnusedException, InUseException {
        this.unlock("site.upd", this.m_siteService.siteReference(siteId));
        Site edit = this.m_siteService.getSite(siteId);
        String desc = el.getAttribute("description-enc");
        try {
            byte[] decoded;
            byte[] filteredDecoded = decoded = Base64.decodeBase64((byte[])desc.getBytes("UTF-8"));
            for (int i = 0; i < decoded.length; ++i) {
                byte b = decoded[i];
                if (b == -109 || b == -108) {
                    filteredDecoded[i] = 34;
                    continue;
                }
                if (b == -111 || b == -110) {
                    filteredDecoded[i] = 39;
                    continue;
                }
                if (b != -106) continue;
                filteredDecoded[i] = 45;
            }
            desc = new String(decoded, "UTF-8");
        }
        catch (Exception any) {
            M_log.warn((Object)"mergeSiteInfo(): exception caught", (Throwable)any);
        }
        edit.setDescription(desc);
        this.m_siteService.save(edit);
    }

    protected void mergeSiteRoles(Element el, String siteId, HashMap useIdTrans, boolean filterSakaiRoles, String[] filteredSakaiRoles) throws PermissionException {
        this.unlock("site.upd", this.m_siteService.siteReference(siteId));
        String source = "";
        Node parent0 = el.getParentNode();
        Node parent1 = parent0.getParentNode();
        Node parent = parent1.getParentNode();
        if (parent.getNodeType() == 1) {
            Element parentEl = (Element)parent;
            source = parentEl.getAttribute("system");
        }
        Vector roles = new Vector();
        String realmId = this.m_siteService.siteReference(siteId);
        try {
            AuthzGroup realm = this.m_authzGroupService.getAuthzGroup(realmId);
            roles.addAll(realm.getRoles());
            NodeList children = el.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                Element element2 = (Element)child;
                String roleId = null;
                if ("Sakai 2.8".equals(source)) {
                    if (!"role".equals(element2.getTagName())) continue;
                    roleId = element2.getAttribute("roleId");
                } else {
                    roleId = element2.getTagName();
                }
                if (!this.checkSystemRole(source, roleId, filterSakaiRoles, filteredSakaiRoles)) continue;
                NodeList children2 = element2.getChildNodes();
                int length2 = children2.getLength();
                for (int i2 = 0; i2 < length2; ++i2) {
                    Element element3;
                    Node child2 = children2.item(i2);
                    if (child2.getNodeType() != 1 || !(element3 = (Element)child2).getTagName().equals("ability")) continue;
                    String userId = element3.getAttribute("userId");
                    this.usersListAllowImport.add(userId);
                }
            }
        }
        catch (Exception err) {
            M_log.warn((Object)("()mergeSiteRoles realm edit exception caught" + realmId), (Throwable)err);
        }
    }

    protected String translateServiceName(String name) {
        if ("org.chefproject.service.GenericContentHostingService".equals(name)) {
            return ContentHostingService.class.getName();
        }
        return name;
    }

    protected boolean checkSakaiService(boolean m_filterSakaiServices, String[] m_filteredSakaiServices, String serviceName) {
        if (m_filterSakaiServices) {
            for (int i = 0; i < m_filteredSakaiServices.length; ++i) {
                if (!serviceName.endsWith(m_filteredSakaiServices[i].toString())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected void unlock(String lock, String reference) throws PermissionException {
        if (!this.m_securityService.unlock(lock, reference)) {
            // empty if block
        }
    }

    protected boolean checkSystemRole(String system, String roleId, boolean filterSakaiRoles, String[] filteredSakaiRoles) {
        if (system.equalsIgnoreCase("Sakai 1.0") || system.equalsIgnoreCase("Sakai 2.8")) {
            if (filterSakaiRoles) {
                for (int i = 0; i < filteredSakaiRoles.length; ++i) {
                    if (filteredSakaiRoles[i].equalsIgnoreCase(roleId)) continue;
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }
}

