/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.AuthzGroupService;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.api.Role;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.EntityProducer;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.site.api.Site;
import org.sakaiproject.site.api.SiteService;
import org.sakaiproject.time.api.Time;
import org.sakaiproject.time.api.TimeService;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.util.Xml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SiteArchiver {
    private static Log M_log = LogFactory.getLog(SiteArchiver.class);
    protected ServerConfigurationService m_serverConfigurationService = null;
    protected EntityManager m_entityManager = null;
    protected SiteService m_siteService = null;
    protected AuthzGroupService m_authzGroupService = null;
    protected UserDirectoryService m_userDirectoryService = null;
    protected TimeService m_timeService = null;
    protected ContentHostingService m_contentHostingService = null;

    public void setServerConfigurationService(ServerConfigurationService service) {
        this.m_serverConfigurationService = service;
    }

    public void setEntityManager(EntityManager service) {
        this.m_entityManager = service;
    }

    public void setSiteService(SiteService service) {
        this.m_siteService = service;
    }

    public void setAuthzGroupService(AuthzGroupService service) {
        this.m_authzGroupService = service;
    }

    public void setUserDirectoryService(UserDirectoryService service) {
        this.m_userDirectoryService = service;
    }

    public void setTimeService(TimeService service) {
        this.m_timeService = service;
    }

    public void setContentHostingService(ContentHostingService service) {
        this.m_contentHostingService = service;
    }

    public String archive(String siteId, String m_storagePath, String fromSystem) {
        String msg;
        Element root;
        Stack<Element> stack;
        Document doc;
        StringBuilder results = new StringBuilder();
        if (M_log.isDebugEnabled()) {
            M_log.debug((Object)("archive(): site: " + siteId));
        }
        Site theSite = null;
        try {
            theSite = this.m_siteService.getSite(siteId);
        }
        catch (IdUnusedException e) {
            results.append("Site: " + siteId + " not found.\n");
            M_log.warn((Object)("archive(): site not found: " + siteId));
            return results.toString();
        }
        List attachments = this.m_entityManager.newReferenceList();
        Time now = this.m_timeService.newTime();
        String storagePath = m_storagePath + siteId + "-archive/";
        File dir = new File(m_storagePath + siteId + "-archive/");
        dir.mkdirs();
        List services = this.m_entityManager.getEntityProducers();
        for (EntityProducer service : services) {
            if (service == null || !service.willArchiveMerge()) continue;
            Document doc2 = Xml.createDocument();
            Stack<Element> stack2 = new Stack<Element>();
            Element root2 = doc2.createElement("archive");
            doc2.appendChild(root2);
            root2.setAttribute("source", siteId);
            root2.setAttribute("server", this.m_serverConfigurationService.getServerId());
            root2.setAttribute("date", now.toString());
            root2.setAttribute("system", fromSystem);
            stack2.push(root2);
            try {
                String msg2 = service.archive(siteId, doc2, stack2, storagePath, attachments);
                results.append(msg2);
            }
            catch (Throwable t) {
                results.append(t.toString() + "\n");
            }
            stack2.pop();
            String fileName = storagePath + service.getLabel() + ".xml";
            Xml.writeDocument((Document)doc2, (String)fileName);
        }
        if (attachments.size() > 0) {
            doc = Xml.createDocument();
            stack = new Stack<Element>();
            root = doc.createElement("archive");
            doc.appendChild(root);
            root.setAttribute("source", siteId);
            root.setAttribute("server", this.m_serverConfigurationService.getServerId());
            root.setAttribute("date", now.toString());
            root.setAttribute("system", fromSystem);
            stack.push(root);
            msg = this.m_contentHostingService.archiveResources(attachments, doc, stack, storagePath);
            results.append(msg);
            stack.pop();
            String fileName = storagePath + "attachment.xml";
            Xml.writeDocument((Document)doc, (String)fileName);
        }
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", siteId);
        root.setAttribute("date", now.toString());
        root.setAttribute("system", fromSystem);
        stack.push(root);
        msg = this.archiveSite(theSite, doc, stack, fromSystem);
        results.append(msg);
        stack.pop();
        Xml.writeDocument((Document)doc, (String)(m_storagePath + siteId + "-archive/site.xml"));
        doc = Xml.createDocument();
        stack = new Stack();
        root = doc.createElement("archive");
        doc.appendChild(root);
        root.setAttribute("site", siteId);
        root.setAttribute("date", now.toString());
        root.setAttribute("system", fromSystem);
        stack.push(root);
        msg = this.archiveUsers(theSite, doc, stack);
        results.append(msg);
        stack.pop();
        Xml.writeDocument((Document)doc, (String)(m_storagePath + siteId + "-archive/user.xml"));
        return results.toString();
    }

    protected String archiveSite(Site site, Document doc, Stack stack, String fromSystem) {
        Element element = doc.createElement("sakai:site");
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        Element siteNode = site.toXml(doc, stack);
        String filter = this.m_serverConfigurationService.getString("archive.toolproperties.excludefilter", "password|secret");
        Pattern pattern = null;
        if (!"none".equals(filter) && filter.length() > 0) {
            try {
                pattern = Pattern.compile(filter);
            }
            catch (Exception e) {
                pattern = null;
            }
        }
        if (pattern != null) {
            NodeList nl = siteNode.getElementsByTagName("property");
            ArrayList<Element> toRemove = new ArrayList<Element>();
            for (int i = 0; i < nl.getLength(); ++i) {
                Matcher matcher;
                Element proptag = (Element)nl.item(i);
                String propname = proptag.getAttribute("name");
                if (propname == null || !(matcher = pattern.matcher(propname = propname.toLowerCase())).find()) continue;
                toRemove.add(proptag);
            }
            for (Element proptag : toRemove) {
                proptag.getParentNode().removeChild(proptag);
            }
        }
        stack.push(siteNode);
        Vector roles = new Vector();
        String realmId = this.m_siteService.siteReference(site.getId());
        try {
            Role role = null;
            AuthzGroup realm = this.m_authzGroupService.getAuthzGroup(realmId);
            Element realmNode = doc.createElement("roles");
            ((Element)stack.peek()).appendChild(realmNode);
            stack.push(realmNode);
            roles.addAll(realm.getRoles());
            for (int i = 0; i < roles.size(); ++i) {
                role = (Role)roles.get(i);
                String roleId = role.getId();
                Element node = null;
                if ("Sakai 2.8".equals(fromSystem)) {
                    node = doc.createElement("role");
                    node.setAttribute("roleId", roleId);
                } else {
                    node = doc.createElement(roleId);
                }
                realmNode.appendChild(node);
                Vector users = new Vector();
                users.addAll(realm.getUsersHasRole(role.getId()));
                for (int j = 0; j < users.size(); ++j) {
                    Element abilityNode = doc.createElement("ability");
                    abilityNode.setAttribute("roleId", roleId);
                    abilityNode.setAttribute("userId", (String)users.get(j));
                    node.appendChild(abilityNode);
                }
            }
        }
        catch (Exception any) {
            M_log.warn((Object)("archve: exception archiving site: " + site.getId() + ": "), (Throwable)any);
        }
        stack.pop();
        return "archiving Site: " + site.getId() + "\n";
    }

    protected String archiveUsers(Site site, Document doc, Stack stack) {
        Element element = doc.createElement("sakai:user");
        ((Element)stack.peek()).appendChild(element);
        stack.push(element);
        try {
            Vector users = new Vector();
            String realmId = this.m_siteService.siteReference(site.getId());
            try {
                AuthzGroup realm = this.m_authzGroupService.getAuthzGroup(realmId);
                users.addAll(this.m_userDirectoryService.getUsers((Collection)realm.getUsers()));
                Collections.sort(users);
                for (int i = 0; i < users.size(); ++i) {
                    User user = (User)users.get(i);
                    user.toXml(doc, stack);
                }
            }
            catch (GroupNotDefinedException e) {
                M_log.warn((Object)e, (Throwable)e);
            }
            catch (Exception any) {
                M_log.warn((Object)any, (Throwable)any);
            }
        }
        catch (Exception any) {
            M_log.warn((Object)any, (Throwable)any);
        }
        stack.pop();
        return "archiving the users for Site: " + site.getId() + "\n";
    }
}

