/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.archive.api.ArchiveService;
import org.sakaiproject.archive.impl.SiteArchiver;
import org.sakaiproject.archive.impl.SiteMerger;
import org.sakaiproject.archive.impl.SiteZipper;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveService2Impl
implements ArchiveService {
    private static Logger M_log = LoggerFactory.getLogger(ArchiveService2Impl.class);
    protected ServerConfigurationService m_serverConfigurationService = null;
    protected EntityManager m_entityManager = null;
    protected SiteArchiver m_siteArchiver = null;
    protected SiteMerger m_siteMerger = null;
    protected SiteZipper m_siteZipper = null;
    protected String m_storagePath = "/";
    protected String m_unzipPath = "/";
    protected boolean m_filterSakaiServices = false;
    protected boolean m_filterSakaiRoles = false;
    protected String[] m_filteredSakaiServices = null;
    protected String[] m_filteredSakaiRoles = null;

    public void setServerConfigurationService(ServerConfigurationService service) {
        this.m_serverConfigurationService = service;
    }

    public void setEntityManager(EntityManager service) {
        this.m_entityManager = service;
    }

    public void setSiteArchiver(SiteArchiver siteArchiver) {
        this.m_siteArchiver = siteArchiver;
    }

    public void setSiteMerger(SiteMerger siteMerger) {
        this.m_siteMerger = siteMerger;
    }

    public void setSiteZipper(SiteZipper siteZipper) {
        this.m_siteZipper = siteZipper;
    }

    public void setStoragePath(String path) {
        this.m_storagePath = path;
    }

    public void setUnzipPath(String unzipPath) {
        this.m_unzipPath = unzipPath;
    }

    public void setMergeFilterSakaiServices(boolean filter) {
        this.m_filterSakaiServices = filter;
    }

    public void setMergeFilterSakaiRoles(boolean filter) {
        this.m_filterSakaiRoles = filter;
    }

    public void setMergeFilteredSakaiServices(String[] filtered) {
        this.m_filteredSakaiServices = filtered;
    }

    public void setMergeFilteredSakaiRoles(String[] filtered) {
        this.m_filteredSakaiRoles = filtered;
    }

    public void init() {
        String[] filteredRoles;
        this.m_storagePath = this.m_serverConfigurationService.getString("archive.storage.path", this.m_storagePath);
        if (!StringUtils.endsWith((String)this.m_storagePath, (String)"/")) {
            this.m_storagePath = this.m_storagePath + "/";
        }
        this.m_unzipPath = this.m_serverConfigurationService.getString("archive.unzip.path", this.m_unzipPath);
        if (!StringUtils.endsWith((String)this.m_unzipPath, (String)"/")) {
            this.m_unzipPath = this.m_unzipPath + "/";
        }
        this.m_filterSakaiServices = this.m_serverConfigurationService.getBoolean("archive.merge.filter.services", this.m_filterSakaiServices);
        this.m_filterSakaiRoles = this.m_serverConfigurationService.getBoolean("archive.merge.filter.roles", this.m_filterSakaiRoles);
        String[] filteredServices = this.m_serverConfigurationService.getStrings("archive.merge.filtered.services");
        if (filteredServices != null) {
            this.m_filteredSakaiServices = filteredServices;
        }
        if ((filteredRoles = this.m_serverConfigurationService.getStrings("archive.merge.filtered.roles")) != null) {
            this.m_filteredSakaiRoles = filteredRoles;
        }
        M_log.info("init(): storage path: " + this.m_storagePath + ", unzip path: " + this.m_unzipPath + ", merge filter{services=" + this.m_filterSakaiServices + ", roles=" + this.m_filterSakaiRoles + "}");
    }

    public void destroy() {
        M_log.info("destroy()");
    }

    public String archive(String siteId) {
        return this.m_siteArchiver.archive(siteId, this.m_storagePath, "Sakai 2.8");
    }

    public String merge(String fileName, String siteId, String creatorId) {
        return this.m_siteMerger.merge(fileName, siteId, creatorId, this.m_storagePath, this.m_filterSakaiServices, this.m_filteredSakaiServices, this.m_filterSakaiRoles, this.m_filteredSakaiRoles);
    }

    public String mergeFromZip(String zipFilePath, String siteId, String creatorId) {
        try {
            String fileName = this.m_siteZipper.unzipArchive(zipFilePath, this.m_unzipPath);
            return this.m_siteMerger.merge(fileName, siteId, creatorId, this.m_storagePath, this.m_filterSakaiServices, this.m_filteredSakaiServices, this.m_filterSakaiRoles, this.m_filteredSakaiRoles);
        }
        catch (IOException e) {
            M_log.error("Error merging from zip: " + e.getClass() + ":" + e.getMessage());
            return "Error merging from zip: " + e.getClass() + ":" + e.getMessage();
        }
    }

    public String archiveAndZip(String siteId) throws IOException {
        String log = this.m_siteArchiver.archive(siteId, this.m_storagePath, "Sakai 2.8");
        log = this.m_siteZipper.zipArchive(siteId, this.m_storagePath) ? log + "Zipfile success.\n" : log + "Zipfile failed\n";
        return log;
    }
}

