/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import java.util.ArrayList;
import java.util.List;
import org.sakaiproject.archive.api.ImportMetadata;
import org.sakaiproject.archive.api.ImportMetadataService;
import org.sakaiproject.archive.impl.ImportMetadataImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportMetadataServiceImpl
implements ImportMetadataService {
    private static final Logger LOG = LoggerFactory.getLogger(ImportMetadataImpl.class);
    private static final String ROOT = "importConfiguration";
    private static final String MAPPINGS = "mappings";
    private static final String MAP = "map";
    private static final String LEGACY_TOOL = "legacyTool";
    private static final String SAKAI_TOOL = "sakaiTool";
    private static final String SERVICE_NAME = "serviceName";
    private static final String FILE_NAME = "filename";
    private static final String MANDATORY = "mandatory";
    private static final String SITE_ROOT = "archive";
    private static final String SITE_SERVICE = "org.sakaiproject.site.api.SiteService";
    private static final String SITE_APPLICATION_ID = "sakai:site";
    private static final String SITE = "site";
    private static final String SITE_ROLES = "roles";
    private static final String SITE_ROLE_MAINTAIN = "maintain";
    private static final String SITE_ROLE_ABILITY = "ability";
    private static final String SITE_ROLE_MAINTAIN_USERID = "userId";
    private static final String SITE_ROLE_ID = "roleId";
    private static final String ID = "id";
    private Document document = null;

    public List getImportMetadataElements(Document doc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getImportMetadataElements(Document" + doc + ")");
        }
        if (doc == null) {
            throw new IllegalArgumentException("Illegal document argument!");
        }
        this.document = doc;
        Element root = doc.getDocumentElement();
        if (root.getTagName().equals(ROOT)) {
            NodeList rootNodeList = root.getChildNodes();
            int length = rootNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Element mappingElement;
                Node mapping = rootNodeList.item(i);
                if (mapping.getNodeType() != 1 || !(mappingElement = (Element)mapping).getTagName().equals(MAPPINGS)) continue;
                ArrayList<ImportMetadataImpl> maps = new ArrayList<ImportMetadataImpl>();
                NodeList mapNode = mappingElement.getChildNodes();
                int mapLength = mapNode.getLength();
                for (int j = 0; j < mapLength; ++j) {
                    Element mapElement;
                    Node mapNodes = mapNode.item(j);
                    if (mapNodes.getNodeType() != 1 || !(mapElement = (Element)mapNodes).getTagName().equals(MAP)) continue;
                    ImportMetadataImpl importMetadataMap = new ImportMetadataImpl();
                    importMetadataMap.setId(mapElement.getAttribute(ID));
                    importMetadataMap.setFileName(mapElement.getAttribute(FILE_NAME));
                    importMetadataMap.setLegacyTool(mapElement.getAttribute(LEGACY_TOOL));
                    importMetadataMap.setSakaiTool(mapElement.getAttribute(SAKAI_TOOL));
                    importMetadataMap.setSakaiServiceName(mapElement.getAttribute(SERVICE_NAME));
                    if (mapElement.getAttribute(MANDATORY) != null && mapElement.getAttribute(MANDATORY).length() > 0 && mapElement.getAttribute(MANDATORY).endsWith("true")) {
                        importMetadataMap.setMandatory(true);
                    }
                    maps.add(importMetadataMap);
                }
                return maps;
            }
        }
        return null;
    }

    public ImportMetadata getImportMapById(String id) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("getImportMapById(String" + id + ")");
        }
        if (id == null || id.length() < 1) {
            throw new IllegalArgumentException("Illegal id argument!");
        }
        if (this.document == null) {
            LOG.error("No valid document found");
            return null;
        }
        Element root = this.document.getDocumentElement();
        if (root.getTagName().equals(ROOT)) {
            NodeList rootNodeList = root.getChildNodes();
            int length = rootNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Element mappingElement;
                Node mapping = rootNodeList.item(i);
                if (mapping.getNodeType() != 1 || !(mappingElement = (Element)mapping).getTagName().equals(MAPPINGS)) continue;
                NodeList mapNode = mappingElement.getChildNodes();
                int mapLength = mapNode.getLength();
                for (int j = 0; j < mapLength; ++j) {
                    Element mapElement;
                    Node mapNodes = mapNode.item(j);
                    if (mapNodes.getNodeType() != 1 || !(mapElement = (Element)mapNodes).getTagName().equals(MAP) || mapElement.getAttribute(ID) == null || !mapElement.getAttribute(ID).equals(id)) continue;
                    ImportMetadataImpl importMetadataMap = new ImportMetadataImpl();
                    importMetadataMap.setId(mapElement.getAttribute(ID));
                    importMetadataMap.setFileName(mapElement.getAttribute(FILE_NAME));
                    importMetadataMap.setLegacyTool(mapElement.getAttribute(LEGACY_TOOL));
                    importMetadataMap.setSakaiTool(mapElement.getAttribute(SAKAI_TOOL));
                    importMetadataMap.setSakaiServiceName(mapElement.getAttribute(SERVICE_NAME));
                    if (mapElement.getAttribute(MANDATORY) != null && mapElement.getAttribute(MANDATORY).length() > 0 && mapElement.getAttribute(MANDATORY).endsWith("true")) {
                        importMetadataMap.setMandatory(true);
                    }
                    return importMetadataMap;
                }
            }
        }
        return null;
    }

    public boolean hasMaintainRole(String username, Document siteDoc) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("hasMaintainRole(Document" + siteDoc + ")");
        }
        if (username == null || username.length() < 1) {
            throw new IllegalArgumentException("Illegal username argument!");
        }
        if (siteDoc == null) {
            throw new IllegalArgumentException("Illegal document argument!");
        }
        Element root = siteDoc.getDocumentElement();
        if (root.getTagName().equals(SITE_ROOT)) {
            NodeList rootNodeList = root.getChildNodes();
            int length = rootNodeList.getLength();
            for (int i = 0; i < length; ++i) {
                Element serviceElement;
                Node service = rootNodeList.item(i);
                if (service.getNodeType() != 1 || !(serviceElement = (Element)service).getTagName().equals(SITE_SERVICE) && !serviceElement.getTagName().equals(SITE_APPLICATION_ID)) continue;
                NodeList siteNodes = serviceElement.getChildNodes();
                int siteNodeLength = siteNodes.getLength();
                for (int j = 0; j < siteNodeLength; ++j) {
                    Element siteElement;
                    Node siteNode = siteNodes.item(j);
                    if (siteNode.getNodeType() != 1 || !(siteElement = (Element)siteNode).getTagName().equals(SITE)) continue;
                    NodeList rolesNodes = siteElement.getChildNodes();
                    int rolesNodeLength = rolesNodes.getLength();
                    for (int k = 0; k < rolesNodeLength; ++k) {
                        Element roleElement;
                        Node rolesNode = rolesNodes.item(k);
                        if (rolesNode.getNodeType() != 1 || !(roleElement = (Element)rolesNode).getTagName().equals(SITE_ROLES)) continue;
                        NodeList mtNodes = roleElement.getChildNodes();
                        int mtLength = mtNodes.getLength();
                        for (int l = 0; l < mtLength; ++l) {
                            Element mtElement;
                            Node mtNode = mtNodes.item(l);
                            if (mtNode.getNodeType() != 1 || !(mtElement = (Element)mtNode).getTagName().equals(SITE_ROLE_MAINTAIN)) continue;
                            NodeList abNodes = mtElement.getChildNodes();
                            int abLength = abNodes.getLength();
                            for (int m = 0; m < abLength; ++m) {
                                Element abElement;
                                Node abNode = abNodes.item(m);
                                if (abNode.getNodeType() != 1 || !(abElement = (Element)abNode).getTagName().equals(SITE_ROLE_ABILITY)) continue;
                                String siteUserID = abElement.getAttribute(SITE_ROLE_MAINTAIN_USERID);
                                String userRole = abElement.getAttribute(SITE_ROLE_ID);
                                if (siteUserID == null || siteUserID.trim().length() <= 0 || !siteUserID.equals(username) || !userRole.equals(SITE_ROLE_MAINTAIN)) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
}

