/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.archive.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteZipper {
    private static Logger log = LoggerFactory.getLogger(SiteZipper.class);
    protected ServerConfigurationService serverConfigurationService = null;

    public void setServerConfigurationService(ServerConfigurationService service) {
        this.serverConfigurationService = service;
    }

    public String unzipArchive(String zipFilePath, String m_unzipPath) throws IOException {
        log.debug("zipFilePath: " + zipFilePath);
        ZipFile zipFile = new ZipFile(zipFilePath);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            File dest = new File(m_unzipPath, entry.getName());
            log.debug("Dest: " + dest.getAbsolutePath());
            if (entry.isDirectory()) {
                dest.mkdir();
                continue;
            }
            InputStream in = zipFile.getInputStream(entry);
            FileOutputStream out = new FileOutputStream(dest);
            IOUtils.copy((InputStream)in, (OutputStream)out);
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        String unzippedArchivePath = StringUtils.substringAfterLast((String)(StringUtils.substringBeforeLast((String)zipFile.getName(), (String)"-") + "-archive"), (String)File.separator);
        log.debug("unzippedArchivePath: " + unzippedArchivePath);
        return unzippedArchivePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean zipArchive(String siteId, String m_storagePath) throws IOException {
        String archivePath = m_storagePath + siteId + "-archive";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        String timestamp = dateFormat.format(Calendar.getInstance().getTime());
        String compressedArchivePath = m_storagePath + siteId + "-" + timestamp + ".zip";
        File zipFile = new File(compressedArchivePath);
        if (!zipFile.exists()) {
            log.info("Creating zip file: " + compressedArchivePath);
            zipFile.createNewFile();
        }
        FileOutputStream fOut = null;
        FileInputStream zip = null;
        FilterOutputStream bOut = null;
        ZipArchiveOutputStream zOut = null;
        try {
            fOut = new FileOutputStream(zipFile);
            bOut = new BufferedOutputStream(fOut);
            zOut = new ZipArchiveOutputStream((OutputStream)bOut);
            SiteZipper.addFileToZip(zOut, archivePath, "");
            String hashPath = m_storagePath + siteId + "-" + timestamp + ".sha1";
            log.info("Creating hash: " + hashPath);
            zip = new FileInputStream(compressedArchivePath);
            String hash = DigestUtils.sha1Hex((InputStream)zip);
            FileUtils.writeStringToFile((File)new File(hashPath), (String)hash);
        }
        finally {
            zOut.finish();
            zOut.close();
            bOut.close();
            fOut.close();
            zip.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFileToZip(ZipArchiveOutputStream zOut, String path, String base) throws IOException {
        block5: {
            String entryName;
            File f;
            block4: {
                f = new File(path);
                entryName = base + f.getName();
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(f, entryName);
                zOut.putArchiveEntry((ArchiveEntry)zipEntry);
                if (!f.isFile()) break block4;
                FileInputStream fInputStream = null;
                try {
                    fInputStream = new FileInputStream(f);
                    IOUtils.copy((InputStream)fInputStream, (OutputStream)zOut);
                    zOut.closeArchiveEntry();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fInputStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)fInputStream);
                break block5;
            }
            zOut.closeArchiveEntry();
            File[] children = f.listFiles();
            if (children != null) {
                for (File child : children) {
                    SiteZipper.addFileToZip(zOut, child.getAbsolutePath(), entryName + "/");
                }
            }
        }
    }
}

