/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.Manifest;
import org.sakaiproject.importer.impl.ManifestFile;
import org.sakaiproject.importer.impl.ManifestItem;
import org.sakaiproject.importer.impl.ManifestResource;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.ZipFileParser;
import org.sakaiproject.importer.impl.importables.FileResource;
import org.sakaiproject.importer.impl.importables.Folder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class IMSFileParser
extends ZipFileParser {
    protected Map<String, Node> resourceMap = new HashMap<String, Node>();
    protected Map<String, IMSResourceTranslator> translatorMap = new HashMap<String, IMSResourceTranslator>();
    protected Map dependencies = new HashMap();
    protected Document archiveManifest;
    protected ResourceHelper resourceHelper;
    protected ItemHelper itemHelper;
    protected FileHelper fileHelper;
    protected ManifestHelper manifestHelper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awakeFromUnzip(String pathToData) {
        this.pathToData = pathToData;
        String absolutepathToManifest = pathToData + "/" + "imsmanifest.xml";
        absolutepathToManifest = absolutepathToManifest.replace('\\', '/');
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(absolutepathToManifest);
            DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.archiveManifest = docBuilder.parse(fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void setTranslatorMap(Map translatorMap) {
        this.translatorMap = translatorMap;
    }

    public boolean isValidArchive(byte[] fileData) {
        if (super.isValidArchive(fileData)) {
            return this.fileExistsInArchive("/imsmanifest.xml", fileData);
        }
        return false;
    }

    protected abstract Collection getCategoriesFromArchive(String var1);

    protected Collection getImportableItemsFromArchive(String pathToData) {
        ArrayList rv = new ArrayList();
        Document manifest = this.archiveManifest;
        List itemNodes = this.manifestHelper.getTopLevelItemNodes(manifest);
        List resourceNodes = this.manifestHelper.getResourceNodes(manifest);
        for (Node resourceNode : resourceNodes) {
            this.resourceMap.put(this.resourceHelper.getId(resourceNode), resourceNode);
        }
        int priority = 1;
        for (Node itemNode : itemNodes) {
            String title = this.itemHelper.getTitle(itemNode);
            rv.addAll(this.translateFromNodeToImportables(itemNode, "", priority, null));
            ++priority;
        }
        Object[] remainingRes = this.resourceMap.values().toArray();
        for (int i = 0; i < remainingRes.length; ++i) {
            Node resourceNode;
            resourceNode = (Node)remainingRes[i];
            rv.addAll(this.translateFromNodeToImportables(resourceNode, "", i + 1, null));
            this.resourceMap.remove(XPathHelper.getNodeValue("./attribute::identifier", resourceNode));
        }
        return rv;
    }

    protected Collection translateFromNodeToImportables(Node node, String contextPath, int priority, Importable parent) {
        ArrayList<Importable> branchOfImportables = new ArrayList<Importable>();
        String tag = node.getNodeName();
        String itemResourceId = null;
        if ("item".equals(tag)) {
            itemResourceId = this.itemHelper.getResourceId(node);
        } else if ("resource".equals(tag)) {
            itemResourceId = this.resourceHelper.getId(node);
        } else if ("file".equals(tag)) {
            itemResourceId = this.resourceHelper.getId(node.getParentNode());
        }
        Document resourceDescriptor = this.resourceHelper.getDescriptor(this.manifestHelper.getResourceForId(itemResourceId, this.archiveManifest));
        if (this.resourceHelper.isFolder(resourceDescriptor) || "item".equals(tag) && XPathHelper.selectNodes("./item", node).size() > 0 || "item".equals(tag) && this.isCompoundDocument(this.manifestHelper.getResourceForId(itemResourceId, this.archiveManifest), resourceDescriptor)) {
            String folderTitle = this.getTitleForNode(node);
            Folder folder = new Folder();
            folder.setPath(contextPath);
            folder.setTitle(folderTitle);
            folder.setDescription(this.getDescriptionForNode(node));
            folder.setSequenceNum(priority);
            if (parent != null) {
                folder.setParent(parent);
                folder.setLegacyGroup(parent.getLegacyGroup());
            } else {
                folder.setLegacyGroup(folderTitle);
            }
            String folderPath = contextPath + folderTitle.replaceAll("/", "_") + "/";
            if (this.isCompoundDocument(this.manifestHelper.getResourceForId(itemResourceId, this.archiveManifest), resourceDescriptor)) {
                if (this.wantsCompanionForCompoundDocument()) {
                    folder.setSequenceNum(++priority);
                    branchOfImportables.add(this.getCompanionForCompoundDocument(resourceDescriptor, folder));
                }
                branchOfImportables.addAll(this.translateFromNodeToImportables(this.manifestHelper.getResourceForId(itemResourceId, this.archiveManifest), folderPath, priority, folder));
            } else {
                List children = XPathHelper.selectNodes("./item", node);
                int childPriority = 1;
                Iterator i = children.iterator();
                while (i.hasNext()) {
                    branchOfImportables.addAll(this.translateFromNodeToImportables((Node)i.next(), folderPath, childPriority, folder));
                    ++childPriority;
                }
            }
            this.resourceMap.remove(itemResourceId);
            branchOfImportables.add(folder);
        } else if ("item".equals(tag)) {
            Node resourceNode = this.manifestHelper.getResourceForId(itemResourceId, this.archiveManifest);
            if (resourceNode != null) {
                if (parent == null) {
                    parent = new Folder();
                    parent.setLegacyGroup(this.itemHelper.getTitle(node));
                }
                branchOfImportables.addAll(this.translateFromNodeToImportables(resourceNode, contextPath, priority, parent));
            }
        } else {
            if ("file".equals(tag)) {
                FileResource file = new FileResource();
                try {
                    String fileName = this.fileHelper.getFilenameForNode(node);
                    file.setFileName(fileName);
                    if (node.getParentNode().getChildNodes().getLength() > 1) {
                        file.setDescription("");
                    } else {
                        file.setDescription(this.resourceHelper.getDescription(node.getParentNode()));
                    }
                    file.setFileBytes(this.fileHelper.getFileBytesForNode(node, contextPath));
                    file.setDestinationResourcePath(this.fileHelper.getFilePathForNode(node, contextPath));
                    file.setContentType(this.mimeTypes.getContentType(fileName));
                    file.setTitle(this.fileHelper.getTitle(node));
                    if (parent != null) {
                        file.setParent(parent);
                        file.setLegacyGroup(parent.getLegacyGroup());
                    } else {
                        file.setLegacyGroup("");
                    }
                }
                catch (IOException e) {
                    this.resourceMap.remove(this.resourceHelper.getId(node.getParentNode()));
                    return branchOfImportables;
                }
                branchOfImportables.add(file);
                this.resourceMap.remove(this.resourceHelper.getId(node.getParentNode()));
                return branchOfImportables;
            }
            if ("resource".equals(tag)) {
                Importable resource = null;
                boolean processResourceChildren = true;
                IMSResourceTranslator translator = this.translatorMap.get(this.resourceHelper.getType(node));
                if (translator != null) {
                    String title = this.resourceHelper.getTitle(node);
                    ((Element)node).setAttribute("title", title);
                    ((Element)node).setAttribute("priority", Integer.toString(priority));
                    resource = translator.translate(node, this.resourceHelper.getDescriptor(node), contextPath, this.pathToData);
                    processResourceChildren = translator.processResourceChildren();
                }
                if (resource != null) {
                    String dependency = this.resourceHelper.getDependency(node);
                    if (!"".equals(dependency)) {
                        this.dependencies.put(this.resourceHelper.getId(node), dependency);
                    }
                    if (resource.getLegacyGroup() == null || "".equals(resource.getLegacyGroup())) {
                        if (this.dependencies.containsValue(this.resourceHelper.getId(node))) {
                            resource.setLegacyGroup("mandatory");
                        } else if (parent != null) {
                            resource.setParent(parent);
                            resource.setLegacyGroup(parent.getLegacyGroup());
                        } else {
                            resource.setLegacyGroup(this.resourceHelper.getTitle(node));
                        }
                    }
                    branchOfImportables.add(resource);
                    parent = resource;
                }
                if (processResourceChildren) {
                    NodeList children = node.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        branchOfImportables.addAll(this.translateFromNodeToImportables(children.item(i), contextPath, priority, parent));
                    }
                }
                this.resourceMap.remove(itemResourceId);
            }
        }
        return branchOfImportables;
    }

    protected abstract Importable getCompanionForCompoundDocument(Document var1, Folder var2);

    protected abstract boolean wantsCompanionForCompoundDocument();

    protected String getTitleForNode(Node node) {
        if ("item".equals(node.getNodeName())) {
            return this.itemHelper.getTitle(node);
        }
        if ("resource".equals(node.getNodeName())) {
            return this.resourceHelper.getTitle(node);
        }
        return "";
    }

    protected String getDescriptionForNode(Node node) {
        if ("item".equals(node.getNodeName())) {
            return this.itemHelper.getDescription(node);
        }
        if ("resource".equals(node.getNodeName())) {
            return this.resourceHelper.getDescription(node);
        }
        return "";
    }

    protected abstract boolean isCompoundDocument(Node var1, Document var2);

    public void addResourceTranslator(IMSResourceTranslator t) {
        this.translatorMap.put(t.getTypeName(), t);
    }

    protected static abstract class ManifestHelper
    implements Manifest {
        protected ManifestHelper() {
        }
    }

    protected abstract class FileHelper
    implements ManifestFile {
        protected FileHelper() {
        }

        public byte[] getFileBytesForNode(Node node, String contextPath) throws IOException {
            String filePath = this.getFilePathForNode(node, contextPath);
            return IMSFileParser.this.getBytesFromFile(new File(IMSFileParser.this.pathToData + "/" + filePath));
        }

        public String getFilePathForNode(Node node, String contextPath) {
            return contextPath + "/" + this.getFilenameForNode(node);
        }

        public String getTitle(Node fileNode) {
            if (fileNode.getParentNode().getChildNodes().getLength() > 1) {
                return this.getFilenameForNode(fileNode);
            }
            return IMSFileParser.this.resourceHelper.getTitle(fileNode.getParentNode());
        }

        public String getFilenameForNode(Node node) {
            String sourceFilePath = XPathHelper.getNodeValue("./@href", node).replaceAll("\\\\", "/");
            return sourceFilePath.lastIndexOf("/") < 0 ? sourceFilePath : sourceFilePath.substring(sourceFilePath.lastIndexOf("/") + 1);
        }
    }

    protected static abstract class ItemHelper
    implements ManifestItem {
        protected ItemHelper() {
        }

        public String getResourceId(Node itemNode) {
            return XPathHelper.getNodeValue("./@identifierref", itemNode);
        }
    }

    protected static abstract class ResourceHelper
    implements ManifestResource {
        protected ResourceHelper() {
        }

        public String getDependency(Node node) {
            return XPathHelper.getNodeValue("./dependency/@identifierref", node);
        }
    }
}

