/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.ImportDataSource;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.api.ImportService;
import org.sakaiproject.importer.api.Importable;

public class BasicImportService
implements ImportService {
    private List parsers;
    private List resourceHandlers;
    private org.sakaiproject.component.api.ServerConfigurationService configService = ServerConfigurationService.getInstance();

    public void doImportItems(Collection importables, String siteId) {
        HandlesImportable handler2 = null;
        for (Importable thing : importables) {
            for (HandlesImportable handler2 : this.resourceHandlers) {
                if (!handler2.canHandleType(thing.getTypeName())) continue;
                handler2.handle(thing, siteId);
            }
        }
    }

    public boolean isValidArchive(byte[] archiveFileData) {
        boolean isValid = false;
        Iterator i = this.parsers.iterator();
        while (i.hasNext()) {
            if (!((ImportFileParser)i.next()).isValidArchive(archiveFileData)) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public ImportDataSource parseFromFile(byte[] archiveFileData) {
        for (ImportFileParser parser : this.parsers) {
            if (!parser.isValidArchive(archiveFileData)) continue;
            return parser.newParser().parse(archiveFileData, this.configService.getSakaiHomePath() + "archive");
        }
        return null;
    }

    public void registerParser(ImportFileParser parser) {
        this.parsers.add(parser);
    }

    public void setParsers(List parsers) {
        this.parsers = parsers;
    }

    public void registerResourceHandler(HandlesImportable handler) {
        this.resourceHandlers.add(handler);
    }

    public void setResourceHandlers(List resourceHandlers) {
        this.resourceHandlers = resourceHandlers;
    }
}

