/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.sakaiproject.component.cover.ServerConfigurationService;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.ImportDataSource;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.api.ImportService;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.api.ResetOnCloseInputStream;

public class BasicImportService
implements ImportService {
    private List<ImportFileParser> parsers;
    private List<HandlesImportable> resourceHandlers;
    private org.sakaiproject.component.api.ServerConfigurationService configService = ServerConfigurationService.getInstance();

    public void doImportItems(Collection<Importable> importables, String siteId) {
        for (Importable thing : importables) {
            for (HandlesImportable handler : this.resourceHandlers) {
                if (!handler.canHandleType(thing.getTypeName())) continue;
                handler.handle(thing, siteId);
            }
        }
    }

    public boolean isValidArchive(ResetOnCloseInputStream archiveFileData) {
        return this.findParser(archiveFileData) != null;
    }

    private ImportFileParser findParser(ResetOnCloseInputStream archiveFileData) {
        for (ImportFileParser parser : this.parsers) {
            if (!parser.isValidArchive((InputStream)archiveFileData)) continue;
            return parser;
        }
        return null;
    }

    public ImportDataSource parseFromFile(ResetOnCloseInputStream archiveFileData) {
        ImportFileParser parser = this.findParser(archiveFileData);
        if (parser != null) {
            return parser.newParser().parse((InputStream)archiveFileData, this.configService.getSakaiHomePath() + "archive");
        }
        return null;
    }

    public void registerParser(ImportFileParser parser) {
        this.parsers.add(parser);
    }

    public void setParsers(List<ImportFileParser> parsers) {
        this.parsers = parsers;
    }

    public void registerResourceHandler(HandlesImportable handler) {
        this.resourceHandlers.add(handler);
    }

    public void setResourceHandlers(List<HandlesImportable> resourceHandlers) {
        this.resourceHandlers = resourceHandlers;
    }
}

