/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.MimetypesFileTypeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.archive.api.ImportMetadata;
import org.sakaiproject.importer.api.ImportDataSource;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.ZipImportDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public abstract class ZipFileParser
implements ImportFileParser {
    private static final Logger log = LoggerFactory.getLogger(ZipFileParser.class);
    protected MimetypesFileTypeMap mimeTypes = new MimetypesFileTypeMap();
    protected String pathToData;
    protected String localArchiveLocation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidArchive(InputStream fileData) {
        ZipEntry entry;
        ZipInputStream zipStream = new ZipInputStream(fileData);
        try {
            entry = zipStream.getNextEntry();
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException iOException) {}
        }
        return entry != null;
    }

    public ImportDataSource parse(InputStream fileData, String unArchiveLocation) {
        this.localArchiveLocation = this.unzipArchive(fileData, unArchiveLocation);
        this.pathToData = unArchiveLocation + File.separator + this.localArchiveLocation;
        this.awakeFromUnzip(this.pathToData);
        ArrayList<ImportMetadata> categories = new ArrayList<ImportMetadata>();
        ArrayList<Importable> items = new ArrayList<Importable>();
        categories.addAll(this.getCategoriesFromArchive(this.pathToData));
        items.addAll(this.getImportableItemsFromArchive(this.pathToData));
        ZipImportDataSource dataSource = new ZipImportDataSource();
        dataSource.setItemCategories(categories);
        dataSource.setItems(items);
        return dataSource;
    }

    protected abstract void awakeFromUnzip(String var1);

    protected abstract Collection getImportableItemsFromArchive(String var1);

    protected abstract Collection getCategoriesFromArchive(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String unzipArchive(InputStream fileData, String unArchiveLocation) {
        String localArchiveLocation = Long.toString(new Date().getTime());
        String pathToData = unArchiveLocation + "/" + localArchiveLocation;
        File dir = new File(pathToData);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        TreeSet<String> dirsMade = new TreeSet<String>();
        ZipInputStream zipStream = new ZipInputStream(fileData);
        try {
            ZipEntry entry = null;
            try {
                entry = zipStream.getNextEntry();
            }
            catch (IOException e) {
                entry = null;
            }
            boolean foundTheManifest = false;
            while (entry != null) {
                File zipEntryFile;
                File d;
                String dirName;
                int ix;
                String zipName = entry.getName();
                if (!foundTheManifest && zipName.endsWith("imsmanifest.xml") && zipName.startsWith("imsmanifest.xml")) {
                    foundTheManifest = true;
                }
                if (!foundTheManifest && zipName.endsWith("imsmanifest.xml") && !zipName.startsWith("imsmanifest.xml")) {
                    localArchiveLocation = localArchiveLocation + "/" + zipName.substring(0, zipName.lastIndexOf("/"));
                    foundTheManifest = true;
                }
                if ((ix = zipName.lastIndexOf(47)) <= 0) {
                    ix = zipName.lastIndexOf(92);
                }
                if (!(ix <= 0 || dirsMade.contains(dirName = zipName.substring(0, ix).replace("\\", "/")) || (d = new File(dir.getPath() + "/" + dirName)).exists() && d.isDirectory())) {
                    if (!d.mkdirs()) {
                        // empty if block
                    }
                    dirsMade.add(dirName);
                }
                if (!(zipEntryFile = new File(dir.getPath() + "/" + zipName.replace("\\", "/"))).isDirectory()) {
                    FileOutputStream ofile = null;
                    try {
                        int bytesRead;
                        ofile = new FileOutputStream(zipEntryFile);
                        byte[] buffer = new byte[10240];
                        while ((bytesRead = zipStream.read(buffer)) != -1) {
                            ofile.write(buffer, 0, bytesRead);
                        }
                    }
                    catch (FileNotFoundException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    catch (IOException e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        if (ofile != null) {
                            try {
                                ofile.close();
                            }
                            catch (IOException e) {}
                        }
                    }
                }
                try {
                    zipStream.closeEntry();
                }
                catch (IOException ofile) {
                    // empty catch block
                }
                try {
                    entry = zipStream.getNextEntry();
                }
                catch (IOException e) {
                    entry = null;
                }
            }
        }
        finally {
            try {
                zipStream.closeEntry();
            }
            catch (IOException iOException) {}
        }
        return localArchiveLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fileExistsInArchive(String pathAndFilename, InputStream archive) {
        boolean bl;
        ZipInputStream zipStream = new ZipInputStream(archive);
        if (pathAndFilename.charAt(0) == '/') {
            pathAndFilename = pathAndFilename.substring(1);
        }
        try {
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entryName.endsWith(pathAndFilename)) {
                    boolean bl2 = true;
                    return bl2;
                }
                entry = zipStream.getNextEntry();
            }
            bl = false;
        }
        catch (IOException e) {
            boolean bl3 = false;
            return bl3;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Document extractFileAsDOM(String pathAndFilename, InputStream archive) {
        ZipInputStream zipStream = new ZipInputStream(archive);
        if (pathAndFilename.charAt(0) == '/') {
            pathAndFilename = pathAndFilename.substring(1);
        }
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            ZipEntry entry = zipStream.getNextEntry();
            while (entry != null) {
                String entryName = entry.getName();
                if (entryName.endsWith(pathAndFilename)) {
                    Document document = docBuilder.parse(zipStream);
                    return document;
                }
                entry = zipStream.getNextEntry();
            }
            Document document = null;
            return document;
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            Document document = null;
            return document;
        }
        catch (ParserConfigurationException e) {
            log.error(e.getMessage(), (Throwable)e);
            Document document = null;
            return document;
        }
        catch (FactoryConfigurationError e) {
            log.error(e.getMessage(), (Throwable)e);
            Document document = null;
            return document;
        }
        catch (SAXException e) {
            log.error(e.getMessage(), (Throwable)e);
            Document document = null;
            return document;
        }
        finally {
            try {
                zipStream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] getBytesFromFile(File file) throws IOException {
        byte[] bytes;
        try (FileInputStream is = new FileInputStream(file);){
            int offset;
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                // empty if block
            }
            bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read file " + file.getName());
            }
        }
        return bytes;
    }
}

