/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import junit.framework.TestCase;
import org.sakaiproject.importer.api.ImportDataSource;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.impl.SakaiArchiveDataSource;
import org.sakaiproject.importer.impl.SakaiArchiveFileParser;

public class SakaiArchiveTest
extends TestCase {
    private static ImportFileParser parser;
    private byte[] archiveData;
    private FileInputStream archiveStream;

    public void setUp() throws IOException {
        System.out.println("doing setUp()");
        parser = new SakaiArchiveFileParser();
        this.archiveStream = new FileInputStream(new File("/Users/zach/Downloads/sakai_course_export.zip"));
        this.archiveData = new byte[this.archiveStream.available()];
        this.archiveStream.read(this.archiveData, 0, this.archiveStream.available());
        this.archiveStream.close();
    }

    public void testCanGetDataSource() {
        ImportDataSource dataSource = parser.parse(this.archiveData, "/Users/zach/Desktop");
        SakaiArchiveTest.assertNotNull((Object)dataSource);
        System.out.println("There are " + dataSource.getItemCategories().size() + " categories in this archive.");
        ((SakaiArchiveDataSource)dataSource).buildSourceFolder(dataSource.getItemCategories());
    }

    public void testArchiveIsValid() {
        SakaiArchiveTest.assertTrue((boolean)parser.isValidArchive(this.archiveData));
    }
}

