/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sakaiproject.archive.cover.ImportMetadataService;
import org.sakaiproject.importer.api.ImportDataSource;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.impl.SakaiArchiveDataSource;
import org.sakaiproject.importer.impl.ZipFileParser;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SakaiArchiveFileParser
extends ZipFileParser {
    private static final String LEGACY_TOOL = "legacyTool";
    private static final String SAKAI_TOOL = "sakaiTool";
    private static final String ROOT = "importConfiguration";
    private static final String MAPPINGS = "mappings";
    private static final String MAP = "map";
    private static final String SERVICE_NAME = "serviceName";
    private static final String FILE_NAME = "filename";
    private static final String MANDATORY = "mandatory";
    private static final String ID = "id";
    protected Document importMappings;

    public boolean isValidArchive(InputStream fileData) {
        if (super.isValidArchive(fileData)) {
            return this.fileExistsInArchive("/import_mappings.xml", fileData);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void awakeFromUnzip(String unArchiveLocation) {
        this.pathToData = unArchiveLocation;
        String absolutepathToManifest = this.pathToData + "/" + "import_mappings.xml";
        absolutepathToManifest = absolutepathToManifest.replace('\\', '/');
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(absolutepathToManifest);
            DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
            builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder docBuilder = builderFactory.newDocumentBuilder();
            this.importMappings = docBuilder.parse(fis);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fis != null) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public ImportFileParser newParser() {
        return new SakaiArchiveFileParser();
    }

    public ImportDataSource parse(InputStream fileData, String unArchiveLocation) {
        this.localArchiveLocation = this.unzipArchive(fileData, unArchiveLocation);
        this.pathToData = unArchiveLocation + "/" + this.localArchiveLocation;
        this.awakeFromUnzip(this.pathToData);
        ArrayList categories = new ArrayList();
        ArrayList items = new ArrayList();
        categories.addAll(this.getCategoriesFromArchive(this.pathToData));
        items.addAll(this.getImportableItemsFromArchive(this.pathToData));
        SakaiArchiveDataSource dataSource = new SakaiArchiveDataSource(fileData, this.localArchiveLocation, this.pathToData);
        dataSource.setItemCategories(categories);
        dataSource.setItems(items);
        return dataSource;
    }

    protected Collection getCategoriesFromArchive(String pathToData) {
        return ImportMetadataService.getImportMetadataElements((Document)this.importMappings);
    }

    protected Collection getImportableItemsFromArchive(String pathToData) {
        return new ArrayList();
    }
}

