/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.sakaiproject.archive.api.ImportMetadata;
import org.sakaiproject.importer.api.SakaiArchive;
import org.sakaiproject.importer.impl.BasicImportDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SakaiArchiveDataSource
extends BasicImportDataSource
implements SakaiArchive {
    private static final Logger log = LoggerFactory.getLogger(SakaiArchiveDataSource.class);
    private String sourceFolder;
    private String localArchiveFolder;
    private String pathToArchive;
    private InputStream fileData;

    public SakaiArchiveDataSource(InputStream fileData, String localArchiveFolder, String pathToArchive) {
        this.fileData = fileData;
        this.localArchiveFolder = localArchiveFolder;
        this.pathToArchive = pathToArchive;
        this.sourceFolder = localArchiveFolder + "/source/";
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public void setSourceFolder(String sourceFolder) {
        this.sourceFolder = sourceFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildSourceFolder(Collection<ImportMetadata> selectedItems) {
        File dir = new File(this.pathToArchive + "/source");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        block66: for (ImportMetadata impvalue : selectedItems) {
            String selectedFileName = impvalue.getFileName();
            ZipInputStream zipStream = new ZipInputStream(this.fileData);
            try {
                ZipEntry entry;
                try {
                    entry = zipStream.getNextEntry();
                }
                catch (IOException e) {
                    entry = null;
                }
                while (entry != null) {
                    String entryName = entry.getName();
                    if (entryName.equals(selectedFileName)) {
                        File zipEntryFile = new File(dir.getPath() + "/" + entryName);
                        if (!zipEntryFile.isDirectory()) {
                            FileOutputStream ofile = null;
                            try {
                                int bytesRead;
                                ofile = new FileOutputStream(zipEntryFile);
                                byte[] buffer = new byte[10240];
                                while ((bytesRead = zipStream.read(buffer)) != -1) {
                                    ofile.write(buffer, 0, bytesRead);
                                }
                            }
                            catch (FileNotFoundException e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                            catch (IOException e) {
                                log.error(e.getMessage(), (Throwable)e);
                            }
                            finally {
                                if (ofile != null) {
                                    try {
                                        ofile.close();
                                    }
                                    catch (IOException e) {}
                                }
                            }
                        }
                        try {
                            zipStream.closeEntry();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        try {
                            zipStream.close();
                        }
                        catch (IOException iOException) {}
                        continue block66;
                    }
                    try {
                        entry = zipStream.getNextEntry();
                    }
                    catch (IOException e) {
                        entry = null;
                    }
                }
            }
            finally {
                try {
                    zipStream.closeEntry();
                }
                catch (IOException entry) {}
                try {
                    zipStream.close();
                }
                catch (IOException entry) {}
            }
        }
        ZipInputStream zipStream = new ZipInputStream(this.fileData);
        try {
            ZipEntry entry;
            try {
                entry = zipStream.getNextEntry();
            }
            catch (IOException e) {
                entry = null;
            }
            while (entry != null) {
                String entryName = entry.getName();
                if (!entryName.endsWith(".xml")) {
                    File zipEntryFile = new File(dir.getPath() + "/" + entryName);
                    if (!zipEntryFile.isDirectory()) {
                        FileOutputStream ofile = null;
                        try {
                            int bytesRead;
                            ofile = new FileOutputStream(zipEntryFile);
                            byte[] buffer = new byte[10240];
                            while ((bytesRead = zipStream.read(buffer)) != -1) {
                                ofile.write(buffer, 0, bytesRead);
                            }
                        }
                        catch (FileNotFoundException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                        finally {
                            if (ofile != null) {
                                try {
                                    ofile.close();
                                }
                                catch (IOException e) {}
                            }
                        }
                    }
                    try {
                        zipStream.closeEntry();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                try {
                    entry = zipStream.getNextEntry();
                }
                catch (IOException e) {
                    entry = null;
                }
            }
        }
        finally {
            try {
                zipStream.closeEntry();
            }
            catch (IOException iOException) {}
            try {
                zipStream.close();
            }
            catch (IOException iOException) {}
        }
    }
}

