/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.common.edu.person;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Example;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Order;
import org.hibernate.type.Type;
import org.sakaiproject.api.common.edu.person.PhotoService;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.api.common.edu.person.SakaiPersonManager;
import org.sakaiproject.api.common.manager.Persistable;
import org.sakaiproject.api.common.type.TypeManager;
import org.sakaiproject.authz.cover.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.component.common.edu.person.SakaiPersonImpl;
import org.sakaiproject.component.common.manager.PersistableHelper;
import org.sakaiproject.event.api.EventTrackingService;
import org.sakaiproject.id.cover.IdManager;
import org.sakaiproject.tool.cover.SessionManager;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserEdit;
import org.sakaiproject.user.api.UserNotDefinedException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class SakaiPersonManagerImpl
extends HibernateDaoSupport
implements SakaiPersonManager {
    private static final Log LOG = LogFactory.getLog(SakaiPersonManagerImpl.class);
    private static final String PERCENT_SIGN = "%";
    private static final String SURNAME = "surname";
    private static final String GIVENNAME = "givenName";
    private static final String UID = "uid";
    private static final String TYPE_UUID = "typeUuid";
    private static final String AGENT_UUID = "agentUuid";
    private static final String AGENT_UUID_COLLECTION = "agentUuidCollection";
    private static final String FERPA_ENABLED = "ferpaEnabled";
    private static final String HQL_FIND_SAKAI_PERSON_BY_AGENT_AND_TYPE = "findEduPersonByAgentAndType";
    private static final String HQL_FIND_SAKAI_PERSONS_BY_AGENTS_AND_TYPE = "findEduPersonsByAgentsAndType";
    private static final String HQL_FIND_SAKAI_PERSON_BY_UID = "findSakaiPersonByUid";
    private static final int MAX_QUERY_COLLECTION_SIZE = 1000;
    private TypeManager typeManager;
    private PersistableHelper persistableHelper;
    private org.sakaiproject.api.common.type.Type systemMutableType;
    private org.sakaiproject.api.common.type.Type userMutableType;
    private static final String[] SYSTEM_MUTABLE_PRIMITIVES = new String[]{"org.sakaiproject", "api.common.edu.person", "SakaiPerson.recordType.systemMutable", "System Mutable SakaiPerson", "System Mutable SakaiPerson"};
    private static final String[] USER_MUTABLE_PRIMITIVES = new String[]{"org.sakaiproject", "api.common.edu.person", "SakaiPerson.recordType.userMutable", "User Mutable SakaiPerson", "User Mutable SakaiPerson"};
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;
    private EventTrackingService eventTrackingService;
    private PhotoService photoService;

    public void setServerConfigurationService(ServerConfigurationService scs) {
        this.serverConfigurationService = scs;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setUserDirectoryService(userDirectoryService " + userDirectoryService + ")"));
        }
        this.userDirectoryService = userDirectoryService;
    }

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setPhotoService(PhotoService ps) {
        this.photoService = ps;
    }

    public void init() {
        LOG.debug((Object)"init()");
        LOG.debug((Object)"// init systemMutableType");
        this.systemMutableType = this.typeManager.getType(SYSTEM_MUTABLE_PRIMITIVES[0], SYSTEM_MUTABLE_PRIMITIVES[1], SYSTEM_MUTABLE_PRIMITIVES[2]);
        if (this.systemMutableType == null) {
            this.systemMutableType = this.typeManager.createType(SYSTEM_MUTABLE_PRIMITIVES[0], SYSTEM_MUTABLE_PRIMITIVES[1], SYSTEM_MUTABLE_PRIMITIVES[2], SYSTEM_MUTABLE_PRIMITIVES[3], SYSTEM_MUTABLE_PRIMITIVES[4]);
        }
        if (this.systemMutableType == null) {
            throw new IllegalStateException("systemMutableType == null");
        }
        LOG.debug((Object)"// init userMutableType");
        this.userMutableType = this.typeManager.getType(USER_MUTABLE_PRIMITIVES[0], USER_MUTABLE_PRIMITIVES[1], USER_MUTABLE_PRIMITIVES[2]);
        if (this.userMutableType == null) {
            this.userMutableType = this.typeManager.createType(USER_MUTABLE_PRIMITIVES[0], USER_MUTABLE_PRIMITIVES[1], USER_MUTABLE_PRIMITIVES[2], USER_MUTABLE_PRIMITIVES[3], USER_MUTABLE_PRIMITIVES[4]);
        }
        if (this.userMutableType == null) {
            throw new IllegalStateException("userMutableType == null");
        }
        LOG.debug((Object)"init() has completed successfully");
    }

    public SakaiPerson create(String userId, org.sakaiproject.api.common.type.Type recordType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("create(String " + userId + ",  Type " + recordType + ")"));
        }
        if (userId == null || userId.length() < 1) {
            throw new IllegalArgumentException("Illegal agentUuid argument passed!");
        }
        if (!this.isSupportedType(recordType)) {
            throw new IllegalArgumentException("Illegal recordType argument passed!");
        }
        SakaiPersonImpl spi = new SakaiPersonImpl();
        this.persistableHelper.createPersistableFields((Persistable)spi);
        spi.setUuid(IdManager.createUuid());
        spi.setAgentUuid(userId);
        spi.setUid(userId);
        spi.setTypeUuid(recordType.getUuid());
        spi.setLocked(Boolean.valueOf(false));
        this.getHibernateTemplate().save((Object)spi);
        String ref = this.getReference((SakaiPerson)spi);
        this.eventTrackingService.post(this.eventTrackingService.newEvent("profile.new", ref, true));
        if (this.serverConfigurationService.getBoolean("profile.updateUser", false)) {
            try {
                User u = this.userDirectoryService.getUser(userId);
                spi.setGivenName(u.getFirstName());
                spi.setSurname(u.getLastName());
                spi.setMail(u.getEmail());
            }
            catch (UserNotDefinedException uue) {
                LOG.error((Object)("User " + userId + "doesn't exist"));
            }
        }
        LOG.debug((Object)"return spi;");
        return spi;
    }

    public SakaiPerson getSakaiPerson(org.sakaiproject.api.common.type.Type recordType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getSakaiPerson(Type " + recordType + ")"));
        }
        LOG.debug((Object)"return findSakaiPerson(agent.getUuid(), recordType);");
        return this.getSakaiPerson(SessionManager.getCurrentSessionUserId(), recordType);
    }

    public SakaiPerson getPrototype() {
        LOG.debug((Object)"getPrototype()");
        return new SakaiPersonImpl();
    }

    public List findSakaiPersonByUid(final String uid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findSakaiPersonByUid(String " + uid + ")"));
        }
        if (uid == null || uid.length() < 1) {
            throw new IllegalArgumentException("Illegal uid argument passed!");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(SakaiPersonManagerImpl.HQL_FIND_SAKAI_PERSON_BY_UID);
                q.setParameter(SakaiPersonManagerImpl.UID, (Object)uid, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        LOG.debug((Object)"return getHibernateTemplate().executeFind(hcb);");
        List hb = this.getHibernateTemplate().executeFind(hcb);
        if (this.photoService.overRidesDefault()) {
            return this.getDiskPhotosForList(hb);
        }
        return hb;
    }

    public void save(SakaiPerson sakaiPerson) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("save(SakaiPerson " + sakaiPerson + ")"));
        }
        if (sakaiPerson == null) {
            throw new IllegalArgumentException("Illegal sakaiPerson argument passed!");
        }
        if (!this.isSupportedType(sakaiPerson.getTypeUuid())) {
            throw new IllegalArgumentException("The sakaiPerson argument contains an invalid Type!");
        }
        if (this.getSystemMutableType().getUuid().equals(sakaiPerson.getTypeUuid()) && !SecurityService.isSuperUser()) {
            throw new IllegalAccessError("System mutable records cannot be updated.");
        }
        if (!(SecurityService.unlock((String)"admin", (String)"profile.save", (String)sakaiPerson.getAgentUuid()) || StringUtils.equals((String)SessionManager.getCurrentSessionUserId(), (String)sakaiPerson.getAgentUuid()) || SecurityService.isSuperUser() || StringUtils.equals((String)SessionManager.getCurrentSessionUserId(), (String)sakaiPerson.getAgentUuid()))) {
            throw new IllegalAccessError("You do not have permissions to update this record!");
        }
        if (!(sakaiPerson instanceof SakaiPersonImpl)) {
            throw new UnsupportedOperationException("Unknown SakaiPerson implementation found!");
        }
        SakaiPersonImpl spi = (SakaiPersonImpl)sakaiPerson;
        this.persistableHelper.modifyPersistableFields((Persistable)spi);
        if (this.photoService.overRidesDefault()) {
            this.photoService.savePhoto(spi.getJpegPhoto(), spi.getAgentUuid());
            spi.setJpegPhoto(null);
        }
        this.getHibernateTemplate().update((Object)spi);
        String ref = this.getReference((SakaiPerson)spi);
        LOG.debug((Object)("got ref of: " + ref + " about to set events"));
        this.eventTrackingService.post(this.eventTrackingService.newEvent("profile.update", ref, true));
        LOG.debug((Object)("User record updated for Id :-" + spi.getAgentUuid()));
        if (this.serverConfigurationService.getBoolean("profile.updateUser", false) && spi.getTypeUuid().equals(this.userMutableType.getUuid())) {
            try {
                UserEdit userEdit = null;
                userEdit = this.userDirectoryService.editUser(spi.getAgentUuid());
                userEdit.setFirstName(spi.getGivenName());
                userEdit.setLastName(spi.getSurname());
                userEdit.setEmail(spi.getMail());
                this.userDirectoryService.commitEdit(userEdit);
                LOG.debug((Object)"Saved user object");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getReference(SakaiPerson spi) {
        String ref = "/profile/type/" + spi.getTypeUuid() + "/id/" + spi.getAgentUuid();
        return ref;
    }

    public SakaiPerson getSakaiPerson(final String agentUuid, final org.sakaiproject.api.common.type.Type recordType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getSakaiPerson(String " + agentUuid + ", Type " + recordType + ")"));
        }
        if (agentUuid == null || agentUuid.length() < 1) {
            throw new IllegalArgumentException("Illegal agentUuid argument passed!");
        }
        if (recordType == null || !this.isSupportedType(recordType)) {
            throw new IllegalArgumentException("Illegal recordType argument passed!");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(SakaiPersonManagerImpl.HQL_FIND_SAKAI_PERSON_BY_AGENT_AND_TYPE);
                q.setParameter(SakaiPersonManagerImpl.AGENT_UUID, (Object)agentUuid, (Type)Hibernate.STRING);
                q.setParameter(SakaiPersonManagerImpl.TYPE_UUID, (Object)recordType.getUuid(), (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        LOG.debug((Object)"return (SakaiPerson) getHibernateTemplate().execute(hcb);");
        SakaiPerson sp = (SakaiPerson)this.getHibernateTemplate().execute(hcb);
        if (this.photoService.overRidesDefault() && sp != null && sp.getTypeUuid().equals(this.getSystemMutableType().getUuid())) {
            sp.setJpegPhoto(this.photoService.getPhotoAsByteArray(sp.getAgentUuid()));
        }
        return sp;
    }

    public Map<String, SakaiPerson> getSakaiPersons(Set<String> userIds, org.sakaiproject.api.common.type.Type recordType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getSakaiPersons(Collection size " + userIds.size() + ", Type " + recordType + ")"));
        }
        if (userIds == null || userIds.size() == 0) {
            throw new IllegalArgumentException("Illegal agentUuid argument passed!");
        }
        if (recordType == null || !this.isSupportedType(recordType)) {
            throw new IllegalArgumentException("Illegal recordType argument passed!");
        }
        int collectionSize = userIds.size();
        ArrayList<String> userIdList = new ArrayList<String>(userIds);
        HashMap<String, SakaiPerson> map = new HashMap<String, SakaiPerson>(collectionSize);
        if (collectionSize > 1000) {
            ArrayList<String> userListChunk = new ArrayList<String>();
            for (int offset = 0; offset < collectionSize; ++offset) {
                if (offset > 0 && offset % 1000 == 0) {
                    List<SakaiPerson> personListChunk = this.listSakaiPersons(userListChunk, recordType);
                    this.addSakaiPersonsToMap(personListChunk, map);
                    userListChunk.clear();
                }
                userListChunk.add((String)userIdList.get(offset));
            }
            if (!userListChunk.isEmpty()) {
                List<SakaiPerson> lastChunk = this.listSakaiPersons(userListChunk, recordType);
                this.addSakaiPersonsToMap(lastChunk, map);
            }
        } else {
            this.addSakaiPersonsToMap(this.listSakaiPersons(userIds, recordType), map);
        }
        return map;
    }

    private void addSakaiPersonsToMap(List<SakaiPerson> sakaiPersons, Map<String, SakaiPerson> map) {
        for (SakaiPerson person : sakaiPersons) {
            map.put(person.getAgentUuid(), person);
        }
    }

    private List<SakaiPerson> listSakaiPersons(final Collection<String> userIds, final org.sakaiproject.api.common.type.Type recordType) {
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(SakaiPersonManagerImpl.HQL_FIND_SAKAI_PERSONS_BY_AGENTS_AND_TYPE);
                q.setParameterList(SakaiPersonManagerImpl.AGENT_UUID_COLLECTION, userIds);
                q.setParameter(SakaiPersonManagerImpl.TYPE_UUID, (Object)recordType.getUuid(), (Type)Hibernate.STRING);
                return q.list();
            }
        };
        List hb = this.getHibernateTemplate().executeFind(hcb);
        if (this.photoService.overRidesDefault()) {
            return this.getDiskPhotosForList(hb);
        }
        return hb;
    }

    public List findSakaiPerson(String simpleSearchCriteria) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findSakaiPerson(String " + simpleSearchCriteria + ")"));
        }
        if (simpleSearchCriteria == null || simpleSearchCriteria.length() < 1) {
            throw new IllegalArgumentException("Illegal simpleSearchCriteria argument passed!");
        }
        final String match = PERCENT_SIGN + simpleSearchCriteria + PERCENT_SIGN;
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(SakaiPersonImpl.class);
                c.add((Criterion)Expression.disjunction().add(Expression.ilike((String)SakaiPersonManagerImpl.UID, (Object)match)).add(Expression.ilike((String)SakaiPersonManagerImpl.GIVENNAME, (Object)match)).add(Expression.ilike((String)SakaiPersonManagerImpl.SURNAME, (Object)match)));
                c.addOrder(Order.asc((String)SakaiPersonManagerImpl.SURNAME));
                return c.list();
            }
        };
        LOG.debug((Object)"return getHibernateTemplate().executeFind(hcb);");
        List hb = this.getHibernateTemplate().executeFind(hcb);
        if (this.photoService.overRidesDefault()) {
            return this.getDiskPhotosForList(hb);
        }
        return hb;
    }

    public void setTypeManager(TypeManager typeManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setTypeManager(TypeManager " + typeManager + ")"));
        }
        this.typeManager = typeManager;
    }

    public org.sakaiproject.api.common.type.Type getUserMutableType() {
        LOG.debug((Object)"getUserMutableType()");
        return this.userMutableType;
    }

    public org.sakaiproject.api.common.type.Type getSystemMutableType() {
        LOG.debug((Object)"getSystemMutableType()");
        return this.systemMutableType;
    }

    public List findSakaiPerson(final SakaiPerson queryByExample) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("findSakaiPerson(SakaiPerson " + queryByExample + ")"));
        }
        if (queryByExample == null) {
            throw new IllegalArgumentException("Illegal queryByExample argument passed!");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria criteria = session.createCriteria(queryByExample.getClass());
                criteria.add((Criterion)Example.create((Object)queryByExample));
                return criteria.list();
            }
        };
        LOG.debug((Object)"return getHibernateTemplate().executeFind(hcb);");
        List hb = this.getHibernateTemplate().executeFind(hcb);
        if (this.photoService.overRidesDefault()) {
            return this.getDiskPhotosForList(hb);
        }
        return hb;
    }

    public void delete(SakaiPerson sakaiPerson) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("delete(SakaiPerson " + sakaiPerson + ")"));
        }
        if (sakaiPerson == null) {
            throw new IllegalArgumentException("Illegal sakaiPerson argument passed!");
        }
        String ref = this.getReference(sakaiPerson);
        if (!SecurityService.unlock((String)"user.del", (String)ref)) {
            throw new SecurityException("You do not have permission to delete this sakaiPerson.");
        }
        LOG.debug((Object)"getHibernateTemplate().delete(sakaiPerson);");
        this.getHibernateTemplate().delete((Object)sakaiPerson);
        this.eventTrackingService.post(this.eventTrackingService.newEvent("profile.delete", ref, true));
    }

    private boolean isSupportedType(org.sakaiproject.api.common.type.Type recordType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isSupportedType(Type " + recordType + ")"));
        }
        if (recordType == null) {
            return false;
        }
        if (this.getUserMutableType().equals(recordType)) {
            return true;
        }
        return this.getSystemMutableType().equals(recordType);
    }

    private boolean isSupportedType(String typeUuid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isSupportedType(String " + typeUuid + ")"));
        }
        if (typeUuid == null) {
            return false;
        }
        if (this.getUserMutableType().getUuid().equals(typeUuid)) {
            return true;
        }
        return this.getSystemMutableType().getUuid().equals(typeUuid);
    }

    public void setPersistableHelper(PersistableHelper persistableHelper) {
        this.persistableHelper = persistableHelper;
    }

    public List isFerpaEnabled(final Collection agentUuids) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isFerpaEnabled(Set " + agentUuids + ")"));
        }
        if (agentUuids == null || agentUuids.isEmpty()) {
            throw new IllegalArgumentException("Illegal Set agentUuids argument!");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(SakaiPersonImpl.class);
                c.add(Expression.in((String)SakaiPersonManagerImpl.AGENT_UUID, (Collection)agentUuids));
                c.add((Criterion)Expression.eq((String)SakaiPersonManagerImpl.FERPA_ENABLED, (Object)Boolean.TRUE));
                return c.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    public List findAllFerpaEnabled() {
        LOG.debug((Object)"findAllFerpaEnabled()");
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Criteria c = session.createCriteria(SakaiPersonImpl.class);
                c.add((Criterion)Expression.eq((String)SakaiPersonManagerImpl.FERPA_ENABLED, (Object)Boolean.TRUE));
                return c.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    private List getDiskPhotosForList(List listIn) {
        ArrayList<SakaiPerson> listOut = new ArrayList<SakaiPerson>();
        for (int i = 0; i < listIn.size(); ++i) {
            SakaiPerson sp = (SakaiPerson)listIn.get(i);
            if (sp.getAgentUuid() != null && sp.getTypeUuid().equals(this.getSystemMutableType().getUuid())) {
                sp.setJpegPhoto(this.photoService.getPhotoAsByteArray(sp.getAgentUuid()));
            }
            listOut.add(sp);
        }
        return listOut;
    }
}

