/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.common.edu.person;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sakaiproject.api.common.edu.person.BasePhotoService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.user.api.UserDirectoryService;
import org.sakaiproject.user.api.UserNotDefinedException;

public class FileSystemPhotoService
extends BasePhotoService {
    private static final Log LOG = LogFactory.getLog(FileSystemPhotoService.class);
    private String photoRepositoryPath = null;
    private ServerConfigurationService serverConfigurationService;
    private UserDirectoryService userDirectoryService;

    public void setServerConfigurationService(ServerConfigurationService scs) {
        this.serverConfigurationService = scs;
    }

    public void setUserDirectoryService(UserDirectoryService userDirectoryService) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("setUserDirectoryService(userDirectoryService " + userDirectoryService + ")"));
        }
        this.userDirectoryService = userDirectoryService;
    }

    public void init() {
        this.photoRepositoryPath = this.serverConfigurationService.getString("profile.photoRepositoryPath", null);
    }

    public byte[] getPhotoAsByteArray(String userId) {
        LOG.debug((Object)("getPhotoAsByteArray(" + userId + ") repo path" + this.photoRepositoryPath));
        return this.getInstitutionalPhotoFromDiskRespository(userId);
    }

    public void savePhoto(byte[] data, String userId) {
        this.savePhotoToDiskRepository(data, userId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getInstitutionalPhotoFromDiskRespository(String uid) {
        LOG.debug((Object)("fetching photo's from: " + this.photoRepositoryPath));
        if (this.photoRepositoryPath != null) {
            FileInputStream fileInput = null;
            try {
                int offset;
                String eid = this.userDirectoryService.getUserEid(uid);
                String photoPath = this.photoRepositoryPath + "/" + eid + ".jpg";
                LOG.debug((Object)("Get photo from disk: " + photoPath));
                File file = new File(photoPath);
                byte[] bytes = new byte[(int)file.length()];
                fileInput = new FileInputStream(file);
                int numRead = 0;
                for (offset = 0; offset < bytes.length && (numRead = fileInput.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
                }
                if (offset < bytes.length) {
                    throw new IOException("Could not completely read file :" + file.getName());
                }
                byte[] byArray = bytes;
                return byArray;
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)("FileNotFoundException: " + e));
            }
            catch (IOException e) {
                LOG.error((Object)("IOException: " + e));
            }
            catch (UserNotDefinedException e) {
                LOG.debug((Object)("UserNotDefinedException: " + (Object)((Object)e)));
            }
            finally {
                try {
                    if (fileInput != null) {
                        fileInput.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Exception in finally block: " + e));
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void savePhotoToDiskRepository(byte[] photo, String uid) {
        if (this.photoRepositoryPath != null) {
            if (photo == null || photo.length == 0) {
                return;
            }
            FileOutputStream fileOutput = null;
            try {
                String eid = this.userDirectoryService.getUserEid(uid);
                String photoPath = this.photoRepositoryPath + "/" + eid + ".jpg";
                fileOutput = new FileOutputStream(photoPath);
                fileOutput.write(photo);
            }
            catch (UserNotDefinedException e) {
                LOG.debug((Object)("UserNotDefinedException: " + (Object)((Object)e)));
            }
            catch (FileNotFoundException e) {
                LOG.debug((Object)("FileNotFoundException: " + e));
            }
            catch (IOException e) {
                LOG.error((Object)("IOException: " + e));
            }
            finally {
                try {
                    if (fileOutput != null) {
                        fileOutput.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)("Exception in finally block: " + e));
                }
            }
        }
    }
}

