/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.common.type;

import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.sakaiproject.api.common.manager.Persistable;
import org.sakaiproject.api.common.type.Type;
import org.sakaiproject.api.common.type.TypeManager;
import org.sakaiproject.component.common.manager.PersistableHelper;
import org.sakaiproject.component.common.type.TypeImpl;
import org.sakaiproject.id.cover.IdManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class TypeManagerImpl
extends HibernateDaoSupport
implements TypeManager {
    private static final Log LOG = LogFactory.getLog(TypeManagerImpl.class);
    private static final String ID = "id";
    private static final String FINDTYPEBYID = "findTypeById";
    private static final String UUID = "uuid";
    private static final String FINDTYPEBYUUID = "findTypeByUuid";
    private static final String AUTHORITY = "authority";
    private static final String DOMAIN = "domain";
    private static final String KEYWORD = "keyword";
    private static final String FINDTYPEBYTUPLE = "findTypeByTuple";
    private boolean cacheFindTypeByTuple = true;
    private boolean cacheFindTypeByUuid = true;
    private boolean cacheFindTypeById = true;
    private PersistableHelper persistableHelper;

    public Type createType(String authority, String domain, String keyword, String displayName, String description) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("createType(String " + authority + ", String " + domain + ", String " + keyword + ", String " + displayName + ", String " + description + ")"));
        }
        if (authority == null || authority.length() < 1) {
            throw new IllegalArgumentException(AUTHORITY);
        }
        if (domain == null || domain.length() < 1) {
            throw new IllegalArgumentException(DOMAIN);
        }
        if (keyword == null || keyword.length() < 1) {
            throw new IllegalArgumentException(KEYWORD);
        }
        if (displayName == null || displayName.length() < 1) {
            throw new IllegalArgumentException("displayName");
        }
        TypeImpl ti = new TypeImpl();
        this.persistableHelper.createPersistableFields((Persistable)ti);
        ti.setUuid(IdManager.createUuid());
        ti.setAuthority(authority);
        ti.setDomain(domain);
        ti.setKeyword(keyword);
        ti.setDisplayName(displayName);
        ti.setDescription(description);
        this.getHibernateTemplate().save((Object)ti);
        return ti;
    }

    public void saveType(Type type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("saveType(Type " + type + ")"));
        }
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (!(type instanceof TypeImpl)) {
            throw new IllegalAccessError("Alternate Type implementations not supported yet.");
        }
        TypeImpl ti = (TypeImpl)type;
        this.persistableHelper.modifyPersistableFields((Persistable)ti);
        this.getHibernateTemplate().saveOrUpdate((Object)ti);
    }

    public Type getType(final String uuid) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getType(String " + uuid + ")"));
        }
        if (uuid == null || uuid.length() < 1) {
            throw new IllegalArgumentException(UUID);
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(TypeManagerImpl.FINDTYPEBYUUID);
                q.setString(TypeManagerImpl.UUID, uuid);
                q.setCacheable(TypeManagerImpl.this.cacheFindTypeByUuid);
                q.setCacheRegion(Type.class.getCanonicalName());
                return q.uniqueResult();
            }
        };
        Type type = (Type)this.getHibernateTemplate().execute(hcb);
        return type;
    }

    public Type getType(final String authority, final String domain, final String keyword) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getType(String " + authority + ", String " + domain + ", String " + keyword + ")"));
        }
        if (authority == null || authority.length() < 1) {
            throw new IllegalArgumentException(AUTHORITY);
        }
        if (domain == null || domain.length() < 1) {
            throw new IllegalArgumentException(DOMAIN);
        }
        if (keyword == null || keyword.length() < 1) {
            throw new IllegalArgumentException(KEYWORD);
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(TypeManagerImpl.FINDTYPEBYTUPLE);
                q.setString(TypeManagerImpl.AUTHORITY, authority);
                q.setString(TypeManagerImpl.DOMAIN, domain);
                q.setString(TypeManagerImpl.KEYWORD, keyword);
                q.setCacheable(TypeManagerImpl.this.cacheFindTypeByTuple);
                q.setCacheRegion(Type.class.getCanonicalName());
                return q.uniqueResult();
            }
        };
        Type type = (Type)this.getHibernateTemplate().execute(hcb);
        return type;
    }

    public void setCacheFindTypeByTuple(boolean cacheFindTypeByTuple) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("setCacheFindTypeByTuple(boolean " + cacheFindTypeByTuple + ")"));
        }
        this.cacheFindTypeByTuple = cacheFindTypeByTuple;
    }

    public void setCacheFindTypeByUuid(boolean cacheFindTypeByUuid) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("setCacheFindTypeByUuid(boolean " + cacheFindTypeByUuid + ")"));
        }
        this.cacheFindTypeByUuid = cacheFindTypeByUuid;
    }

    public void setCacheFindTypeById(boolean cacheFindTypeById) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("setCacheFindTypeById(boolean " + cacheFindTypeById + ")"));
        }
        this.cacheFindTypeById = cacheFindTypeById;
    }

    public void deleteType(Type type) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("deleteType(Type " + type + ")"));
        }
        throw new UnsupportedOperationException("Types should never be deleted!");
    }

    public void setPersistableHelper(PersistableHelper persistableHelper) {
        this.persistableHelper = persistableHelper;
    }
}

