/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.common.edu.person;

import java.util.Observable;
import java.util.Observer;
import org.sakaiproject.api.common.edu.person.SakaiPerson;
import org.sakaiproject.api.common.edu.person.SakaiPersonManager;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.entity.api.EntityManager;
import org.sakaiproject.entity.api.Reference;
import org.sakaiproject.event.api.Event;
import org.sakaiproject.event.api.EventTrackingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SakaiPersonObserver
implements Observer {
    private static Logger log = LoggerFactory.getLogger(SakaiPersonObserver.class);
    private EventTrackingService eventTrackingService;
    private SakaiPersonManager sakaiPersonManager;
    private EntityManager entityManager;
    private ServerConfigurationService serverConfigurationService;

    public void setEventTrackingService(EventTrackingService eventTrackingService) {
        this.eventTrackingService = eventTrackingService;
    }

    public void setSakaiPersonManager(SakaiPersonManager sakaiPersonManager) {
        this.sakaiPersonManager = sakaiPersonManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }

    public void init() {
        log.info("init()");
        if (this.serverConfigurationService.getBoolean("profile.autoCleanUp", true)) {
            this.eventTrackingService.addObserver((Observer)this);
        }
    }

    public void destroy() {
        log.info("destroy()");
        this.eventTrackingService.deleteObserver((Observer)this);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (!(arg instanceof Event)) {
            return;
        }
        Event event = (Event)arg;
        String function = event.getEvent();
        if ("user.del".equals(function)) {
            Reference ref = this.entityManager.newReference(event.getResource());
            String refId = ref.getId();
            SakaiPerson sp = this.sakaiPersonManager.getSakaiPerson(refId, this.sakaiPersonManager.getUserMutableType());
            if (sp != null) {
                this.sakaiPersonManager.delete(sp);
            }
            if ((sp = this.sakaiPersonManager.getSakaiPerson(refId, this.sakaiPersonManager.getSystemMutableType())) != null) {
                this.sakaiPersonManager.delete(sp);
            }
        }
    }
}

