/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.common.manager;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import org.apache.commons.beanutils.PropertyUtils;
import org.sakaiproject.api.common.manager.Persistable;
import org.sakaiproject.tool.api.Session;
import org.sakaiproject.tool.api.SessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistableHelper {
    private static final String SYSTEM = "SYSTEM";
    private static final Logger LOG = LoggerFactory.getLogger(PersistableHelper.class);
    private static final String LASTMODIFIEDDATE = "lastModifiedDate";
    private static final String LASTMODIFIEDBY = "lastModifiedBy";
    private static final String CREATEDDATE = "createdDate";
    private static final String CREATEDBY = "createdBy";
    private SessionManager sessionManager;

    public void modifyPersistableFields(Persistable persistable) {
        Date now = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug("modifyPersistableFields(Persistable " + persistable + ")");
        }
        if (persistable == null) {
            throw new IllegalArgumentException("Illegal persistable argument passed!");
        }
        try {
            String actor = this.getActor();
            PropertyUtils.setProperty((Object)persistable, (String)LASTMODIFIEDBY, (Object)actor);
            PropertyUtils.setProperty((Object)persistable, (String)LASTMODIFIEDDATE, (Object)now);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    public void createPersistableFields(Persistable persistable) {
        Date now = new Date();
        if (LOG.isDebugEnabled()) {
            LOG.debug("modifyPersistableFields(Persistable " + persistable + ")");
        }
        if (persistable == null) {
            throw new IllegalArgumentException("Illegal persistable argument passed!");
        }
        try {
            String actor = this.getActor();
            PropertyUtils.setProperty((Object)persistable, (String)LASTMODIFIEDBY, (Object)actor);
            PropertyUtils.setProperty((Object)persistable, (String)LASTMODIFIEDDATE, (Object)now);
            PropertyUtils.setProperty((Object)persistable, (String)CREATEDBY, (Object)actor);
            PropertyUtils.setProperty((Object)persistable, (String)CREATEDDATE, (Object)now);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private String getActor() {
        LOG.debug("getActor()");
        String actor = null;
        Session session = this.sessionManager.getCurrentSession();
        if (session == null) {
            return SYSTEM;
        }
        actor = session.getUserId();
        if (actor == null || actor.length() < 1) {
            return SYSTEM;
        }
        return actor;
    }

    public void setSessionManager(SessionManager sessionManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("setSessionManager(SessionManager " + sessionManager + ")");
        }
        this.sessionManager = sessionManager;
    }
}

