/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.BasicImportMetadata;
import org.sakaiproject.importer.impl.IMSFileParser;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.Folder;
import org.sakaiproject.importer.impl.importables.HtmlDocument;
import org.sakaiproject.importer.impl.translators.Bb55AnnouncementTranslator;
import org.sakaiproject.importer.impl.translators.Bb55AssessmentTranslator;
import org.sakaiproject.importer.impl.translators.Bb55DocumentTranslator;
import org.sakaiproject.importer.impl.translators.Bb55ExternalLinkTranslator;
import org.sakaiproject.importer.impl.translators.Bb55QuestionPoolTranslator;
import org.sakaiproject.importer.impl.translators.Bb55StaffInfoTranslator;
import org.sakaiproject.importer.impl.translators.Bb55SurveyTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Blackboard55FileParser
extends IMSFileParser {
    public static final String ASSESSMENT_GROUP = "Assessments";
    public static final String ANNOUNCEMENT_GROUP = "Announcements";

    public Blackboard55FileParser() {
        this.addResourceTranslator(new Bb55AnnouncementTranslator());
        this.addResourceTranslator(new Bb55StaffInfoTranslator());
        this.addResourceTranslator(new Bb55ExternalLinkTranslator());
        this.addResourceTranslator(new Bb55DocumentTranslator());
        this.addResourceTranslator(new Bb55QuestionPoolTranslator());
        this.addResourceTranslator(new Bb55AssessmentTranslator());
        this.addResourceTranslator(new Bb55SurveyTranslator());
        this.resourceHelper = new Bb55ResourceHelper();
        this.itemHelper = new Bb55ItemHelper();
        this.fileHelper = new Bb55FileHelper();
        this.manifestHelper = new Bb55ManifestHelper();
    }

    public boolean isValidArchive(InputStream fileData) {
        if (super.isValidArchive(fileData)) {
            Document manifest = this.extractFileAsDOM("/imsmanifest.xml", fileData);
            return XPathHelper.selectNodes((String)"/manifest/organizations/tableofcontents/item", (Object)manifest).size() > 0 || XPathHelper.selectNodes((String)"/manifest/resources/resource", (Object)manifest).size() > 0 || XPathHelper.selectNodes((String)"/manifest/organization/tableofcontents/item", (Object)manifest).size() > 0;
        }
        return false;
    }

    protected Collection getCategoriesFromArchive(String pathToData) {
        BasicImportMetadata im;
        ArrayList<BasicImportMetadata> categories = new ArrayList<BasicImportMetadata>();
        List topLevelItems = this.manifestHelper.getTopLevelItemNodes(this.archiveManifest);
        for (Node topLevelItem : topLevelItems) {
            im = new BasicImportMetadata();
            im.setId(this.itemHelper.getId(topLevelItem));
            im.setLegacyTool(this.itemHelper.getTitle(topLevelItem));
            im.setMandatory(false);
            im.setFileName(".xml");
            im.setSakaiServiceName("ContentHostingService");
            im.setSakaiTool("Resources");
            categories.add(im);
        }
        if (XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-quiz']", (Object)this.archiveManifest).size() + XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-pool']", (Object)this.archiveManifest).size() + XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-survey']", (Object)this.archiveManifest).size() > 0) {
            im = new BasicImportMetadata();
            im.setId("assessments");
            im.setLegacyTool(ASSESSMENT_GROUP);
            im.setMandatory(false);
            im.setFileName(".xml");
            im.setSakaiTool("Tests & Quizzes");
            categories.add(im);
        }
        if (XPathHelper.selectNodes((String)"//resource[@type='resource/x-bb-announcement']", (Object)this.archiveManifest).size() > 0) {
            im = new BasicImportMetadata();
            im.setId("announcements");
            im.setLegacyTool(ANNOUNCEMENT_GROUP);
            im.setMandatory(false);
            im.setFileName(".xml");
            im.setSakaiTool(ANNOUNCEMENT_GROUP);
            categories.add(im);
        }
        return categories;
    }

    protected boolean isFolder(Document resourceDescriptor) {
        return "true".equals(XPathHelper.getNodeValue((String)"//ISFOLDER/@value", (Node)resourceDescriptor));
    }

    protected boolean isCompoundDocument(Node node, Document resourceDescriptor) {
        return "resource/x-bb-document".equals(XPathHelper.getNodeValue((String)"./@type", (Node)node)) && node.hasChildNodes() && node.getChildNodes().getLength() > 1;
    }

    protected boolean wantsCompanionForCompoundDocument() {
        return true;
    }

    protected Importable getCompanionForCompoundDocument(Document resourceDescriptor, Folder folder) {
        HtmlDocument html = new HtmlDocument();
        StringBuffer content = new StringBuffer();
        List linkFileNodes = XPathHelper.selectNodes((String)"//FILEREF/FILEACTION[@value='link']/parent::node()", (Object)resourceDescriptor);
        List embedFileNodes = XPathHelper.selectNodes((String)"//FILEREF/FILEACTION[@value='embed']/parent::node()", (Object)resourceDescriptor);
        String documentText = XPathHelper.getNodeValue((String)"//TEXT", (Node)resourceDescriptor);
        content.append("<html>\n");
        content.append("  <head><title>" + folder.getTitle() + "</title></head>\n");
        content.append("  <body>\n");
        content.append("    <p>" + documentText + "</p>\n");
        for (Node fileNode : embedFileNodes) {
            content.append(this.imgTagFromFileNode(fileNode, folder.getTitle()) + "<br/>\n");
        }
        if (linkFileNodes.size() > 0) {
            content.append("    <table border=\"1\">\n");
            for (Node fileNode : linkFileNodes) {
                String fileName = XPathHelper.getNodeValue((String)"./RELFILE/@value", (Node)fileNode);
                content.append("      <tr><td><a href=\"" + folder.getTitle() + "/" + fileName + "\">" + fileName + "</a></td></tr>\n");
            }
            content.append("    </table>\n");
        }
        content.append("  </body>\n");
        content.append("</html>");
        html.setContent(content.toString());
        html.setTitle(folder.getTitle());
        html.setContextPath(folder.getPath() + folder.getTitle() + "_manifest");
        html.setLegacyGroup(folder.getLegacyGroup());
        html.setSequenceNum(folder.getSequenceNum() - 1);
        return html;
    }

    private String imgTagFromFileNode(Node fileNode, String folder) {
        String src = folder + "/" + XPathHelper.getNodeValue((String)"./RELFILE/@value", (Node)fileNode);
        String height = XPathHelper.getNodeValue((String)"./REGISTRY/REGISTRYENTRY[@key='height']/@value", (Node)fileNode);
        String width = XPathHelper.getNodeValue((String)"./REGISTRY/REGISTRYENTRY[@key='width']/@value", (Node)fileNode);
        String alt = XPathHelper.getNodeValue((String)"./REGISTRY/REGISTRYENTRY[@key='alttext']/@value", (Node)fileNode);
        String align = XPathHelper.getNodeValue((String)"./REGISTRY/REGISTRYENTRY[@key='alignment']/@value", (Node)fileNode);
        String link = XPathHelper.getNodeValue((String)"./REGISTRY/REGISTRYENTRY[@key='hyperlink']/@value", (Node)fileNode);
        String imgTag = "<img src=\"" + src + "\" height=\"" + height + "\" width=\"" + width + "\" align=\"" + align + "\" alt=\"" + alt + "\" />";
        if ("http://".equals(link)) {
            return imgTag;
        }
        String target = "N".equals(XPathHelper.getNodeValue((String)"./REGISTRY/REGISTRYENTRY[@key='launchinnewwindow']/@value", (Node)fileNode)) ? "_top" : "_blank";
        return "<a href=\"" + link + "\" target=\"" + target + "\">" + imgTag + "</a>";
    }

    protected String getFilePathForNode(Node node) {
        String basePath = XPathHelper.getNodeValue((String)"./attribute::baseurl", (Node)node.getParentNode());
        String fileName = XPathHelper.getNodeValue((String)"./attribute::href", (Node)node);
        return basePath + "/" + fileName;
    }

    protected String getFilenameForNode(Node node) {
        String sourceFilePath = XPathHelper.getNodeValue((String)"./attribute::href", (Node)node);
        return sourceFilePath.lastIndexOf("/") < 0 ? sourceFilePath : sourceFilePath.substring(sourceFilePath.lastIndexOf("/") + 1);
    }

    public ImportFileParser newParser() {
        return new Blackboard55FileParser();
    }

    protected class Bb55FileHelper
    extends IMSFileParser.FileHelper {
        protected Bb55FileHelper() {
            super((IMSFileParser)Blackboard55FileParser.this);
        }

        public byte[] getFileBytesForNode(Node node, String contextPath) throws IOException {
            String basePath = XPathHelper.getNodeValue((String)"./@baseurl", (Node)node.getParentNode());
            String fileName = XPathHelper.getNodeValue((String)"./@href", (Node)node);
            String filePath = basePath + "/" + fileName;
            return Blackboard55FileParser.this.getBytesFromFile(new File(Blackboard55FileParser.this.pathToData + "/" + filePath));
        }
    }

    protected class Bb55ManifestHelper
    extends IMSFileParser.ManifestHelper {
        protected Bb55ManifestHelper() {
        }

        public List getItemNodes(Document manifest) {
            return XPathHelper.selectNodes((String)"//item", (Object)manifest);
        }

        public Node getResourceForId(String resourceId, Document manifest) {
            return XPathHelper.selectNode((String)("//resource[@identifier='" + resourceId + "']"), (Object)Blackboard55FileParser.this.archiveManifest);
        }

        public List getResourceNodes(Document manifest) {
            return XPathHelper.selectNodes((String)"//resource", (Object)manifest);
        }

        public List getTopLevelItemNodes(Document manifest) {
            return XPathHelper.selectNodes((String)"//tableofcontents/item", (Object)manifest);
        }
    }

    protected class Bb55ItemHelper
    extends IMSFileParser.ItemHelper {
        protected Bb55ItemHelper() {
        }

        public String getId(Node itemNode) {
            return XPathHelper.getNodeValue((String)"./@identifier", (Node)itemNode);
        }

        public String getTitle(Node itemNode) {
            return XPathHelper.getNodeValue((String)"./@title", (Node)itemNode);
        }

        public String getDescription(Node itemNode) {
            String resourceId = XPathHelper.getNodeValue((String)"./@identifierref", (Node)itemNode);
            Node resourceNode = Blackboard55FileParser.this.manifestHelper.getResourceForId(resourceId, Blackboard55FileParser.this.archiveManifest);
            return Blackboard55FileParser.this.resourceHelper.getDescription(resourceNode);
        }
    }

    protected class Bb55ResourceHelper
    extends IMSFileParser.ResourceHelper {
        protected Bb55ResourceHelper() {
        }

        public String getTitle(Node resourceNode) {
            Document descriptor = this.getDescriptor(resourceNode);
            return XPathHelper.getNodeValue((String)"/CONTENT/TITLE", (Node)descriptor);
        }

        public String getType(Node resourceNode) {
            return XPathHelper.getNodeValue((String)"./@type", (Node)resourceNode);
        }

        public String getId(Node resourceNode) {
            return XPathHelper.getNodeValue((String)"./@identifier", (Node)resourceNode);
        }

        public Document getDescriptor(Node resourceNode) {
            String descriptorFilename = XPathHelper.getNodeValue((String)"./@file", (Node)resourceNode);
            try {
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                FileInputStream fis = new FileInputStream(Blackboard55FileParser.this.pathToData + "/" + descriptorFilename);
                return docBuilder.parse(fis);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getDescription(Node resourceNode) {
            Document descriptor = Blackboard55FileParser.this.resourceHelper.getDescriptor(resourceNode);
            String desc = XPathHelper.getNodeValue((String)"//TEXT", (Node)descriptor);
            return desc;
        }

        public boolean isFolder(Document resourceDescriptor) {
            return "true".equals(XPathHelper.getNodeValue((String)"/CONTENT/FLAGS/ISFOLDER/@value", (Node)resourceDescriptor));
        }
    }
}

