/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.translators;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.Assessment;
import org.sakaiproject.importer.impl.importables.AssessmentAnswer;
import org.sakaiproject.importer.impl.importables.AssessmentQuestion;
import org.sakaiproject.importer.impl.importables.FileResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Bb55AssessmentTranslator
implements IMSResourceTranslator {
    private final String rootElement = "ASSESSMENT";

    public String getTypeName() {
        return "assessment/x-bb-quiz";
    }

    public Importable translate(Node resourceNode, Document descriptor, String contextPath, String archiveBasePath) {
        Assessment rv = this.newImportable();
        rv.setDescription(this.cleanUpCharacters(XPathHelper.getNodeValue((String)("/" + this.rootElement() + "/DESCRIPTION/TEXT"), (Node)descriptor)));
        rv.setTitle(this.cleanUpCharacters(XPathHelper.getNodeValue((String)("/" + this.rootElement() + "/TITLE/@value"), (Node)descriptor)));
        List multiChoiceNodes = XPathHelper.selectNodes((String)"//QUESTION_MULTIPLECHOICE", (Object)descriptor);
        List essayNodes = XPathHelper.selectNodes((String)"//QUESTION_ESSAY", (Object)descriptor);
        List fillTheBlankNodes = XPathHelper.selectNodes((String)"//QUESTION_FILLINBLANK", (Object)descriptor);
        List matchingNodes = XPathHelper.selectNodes((String)"//QUESTION_MATCH", (Object)descriptor);
        List multiAnswerNodes = XPathHelper.selectNodes((String)"//QUESTION_MULTIPLEANSWER", (Object)descriptor);
        List orderingNodes = XPathHelper.selectNodes((String)"//QUESTION_ORDER", (Object)descriptor);
        List trueFalseNodes = XPathHelper.selectNodes((String)"//QUESTION_TRUEFALSE", (Object)descriptor);
        int totalNumberOfQuestions = multiChoiceNodes.size() + essayNodes.size() + fillTheBlankNodes.size() + matchingNodes.size() + multiAnswerNodes.size() + orderingNodes.size() + trueFalseNodes.size();
        if (totalNumberOfQuestions < 1) {
            return null;
        }
        rv.setMultiChoiceQuestions(this.getQuestionsFromNodes(multiChoiceNodes, AssessmentQuestion.MULTIPLE_CHOICE));
        rv.setEssayQuestions(this.getQuestionsFromNodes(essayNodes, AssessmentQuestion.ESSAY));
        rv.setFillBlankQuestions(this.getQuestionsFromNodes(fillTheBlankNodes, AssessmentQuestion.FILL_BLANK));
        rv.setMatchQuestions(this.getQuestionsFromNodes(matchingNodes, AssessmentQuestion.MATCHING));
        rv.setMultiAnswerQuestions(this.getQuestionsFromNodes(multiAnswerNodes, AssessmentQuestion.MULTIPLE_ANSWER));
        rv.setOrderingQuestions(this.getQuestionsFromNodes(orderingNodes, AssessmentQuestion.ORDERING));
        rv.setTrueFalseQuestions(this.getQuestionsFromNodes(trueFalseNodes, AssessmentQuestion.TRUE_FALSE));
        rv.setLegacyGroup("Assessments");
        return rv;
    }

    private List getAttachments(Node resourceNode, Document descriptor, String archiveBasePath) throws IOException {
        ArrayList<FileResource> rv = new ArrayList<FileResource>();
        List fileNodes = XPathHelper.selectNodes((String)"//FILEREF", (Object)descriptor);
        for (Node fileNode : fileNodes) {
            String relFile = XPathHelper.getNodeValue((String)"./RELFILE/@value", (Node)fileNode);
            String filePath = archiveBasePath + "/" + XPathHelper.getNodeValue((String)"./CONTENTID/@value", (Node)fileNode) + "/" + relFile;
            FileResource attachment = new FileResource();
            attachment.setInputStream((InputStream)new FileInputStream(filePath));
            attachment.setFileName(relFile.substring(relFile.lastIndexOf("/") + 1));
            rv.add(attachment);
        }
        return rv;
    }

    public boolean processResourceChildren() {
        return false;
    }

    private List getQuestionsFromNodes(List questionNodes, int questionType) {
        ArrayList<AssessmentQuestion> rv = new ArrayList<AssessmentQuestion>();
        Iterator i = questionNodes.iterator();
        while (i.hasNext()) {
            AssessmentQuestion q = new AssessmentQuestion();
            HashMap<String, AssessmentAnswer> answers = new HashMap<String, AssessmentAnswer>();
            Node questionNode = (Node)i.next();
            String questionId = XPathHelper.getNodeValue((String)"./@id", (Node)questionNode);
            int questionPosition = XPathHelper.selectNodes((String)("../QUESTIONLIST/QUESTION[@id='" + questionId + "']/preceding-sibling::QUESTION"), (Object)questionNode).size() + 1;
            q.setPosition(new Integer(questionPosition));
            List answerNodes = XPathHelper.selectNodes((String)"./ANSWER", (Object)questionNode);
            Iterator j = answerNodes.iterator();
            while (j.hasNext()) {
                AssessmentAnswer a = new AssessmentAnswer();
                Node answerNode = (Node)j.next();
                a.setAnswerId(XPathHelper.getNodeValue((String)"./@id", (Node)answerNode));
                try {
                    a.setPosition(Integer.parseInt(XPathHelper.getNodeValue((String)"./@position", (Node)answerNode)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Object answerText = XPathHelper.getNodeValue((String)"./TEXT", (Node)answerNode);
                if (XPathHelper.selectNode((String)"./IMAGE", (Object)answerNode) != null) {
                    answerText = (String)answerText + "\n<p>\n  " + this.createHtmlImageReference(XPathHelper.selectNode((String)"./IMAGE", (Object)answerNode), XPathHelper.getNodeValue((String)"./IMAGE/@style", (Node)answerNode)) + "\n</p>";
                }
                answerText = this.cleanUpCharacters((String)answerText);
                a.setAnswerText((String)answerText);
                answers.put(a.getAnswerId(), a);
            }
            if (questionType == AssessmentQuestion.MATCHING) {
                HashMap<String, AssessmentAnswer> choices = new HashMap<String, AssessmentAnswer>();
                List choiceNodes = XPathHelper.selectNodes((String)"./CHOICE", (Object)questionNode);
                Iterator j2 = choiceNodes.iterator();
                while (j2.hasNext()) {
                    AssessmentAnswer c = new AssessmentAnswer();
                    Node choiceNode = (Node)j2.next();
                    c.setAnswerId(XPathHelper.getNodeValue((String)"./@id", (Node)choiceNode));
                    try {
                        c.setPosition(Integer.parseInt(XPathHelper.getNodeValue((String)"./@position", (Node)choiceNode)));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    String matchingAnswerText = XPathHelper.getNodeValue((String)"./TEXT", (Node)choiceNode);
                    c.setAnswerText(this.cleanUpCharacters(matchingAnswerText));
                    choices.put(c.getAnswerId(), c);
                }
                q.setChoices(choices);
            }
            q.setQuestionType(questionType);
            q.setAnswers(answers);
            Object questionTextString = XPathHelper.getNodeValue((String)"./BODY/TEXT", (Node)questionNode);
            questionTextString = this.cleanUpCharacters((String)questionTextString);
            if (XPathHelper.selectNode((String)"./IMAGE", (Object)questionNode) != null) {
                questionTextString = (String)questionTextString + "\n<p>\n  " + this.createHtmlImageReference(XPathHelper.selectNode((String)"./IMAGE", (Object)questionNode), XPathHelper.getNodeValue((String)"./IMAGE/@style", (Node)questionNode)) + "\n</p>";
            }
            q.setQuestionText((String)questionTextString);
            try {
                Double pointValue = Double.parseDouble(XPathHelper.getNodeValue((String)("../QUESTIONLIST/QUESTION[@id='" + questionId + "']/@points"), (Node)questionNode));
                q.setPointValue(pointValue);
            }
            catch (NumberFormatException e) {
                q.setPointValue(new Double(1.0));
            }
            List correctAnswerNodes = XPathHelper.selectNodes((String)"./GRADABLE/CORRECTANSWER", (Object)questionNode);
            HashSet<String> correctAnswerIDs = new HashSet<String>();
            for (Node correctAnswerNode : correctAnswerNodes) {
                String correctAnswerId = XPathHelper.getNodeValue((String)"./@answer_id", (Node)correctAnswerNode);
                correctAnswerIDs.add(correctAnswerId);
                ((AssessmentAnswer)answers.get(correctAnswerId)).setChoiceId(XPathHelper.getNodeValue((String)"./@choice_id", (Node)correctAnswerNode));
            }
            q.setCorrectAnswerIDs(correctAnswerIDs);
            q.setFeedbackWhenCorrect(this.cleanUpCharacters(XPathHelper.getNodeValue((String)"./GRADABLE/FEEDBACK_WHEN_CORRECT", (Node)questionNode)));
            q.setFeedbackWhenIncorrect(this.cleanUpCharacters(XPathHelper.getNodeValue((String)"./GRADABLE/FEEDBACK_WHEN_INCORRECT", (Node)questionNode)));
            rv.add(q);
        }
        return rv;
    }

    private String cleanUpCharacters(String questionTextString) {
        String rv = new String(questionTextString);
        char leftSingleQuote = '\u0091';
        char rightSingleQuote = '\u0092';
        char leftDoubleQuote = '\u0093';
        char rightDoubleQuote = '\u0094';
        char enDash = '\u0096';
        char dash = '-';
        char apos = '\u0092';
        char apostrophe = '\'';
        char doubleQuote = '\"';
        rv = rv.replace(enDash, dash);
        rv = rv.replace(apos, apostrophe);
        rv = rv.replace(leftSingleQuote, apostrophe);
        rv = rv.replace(rightSingleQuote, apostrophe);
        rv = rv.replace(leftDoubleQuote, doubleQuote);
        rv = rv.replace(rightDoubleQuote, doubleQuote);
        return rv;
    }

    private String createHtmlImageReference(Node imageNode, String referenceType) {
        String imageFileName = XPathHelper.getNodeValue((String)"./@source", (Node)imageNode);
        if ("link".equals(referenceType)) {
            return "<a href=\"" + imageFileName + "\" target=\"_blank\">Link to file</a>";
        }
        if ("embed".equals(referenceType)) {
            return "<img src=\"" + imageFileName + "\" alt=\"" + imageFileName + "\" />";
        }
        return "";
    }

    protected Assessment newImportable() {
        return new Assessment();
    }

    protected String rootElement() {
        return "ASSESSMENT";
    }

    protected byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            // empty if block
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }
}

