/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.translators;

import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.importables.Assessment;
import org.springframework.core.io.ClassPathResource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class Bb6QtiTranslator
implements IMSResourceTranslator {
    private static final String xsl = "org/sakaiproject/importer/xml/Bb2Qti.xsl";

    public String getTypeName() {
        return "assessment/x-bb-qti-test";
    }

    public Importable translate(Node resourceNode, Document descriptor, String contextPath, String archiveBasePath) {
        Assessment rv = new Assessment();
        Document stylesheet = this.readDocument(xsl);
        rv.setQti(Bb6QtiTranslator.transformDocument(descriptor, stylesheet));
        rv.setVersion("1.2");
        rv.setLegacyGroup("Assessments");
        return rv;
    }

    public boolean processResourceChildren() {
        return false;
    }

    public static Document transformDocument(Document document, Document stylesheet) {
        Document transformedDoc = null;
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        try {
            builderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            builderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            builderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            DocumentBuilder documentBuilder = builderFactory.newDocumentBuilder();
            transformedDoc = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        DOMSource docSource = new DOMSource(document);
        DOMResult docResult = new DOMResult(transformedDoc);
        DOMSource xslSource = new DOMSource(stylesheet);
        Transformer transformer = null;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            transformer = transformerFactory.newTransformer(xslSource);
            transformer.transform(docSource, docResult);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return transformedDoc;
    }

    public Document readDocument(String name) {
        InputSource inputSource;
        InputStreamReader in;
        DocumentBuilder docBuilder;
        Document doc = null;
        ClassPathResource resource = new ClassPathResource(name);
        try {
            docBuilder = this.getDocumentBuilder();
            InputStream inStream = resource.getInputStream();
            doc = docBuilder.parse(inStream);
        }
        catch (Exception e) {
            doc = null;
        }
        if (doc != null) {
            return doc;
        }
        try {
            docBuilder = this.getDocumentBuilder();
            in = new InputStreamReader(resource.getInputStream(), "ISO-8859-1");
            inputSource = new InputSource(in);
            doc = docBuilder.parse(inputSource);
        }
        catch (Exception any) {
            doc = null;
        }
        if (doc != null) {
            return doc;
        }
        try {
            docBuilder = this.getDocumentBuilder();
            in = new InputStreamReader(resource.getInputStream(), "UTF-8");
            inputSource = new InputSource(in);
            doc = docBuilder.parse(inputSource);
        }
        catch (Exception any) {
            any.printStackTrace();
            doc = null;
        }
        return doc;
    }

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        return dbf.newDocumentBuilder();
    }
}

