/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.translators;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.Announcement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class Bb6AnnouncementTranslator
implements IMSResourceTranslator {
    private static Logger log = LoggerFactory.getLogger(Bb6AnnouncementTranslator.class);

    public String getTypeName() {
        return "resource/x-bb-announcement";
    }

    public Importable translate(Node resourceNode, Document descriptor, String contextPath, String archiveBasePath) {
        Date d;
        Announcement item = new Announcement();
        item.setLegacyGroup(item.getDisplayType());
        SimpleDateFormat df = new SimpleDateFormat("yyyy-mm-dd hh:mm:ss zzz");
        String bbid = XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/@id", (Node)descriptor);
        item.setTitle(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/TITLE/@value", (Node)descriptor));
        item.setDescription(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/DESCRIPTION/TEXT", (Node)descriptor));
        item.setHtml(Boolean.getBoolean(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/FLAGS/ISHTML/@value", (Node)descriptor)));
        item.setLiternalNewline(Boolean.getBoolean(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/FLAGS/ISNEWLINELITERAL/@value", (Node)descriptor)));
        item.setPermanent(Boolean.getBoolean(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/ISPERMANENT/@value", (Node)descriptor)));
        try {
            d = df.parse(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/DATES/RESTRICTSTART/@value", (Node)descriptor));
            item.setStart(d);
        }
        catch (ParseException e) {
            log.warn("Could not parse date startdate for " + bbid + ": " + e.toString());
        }
        try {
            d = df.parse(XPathHelper.getNodeValue((String)"/ANNOUNCEMENT/DATES/RESTRICTEND/@value", (Node)descriptor));
            item.setEnd(d);
        }
        catch (ParseException e) {
            log.warn("Could not parse date enddate for " + bbid + ": " + e.toString());
        }
        log.info("Translation complete for BB6 announcement item:" + bbid);
        log.debug("Announcement item: " + item.toString());
        item.setLegacyGroup("Announcements");
        return item;
    }

    public boolean processResourceChildren() {
        return false;
    }
}

