/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.translators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.Assessment;
import org.sakaiproject.importer.impl.importables.AssessmentAnswer;
import org.sakaiproject.importer.impl.importables.AssessmentQuestion;
import org.sakaiproject.util.Validator;

public class Bb6AssessmentTranslator
implements IMSResourceTranslator {
    private static final String IMG_PATTERN = "(.*/)*.+\\.(png|jpg|gif|bmp|jpeg|PNG|JPG|GIF|BMP|JPEG)$";
    private Pattern imgPattern = Pattern.compile("(.*/)*.+\\.(png|jpg|gif|bmp|jpeg|PNG|JPG|GIF|BMP|JPEG)$");

    public String getTypeName() {
        return "assessment/x-bb-qti-test";
    }

    public Importable translate(org.w3c.dom.Node resourceNode, org.w3c.dom.Document descriptor, String contextPath, String archiveBasePath) {
        Assessment rv = this.newImportable();
        rv.setDescription(XPathHelper.getNodeValue((String)"/questestinterop/assessment/presentation_material/flow_mat/material/mat_extension/mat_formattedtext", (org.w3c.dom.Node)descriptor));
        rv.setTitle(XPathHelper.getNodeValue((String)"/questestinterop/assessment/@title", (org.w3c.dom.Node)descriptor));
        List multiChoiceNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'Multiple Choice']/ancestor::item", (Object)descriptor);
        List essayNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'Essay']/ancestor::item", (Object)descriptor);
        List fillTheBlankNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'Fill in the Blank']/ancestor::item", (Object)descriptor);
        List matchingNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'Matching']/ancestor::item", (Object)descriptor);
        List multiAnswerNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'Multiple Answer']/ancestor::item", (Object)descriptor);
        List orderingNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'Ordering']/ancestor::item", (Object)descriptor);
        List trueFalseNodes = XPathHelper.selectNodes((String)"//item/itemmetadata/bbmd_questiontype[. = 'True/False']/ancestor::item", (Object)descriptor);
        int totalNumberOfQuestions = multiChoiceNodes.size() + essayNodes.size() + fillTheBlankNodes.size() + matchingNodes.size() + multiAnswerNodes.size() + orderingNodes.size() + trueFalseNodes.size();
        if (totalNumberOfQuestions < 1) {
            return null;
        }
        rv.setMultiChoiceQuestions(this.getQuestionsFromNodes(multiChoiceNodes, AssessmentQuestion.MULTIPLE_CHOICE));
        rv.setEssayQuestions(this.getQuestionsFromNodes(essayNodes, AssessmentQuestion.ESSAY));
        rv.setFillBlankQuestions(this.getQuestionsFromNodes(fillTheBlankNodes, AssessmentQuestion.FILL_BLANK));
        rv.setMatchQuestions(this.getQuestionsFromNodes(matchingNodes, AssessmentQuestion.MATCHING));
        rv.setMultiAnswerQuestions(this.getQuestionsFromNodes(multiAnswerNodes, AssessmentQuestion.MULTIPLE_ANSWER));
        rv.setOrderingQuestions(this.getQuestionsFromNodes(orderingNodes, AssessmentQuestion.ORDERING));
        rv.setTrueFalseQuestions(this.getQuestionsFromNodes(trueFalseNodes, AssessmentQuestion.TRUE_FALSE));
        rv.setLegacyGroup("Assessments");
        return rv;
    }

    protected Assessment newImportable() {
        return new Assessment();
    }

    public boolean processResourceChildren() {
        return true;
    }

    private List getQuestionsFromNodes(List questionNodes, int questionType) {
        ArrayList<AssessmentQuestion> rv = new ArrayList<AssessmentQuestion>();
        Iterator i = questionNodes.iterator();
        while (i.hasNext()) {
            org.w3c.dom.Node answerNode;
            AssessmentAnswer a;
            AssessmentQuestion q = new AssessmentQuestion();
            HashMap<String, AssessmentAnswer> answers = new HashMap<String, AssessmentAnswer>();
            HashSet<String> correctAnswerIDs = new HashSet<String>();
            org.w3c.dom.Node questionNode = (org.w3c.dom.Node)i.next();
            int questionPosition = XPathHelper.selectNodes((String)"./preceding-sibling::item", (Object)questionNode).size() + 1;
            q.setPosition(new Integer(questionPosition));
            List answerNodes = null;
            if (questionType == AssessmentQuestion.MATCHING) {
                answerNodes = XPathHelper.selectNodes((String)"./presentation//flow[@class='RESPONSE_BLOCK']/flow[@class='Block']", (Object)questionNode);
                HashMap<String, AssessmentAnswer> choices = new HashMap<String, AssessmentAnswer>();
                int choicesSize = XPathHelper.selectNodes((String)"./presentation//flow[@class='RIGHT_MATCH_BLOCK']/flow[@class='Block']", (Object)questionNode).size();
                int answerPosition = 0;
                Iterator j = answerNodes.iterator();
                while (j.hasNext()) {
                    a = new AssessmentAnswer();
                    answerNode = (org.w3c.dom.Node)j.next();
                    a.setAnswerId(XPathHelper.getNodeValue((String)"./response_lid/@ident", (org.w3c.dom.Node)answerNode));
                    a.setPosition(++answerPosition);
                    String answerText = XPathHelper.getNodeValue((String)".//mat_formattedtext[1]", (org.w3c.dom.Node)answerNode);
                    String answerImageText = this.getAnswerImageText(answerNode);
                    if (!"".equals(answerImageText)) {
                        answerText = new StringBuffer(answerText + "\n").append("<img src=\"" + answerImageText + "\"/>").toString();
                    }
                    a.setAnswerText(Bb6AssessmentTranslator.stripHTMLComments(answerText));
                    AssessmentAnswer c = new AssessmentAnswer();
                    c.setAnswerId(XPathHelper.getNodeValue((String)("./resprocessing//varequal[@respident='" + a.getAnswerId() + "']"), (org.w3c.dom.Node)questionNode));
                    for (int k = 1; k <= choicesSize; ++k) {
                        if (!c.getAnswerId().equals(XPathHelper.getNodeValue((String)("./response_lid/render_choice/flow_label/response_label[" + k + "]/@ident"), (org.w3c.dom.Node)answerNode))) continue;
                        String choiceText = XPathHelper.getNodeValue((String)("./presentation//flow[@class='RIGHT_MATCH_BLOCK']/flow[" + k + "]//mat_formattedtext"), (org.w3c.dom.Node)questionNode);
                        String choiceImageText = this.getChoiceImageText(questionNode, k);
                        if (!"".equals(choiceImageText)) {
                            choiceText = new StringBuffer(choiceText + "\n").append("<img src=\"" + choiceImageText + "\"/>").toString();
                        }
                        c.setAnswerText(Bb6AssessmentTranslator.stripHTMLComments(choiceText));
                        c.setPosition(k - 1);
                        choices.put(c.getAnswerId(), c);
                        a.setChoiceId(c.getAnswerId());
                        break;
                    }
                    correctAnswerIDs.add(a.getAnswerId());
                    answers.put(a.getAnswerId(), a);
                }
                q.setChoices(choices);
            } else if (questionType == AssessmentQuestion.ESSAY) {
                a = new AssessmentAnswer();
                a.setAnswerId(XPathHelper.getNodeValue((String)"./itemmetadata/bbmd_asi_object_id", (org.w3c.dom.Node)questionNode));
                a.setAnswerText(Bb6AssessmentTranslator.stripHTMLComments(XPathHelper.getNodeValue((String)"./itemfeedback[@ident='solution']//mat_formattedtext[1]", (org.w3c.dom.Node)questionNode)));
                correctAnswerIDs.add(a.getAnswerId());
                answers.put(a.getAnswerId(), a);
            } else if (questionType == AssessmentQuestion.FILL_BLANK) {
                answerNodes = XPathHelper.selectNodes((String)"./resprocessing/respcondition/conditionvar/varequal[@respident='response']/ancestor::respcondition", (Object)questionNode);
                Iterator j = answerNodes.iterator();
                while (j.hasNext()) {
                    a = new AssessmentAnswer();
                    answerNode = (org.w3c.dom.Node)j.next();
                    a.setAnswerId(XPathHelper.getNodeValue((String)"./@title", (org.w3c.dom.Node)answerNode));
                    a.setAnswerText(Bb6AssessmentTranslator.stripHTMLComments(XPathHelper.getNodeValue((String)"./conditionvar/varequal", (org.w3c.dom.Node)answerNode)));
                    answers.put(a.getAnswerId(), a);
                }
                List correctAnswerNodes = null;
                correctAnswerNodes = XPathHelper.selectNodes((String)"./resprocessing/respcondition/conditionvar/varequal", (Object)questionNode);
                for (org.w3c.dom.Node correctAnswerNode : correctAnswerNodes) {
                    String correctAnswerId = XPathHelper.getNodeValue((String)".", (org.w3c.dom.Node)correctAnswerNode);
                    if ("".equals(correctAnswerId)) continue;
                    correctAnswerIDs.add(correctAnswerId);
                }
            } else {
                answerNodes = XPathHelper.selectNodes((String)"./presentation//flow[@class='RESPONSE_BLOCK']//response_label", (Object)questionNode);
                int position = 0;
                Iterator j = answerNodes.iterator();
                while (j.hasNext()) {
                    a = new AssessmentAnswer();
                    answerNode = (org.w3c.dom.Node)j.next();
                    a.setAnswerId(XPathHelper.getNodeValue((String)"./@ident", (org.w3c.dom.Node)answerNode));
                    a.setPosition(++position);
                    String answerText = XPathHelper.getNodeValue((String)".//mat_formattedtext[1]", (org.w3c.dom.Node)answerNode);
                    String answerImageText = this.getAnswerImageText(answerNode);
                    if (!"".equals(answerImageText)) {
                        answerText = new StringBuffer(answerText + "\n").append("<img src=\"" + answerImageText + "\"/>").toString();
                    }
                    if (answerText == null || "".equals(answerText)) {
                        answerText = XPathHelper.getNodeValue((String)".//mattext[1]", (org.w3c.dom.Node)answerNode);
                    }
                    if (answerText != null && questionType == AssessmentQuestion.MULTIPLE_CHOICE) {
                        answerText = answerText.trim().replaceAll("(?i)^<p>(.*)</p>$", "$1");
                        answerText = answerText.trim().replaceAll("(?i)<br[ /]*>$", "");
                    }
                    a.setAnswerText(Bb6AssessmentTranslator.stripHTMLComments(answerText));
                    answers.put(a.getAnswerId(), a);
                }
                List correctAnswerNodes = null;
                if (questionType == AssessmentQuestion.MULTIPLE_ANSWER) {
                    correctAnswerNodes = XPathHelper.selectNodes((String)"./resprocessing/respcondition[@title='correct']/conditionvar/and/varequal", (Object)questionNode);
                } else {
                    correctAnswerNodes = XPathHelper.selectNodes((String)"./resprocessing/respcondition[@title='correct']/conditionvar/varequal", (Object)questionNode);
                    if (correctAnswerNodes == null || correctAnswerNodes.size() < 1) {
                        correctAnswerNodes = XPathHelper.selectNodes((String)"./resprocessing/respcondition/displayfeedback[@linkrefid='correct']/../conditionvar/varequal", (Object)questionNode);
                    }
                }
                for (org.w3c.dom.Node correctAnswerNode : correctAnswerNodes) {
                    String correctAnswerId = XPathHelper.getNodeValue((String)".", (org.w3c.dom.Node)correctAnswerNode);
                    if ("".equals(correctAnswerId)) continue;
                    if (correctAnswerId.equalsIgnoreCase("true") || correctAnswerId.equalsIgnoreCase("false")) {
                        for (Object o : answers.values()) {
                            a = (AssessmentAnswer)o;
                            if (!a.getAnswerText().equalsIgnoreCase(correctAnswerId)) continue;
                            correctAnswerId = a.getAnswerId();
                        }
                    }
                    correctAnswerIDs.add(correctAnswerId);
                }
            }
            q.setQuestionType(questionType);
            q.setAnswers(answers);
            String questionTextString = XPathHelper.getNodeValue((String)"./presentation//flow[@class='FORMATTED_TEXT_BLOCK']//mat_formattedtext[1]", (org.w3c.dom.Node)questionNode);
            if (questionType == AssessmentQuestion.FILL_BLANK && questionTextString.indexOf("__") < 0) {
                questionTextString = questionTextString + " ____";
            }
            String questionResourceEmbed = this.getResourceEmbed(questionNode);
            q.setQuestionText(Bb6AssessmentTranslator.stripHTMLComments(questionTextString + questionResourceEmbed));
            try {
                double pointValue = Double.parseDouble(XPathHelper.getNodeValue((String)"./itemmetadata/qmd_absolutescore_max", (org.w3c.dom.Node)questionNode));
                if (pointValue < 0.0) {
                    pointValue = Double.parseDouble(XPathHelper.getNodeValue((String)"./resprocessing/outcomes/decvar/@maxvalue", (org.w3c.dom.Node)questionNode));
                }
                q.setPointValue(Double.valueOf(pointValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            q.setCorrectAnswerIDs(correctAnswerIDs);
            q.setFeedbackWhenCorrect(Bb6AssessmentTranslator.stripHTMLComments(XPathHelper.getNodeValue((String)"./itemfeedback[@ident = 'correct']//mat_formattedtext[1]", (org.w3c.dom.Node)questionNode)));
            q.setFeedbackWhenIncorrect(Bb6AssessmentTranslator.stripHTMLComments(XPathHelper.getNodeValue((String)"./itemfeedback[@ident = 'incorrect']//mat_formattedtext[1]", (org.w3c.dom.Node)questionNode)));
            rv.add(q);
        }
        return rv;
    }

    protected String getChoiceImageText(org.w3c.dom.Node questionNode, int choiceNum) {
        String imageUri = XPathHelper.getNodeValue((String)("./presentation//flow[@class='RIGHT_MATCH_BLOCK']/flow[" + choiceNum + "]//matapplication[1]/@uri"), (org.w3c.dom.Node)questionNode);
        return imageUri.replaceAll("\\\\", "/");
    }

    protected String getAnswerImageText(org.w3c.dom.Node answerNode) {
        String imageUri = XPathHelper.getNodeValue((String)".//matapplication[1]/@uri", (org.w3c.dom.Node)answerNode);
        return imageUri.replaceAll("\\\\", "/");
    }

    protected String getResourceEmbed(org.w3c.dom.Node questionNode) {
        String uri = XPathHelper.getNodeValue((String)"./presentation/flow/flow[@class='QUESTION_BLOCK']/flow[@class='FILE_BLOCK']/material/matapplication[1]/@uri", (org.w3c.dom.Node)questionNode);
        uri = uri.replaceAll("\\\\", "/");
        Object[] subPath = uri.split(Pattern.quote("/"));
        System.out.println("s:" + Arrays.toString(subPath));
        Object fileName = subPath[subPath.length - 1];
        String cleanedFileName = Validator.escapeResourceName((String)fileName);
        uri = uri.replaceAll((String)fileName, cleanedFileName);
        System.out.println("replacing: " + (String)fileName + "::" + cleanedFileName + "::" + uri);
        Matcher matcher = this.imgPattern.matcher(uri);
        if (matcher.matches()) {
            return "\n<br/><img alt=\"\" src=\"" + uri + "\" />";
        }
        if (!"".equals(uri)) {
            String label = XPathHelper.getNodeValue((String)"./presentation/flow/flow[@class='QUESTION_BLOCK']/flow[@class='FILE_BLOCK']/material/matapplication[1]/@label", (org.w3c.dom.Node)questionNode);
            if ("".equals(label)) {
                label = "Document Link";
            }
            return "\n<br/><br/><IMG SRC=\"/library/image/silk/report.png\" alt=\"\" />&nbsp;<a href=\"" + uri + "\">" + label + "</a>";
        }
        return "";
    }

    private static String stripHTMLComments(String html) {
        if (html == null) {
            return null;
        }
        Document doc = Jsoup.parseBodyFragment((String)html);
        ArrayList<Document> nodes = new ArrayList<Document>();
        ArrayList<Node> comments = new ArrayList<Node>();
        nodes.add(doc);
        while (!nodes.isEmpty()) {
            Node node = (Node)nodes.remove(0);
            if (node instanceof Comment) {
                comments.add(node);
                continue;
            }
            nodes.addAll(node.childNodes());
        }
        for (Node victim : comments) {
            victim.remove();
        }
        return doc.body().html();
    }
}

