/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.translators;

import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.Folder;
import org.sakaiproject.importer.impl.importables.TextDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Bb6SmartTextDocumentTranslator
implements IMSResourceTranslator {
    public String getTypeName() {
        return "resource/x-bb-document-smart-text";
    }

    public Importable translate(Node resourceNode, Document descriptor, String contextPath, String archiveBasePath) {
        String content = XPathHelper.getNodeValue((String)"/CONTENT/BODY/TEXT", (Node)descriptor);
        String title = XPathHelper.getNodeValue((String)"/CONTENT/TITLE/@value", (Node)descriptor).trim().replaceAll("\\<.*?\\>", "").replaceAll("/", "_");
        int priority = Integer.parseInt(((Element)resourceNode).getAttribute("priority"));
        content.replaceAll("&quot;", "\"");
        contextPath = (String)contextPath + title;
        if (!XPathHelper.selectNode((String)"/CONTENT/FILES", (Object)descriptor).hasChildNodes()) {
            TextDocument text = new TextDocument();
            text.setContent(content);
            text.setTitle(title);
            text.setContextPath((String)contextPath);
            text.setSequenceNum(priority);
            return text;
        }
        Folder folder = new Folder();
        folder.setDescription(content);
        folder.setTitle(title);
        folder.setPath((String)contextPath);
        folder.setSequenceNum(priority);
        return folder;
    }

    public boolean processResourceChildren() {
        return true;
    }
}

