/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.sakaiproject.importer.api.ImportFileParser;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.BasicImportMetadata;
import org.sakaiproject.importer.impl.IMSFileParser;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.Folder;
import org.sakaiproject.importer.impl.importables.HtmlDocument;
import org.sakaiproject.importer.impl.translators.Bb6AnnouncementTranslator;
import org.sakaiproject.importer.impl.translators.Bb6AssessmentAttemptFilesTranslator;
import org.sakaiproject.importer.impl.translators.Bb6AssessmentAttemptTranslator;
import org.sakaiproject.importer.impl.translators.Bb6AssessmentTranslator;
import org.sakaiproject.importer.impl.translators.Bb6CollabSessionTranslator;
import org.sakaiproject.importer.impl.translators.Bb6CourseMembershipTranslator;
import org.sakaiproject.importer.impl.translators.Bb6CourseUploadsTranslator;
import org.sakaiproject.importer.impl.translators.Bb6DiscussionBoardTranslator;
import org.sakaiproject.importer.impl.translators.Bb6ExternalLinkTranslator;
import org.sakaiproject.importer.impl.translators.Bb6GroupUploadsTranslator;
import org.sakaiproject.importer.impl.translators.Bb6HTMLDocumentTranslator;
import org.sakaiproject.importer.impl.translators.Bb6QuestionPoolTranslator;
import org.sakaiproject.importer.impl.translators.Bb6SmartTextDocumentTranslator;
import org.sakaiproject.importer.impl.translators.Bb6StaffInfoTranslator;
import org.sakaiproject.importer.impl.translators.Bb6SurveyTranslator;
import org.sakaiproject.importer.impl.translators.Bb6TextDocumentTranslator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Blackboard6FileParser
extends IMSFileParser {
    public static final String ASSESSMENT_GROUP = "Assessments";
    public static final String ANNOUNCEMENT_GROUP = "Announcements";
    public static final String ASSESSMENT_FILES_DIRECTORY = "TQimages";

    public Blackboard6FileParser() {
        this.addResourceTranslator(new Bb6AnnouncementTranslator());
        this.addResourceTranslator(new Bb6AssessmentTranslator());
        this.addResourceTranslator(new Bb6QuestionPoolTranslator());
        this.addResourceTranslator(new Bb6SurveyTranslator());
        this.addResourceTranslator(new Bb6AssessmentAttemptTranslator());
        this.addResourceTranslator(new Bb6StaffInfoTranslator());
        this.addResourceTranslator(new Bb6HTMLDocumentTranslator());
        this.addResourceTranslator(new Bb6TextDocumentTranslator());
        this.addResourceTranslator(new Bb6SmartTextDocumentTranslator());
        this.addResourceTranslator(new Bb6ExternalLinkTranslator());
        this.addResourceTranslator(new Bb6CollabSessionTranslator());
        this.addResourceTranslator(new Bb6AssessmentAttemptFilesTranslator());
        this.addResourceTranslator(new Bb6CourseUploadsTranslator());
        this.addResourceTranslator(new Bb6GroupUploadsTranslator());
        this.addResourceTranslator(new Bb6CourseMembershipTranslator());
        this.addResourceTranslator(new Bb6DiscussionBoardTranslator());
        this.resourceHelper = new Bb6ResourceHelper();
        this.itemHelper = new Bb6ItemHelper();
        this.fileHelper = new Bb6FileHelper();
        this.manifestHelper = new Bb6ManifestHelper();
    }

    public boolean isValidArchive(InputStream fileData) {
        if (super.isValidArchive(fileData)) {
            Document manifest = this.extractFileAsDOM("/imsmanifest.xml", fileData);
            NodeList nl = manifest.getElementsByTagName("manifest");
            if (nl.getLength() > 0) {
                Element node = (Element)nl.item(0);
                String url = node.getAttribute("xmlns:bb");
                if (url == null || !url.equals("http://www.blackboard.com/content-packaging/")) {
                    return false;
                }
            } else {
                return false;
            }
            return XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-quiz']", (Object)manifest).size() + XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-pool']", (Object)manifest).size() + XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-survey']", (Object)manifest).size() == 0 || XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-qti-test']", (Object)manifest).size() + XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-qti-pool']", (Object)manifest).size() > 0;
        }
        return false;
    }

    protected boolean isCompoundDocument(Node node, Document resourceDescriptor) {
        return "resource/x-bb-document".equals(XPathHelper.getNodeValue((String)"./@type", (Node)node)) && node.hasChildNodes() && node.getChildNodes().getLength() > 1;
    }

    protected Importable getCompanionForCompoundDocument(Document resourceDescriptor, Folder folder) {
        HtmlDocument html = new HtmlDocument();
        StringBuffer content = new StringBuffer();
        List fileNodes = XPathHelper.selectNodes((String)"/CONTENT/FILES/FILE", (Object)resourceDescriptor);
        content.append("<html>\n");
        content.append("  <head><title>" + folder.getTitle() + "</title></head>\n");
        content.append("  <body>\n");
        content.append("    <p>" + XPathHelper.getNodeValue((String)"/CONTENT/BODY/TEXT", (Node)resourceDescriptor) + "</p>\n");
        content.append("    <table border=\"1\">\n");
        for (Node fileNode : fileNodes) {
            String fileName = XPathHelper.getNodeValue((String)"./NAME", (Node)fileNode);
            content.append("      <tr><td><a href=\"" + folder.getTitle() + "/" + fileName + "\">" + fileName + "</a></td></tr>\n");
        }
        content.append("    </table>\n");
        content.append("  </body>\n");
        content.append("</html>");
        html.setContent(content.toString());
        html.setTitle(folder.getTitle());
        html.setContextPath(folder.getPath() + folder.getTitle() + "_manifest");
        html.setLegacyGroup(folder.getLegacyGroup());
        html.setSequenceNum(folder.getSequenceNum() - 1);
        return html;
    }

    protected boolean wantsCompanionForCompoundDocument() {
        return true;
    }

    protected Collection getCategoriesFromArchive(String pathToData) {
        BasicImportMetadata im;
        ArrayList<BasicImportMetadata> categories = new ArrayList<BasicImportMetadata>();
        List topLevelItems = this.manifestHelper.getTopLevelItemNodes(this.archiveManifest);
        for (Node topLevelItem : topLevelItems) {
            String resourceId = XPathHelper.getNodeValue((String)"./@identifierref", (Node)topLevelItem);
            Node resourceNode = this.manifestHelper.getResourceForId(resourceId, this.archiveManifest);
            String targetType = XPathHelper.getNodeValue((String)"/COURSETOC/TARGETTYPE/@value", (Node)this.resourceHelper.getDescriptor(resourceNode));
            if (!"CONTENT".equals(targetType) && !"STAFF_INFO".equals(targetType)) continue;
            im = new BasicImportMetadata();
            im.setId(this.itemHelper.getId(topLevelItem));
            im.setLegacyTool(this.itemHelper.getTitle(topLevelItem));
            im.setMandatory(false);
            im.setFileName(".xml");
            im.setSakaiServiceName("ContentHostingService");
            im.setSakaiTool("Resources");
            categories.add(im);
        }
        if (XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-qti-test']", (Object)this.archiveManifest).size() + XPathHelper.selectNodes((String)"//resource[@type='assessment/x-bb-qti-pool']", (Object)this.archiveManifest).size() > 0) {
            im = new BasicImportMetadata();
            im.setId("assessments");
            im.setLegacyTool(ASSESSMENT_GROUP);
            im.setMandatory(false);
            im.setFileName(".xml");
            im.setSakaiTool("Tests & Quizzes");
            categories.add(im);
        }
        if (XPathHelper.selectNodes((String)"//resource[@type='resource/x-bb-announcement']", (Object)this.archiveManifest).size() > 0) {
            im = new BasicImportMetadata();
            im.setId("announcements");
            im.setLegacyTool(ANNOUNCEMENT_GROUP);
            im.setMandatory(false);
            im.setFileName(".xml");
            im.setSakaiTool(ANNOUNCEMENT_GROUP);
            categories.add(im);
        }
        return categories;
    }

    public ImportFileParser newParser() {
        return new Blackboard6FileParser();
    }

    protected class Bb6FileHelper
    extends IMSFileParser.FileHelper {
        protected Bb6FileHelper() {
            super((IMSFileParser)Blackboard6FileParser.this);
        }

        public byte[] getFileBytesForNode(Node node, String contextPath) throws IOException {
            String basePath = XPathHelper.getNodeValue((String)"./@identifier", (Node)node.getParentNode());
            String fileHref = XPathHelper.getNodeValue((String)"./@href", (Node)node).replaceAll("\\\\", "/");
            String filePath = basePath + "/" + fileHref;
            return Blackboard6FileParser.this.getBytesFromFile(new File(Blackboard6FileParser.this.pathToData + "/" + filePath));
        }

        public String getFilePathForNode(Node node, String contextPath) {
            String parentType = XPathHelper.getNodeValue((String)"../@type", (Node)node);
            if ("assessment/x-bb-qti-pool".equals(parentType) || "assessment/x-bb-qti-test".equals(parentType)) {
                contextPath = (String)contextPath + "/TQimages";
            }
            String fileHref = XPathHelper.getNodeValue((String)"./@href", (Node)node);
            return (String)contextPath + "/" + fileHref.replaceAll("\\\\", "/");
        }
    }

    protected class Bb6ManifestHelper
    extends IMSFileParser.ManifestHelper {
        protected Bb6ManifestHelper() {
        }

        public List getItemNodes(Document manifest) {
            return XPathHelper.selectNodes((String)"//item", (Object)manifest);
        }

        public Node getResourceForId(String resourceId, Document manifest) {
            return XPathHelper.selectNode((String)("//resource[@identifier='" + resourceId + "']"), (Object)Blackboard6FileParser.this.archiveManifest);
        }

        public List getResourceNodes(Document manifest) {
            return XPathHelper.selectNodes((String)"//resource", (Object)manifest);
        }

        public List getTopLevelItemNodes(Document manifest) {
            return XPathHelper.selectNodes((String)"//organization/item", (Object)manifest);
        }
    }

    protected class Bb6ItemHelper
    extends IMSFileParser.ItemHelper {
        protected Bb6ItemHelper() {
        }

        public String getId(Node itemNode) {
            return XPathHelper.getNodeValue((String)"./@identifier", (Node)itemNode);
        }

        public String getTitle(Node itemNode) {
            return XPathHelper.getNodeValue((String)"./title", (Node)itemNode);
        }

        public String getDescription(Node itemNode) {
            String resourceId = XPathHelper.getNodeValue((String)"./@identifierref", (Node)itemNode);
            Node resourceNode = Blackboard6FileParser.this.manifestHelper.getResourceForId(resourceId, Blackboard6FileParser.this.archiveManifest);
            return Blackboard6FileParser.this.resourceHelper.getDescription(resourceNode);
        }
    }

    protected class Bb6ResourceHelper
    extends IMSFileParser.ResourceHelper {
        protected Bb6ResourceHelper() {
        }

        public String getTitle(Node resourceNode) {
            return resourceNode.getAttributes().getNamedItem("bb:title").getNodeValue().replaceAll("/", "_");
        }

        public String getType(Node resourceNode) {
            String nodeType = XPathHelper.getNodeValue((String)"./@type", (Node)resourceNode);
            if ("resource/x-bb-document".equals(nodeType)) {
                if (resourceNode.hasChildNodes()) {
                    return nodeType;
                }
                String subType = XPathHelper.getNodeValue((String)"/CONTENT/CONTENTHANDLER/@value", (Node)Blackboard6FileParser.this.resourceHelper.getDescriptor(resourceNode));
                if ("resource/x-bb-externallink".equals(subType)) {
                    nodeType = "resource/x-bb-externallink";
                } else if ("resource/x-bb-asmt-test-link".equals(subType)) {
                    nodeType = "resource/x-bb-asmt-test-link";
                } else {
                    String docType = XPathHelper.getNodeValue((String)"/CONTENT/BODY/TYPE/@value", (Node)Blackboard6FileParser.this.resourceHelper.getDescriptor(resourceNode));
                    if ("H".equals(docType)) {
                        nodeType = "resource/x-bb-document-html";
                    } else if ("P".equals(docType)) {
                        nodeType = "resource/x-bb-document-plain-text";
                    } else if ("S".equals(docType)) {
                        nodeType = "resource/x-bb-document-smart-text";
                    }
                }
            }
            return nodeType;
        }

        public String getId(Node resourceNode) {
            return XPathHelper.getNodeValue((String)"./@identifier", (Node)resourceNode);
        }

        public Document getDescriptor(Node resourceNode) {
            try {
                String descriptorFilename = resourceNode.getAttributes().getNamedItem("bb:file").getNodeValue();
                DocumentBuilder docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                FileInputStream fis = new FileInputStream(Blackboard6FileParser.this.pathToData + "/" + descriptorFilename);
                return docBuilder.parse(fis);
            }
            catch (Exception e) {
                return null;
            }
        }

        public String getDescription(Node resourceNode) {
            Document descriptor = Blackboard6FileParser.this.resourceHelper.getDescriptor(resourceNode);
            return XPathHelper.getNodeValue((String)"/CONTENT/BODY/TEXT", (Node)descriptor);
        }

        public boolean isFolder(Document resourceDescriptor) {
            return "true".equals(XPathHelper.getNodeValue((String)"/CONTENT/FLAGS/ISFOLDER/@value", (Node)resourceDescriptor));
        }
    }
}

