/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.translators;

import org.sakaiproject.importer.api.IMSResourceTranslator;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.XPathHelper;
import org.sakaiproject.importer.impl.importables.HtmlDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Bb6StaffInfoTranslator
implements IMSResourceTranslator {
    public String getTypeName() {
        return "resource/x-bb-staffinfo";
    }

    public Importable translate(Node resourceNode, Document descriptor, String contextPath, String archiveBasePath) {
        HtmlDocument rv = new HtmlDocument();
        String lastName = XPathHelper.getNodeValue((String)"/STAFFINFO/CONTACT/NAME/FAMILY/@value", (Node)descriptor);
        String firstName = XPathHelper.getNodeValue((String)"/STAFFINFO/CONTACT/NAME/GIVEN/@value", (Node)descriptor);
        String email = XPathHelper.getNodeValue((String)"/STAFFINFO/CONTACT/EMAIL/@value", (Node)descriptor);
        String phone = XPathHelper.getNodeValue((String)"/STAFFINFO/CONTACT/PHONE/@value", (Node)descriptor);
        String bio = XPathHelper.getNodeValue((String)"/STAFFINFO/BIOGRAPHY/TEXT", (Node)descriptor);
        String address = XPathHelper.getNodeValue((String)"/STAFFINFO/CONTACT/OFFICE/ADDRESS/@value", (Node)descriptor);
        String hours = XPathHelper.getNodeValue((String)"/STAFFINFO/CONTACT/OFFICE/HOURS/@value", (Node)descriptor);
        String image = XPathHelper.getNodeValue((String)"/STAFFINFO/IMAGE/@value", (Node)descriptor);
        String homepage = XPathHelper.getNodeValue((String)"/STAFFINFO/HOMEPAGE/@value", (Node)descriptor);
        String title = firstName + " " + lastName;
        int priority = Integer.parseInt(((Element)resourceNode).getAttribute("priority"));
        StringBuffer page = new StringBuffer();
        page.append("<html><head><title>" + title + "</title></head>\n");
        page.append("<body><h1>" + title + "</h1>\n");
        page.append("<p>" + bio + "</p>\n");
        page.append("<p>email: <a href=\"mailto:" + email + "\">" + email + "</a></p>\n");
        page.append("<p>phone: " + phone + "</p>\n");
        page.append("<p>office: " + address + "</p>\n");
        page.append("<p>hours: " + hours + "</p>\n");
        page.append("<p>homepage: <a href=\"" + homepage + "\">" + homepage + "</a></p>\n");
        if (image != null && !"".equals(image)) {
            page.append("<img src='" + image + "' />\n");
        }
        page.append("</body></html>\n");
        contextPath = (String)contextPath + title;
        rv.setContent(page.toString().replaceAll("&lt;", "<"));
        rv.setTitle(title);
        rv.setContextPath((String)contextPath);
        rv.setSequenceNum(priority);
        return rv;
    }

    public boolean processResourceChildren() {
        return true;
    }
}

