/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.importer.impl.handlers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.activation.MimetypesFileTypeMap;
import org.sakaiproject.authz.api.SecurityAdvisor;
import org.sakaiproject.authz.api.SecurityService;
import org.sakaiproject.component.api.ServerConfigurationService;
import org.sakaiproject.content.api.ContentHostingService;
import org.sakaiproject.content.api.ContentResource;
import org.sakaiproject.content.api.ContentResourceEdit;
import org.sakaiproject.entity.api.ResourceProperties;
import org.sakaiproject.entity.api.ResourcePropertiesEdit;
import org.sakaiproject.exception.IdInvalidException;
import org.sakaiproject.exception.IdUnusedException;
import org.sakaiproject.exception.IdUsedException;
import org.sakaiproject.exception.InUseException;
import org.sakaiproject.exception.InconsistentException;
import org.sakaiproject.exception.OverQuotaException;
import org.sakaiproject.exception.PermissionException;
import org.sakaiproject.exception.ServerOverloadException;
import org.sakaiproject.exception.TypeException;
import org.sakaiproject.importer.api.HandlesImportable;
import org.sakaiproject.importer.api.Importable;
import org.sakaiproject.importer.impl.importables.FileResource;
import org.sakaiproject.importer.impl.importables.Folder;
import org.sakaiproject.importer.impl.importables.HtmlDocument;
import org.sakaiproject.importer.impl.importables.TextDocument;
import org.sakaiproject.importer.impl.importables.WebLink;
import org.sakaiproject.tool.api.SessionManager;
import org.sakaiproject.util.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesHandler
implements HandlesImportable {
    private static final Logger log = LoggerFactory.getLogger(ResourcesHandler.class);
    private static final String COPYRIGHT = "(c) 2007";
    private final int BUFFER = 2048;
    private ContentHostingService contentHostingService;
    private SessionManager sessionManager;
    private SecurityService securityService;
    private ServerConfigurationService serverConfigurationService;

    public boolean canHandleType(String typeName) {
        return "sakai-file-resource".equals(typeName) || "sakai-folder".equals(typeName) || "sakai-text-document".equals(typeName) || "sakai-html-document".equals(typeName) || "sakai-web-link".equals(typeName) || "sakai-learning-module".equals(typeName);
    }

    public void handle(Importable thing, String siteId) {
        if (this.canHandleType(thing.getTypeName())) {
            final String currentUser = this.sessionManager.getCurrentSessionUserId();
            this.securityService.pushAdvisor(new SecurityAdvisor(){

                public SecurityAdvisor.SecurityAdvice isAllowed(String userId, String function, String reference) {
                    if (userId != null && userId.equals(currentUser) && ("content.new".equals(function) || "content.read".equals(function))) {
                        return SecurityAdvisor.SecurityAdvice.ALLOWED;
                    }
                    return SecurityAdvisor.SecurityAdvice.PASS;
                }
            });
            Object id = null;
            String contentType = null;
            int notifyOption = 0;
            String title = null;
            String description = null;
            HashMap<String, String> resourceProps = new HashMap<String, String>();
            InputStream contents = null;
            if ("sakai-file-resource".equals(thing.getTypeName())) {
                description = ((FileResource)thing).getDescription();
                String fileName = ((FileResource)thing).getFileName();
                id = this.contentHostingService.getSiteCollection(siteId);
                Object contextPath = ((FileResource)thing).getDestinationResourcePath();
                if (contextPath != null && ((String)contextPath).length() + ((String)id).length() > 255) {
                    contextPath = ((String)contextPath).substring(0, 241 - ((String)id).length());
                    SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
                    contextPath = (String)contextPath + f.format((Object)new Date());
                }
                id = (String)id + (String)contextPath;
                contentType = new MimetypesFileTypeMap().getContentType(fileName);
                contents = ((FileResource)thing).getInputStream();
                title = fileName;
                resourceProps.put("CHEF:description", description);
                if (title.toLowerCase().endsWith(".zip")) {
                    String container = title.substring(0, title.length() - 4);
                    resourceProps.put("DAV:displayname", container);
                    String path = ((String)id).substring(0, ((String)id).length() - title.length());
                    this.addContentCollection(path + container, resourceProps);
                    this.addAllResources(contents, path + container, notifyOption);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("import ResourcesHandler about to add file entitled '{}'", (Object)title);
                    }
                    resourceProps.put("DAV:displayname", title);
                    this.addContentResource((String)id, contentType, contents, resourceProps, notifyOption);
                }
            } else if ("sakai-web-link".equals(thing.getTypeName())) {
                ContentResource contentResource;
                title = ((WebLink)thing).getTitle();
                description = ((WebLink)thing).getDescription();
                id = this.contentHostingService.getSiteCollection(siteId) + thing.getContextPath();
                contentType = "text/url";
                Object absoluteUrl = "";
                absoluteUrl = ((WebLink)thing).isAbsolute() ? ((WebLink)thing).getUrl() : this.serverConfigurationService.getServerUrl() + "/access/content" + this.contentHostingService.getSiteCollection(siteId) + ((WebLink)thing).getUrl();
                contents = new ByteArrayInputStream(((String)absoluteUrl).getBytes());
                if (title == null || title.equals("")) {
                    title = ((WebLink)thing).getUrl();
                }
                resourceProps.put("DAV:displayname", title);
                resourceProps.put("CHEF:description", description);
                resourceProps.put("SAKAI:has_custom_sort", Boolean.TRUE.toString());
                resourceProps.put("SAKAI:content_priority", Integer.toString(((WebLink)thing).getSequenceNum()));
                if (log.isDebugEnabled()) {
                    log.debug("import ResourcesHandler about to add web link entitled '{}'", (Object)title);
                }
                if ((contentResource = this.addContentResource((String)id, contentType, contents, resourceProps, notifyOption)) != null) {
                    try {
                        ContentResourceEdit cre = this.contentHostingService.editResource(contentResource.getId());
                        cre.setResourceType("org.sakaiproject.content.types.urlResource");
                        this.contentHostingService.commitResource(cre, notifyOption);
                    }
                    catch (Exception e1) {
                        log.error("import ResourcesHandler tried to set Resource Type of web link and failed", (Throwable)e1);
                    }
                }
            } else if ("sakai-html-document".equals(thing.getTypeName())) {
                title = ((HtmlDocument)thing).getTitle();
                contents = new ByteArrayInputStream(((HtmlDocument)thing).getContent().getBytes());
                id = this.contentHostingService.getSiteCollection(siteId) + thing.getContextPath();
                contentType = "text/html";
                resourceProps.put("DAV:displayname", title);
                if (log.isDebugEnabled()) {
                    log.debug("import ResourcesHandler about to add html document entitled '{}'", (Object)title);
                }
                this.addContentResource((String)id, contentType, contents, resourceProps, notifyOption);
            } else if ("sakai-text-document".equals(thing.getTypeName())) {
                title = ((TextDocument)thing).getTitle();
                contents = new ByteArrayInputStream(((TextDocument)thing).getContent().getBytes());
                id = this.contentHostingService.getSiteCollection(siteId) + thing.getContextPath();
                contentType = "text/plain";
                resourceProps.put("DAV:displayname", title);
                if (log.isDebugEnabled()) {
                    log.debug("import ResourcesHandler about to add text document entitled '{}'", (Object)title);
                }
                this.addContentResource((String)id, contentType, contents, resourceProps, notifyOption);
            } else if ("sakai-folder".equals(thing.getTypeName())) {
                title = ((Folder)thing).getTitle();
                description = ((Folder)thing).getDescription();
                resourceProps.put("DAV:displayname", title);
                resourceProps.put("CHEF:description", description);
                resourceProps.put("CHEF:copyright", COPYRIGHT);
                String path = this.contentHostingService.getSiteCollection(siteId) + ((Folder)thing).getPath();
                this.addContentCollection(path, resourceProps);
            }
            this.securityService.popAdvisor();
        }
    }

    protected void addAllResources(InputStream archive, String path, int notifyOption) {
        ZipInputStream zipStream = new ZipInputStream(archive);
        if (((String)path).charAt(0) == '/') {
            path = ((String)path).substring(1);
        }
        if (!((String)path).endsWith("/")) {
            path = (String)path + "/";
        }
        try {
            ZipEntry entry;
            while ((entry = zipStream.getNextEntry()) != null) {
                int count;
                HashMap<String, String> resourceProps = new HashMap<String, String>();
                String contentType = new MimetypesFileTypeMap().getContentType(entry.getName());
                String title = entry.getName();
                if (title.lastIndexOf("/") > 0) {
                    title = title.substring(title.lastIndexOf("/") + 1);
                }
                resourceProps.put("DAV:displayname", title);
                resourceProps.put("CHEF:copyright", COPYRIGHT);
                if (log.isDebugEnabled()) {
                    log.debug("import ResourcesHandler about to add file entitled '{}'", (Object)title);
                }
                ByteArrayOutputStream contents = new ByteArrayOutputStream();
                byte[] data = new byte[2048];
                while ((count = zipStream.read(data, 0, 2048)) != -1) {
                    contents.write(data, 0, count);
                }
                if (entry.isDirectory()) {
                    this.addContentCollection((String)path + entry.getName(), resourceProps);
                    this.addAllResources(new ByteArrayInputStream(contents.toByteArray()), (String)path + entry.getName(), notifyOption);
                    continue;
                }
                this.addContentResource((String)path + entry.getName(), contentType, new ByteArrayInputStream(contents.toByteArray()), resourceProps, notifyOption);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    protected ContentResource addContentResource(String id, String contentType, InputStream contents, Map properties, int notifyOption) {
        try {
            id = this.makeIdCleanAndLengthCompliant(id);
            ResourcePropertiesEdit resourceProps = this.contentHostingService.newResourceProperties();
            Set keys = properties.keySet();
            for (String key : keys) {
                String value = (String)properties.get(key);
                resourceProps.addProperty(key, value);
            }
            String enclosingDirectory = id.substring(0, id.lastIndexOf(47, id.length() - 2) + 1);
            if (this.existsDirectory(enclosingDirectory)) {
                this.contentHostingService.addProperty(enclosingDirectory, "SAKAI:has_custom_sort", Boolean.TRUE.toString());
            }
            return this.contentHostingService.addResource(id, contentType, contents, (ResourceProperties)resourceProps, notifyOption);
        }
        catch (PermissionException e) {
            log.error("ResourcesHandler.addContentResource: {}", (Object)e.toString());
        }
        catch (IdUsedException e) {
            log.warn("ResourcesHandler.addContentResource IdUsedException: {}", (Object)e.toString());
        }
        catch (IdInvalidException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InconsistentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (OverQuotaException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (ServerOverloadException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (IdUnusedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (TypeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InUseException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected boolean existsDirectory(String path) {
        try {
            this.contentHostingService.getCollection(path);
        }
        catch (IdUnusedException e) {
            return false;
        }
        catch (TypeException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (PermissionException e) {
            log.error("ResourcesHandler.existsDirectory: {}", (Object)e.toString());
        }
        return true;
    }

    protected void addContentCollection(String path, Map properties) {
        path = this.makeIdCleanAndLengthCompliant(path);
        ResourcePropertiesEdit resourceProps = this.contentHostingService.newResourceProperties();
        Set keys = properties.keySet();
        for (String key : keys) {
            String value = (String)properties.get(key);
            resourceProps.addProperty(key, value);
        }
        try {
            this.contentHostingService.addCollection(path, (ResourceProperties)resourceProps);
        }
        catch (IdUsedException i) {
        }
        catch (IdInvalidException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (PermissionException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InconsistentException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String makeIdCleanAndLengthCompliant(String path) {
        String[] parts = path.split("/");
        StringBuilder rv = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].length() <= 0) continue;
            rv.append("/" + Validator.escapeResourceName((String)parts[i]));
        }
        if (rv.length() > 250) {
            rv.setLength(236);
            SimpleDateFormat f = new SimpleDateFormat("yyyyMMddHHmmss");
            rv.append(f.format((Object)new Date()));
            if (log.isDebugEnabled()) {
                log.debug("makeIdCleanAndLengthCompliant truncated from {} to {}", (Object)path, (Object)rv.toString());
            }
        }
        return rv.toString();
    }

    public ContentHostingService getContentHostingService() {
        return this.contentHostingService;
    }

    public void setContentHostingService(ContentHostingService chs) {
        this.contentHostingService = chs;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public SecurityService getSecurityService() {
        return this.securityService;
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityService = securityService;
    }

    public ServerConfigurationService getServerConfigurationService() {
        return this.serverConfigurationService;
    }

    public void setServerConfigurationService(ServerConfigurationService serverConfigurationService) {
        this.serverConfigurationService = serverConfigurationService;
    }
}

