/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.hbm.privacy;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;

@Entity
@Table(name="SAKAI_PRIVACY_RECORD", uniqueConstraints={@UniqueConstraint(name="uniquePrivacyRecord", columnNames={"contextId", "recordType", "userId"})})
@NamedQueries(value={@NamedQuery(name="findPrivacyByUserIdContextIdType", query="from PrivacyRecord as privacy where privacy.userId = :userId and privacy.contextId = :contextId and privacy.recordType = :recordType"), @NamedQuery(name="findDisabledPrivacyUserIdContextIdType", query="from PrivacyRecord as privacy where privacy.userId = :userId and privacy.contextId = :contextId and privacy.recordType = :recordType and privacy.viewable = :viewable"), @NamedQuery(name="finalPrivacyByContextViewableType", query="from PrivacyRecord as privacy where privacy.contextId = :contextId and privacy.viewable = :viewable and privacy.recordType = :recordType"), @NamedQuery(name="finalPrivacyByContextType", query="from PrivacyRecord as privacy where privacy.contextId = :contextId and privacy.recordType = :recordType"), @NamedQuery(name="finalPrivacyByContextViewableTypeUserList", query="from PrivacyRecord as privacy where privacy.contextId = :contextId and privacy.viewable = :viewable and privacy.recordType = :recordType and privacy.userId in (:userIds)"), @NamedQuery(name="finalPrivacyByContextTypeAndUserIds", query="from PrivacyRecord as privacy where privacy.contextId = :contextId and privacy.recordType = :recordType and privacy.userId in (:userIds)")})
public class PrivacyRecord {
    @Id
    @Column(name="id")
    @GeneratedValue(strategy=GenerationType.AUTO, generator="privacy_record_sequence")
    @SequenceGenerator(name="privacy_record_sequence", sequenceName="PrivacyRecordImpl_SEQ")
    private Long surrogateKey;
    @Version
    @Column
    private Integer lockId;
    @Column(length=100, nullable=false)
    private String contextId;
    @Column(length=100, nullable=false)
    private String recordType;
    @Column(length=100, nullable=false)
    private String userId;
    @Column(nullable=false)
    private boolean viewable;

    public PrivacyRecord(String userId, String contextId, String recordType, boolean viewable) {
        this.userId = userId;
        this.contextId = contextId;
        this.recordType = recordType;
        this.viewable = viewable;
    }

    public Long getSurrogateKey() {
        return this.surrogateKey;
    }

    public Integer getLockId() {
        return this.lockId;
    }

    public String getContextId() {
        return this.contextId;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean isViewable() {
        return this.viewable;
    }

    public void setSurrogateKey(Long surrogateKey) {
        this.surrogateKey = surrogateKey;
    }

    public void setLockId(Integer lockId) {
        this.lockId = lockId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setViewable(boolean viewable) {
        this.viewable = viewable;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PrivacyRecord)) {
            return false;
        }
        PrivacyRecord other = (PrivacyRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$surrogateKey = this.getSurrogateKey();
        Long other$surrogateKey = other.getSurrogateKey();
        if (this$surrogateKey == null ? other$surrogateKey != null : !((Object)this$surrogateKey).equals(other$surrogateKey)) {
            return false;
        }
        Integer this$lockId = this.getLockId();
        Integer other$lockId = other.getLockId();
        if (this$lockId == null ? other$lockId != null : !((Object)this$lockId).equals(other$lockId)) {
            return false;
        }
        String this$contextId = this.getContextId();
        String other$contextId = other.getContextId();
        if (this$contextId == null ? other$contextId != null : !this$contextId.equals(other$contextId)) {
            return false;
        }
        String this$recordType = this.getRecordType();
        String other$recordType = other.getRecordType();
        if (this$recordType == null ? other$recordType != null : !this$recordType.equals(other$recordType)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        return this.isViewable() == other.isViewable();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PrivacyRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $surrogateKey = this.getSurrogateKey();
        result = result * 59 + ($surrogateKey == null ? 43 : ((Object)$surrogateKey).hashCode());
        Integer $lockId = this.getLockId();
        result = result * 59 + ($lockId == null ? 43 : ((Object)$lockId).hashCode());
        String $contextId = this.getContextId();
        result = result * 59 + ($contextId == null ? 43 : $contextId.hashCode());
        String $recordType = this.getRecordType();
        result = result * 59 + ($recordType == null ? 43 : $recordType.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        result = result * 59 + (this.isViewable() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "PrivacyRecord(surrogateKey=" + this.getSurrogateKey() + ", lockId=" + this.getLockId() + ", contextId=" + this.getContextId() + ", recordType=" + this.getRecordType() + ", userId=" + this.getUserId() + ", viewable=" + this.isViewable() + ")";
    }

    public PrivacyRecord() {
    }
}

