/*
 * Decompiled with CFR 0.152.
 */
package org.sakaiproject.component.privacy;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.type.Type;
import org.sakaiproject.api.privacy.PrivacyManager;
import org.sakaiproject.authz.api.AuthzGroup;
import org.sakaiproject.authz.api.GroupNotDefinedException;
import org.sakaiproject.authz.cover.AuthzGroupService;
import org.sakaiproject.hbm.privacy.PrivacyRecordImpl;
import org.sakaiproject.user.api.User;
import org.sakaiproject.user.cover.UserDirectoryService;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public class PrivacyManagerImpl
extends HibernateDaoSupport
implements PrivacyManager {
    private static Log log = LogFactory.getLog(PrivacyManagerImpl.class);
    private static final String QUERY_BY_USERID_CONTEXTID_TYPEID = "findPrivacyByUserIdContextIdType";
    private static final String QUERY_BY_DISABLED_USERID_CONTEXTID = "findDisabledPrivacyUserIdContextIdType";
    private static final String QUERY_BY_CONTEXT_VIEWABLE_TYPE = "finalPrivacyByContextViewableType";
    private static final String QUERY_BY_CONTEXT__TYPE = "finalPrivacyByContextType";
    private static final String QUERY_BY_CONTEXT__TYPE_IDLIST = "finalPrivacyByContextTypeAndUserIds";
    private static final String QUERY_BY_CONTEXT_VIEWABLE_TYPE_IDLIST = "finalPrivacyByContextViewableTypeUserList";
    private static final String CONTEXT_ID = "contextId";
    private static final String USER_ID = "userId";
    private static final String RECORD_TYPE = "recordType";
    private static final String VIEWABLE = "viewable";
    protected boolean defaultViewable = true;
    protected Boolean overrideViewable = null;
    protected boolean userRecordHasPrecedence = true;
    protected int maxResultSetNumber = 1000;

    public Set findViewable(String contextId, Set userIds) {
        if (contextId == null || userIds == null) {
            throw new IllegalArgumentException("Null Argument in findViewable");
        }
        if (this.overrideViewable != null) {
            if (this.overrideViewable.booleanValue()) {
                return userIds;
            }
            return new HashSet();
        }
        Iterator iter = userIds.iterator();
        ArrayList<String> userIdList = new ArrayList<String>();
        while (iter.hasNext()) {
            String userId = (String)iter.next();
            if (userId == null) continue;
            userIdList.add(userId);
        }
        HashMap<String, PrivacyRecordImpl> sysMap = new HashMap<String, PrivacyRecordImpl>();
        HashMap<String, PrivacyRecordImpl> userMap = new HashMap<String, PrivacyRecordImpl>();
        ArrayList pieceList = new ArrayList();
        List resultPieceList = new ArrayList();
        for (int i = 0; i <= userIdList.size() / this.maxResultSetNumber; ++i) {
            int j;
            pieceList.clear();
            if (i == userIdList.size() / this.maxResultSetNumber) {
                for (j = 0; j < userIdList.size() % this.maxResultSetNumber; ++j) {
                    pieceList.add(userIdList.get(j + i * this.maxResultSetNumber));
                }
            } else {
                for (j = 0; j < this.maxResultSetNumber; ++j) {
                    pieceList.add(userIdList.get(j + i * this.maxResultSetNumber));
                }
            }
            if (pieceList.size() <= 0) continue;
            resultPieceList = this.getPrivacyByContextAndTypeAndUserIds(contextId, "system_record", pieceList);
            for (j = 0; j < resultPieceList.size(); ++j) {
                sysMap.put(((PrivacyRecordImpl)resultPieceList.get(j)).getUserId(), (PrivacyRecordImpl)resultPieceList.get(j));
            }
            resultPieceList = this.getPrivacyByContextAndTypeAndUserIds(contextId, "user_record", pieceList);
            for (j = 0; j < resultPieceList.size(); ++j) {
                userMap.put(((PrivacyRecordImpl)resultPieceList.get(j)).getUserId(), (PrivacyRecordImpl)resultPieceList.get(j));
            }
        }
        HashSet<String> returnSet = new HashSet<String>();
        for (int i = 0; i < userIdList.size(); ++i) {
            String id = (String)userIdList.get(i);
            if (this.getDisabled((PrivacyRecordImpl)sysMap.get(id), (PrivacyRecordImpl)userMap.get(id))) continue;
            returnSet.add(id);
        }
        return returnSet;
    }

    public Set findHidden(String contextId, Set userIds) {
        if (contextId == null || userIds == null) {
            throw new IllegalArgumentException("Null Argument in findViewable");
        }
        if (this.overrideViewable != null) {
            if (this.overrideViewable.booleanValue()) {
                return new HashSet();
            }
            return userIds;
        }
        Iterator iter = userIds.iterator();
        ArrayList<String> userIdList = new ArrayList<String>();
        while (iter.hasNext()) {
            String userId = (String)iter.next();
            if (userId == null) continue;
            userIdList.add(userId);
        }
        HashMap<String, PrivacyRecordImpl> sysMap = new HashMap<String, PrivacyRecordImpl>();
        HashMap<String, PrivacyRecordImpl> userMap = new HashMap<String, PrivacyRecordImpl>();
        ArrayList pieceList = new ArrayList();
        List resultPieceList = new ArrayList();
        for (int i = 0; i <= userIdList.size() / this.maxResultSetNumber; ++i) {
            int j;
            pieceList.clear();
            if (i == userIdList.size() / this.maxResultSetNumber) {
                for (j = 0; j < userIdList.size() % this.maxResultSetNumber; ++j) {
                    pieceList.add(userIdList.get(j + i * this.maxResultSetNumber));
                }
            } else {
                for (j = 0; j < this.maxResultSetNumber; ++j) {
                    pieceList.add(userIdList.get(j + i * this.maxResultSetNumber));
                }
            }
            if (pieceList.size() <= 0) continue;
            resultPieceList = this.getPrivacyByContextAndTypeAndUserIds(contextId, "system_record", pieceList);
            for (j = 0; j < resultPieceList.size(); ++j) {
                sysMap.put(((PrivacyRecordImpl)resultPieceList.get(j)).getUserId(), (PrivacyRecordImpl)resultPieceList.get(j));
            }
            resultPieceList = this.getPrivacyByContextAndTypeAndUserIds(contextId, "user_record", pieceList);
            for (j = 0; j < resultPieceList.size(); ++j) {
                userMap.put(((PrivacyRecordImpl)resultPieceList.get(j)).getUserId(), (PrivacyRecordImpl)resultPieceList.get(j));
            }
        }
        HashSet<String> returnSet = new HashSet<String>();
        for (int i = 0; i < userIdList.size(); ++i) {
            String id = (String)userIdList.get(i);
            if (!this.getDisabled((PrivacyRecordImpl)sysMap.get(id), (PrivacyRecordImpl)userMap.get(id))) continue;
            returnSet.add(id);
        }
        return returnSet;
    }

    public Set getViewableState(String contextId, Boolean value, String recordType) {
        if (contextId == null || value == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in getViewableState");
        }
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)contextId);
            ArrayList users = new ArrayList();
            users.addAll(UserDirectoryService.getUsers((Collection)realm.getUsers()));
            ArrayList<String> siteUserIds = new ArrayList<String>();
            for (int i = 0; i < users.size(); ++i) {
                siteUserIds.add(((User)users.get(i)).getId());
            }
            ArrayList returnedList = new ArrayList();
            ArrayList pieceList = new ArrayList();
            List resultPieceList = new ArrayList();
            for (int i = 0; i <= siteUserIds.size() / this.maxResultSetNumber; ++i) {
                int j;
                pieceList.clear();
                if (i == siteUserIds.size() / this.maxResultSetNumber) {
                    for (j = 0; j < siteUserIds.size() % this.maxResultSetNumber; ++j) {
                        pieceList.add(siteUserIds.get(j + i * this.maxResultSetNumber));
                    }
                } else {
                    for (j = 0; j < this.maxResultSetNumber; ++j) {
                        pieceList.add(siteUserIds.get(j + i * this.maxResultSetNumber));
                    }
                }
                if (pieceList.size() <= 0) continue;
                resultPieceList = this.getViewableStateList(contextId, value, recordType, pieceList);
                for (j = 0; j < resultPieceList.size(); ++j) {
                    returnedList.add(resultPieceList.get(j));
                }
            }
            if (returnedList != null) {
                HashSet<String> returnSet = new HashSet<String>();
                for (int i = 0; i < returnedList.size(); ++i) {
                    returnSet.add(((PrivacyRecordImpl)returnedList.get(i)).getUserId());
                }
                return returnSet;
            }
            return null;
        }
        catch (GroupNotDefinedException gnde) {
            return null;
        }
    }

    public Map getViewableState(String contextId, String recordType) {
        if (contextId == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in getViewableState");
        }
        try {
            AuthzGroup realm = AuthzGroupService.getAuthzGroup((String)contextId);
            ArrayList users = new ArrayList();
            users.addAll(UserDirectoryService.getUsers((Collection)realm.getUsers()));
            ArrayList<String> siteUserIds = new ArrayList<String>();
            for (int i = 0; i < users.size(); ++i) {
                siteUserIds.add(((User)users.get(i)).getId());
            }
            ArrayList returnedList = new ArrayList();
            ArrayList pieceList = new ArrayList();
            List resultPieceList = new ArrayList();
            for (int i = 0; i <= siteUserIds.size() / this.maxResultSetNumber; ++i) {
                int j;
                pieceList.clear();
                if (i == siteUserIds.size() / this.maxResultSetNumber) {
                    for (j = 0; j < siteUserIds.size() % this.maxResultSetNumber; ++j) {
                        pieceList.add(siteUserIds.get(j + i * this.maxResultSetNumber));
                    }
                } else {
                    for (j = 0; j < this.maxResultSetNumber; ++j) {
                        pieceList.add(siteUserIds.get(j + i * this.maxResultSetNumber));
                    }
                }
                if (pieceList.size() <= 0) continue;
                resultPieceList = this.getPrivacyByContextAndTypeAndUserIds(contextId, recordType, pieceList);
                for (j = 0; j < resultPieceList.size(); ++j) {
                    returnedList.add(resultPieceList.get(j));
                }
            }
            if (returnedList != null) {
                HashMap<String, Boolean> returnMap = new HashMap<String, Boolean>();
                for (int i = 0; i < returnedList.size(); ++i) {
                    PrivacyRecordImpl pr = (PrivacyRecordImpl)returnedList.get(i);
                    returnMap.put(pr.getUserId(), pr.getViewable());
                }
                return returnMap;
            }
            return null;
        }
        catch (GroupNotDefinedException gnde) {
            return null;
        }
    }

    public boolean isViewable(String contextId, String userId) {
        if (contextId == null || userId == null) {
            throw new IllegalArgumentException("Null Argument in isViewable");
        }
        if (this.overrideViewable != null) {
            return this.overrideViewable;
        }
        PrivacyRecordImpl sysRecord = this.getPrivacy(contextId, userId, "system_record");
        PrivacyRecordImpl userRecord = this.getPrivacy(contextId, userId, "user_record");
        return this.checkPrivacyRecord(sysRecord, userRecord);
    }

    public boolean userMadeSelection(String contextId, String userId) {
        if (contextId == null || userId == null) {
            throw new IllegalArgumentException("Null Argument in isViewable");
        }
        PrivacyRecordImpl userRecord = this.getPrivacy(contextId, userId, "user_record");
        return userRecord != null;
    }

    public void setViewableState(String contextId, String userId, Boolean value, String recordType) {
        if (contextId == null || userId == null || value == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in setViewableState");
        }
        PrivacyRecordImpl pr = this.getPrivacy(contextId, userId, recordType);
        if (pr != null) {
            pr.setViewable(value.booleanValue());
            this.savePrivacyRecord(pr);
        } else {
            pr = this.createPrivacyRecord(userId, contextId, recordType, value);
        }
    }

    public void setViewableState(String contextId, Map userViewableState, String recordType) {
        if (contextId == null || userViewableState == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in setViewableState");
        }
        Set keySet = userViewableState.keySet();
        for (Map.Entry entry : keySet) {
            Boolean viewable = (Boolean)entry.getValue();
            this.setViewableState(contextId, (String)entry.getKey(), viewable, recordType);
        }
    }

    private PrivacyRecordImpl getPrivacy(final String contextId, final String userId, final String recordType) {
        if (contextId == null || userId == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in getPrivacy");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivacyManagerImpl.QUERY_BY_USERID_CONTEXTID_TYPEID);
                q.setCacheable(true);
                q.setCacheRegion("org.sakaiproject.api.privacy.PrivacyManager.PrivacyQueryCache.queryGetPrivacy");
                q.setParameter(PrivacyManagerImpl.CONTEXT_ID, (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter(PrivacyManagerImpl.USER_ID, (Object)userId, (Type)Hibernate.STRING);
                q.setParameter(PrivacyManagerImpl.RECORD_TYPE, (Object)recordType, (Type)Hibernate.STRING);
                return q.uniqueResult();
            }
        };
        return (PrivacyRecordImpl)this.getHibernateTemplate().execute(hcb);
    }

    private String getDisabledPrivacy(String contextId, String userId) {
        PrivacyRecordImpl userRecord;
        if (contextId == null || userId == null) {
            throw new IllegalArgumentException("Null Argument in getDisabledPrivacy");
        }
        PrivacyRecordImpl sysRecord = this.getPrivacy(contextId, userId, "system_record");
        if (!this.checkPrivacyRecord(sysRecord, userRecord = this.getPrivacy(contextId, userId, "user_record"))) {
            return userId;
        }
        return null;
    }

    private boolean getDisabled(PrivacyRecordImpl sysRecord, PrivacyRecordImpl userRecord) {
        return !this.checkPrivacyRecord(sysRecord, userRecord);
    }

    private PrivacyRecordImpl createPrivacyRecord(String userId, String contextId, String recordType, boolean viewable) {
        if (userId == null || contextId == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in createPrivacyRecord");
        }
        PrivacyRecordImpl privacy = new PrivacyRecordImpl(userId, contextId, recordType, viewable);
        this.savePrivacyRecord(privacy);
        return privacy;
    }

    private List getViewableStateList(final String contextId, final Boolean viewable, final String recordType) {
        if (contextId == null || viewable == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in getViewableStateList");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivacyManagerImpl.QUERY_BY_CONTEXT_VIEWABLE_TYPE);
                q.setParameter(PrivacyManagerImpl.CONTEXT_ID, (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter(PrivacyManagerImpl.VIEWABLE, (Object)viewable, (Type)Hibernate.BOOLEAN);
                q.setParameter(PrivacyManagerImpl.RECORD_TYPE, (Object)recordType, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private List getViewableStateList(final String contextId, final Boolean viewable, final String recordType, final List userIds) {
        if (contextId == null || viewable == null || recordType == null || userIds == null) {
            throw new IllegalArgumentException("Null Argument in getViewableStateList");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivacyManagerImpl.QUERY_BY_CONTEXT_VIEWABLE_TYPE_IDLIST);
                q.setParameter(PrivacyManagerImpl.CONTEXT_ID, (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter(PrivacyManagerImpl.VIEWABLE, (Object)viewable, (Type)Hibernate.BOOLEAN);
                q.setParameter(PrivacyManagerImpl.RECORD_TYPE, (Object)recordType, (Type)Hibernate.STRING);
                q.setParameterList("userIds", (Collection)userIds);
                return q.list();
            }
        };
        return (List)this.getHibernateTemplate().execute(hcb);
    }

    private List getPrivacyByContextAndType(final String contextId, final String recordType) {
        if (contextId == null || recordType == null) {
            throw new IllegalArgumentException("Null Argument in getPrivacyByContextAndType");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivacyManagerImpl.QUERY_BY_CONTEXT__TYPE);
                q.setParameter(PrivacyManagerImpl.CONTEXT_ID, (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter(PrivacyManagerImpl.RECORD_TYPE, (Object)recordType, (Type)Hibernate.STRING);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    private List getPrivacyByContextAndTypeAndUserIds(final String contextId, final String recordType, final List userIds) {
        if (contextId == null || recordType == null || userIds == null) {
            throw new IllegalArgumentException("Null Argument in getPrivacyByContextAndTypeAndUserIds");
        }
        HibernateCallback hcb = new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.getNamedQuery(PrivacyManagerImpl.QUERY_BY_CONTEXT__TYPE_IDLIST);
                q.setParameter(PrivacyManagerImpl.CONTEXT_ID, (Object)contextId, (Type)Hibernate.STRING);
                q.setParameter(PrivacyManagerImpl.RECORD_TYPE, (Object)recordType, (Type)Hibernate.STRING);
                q.setParameterList("userIds", (Collection)userIds);
                return q.list();
            }
        };
        return this.getHibernateTemplate().executeFind(hcb);
    }

    private void savePrivacyRecord(PrivacyRecordImpl privacy) {
        this.getHibernateTemplate().saveOrUpdate((Object)privacy);
    }

    private void removePrivacyObject(PrivacyRecordImpl o) {
        this.getHibernateTemplate().delete((Object)o);
    }

    private boolean checkPrivacyRecord(PrivacyRecordImpl sysRecord, PrivacyRecordImpl userRecord) {
        if (sysRecord != null && userRecord != null) {
            if (this.userRecordHasPrecedence) {
                return userRecord.getViewable();
            }
            return sysRecord.getViewable();
        }
        if (sysRecord == null && userRecord == null) {
            return this.defaultViewable;
        }
        if (sysRecord != null) {
            return sysRecord.getViewable();
        }
        return userRecord.getViewable();
    }

    public void setDefaultViewable(boolean defaultViewable) {
        this.defaultViewable = defaultViewable;
    }

    public void setOverrideViewable(Boolean overrideViewable) {
        this.overrideViewable = overrideViewable;
    }

    public void setUserRecordHasPrecedence(boolean userRecordHasPrecedence) {
        this.userRecordHasPrecedence = userRecordHasPrecedence;
    }

    public void setMaxResultSetNumber(int maxResultSetNumber) {
        this.maxResultSetNumber = maxResultSetNumber;
    }
}

